/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.spase;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Collections;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.autoplot.datasource.AbstractDataSource;
import org.autoplot.datasource.DataSetURI;
import org.autoplot.datasource.DataSource;
import org.autoplot.datasource.MetadataModel;
import org.autoplot.metatree.SpaseMetadataModel;
import org.autoplot.spase.DOMWalker;
import org.das2.qds.QDataSet;
import org.das2.util.monitor.NullProgressMonitor;
import org.das2.util.monitor.ProgressMonitor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.w3c.dom.traversal.DocumentTraversal;
import org.w3c.dom.traversal.NodeFilter;
import org.w3c.dom.traversal.TreeWalker;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class SpaseRecordDataSource
extends AbstractDataSource {
    private static final Logger logger = Logger.getLogger("apdss.spase");
    URL url;
    Document document;
    DataSource delegate;

    public SpaseRecordDataSource(URI uri) throws IllegalArgumentException, IOException, SAXException, Exception {
        super(uri);
        try {
            this.url = new URL(uri.getSchemeSpecificPart());
        }
        catch (MalformedURLException ex) {
            logger.warning("Failed to convert URI to URL");
            throw new RuntimeException(ex);
        }
    }

    private String findSurl() {
        String[] lookFor = new String[]{"Spase", "NumericalData", "AccessInformation", "AccessURL", "URL"};
        NodeList list = this.document.getElementsByTagName(lookFor[0]);
        Element pos = (Element)list.item(0);
        if (pos == null) {
            throw new IllegalArgumentException("Unable to find node Space/NumericalData/AccessInformation/AccessURL/URL in " + this.url);
        }
        for (int i = 1; i < lookFor.length; ++i) {
            list = pos.getElementsByTagName(lookFor[i]);
            pos = (Element)list.item(0);
        }
        String result = null;
        list = pos.getChildNodes();
        for (int k = 0; k < list.getLength(); ++k) {
            Node child = list.item(k);
            if (child.getNodeType() != 3) continue;
            result = child.getNodeValue();
        }
        return result;
    }

    public QDataSet getDataSet(ProgressMonitor mon) throws Exception {
        mon.started();
        mon.setProgressMessage("parse xml file");
        DataSetURI.getFile((URI)this.uri, (ProgressMonitor)mon.getSubtaskMonitor("get file"));
        this.readXML(mon.getSubtaskMonitor("readXML"));
        String surl = null;
        try {
            QDataSet result;
            XPathFactory factory = XPathFactory.newInstance();
            XPath xpath = factory.newXPath();
            surl = xpath.evaluate("//Spase/NumericalData/AccessInformation/AccessURL/URL/text()", this.document);
            if (surl.trim().length() == 0) {
                surl = xpath.evaluate("//Spase/Granule/Source/URL/text()", this.document);
                if (surl.trim().length() == 0) {
                    throw new IllegalArgumentException("Expected to find URI in //Spase/Granule/Source/URL/text()");
                }
                throw new IllegalArgumentException("Granule is found at: " + surl + ", unable to read");
            }
            this.delegate = DataSetURI.getDataSource((URI)DataSetURI.getURIValid((String)surl));
            mon.setProgressMessage("reading " + this.delegate.getURI());
            QDataSet qDataSet = result = this.delegate.getDataSet(mon.getSubtaskMonitor("get delegate"));
            return qDataSet;
        }
        catch (XPathExpressionException ex) {
            throw new IllegalArgumentException("unable to get /Spase/NumericalData/AccessInformation/AccessURL/URL(): " + ex.getMessage());
        }
        catch (MalformedURLException ex) {
            throw new IllegalArgumentException("Spase record AccessURL is malformed: " + surl);
        }
        catch (Exception ex) {
            throw ex;
        }
        finally {
            mon.finished();
        }
    }

    private void readXML(ProgressMonitor mon) throws IOException, SAXException {
        DocumentBuilder builder = null;
        try {
            builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (ParserConfigurationException ex) {
            throw new RuntimeException(ex);
        }
        File f = DataSetURI.getFile((URI)this.uri, (ProgressMonitor)mon);
        try (FileInputStream in = new FileInputStream(f);){
            InputSource source = new InputSource(in);
            this.document = builder.parse(source);
        }
    }

    public Map<String, Object> getMetadata(ProgressMonitor mon) throws Exception {
        if (this.document == null) {
            this.readXML(mon);
        }
        DocumentTraversal traversal = (DocumentTraversal)((Object)this.document);
        NodeFilter filter = new NodeFilter(){

            @Override
            public short acceptNode(Node n) {
                if (n.getNodeType() == 3 && ((Text)n).getData().trim().length() == 0) {
                    return 2;
                }
                return 1;
            }
        };
        int whatToShow = -129;
        Node root = this.document.getFirstChild();
        TreeWalker walker = traversal.createTreeWalker(root, whatToShow, filter, false);
        DOMWalker walk = new DOMWalker(walker);
        return walk.getAttributes(walk.getRoot());
    }

    public Map<String, Object> getProperties() {
        try {
            return new SpaseMetadataModel().properties(this.getMetadata((ProgressMonitor)new NullProgressMonitor()));
        }
        catch (Exception ex) {
            return Collections.singletonMap("Exception", ex);
        }
    }

    public MetadataModel getMetadataModel() {
        return new SpaseMetadataModel();
    }
}

