/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.xmlfile;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.LinkedHashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.autoplot.datasource.AbstractDataSource;
import org.autoplot.datasource.DataSetURI;
import org.autoplot.datasource.URISplit;
import org.autoplot.spase.SpaseRecordDataSource;
import org.autoplot.spase.VOTableReader;
import org.autoplot.spase.XMLTypeCheck;
import org.das2.datum.EnumerationUnits;
import org.das2.datum.Units;
import org.das2.datum.UnitsUtil;
import org.das2.qds.DDataSet;
import org.das2.qds.DataSetOps;
import org.das2.qds.QDataSet;
import org.das2.qds.WritableDataSet;
import org.das2.qds.ops.Ops;
import org.das2.qds.util.DataSetBuilder;
import org.das2.util.monitor.CancelledOperationException;
import org.das2.util.monitor.ProgressMonitor;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XmlfileDataSource
extends AbstractDataSource {
    Object type;
    Document document;

    public XmlfileDataSource(URI uri) {
        super(uri);
    }

    public QDataSet getDataSet(ProgressMonitor mon) throws Exception {
        mon.started();
        mon.setProgressMessage("parse xml file");
        File f = DataSetURI.getFile((URI)this.uri, (ProgressMonitor)mon.getSubtaskMonitor("get file"));
        this.type = new XMLTypeCheck().calculateType(f);
        if (this.type != XMLTypeCheck.TYPE_VOTABLE) {
            this.readXML(mon.getSubtaskMonitor("readXML"));
        } else {
            this.document = null;
        }
        String surl = null;
        try {
            XPathFactory factory = XPathFactory.newInstance();
            XPath xpath = factory.newXPath();
            if (this.type == XMLTypeCheck.TYPE_SPASE) {
                SpaseRecordDataSource srds = new SpaseRecordDataSource(this.uri);
                QDataSet qDataSet = srds.getDataSet(mon.getSubtaskMonitor("read spase"));
                return qDataSet;
            }
            if (this.type == XMLTypeCheck.TYPE_HELM) {
                String desc;
                NodeList nl = (NodeList)xpath.evaluate("//Eventlist/Event", this.document, XPathConstants.NODESET);
                DataSetBuilder timespans = new DataSetBuilder(2, 100, 2);
                DataSetBuilder description = new DataSetBuilder(1, 100);
                EnumerationUnits eu = EnumerationUnits.create((Object)"eventDesc");
                description.putProperty("UNITS", (Object)eu);
                timespans.putProperty("UNITS", (Object)Units.us2000);
                timespans.putProperty("BINS_1", (Object)"min,max");
                mon.setTaskSize((long)nl.getLength());
                mon.setProgressMessage("reading events");
                for (int j = 0; j < nl.getLength(); ++j) {
                    String stopDate;
                    Node item = nl.item(j);
                    mon.setTaskProgress((long)j);
                    if (mon.isCancelled()) {
                        throw new CancelledOperationException("User pressed cancel");
                    }
                    desc = (String)xpath.evaluate("Description/text()", item, XPathConstants.STRING);
                    String startDate = (String)xpath.evaluate("TimeSpan/StartDate/text()", item, XPathConstants.STRING);
                    if (startDate.compareTo(stopDate = (String)xpath.evaluate("TimeSpan/StopDate/text()", item, XPathConstants.STRING)) > 0) {
                        IllegalArgumentException e = new IllegalArgumentException("StartDate is after StopDate: " + startDate);
                        e.printStackTrace();
                        timespans.putValue(j, 0, Units.us2000.parse(startDate).doubleValue((Units)Units.us2000));
                        timespans.putValue(j, 1, Units.us2000.parse(startDate).doubleValue((Units)Units.us2000));
                        description.putValue(j, eu.createDatum((Object)e.getMessage()).doubleValue((Units)eu));
                        continue;
                    }
                    description.putValue(j, eu.createDatum((Object)desc).doubleValue((Units)eu));
                    timespans.putValue(j, 0, Units.us2000.parse(startDate).doubleValue((Units)Units.us2000));
                    timespans.putValue(j, 1, Units.us2000.parse(stopDate).doubleValue((Units)Units.us2000));
                }
                DDataSet dd = description.getDataSet();
                dd.putProperty("DEPEND_0", (Object)timespans.getDataSet());
                String title = (String)xpath.evaluate("//Eventlist/ResourceHeader/Description", this.document, XPathConstants.STRING);
                dd.putProperty("TITLE", (Object)title);
                desc = dd;
                return desc;
            }
            if (this.type == XMLTypeCheck.TYPE_VOTABLE) {
                QDataSet ttag;
                VOTableReader r = new VOTableReader();
                QDataSet result = r.readTable(f.toString(), mon.getSubtaskMonitor("read votable"));
                QDataSet bds = (QDataSet)result.property("BUNDLE_1");
                QDataSet data = null;
                Units u0 = (Units)bds.property("UNITS", 0);
                Units u1 = null;
                if (bds.length() > 0) {
                    u1 = (Units)bds.property("UNITS", 1);
                }
                int ii = 0;
                if ((u0 == null || !UnitsUtil.isTimeLocation((Units)u0)) && u1 != null && UnitsUtil.isTimeLocation((Units)u1) && bds.length() > 1) {
                    ii = 1;
                    u0 = u1;
                    if (bds.length() > 2) {
                        u1 = (Units)bds.property("UNITS", 2);
                    }
                }
                if (bds.length() > 1) {
                    if (u0 != null && u1 != null && UnitsUtil.isTimeLocation((Units)u0) && UnitsUtil.isTimeLocation((Units)u1)) {
                        WritableDataSet wttag = DataSetOps.applyIndex((QDataSet)result, (int)1, (QDataSet)Ops.linspace((double)ii, (double)(ii + 1), (int)2), (boolean)false);
                        wttag.putProperty("BINS_1", (Object)"min,max");
                        wttag.putProperty("BUNDLE_1", null);
                        wttag.putProperty("UNITS", (Object)u0);
                        ttag = wttag;
                        if (bds.length() == ii + 2) {
                            EnumerationUnits eu = EnumerationUnits.create((Object)"eventDesc");
                            WritableDataSet mdata = Ops.replicate((double)eu.createDatum((Object)"").doubleValue((Units)eu), (int)ttag.length());
                            mdata.putProperty("UNITS", (Object)eu);
                            data = mdata;
                        }
                    } else {
                        ttag = DataSetOps.unbundle((QDataSet)result, (int)0);
                    }
                } else {
                    ttag = DataSetOps.unbundle((QDataSet)result, (int)0);
                }
                if (data == null) {
                    URISplit split = URISplit.parse((URI)this.uri);
                    LinkedHashMap args = URISplit.parseParams((String)split.params);
                    String arg0 = (String)args.get("arg_0");
                    data = arg0 == null ? DataSetOps.unbundle((QDataSet)result, (int)(result.length(0) - 1)) : DataSetOps.unbundle((QDataSet)result, (String)((String)args.get("arg_0")));
                }
                QDataSet qDataSet = Ops.link((QDataSet)ttag, data);
                return qDataSet;
            }
            try {
                throw new IllegalArgumentException("Unsupported XML type, root node should be Spase or Eventlist");
            }
            catch (XPathExpressionException ex) {
                throw new IllegalArgumentException("unable to get /Spase/NumericalData/AccessInformation/AccessURL/URL(): " + ex.getMessage());
            }
            catch (MalformedURLException ex) {
                throw new IllegalArgumentException("Spase record AccessURL is malformed: " + surl);
            }
            catch (Exception ex) {
                throw ex;
            }
        }
        finally {
            mon.finished();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readXML(ProgressMonitor mon) throws IOException, SAXException {
        DocumentBuilder builder = null;
        try {
            builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (ParserConfigurationException ex) {
            throw new RuntimeException(ex);
        }
        File f = DataSetURI.getFile((URI)this.uri, (ProgressMonitor)mon);
        try (FileInputStream in = new FileInputStream(f);){
            InputSource source = new InputSource(in);
            this.document = builder.parse(source);
        }
    }
}

