/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.ascii;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ComboBoxEditor;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import org.autoplot.ascii.AsciiTableTableModel;
import org.autoplot.ascii.ColSpanTableCellRenderer;
import org.autoplot.datasource.DataSetURI;
import org.autoplot.datasource.DataSourceEditorPanel;
import org.autoplot.datasource.URISplit;
import org.autoplot.datasource.ui.PromptComboBoxEditor;
import org.autoplot.datasource.ui.TableRowHeader;
import org.autoplot.datasource.ui.Util;
import org.autoplot.help.AutoplotHelpSystem;
import org.das2.components.DasProgressLabel;
import org.das2.datum.TimeParser;
import org.das2.qds.DataSetUtil;
import org.das2.qds.QDataSet;
import org.das2.qds.util.AsciiHeadersParser;
import org.das2.qds.util.AsciiParser;
import org.das2.qds.util.AutoHistogram;
import org.das2.qds.util.DataSetBuilder;
import org.das2.util.filesystem.FileSystem;
import org.das2.util.monitor.NullProgressMonitor;
import org.das2.util.monitor.ProgressMonitor;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.ELProperty;
import org.jdesktop.beansbinding.Property;
import org.jdesktop.layout.GroupLayout;

public class AsciiTableDataSourceEditorPanel
extends JPanel
implements DataSourceEditorPanel {
    private static final Logger logger = Logger.getLogger("apdss.ascii");
    AsciiTableTableModel model;
    Map<Integer, String> columns;
    AsciiParser parser;
    boolean focusDep0 = false;
    TableCellRenderer defaultCellRenderer;
    boolean isRichHeader = false;
    boolean initializing = true;
    private static final String PARAMS_KEY_COMMENT = "comment";
    Tool currentTool = Tool.NONE;
    JToggleButton currentToolButton;
    private static final String MSG_MOMENT = "moment...";
    URISplit split = null;
    Map<String, String> params;
    protected File file = null;
    public static final String PROP_FILE = "file";
    protected int skipLines = 0;
    public static final String PROP_FIRST_ROW = "skipLines";
    protected String column = "";
    public static final String PROP_COLUMN = "column";
    protected String dep0 = "";
    public static final String PROP_DEP0 = "dep0";
    public JCheckBox bundleCheckBox;
    public JComboBox columnsComboBox;
    public JComboBox commentComboBox;
    public JPanel dataPanel;
    public JLabel dataStatusLabel;
    public JComboBox dep0Columns;
    public JCheckBox dep0timeCheckBox;
    public JComboBox dep1Values;
    public JComboBox<String> depend0unitsCB;
    public JTextField fillValueTextField;
    public JButton guessFillButton;
    public JToggleButton guessTimeFormatToggleButton;
    public JLabel headerLabel;
    public JLabel jLabel1;
    public JLabel jLabel10;
    public JLabel jLabel11;
    public JLabel jLabel12;
    public JLabel jLabel13;
    public JLabel jLabel14;
    public JLabel jLabel15;
    public JLabel jLabel2;
    public JLabel jLabel3;
    public JLabel jLabel4;
    public JLabel jLabel5;
    public JLabel jLabel6;
    public JLabel jLabel7;
    public JLabel jLabel8;
    public JLabel jLabel9;
    public JLayeredPane jLayeredPane1;
    public JPanel jPanel2;
    public JPanel jPanel3;
    public JPanel jPanel4;
    public JPanel jPanel5;
    public JScrollPane jScrollPane1;
    public JSeparator jSeparator1;
    public JTabbedPane jTabbedPane1;
    public JTable jTable1;
    public JToggleButton jToggleButton1;
    public JToggleButton jToggleButton2;
    public JToggleButton jToggleButton3;
    public JToggleButton jToggleButton4;
    public JToggleButton jToggleButton5;
    public JTextField labelTextField;
    public JFormattedTextField skipLinesTextField;
    public JComboBox<String> timeFormatCB;
    public JComboBox timeFormatFieldsComboBox;
    public JToggleButton timeFormatToggleButton;
    public JLabel timesStatusLabel;
    public JTextField titleTextField;
    public JTextField unitsTF;
    public JTextField validMaxTextField;
    public JTextField validMinTextField;
    public JCheckBox whereCB;
    public JComboBox<String> whereOp;
    public JComboBox<String> whereParamList;
    public JComboBox<String> whereValueCB;
    public JCheckBox xCheckBox;
    public JComboBox<String> xComboBox;
    public JPanel xyzPanel;
    public JCheckBox yCheckBox;
    public JComboBox<String> yComboBox;
    public JCheckBox zCheckBox;
    public JComboBox<String> zComboBox;
    private BindingGroup bindingGroup;

    public void markProblems(List<String> problems) {
    }

    Action createToolAction(String label, final Tool t) {
        assert (t != Tool.NONE);
        return new AbstractAction(label){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getSource() instanceof JToggleButton) {
                    if (AsciiTableDataSourceEditorPanel.this.currentTool != Tool.NONE) {
                        AsciiTableDataSourceEditorPanel.this.clearTool();
                        return;
                    }
                    if (AsciiTableDataSourceEditorPanel.this.jTable1.getSelectionModel().isSelectionEmpty()) {
                        AsciiTableDataSourceEditorPanel.this.jTable1.getSelectionModel().clearSelection();
                        AsciiTableDataSourceEditorPanel.this.jTable1.getColumnModel().getSelectionModel().clearSelection();
                        AsciiTableDataSourceEditorPanel.this.currentToolButton = (JToggleButton)e.getSource();
                        Util.enableComponents((Container)((Container)AsciiTableDataSourceEditorPanel.this.jTabbedPane1.getSelectedComponent()), (boolean)false, (Component)((Component)e.getSource()));
                        AsciiTableDataSourceEditorPanel.this.jTabbedPane1.setEnabled(false);
                        AsciiTableDataSourceEditorPanel.this.setCurrentTool(t);
                    } else {
                        AsciiTableDataSourceEditorPanel.this.currentToolButton = (JToggleButton)e.getSource();
                        AsciiTableDataSourceEditorPanel.this.currentTool = t;
                        AsciiTableDataSourceEditorPanel.this.setCurrentTool(t);
                        AsciiTableDataSourceEditorPanel.this.doSelect(t);
                        AsciiTableDataSourceEditorPanel.this.jTable1.getSelectionModel().clearSelection();
                        AsciiTableDataSourceEditorPanel.this.jTable1.getColumnModel().getSelectionModel().clearSelection();
                    }
                }
            }
        };
    }

    private static String getColumnsString(int[] cols, Map<Integer, String> columnsMap) {
        boolean haveColumnNames = true;
        int last = cols[cols.length - 1];
        String slast = columnsMap.get(last);
        if (slast == null) {
            haveColumnNames = false;
        }
        StringBuilder sb = new StringBuilder();
        int t0 = -999;
        int r0 = -999;
        for (int t : cols) {
            if (t - t0 > 1) {
                if (t0 > -999) {
                    sb.append(columnsMap.get(t0)).append(',');
                }
                t0 = t;
                r0 = t;
            } else if (r0 > -999) {
                if (haveColumnNames) {
                    sb.append(columnsMap.get(r0)).append('-');
                } else {
                    sb.append(columnsMap.get(r0)).append('-');
                }
                r0 = -999;
            }
            t0 = t;
        }
        if (t0 > -999) {
            sb.append(columnsMap.get(t0));
        }
        return sb.toString();
    }

    private void doSelect(Tool tool) {
        if (tool == Tool.SKIPLINES && this.jTable1.getSelectedRow() != -1) {
            this.setSkipLines(this.jTable1.getSelectedRow());
            this.clearTool();
        }
        switch (this.jTable1.getColumnModel().getSelectedColumnCount()) {
            case 0: {
                break;
            }
            case 1: {
                int col = this.jTable1.getColumnModel().getSelectedColumns()[0];
                String name = null;
                if (this.columns != null) {
                    name = this.columns.get(col);
                }
                if (name == null) {
                    name = "field" + col;
                }
                if (tool == Tool.DEPEND_0) {
                    this.setDep0(name);
                    break;
                }
                if (tool == Tool.COLUMN) {
                    this.setColumn(name);
                    break;
                }
                if (tool == Tool.TIMEFORMAT) {
                    int row = this.jTable1.getSelectedRow();
                    String val = this.timeFormatCB.getSelectedItem().toString() + (String)this.jTable1.getModel().getValueAt(row, col);
                    this.timeFormatCB.setSelectedItem(val);
                    break;
                }
                if (tool == Tool.GUESSTIMEFORMAT) {
                    int row = this.jTable1.getSelectedRow();
                    String val = (String)this.jTable1.getModel().getValueAt(row, col);
                    this.timeFormatCB.setSelectedItem(val);
                    this.guessTimeFormatButtonAP(row, col, col);
                    break;
                }
                if (tool != Tool.FILLVALUE) break;
                int row = this.jTable1.getSelectedRow();
                String val = (String)this.jTable1.getModel().getValueAt(row, col);
                if (val.contains("+")) {
                    val = "" + Double.parseDouble(val);
                }
                this.fillValueTextField.setText(val);
                break;
            }
            default: {
                int[] cols = this.jTable1.getColumnModel().getSelectedColumns();
                String scols = AsciiTableDataSourceEditorPanel.getColumnsString(cols, this.columns);
                if (tool == Tool.DEPEND_0) break;
                if (tool == Tool.COLUMN) {
                    this.setColumn(scols);
                    break;
                }
                if (tool == Tool.DEPEND_1) {
                    this.dep1Values.setSelectedItem(scols);
                    break;
                }
                if (tool == Tool.TIMEFORMAT) {
                    int row = this.jTable1.getSelectedRow();
                    int first = cols[0];
                    int last = cols[cols.length - 1];
                    StringBuilder val = new StringBuilder(this.timeFormatCB.getSelectedItem().toString());
                    val.append(this.jTable1.getModel().getValueAt(row, first));
                    for (int icol = first + 1; icol <= last; ++icol) {
                        val.append("+").append(this.jTable1.getModel().getValueAt(row, icol));
                    }
                    this.timeFormatCB.setSelectedItem(val.toString());
                    this.dep0timeCheckBox.setSelected(true);
                    this.setDep0(this.columns.get(first));
                    break;
                }
                if (tool != Tool.GUESSTIMEFORMAT) break;
                int first = cols[0];
                int last = cols[cols.length - 1];
                int row = this.jTable1.getSelectedRow();
                StringBuilder val = new StringBuilder();
                val.append(this.jTable1.getModel().getValueAt(row, first));
                for (int icol = first + 1; icol <= last; ++icol) {
                    val.append("+").append(this.jTable1.getModel().getValueAt(row, icol));
                }
                this.timeFormatCB.setSelectedItem(val.toString());
                this.dep0timeCheckBox.setSelected(true);
                this.setDep0(this.columns.get(first));
                this.guessTimeFormatButtonAP(row, first, last);
            }
        }
        Tool oldTool = tool;
        this.clearTool();
        if (oldTool != Tool.NONE) {
            this.jTable1.getSelectionModel().clearSelection();
            this.jTable1.getColumnModel().getSelectionModel().clearSelection();
        }
    }

    public AsciiTableDataSourceEditorPanel() {
        this.initComponents();
        this.depend0unitsCB.setEditor((ComboBoxEditor)new PromptComboBoxEditor("Enter units, or see examples"));
        AutoplotHelpSystem.getHelpSystem().registerHelpID((Component)this, "ascii_main");
        this.columnsComboBox.requestFocusInWindow();
        this.parser = new AsciiParser();
        this.model = new AsciiTableTableModel();
        this.model.setParser(this.parser);
        this.jTable1.setModel(this.model);
        this.defaultCellRenderer = this.jTable1.getDefaultRenderer(Object.class);
        this.jTable1.setDefaultRenderer(Object.class, new ColSpanTableCellRenderer());
        this.jScrollPane1.setRowHeaderView((Component)new TableRowHeader(this.jTable1));
        this.model.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                if (AsciiTableDataSourceEditorPanel.this.columns != null) {
                    AsciiTableDataSourceEditorPanel.updateColumns(AsciiTableDataSourceEditorPanel.this.jTable1, AsciiTableDataSourceEditorPanel.this.columns);
                }
                AsciiTableDataSourceEditorPanel.this.jTable1.repaint();
            }
        });
        this.jTable1.setCellSelectionEnabled(true);
        this.jTable1.getTableHeader().setReorderingAllowed(false);
        this.jTable1.getColumnModel().getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                AsciiTableDataSourceEditorPanel.this.doSelect(AsciiTableDataSourceEditorPanel.this.currentTool);
            }
        });
        this.jTable1.getTableHeader().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int col = AsciiTableDataSourceEditorPanel.this.jTable1.columnAtPoint(e.getPoint());
                String name = null;
                if (AsciiTableDataSourceEditorPanel.this.columns != null) {
                    name = AsciiTableDataSourceEditorPanel.this.columns.get(col);
                }
                if (name == null) {
                    name = "field" + col;
                }
                if (null != AsciiTableDataSourceEditorPanel.this.currentTool) {
                    switch (AsciiTableDataSourceEditorPanel.this.currentTool) {
                        case COLUMN: {
                            AsciiTableDataSourceEditorPanel.this.setColumn(name);
                            break;
                        }
                        case DEPEND_0: {
                            AsciiTableDataSourceEditorPanel.this.setDep0(name);
                            break;
                        }
                        case NONE: {
                            AsciiTableDataSourceEditorPanel.this.setColumn(name);
                            break;
                        }
                    }
                }
            }
        });
        this.jTable1.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                AsciiTableDataSourceEditorPanel.this.doSelect(AsciiTableDataSourceEditorPanel.this.currentTool);
            }
        });
        this.jTable1.getTableHeader().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                super.mouseClicked(e);
                int i = AsciiTableDataSourceEditorPanel.this.jTable1.getTableHeader().columnAtPoint(e.getPoint());
                String name = AsciiTableDataSourceEditorPanel.this.columns.get(i);
                if (AsciiTableDataSourceEditorPanel.this.currentTool == Tool.DEPEND_0) {
                    AsciiTableDataSourceEditorPanel.this.setDep0(name);
                    AsciiTableDataSourceEditorPanel.this.clearTool();
                } else if (AsciiTableDataSourceEditorPanel.this.currentTool == Tool.COLUMN) {
                    AsciiTableDataSourceEditorPanel.this.setColumn(name);
                    AsciiTableDataSourceEditorPanel.this.clearTool();
                }
                Runnable run = new Runnable(){

                    @Override
                    public void run() {
                        AsciiTableDataSourceEditorPanel.this.clearTool();
                    }
                };
                SwingUtilities.invokeLater(run);
            }
        });
        BindingGroup bc = new BindingGroup();
        bc.addBinding((Binding)Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)BeanProperty.create((String)PROP_FIRST_ROW), (Object)this.skipLinesTextField, (Property)BeanProperty.create((String)"value")));
        bc.addBinding((Binding)Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)BeanProperty.create((String)PROP_COLUMN), (Object)this.columnsComboBox, (Property)BeanProperty.create((String)"selectedItem")));
        bc.addBinding((Binding)Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)BeanProperty.create((String)PROP_DEP0), (Object)this.dep0Columns, (Property)BeanProperty.create((String)"selectedItem")));
        bc.bind();
    }

    private void clearTool() {
        if (this.currentTool != Tool.NONE) {
            if (!this.jTabbedPane1.isEnabled()) {
                this.jTabbedPane1.setEnabled(true);
                Util.enableComponents((Container)((Container)this.jTabbedPane1.getSelectedComponent()), (boolean)true, null);
            }
            this.currentTool = Tool.NONE;
            this.currentToolButton.setSelected(false);
            this.currentToolButton = null;
            this.timesStatusLabel.setText("");
            this.dataStatusLabel.setText("");
            this.headerLabel.setText("");
        }
    }

    private void setCurrentTool(Tool tool) {
        this.currentTool = tool;
        String message = "set tool " + (Object)((Object)tool);
        if (null != tool) {
            switch (tool) {
                case FILLVALUE: {
                    message = "Click on value to use as fill (missing) value.";
                    break;
                }
                case GUESSTIMEFORMAT: {
                    message = "Select cells which should be used to guess time format.";
                    break;
                }
                case TIMEFORMAT: {
                    message = "Select cells to copy, which must then be converted to time format template.";
                    break;
                }
                case SKIPLINES: {
                    message = "Click on the row of the first record.";
                    break;
                }
                case DEPEND_0: {
                    message = "Click on the first column which is the independent parameter, often time.";
                    break;
                }
                case DEPEND_1: {
                    message = "Drag to select the cells which identify the column values, used for the Y-values in a spectrogram.";
                    break;
                }
                case COLUMN: {
                    message = "Click on the column to use.";
                    break;
                }
                case NONE: {
                    message = "";
                    break;
                }
            }
        }
        this.dataStatusLabel.setText(message);
        this.timesStatusLabel.setText(message);
        this.headerLabel.setText(message);
    }

    private void initComponents() {
        this.bindingGroup = new BindingGroup();
        this.jTabbedPane1 = new JTabbedPane();
        this.jPanel2 = new JPanel();
        this.jLabel1 = new JLabel();
        this.skipLinesTextField = new JFormattedTextField();
        this.jToggleButton1 = new JToggleButton();
        this.jLabel5 = new JLabel();
        this.commentComboBox = new JComboBox();
        this.headerLabel = new JLabel();
        this.jLabel14 = new JLabel();
        this.dep1Values = new JComboBox();
        this.jToggleButton5 = new JToggleButton();
        this.jPanel3 = new JPanel();
        this.jLabel2 = new JLabel();
        this.timeFormatFieldsComboBox = new JComboBox();
        this.timeFormatToggleButton = new JToggleButton();
        this.jLabel9 = new JLabel();
        this.guessTimeFormatToggleButton = new JToggleButton();
        this.timesStatusLabel = new JLabel();
        this.timeFormatCB = new JComboBox();
        this.dataPanel = new JPanel();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.dep0Columns = new JComboBox();
        this.columnsComboBox = new JComboBox();
        this.jToggleButton2 = new JToggleButton();
        this.jToggleButton3 = new JToggleButton();
        this.dep0timeCheckBox = new JCheckBox();
        this.jLabel6 = new JLabel();
        this.jLabel7 = new JLabel();
        this.jLabel8 = new JLabel();
        this.fillValueTextField = new JTextField();
        this.validMinTextField = new JTextField();
        this.validMaxTextField = new JTextField();
        this.jToggleButton4 = new JToggleButton();
        this.guessFillButton = new JButton();
        this.jSeparator1 = new JSeparator();
        this.bundleCheckBox = new JCheckBox();
        this.dataStatusLabel = new JLabel();
        this.jPanel4 = new JPanel();
        this.jLabel10 = new JLabel();
        this.jLabel11 = new JLabel();
        this.titleTextField = new JTextField();
        this.labelTextField = new JTextField();
        this.jLabel12 = new JLabel();
        this.jLabel13 = new JLabel();
        this.unitsTF = new JTextField();
        this.depend0unitsCB = new JComboBox();
        this.jPanel5 = new JPanel();
        this.whereCB = new JCheckBox();
        this.whereParamList = new JComboBox();
        this.whereOp = new JComboBox();
        this.whereValueCB = new JComboBox();
        this.xyzPanel = new JPanel();
        this.xComboBox = new JComboBox();
        this.xCheckBox = new JCheckBox();
        this.yCheckBox = new JCheckBox();
        this.yComboBox = new JComboBox();
        this.zCheckBox = new JCheckBox();
        this.zComboBox = new JComboBox();
        this.jLabel15 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jTable1 = new JTable();
        this.jLayeredPane1 = new JLayeredPane();
        this.setName("asciiTableDataSourceEditorPanel");
        this.jLabel1.setText("Skip Lines:");
        this.jLabel1.setToolTipText("Skip this many lines before attempting to parse data.  Note if the first line contains parsable column labels, they will be used to identify each column.\n");
        this.skipLinesTextField.setText("11");
        this.skipLinesTextField.setToolTipText("");
        this.skipLinesTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                AsciiTableDataSourceEditorPanel.this.skipLinesTextFieldFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                AsciiTableDataSourceEditorPanel.this.skipLinesTextFieldFocusLost(evt);
            }
        });
        this.jToggleButton1.setAction(this.createToolAction("skiplines", Tool.SKIPLINES));
        this.jToggleButton1.setText("Select");
        this.jToggleButton1.setToolTipText("Select the first row to parse as data or column headers.");
        this.jToggleButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AsciiTableDataSourceEditorPanel.this.jToggleButton1ActionPerformed(evt);
            }
        });
        this.jLabel5.setText("Comment Prefix:");
        this.jLabel5.setToolTipText("Select a character that is the beginning of records that can be ignored.  \n");
        this.commentComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"# hash", "; semicolon", "none", ""}));
        this.commentComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AsciiTableDataSourceEditorPanel.this.commentComboBoxActionPerformed(evt);
            }
        });
        this.jLabel14.setText("Column Values:");
        this.jLabel14.setToolTipText("Select the columns which will be the Y-axis values for each row of a spectrogram.  ");
        this.dep1Values.setEditable(true);
        this.dep1Values.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jToggleButton5.setAction(this.createToolAction("depend1", Tool.DEPEND_1));
        this.jToggleButton5.setText("Select");
        GroupLayout jPanel2Layout = new GroupLayout((Container)this.jPanel2);
        this.jPanel2.setLayout((LayoutManager)jPanel2Layout);
        jPanel2Layout.setHorizontalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((Component)this.headerLabel, -1, -1, Short.MAX_VALUE).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().add((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().add((Component)this.jLabel5).addPreferredGap(0).add((Component)this.commentComboBox, -2, 109, -2)).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().add((Component)this.jLabel1).addPreferredGap(0).add((Component)this.skipLinesTextField, -2, 47, -2).add(18, 18, 18).add((Component)this.jToggleButton1).add(38, 38, 38).add((Component)this.jLabel14).addPreferredGap(0).add((Component)this.dep1Values, -2, 181, -2).addPreferredGap(0).add((Component)this.jToggleButton5))).add(0, 180, Short.MAX_VALUE))).addContainerGap()));
        jPanel2Layout.setVerticalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().add((GroupLayout.Group)jPanel2Layout.createParallelGroup(3).add((Component)this.skipLinesTextField, -2, -1, -2).add((Component)this.jToggleButton1).add((Component)this.jLabel1).add((Component)this.jLabel14).add((Component)this.dep1Values, -2, -1, -2).add((Component)this.jToggleButton5)).addPreferredGap(0).add((GroupLayout.Group)jPanel2Layout.createParallelGroup(3).add((Component)this.commentComboBox, -2, -1, -2).add((Component)this.jLabel5)).addPreferredGap(0).add((Component)this.headerLabel, -1, 24, Short.MAX_VALUE)));
        this.jTabbedPane1.addTab("header", this.jPanel2);
        this.jLabel2.setText("Time Format:");
        this.jLabel2.setToolTipText("<html>Specify the format of time strings, such as \"%Y %m %d.\"<br>\nPluses join adjacent fields, and the droplist to the right<br>\ncan be used to select field types.  The Guess button attempts <br>\nto guess the format of selected fields.</html>\n");
        this.timeFormatFieldsComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"select field type...", "$Y: four digit year", "$y: two digit year", "$m: two-digit month", "$b: month name", "$d: two-digit day of month", "$j: three-digit day of year", "$H: two-digit hour", "$M: two-digit minute", "$S: two-digit second", "$(milli): three-digit milliseconds", "$(micro): three-digit microseconds", "$x: ignore this field", "$(subsec;places=6): microseconds", "$(subsec;places=9): nanoseconds", "+: field separator"}));
        this.timeFormatFieldsComboBox.setToolTipText("Use this droplist to select a field type, and the Select button copies the field type to the Time Format text field.");
        this.timeFormatFieldsComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AsciiTableDataSourceEditorPanel.this.timeFormatFieldsComboBoxActionPerformed(evt);
            }
        });
        this.timeFormatToggleButton.setAction(this.createToolAction("timeFormat", Tool.TIMEFORMAT));
        this.timeFormatToggleButton.setText("Select");
        this.timeFormatToggleButton.setToolTipText("Select column or range of columns which contain the times.  These column values will be copied into the time format and you will have to create a template.");
        this.timeFormatToggleButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AsciiTableDataSourceEditorPanel.this.timeFormatToggleButtonActionPerformed(evt);
            }
        });
        this.jLabel9.setText("<html><i>Specify time format (e.g. $Y$m+$d) when times are not ISO8601 or span multiple fields.</i></html>");
        this.guessTimeFormatToggleButton.setAction(this.createToolAction("guessTimeFormat", Tool.GUESSTIMEFORMAT));
        this.guessTimeFormatToggleButton.setText("Guess");
        this.guessTimeFormatToggleButton.setToolTipText("<html>This will scan the selected columns and try to identify field types.<br> This uses the number of digits in each field to identify the type<br> (e.g. 3 digits implies day of year), so select the cells accordingly.</html>");
        this.guessTimeFormatToggleButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AsciiTableDataSourceEditorPanel.this.guessTimeFormatToggleButtonActionPerformed(evt);
            }
        });
        this.timesStatusLabel.setText(" ");
        this.timeFormatCB.setEditable(true);
        this.timeFormatCB.setModel(new DefaultComboBoxModel<String>(new String[]{"$Y$m+$d", "$Y+$m+$S", "$Y-$j+$H:$M:$S", "ISO8601"}));
        this.timeFormatCB.setSelectedIndex(-1);
        this.timeFormatCB.setSelectedItem("");
        GroupLayout jPanel3Layout = new GroupLayout((Container)this.jPanel3);
        this.jPanel3.setLayout((LayoutManager)jPanel3Layout);
        jPanel3Layout.setHorizontalGroup((GroupLayout.Group)jPanel3Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel3Layout.createSequentialGroup().add(24, 24, 24).add((Component)this.timesStatusLabel, -1, -1, Short.MAX_VALUE).addContainerGap()).add((GroupLayout.Group)jPanel3Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel3Layout.createParallelGroup(1).add((Component)this.jLabel9, -2, 678, -2).add((GroupLayout.Group)jPanel3Layout.createSequentialGroup().add((Component)this.jLabel2).addPreferredGap(0).add(this.timeFormatCB, -2, 353, -2).addPreferredGap(0).add((Component)this.timeFormatFieldsComboBox, -2, 167, -2).addPreferredGap(0).add((Component)this.timeFormatToggleButton).addPreferredGap(0).add((Component)this.guessTimeFormatToggleButton))).addContainerGap(45, Short.MAX_VALUE)));
        jPanel3Layout.setVerticalGroup((GroupLayout.Group)jPanel3Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel3Layout.createSequentialGroup().add(6, 6, 6).add((Component)this.jLabel9, -2, -1, -2).addPreferredGap(1).add((GroupLayout.Group)jPanel3Layout.createParallelGroup(3).add((Component)this.timeFormatFieldsComboBox, -2, -1, -2).add((Component)this.timeFormatToggleButton).add((Component)this.jLabel2).add((Component)this.guessTimeFormatToggleButton).add(this.timeFormatCB, -2, -1, -2)).addPreferredGap(0, -1, Short.MAX_VALUE).add((Component)this.timesStatusLabel, -2, 15, -2)));
        this.jTabbedPane1.addTab("times", this.jPanel3);
        this.jLabel3.setText("Column(s):");
        this.jLabel3.setToolTipText("Select the column to plot.  Multiple, adjacent columns can be plotted as a spectrogram by using the colon or dash character\n");
        this.jLabel4.setText("Depends On:");
        this.jLabel4.setToolTipText("Select the variable that is the independent parameter that Columns depends on.  Note ISO8601 times are handled, or use the \"times\" tab to specify a time format.\n");
        this.dep0Columns.setEditable(true);
        this.dep0Columns.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.dep0Columns.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                AsciiTableDataSourceEditorPanel.this.dep0ColumnsItemStateChanged(evt);
            }
        });
        this.dep0Columns.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                AsciiTableDataSourceEditorPanel.this.dep0ColumnsFocusGained(evt);
            }
        });
        this.columnsComboBox.setEditable(true);
        this.columnsComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.columnsComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                AsciiTableDataSourceEditorPanel.this.columnsComboBoxItemStateChanged(evt);
            }
        });
        this.columnsComboBox.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                AsciiTableDataSourceEditorPanel.this.columnsComboBoxFocusGained(evt);
            }
        });
        this.jToggleButton2.setAction(this.createToolAction(PROP_COLUMN, Tool.COLUMN));
        this.jToggleButton2.setText("Select");
        this.jToggleButton2.setToolTipText("Select column or range of columns");
        this.jToggleButton3.setAction(this.createToolAction("depend0", Tool.DEPEND_0));
        this.jToggleButton3.setText("Select");
        this.jToggleButton3.setToolTipText("Select the column that is the independent variable on which the data values depend.");
        this.dep0timeCheckBox.setText("time");
        this.dep0timeCheckBox.setToolTipText("If selected, then the field should be parsed as a time.\n");
        this.jLabel6.setText("Fill Value:");
        this.jLabel6.setToolTipText("This numeric value will be treated as fill.  Note non-numeric values are automatically handled as fill.\n");
        this.jLabel7.setText("Valid Min:");
        this.jLabel7.setToolTipText("Numbers below this value are treated as invalid.\n");
        this.jLabel8.setText("Valid Max:");
        this.jLabel8.setToolTipText("Numbers above this value are treated as invalid.");
        this.fillValueTextField.setText(" ");
        this.fillValueTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                AsciiTableDataSourceEditorPanel.this.fillValueTextFieldFocusLost(evt);
            }
        });
        this.validMinTextField.setText("   ");
        this.validMaxTextField.setText("    ");
        this.validMaxTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AsciiTableDataSourceEditorPanel.this.validMaxTextFieldActionPerformed(evt);
            }
        });
        this.jToggleButton4.setAction(this.createToolAction("fillValue", Tool.FILLVALUE));
        this.jToggleButton4.setText("Select");
        this.jToggleButton4.setToolTipText("Click on a value to be treated as fill (invalid)");
        this.guessFillButton.setText("Guess");
        this.guessFillButton.setToolTipText("try to guess the fill value by looking for an outlier.");
        this.guessFillButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AsciiTableDataSourceEditorPanel.this.guessFillButtonActionPerformed(evt);
            }
        });
        this.jSeparator1.setOrientation(1);
        this.bundleCheckBox.setText("bundle");
        this.bundleCheckBox.setToolTipText("<html>Range of columns should be treated as a bundle of parameters, like X, Y, Z.  When plotted, these will result in separate traces instead of a spectrogram.</html>");
        GroupLayout dataPanelLayout = new GroupLayout((Container)this.dataPanel);
        this.dataPanel.setLayout((LayoutManager)dataPanelLayout);
        dataPanelLayout.setHorizontalGroup((GroupLayout.Group)dataPanelLayout.createParallelGroup(1).add((GroupLayout.Group)dataPanelLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)dataPanelLayout.createParallelGroup(1).add((GroupLayout.Group)dataPanelLayout.createSequentialGroup().add((GroupLayout.Group)dataPanelLayout.createParallelGroup(2).add((Component)this.jLabel3).add((Component)this.jLabel4)).addPreferredGap(0).add((GroupLayout.Group)dataPanelLayout.createParallelGroup(1, false).add((Component)this.dep0Columns, 0, -1, Short.MAX_VALUE).add((Component)this.columnsComboBox, 0, 166, Short.MAX_VALUE)).addPreferredGap(0).add((GroupLayout.Group)dataPanelLayout.createParallelGroup(1, false).add((GroupLayout.Group)dataPanelLayout.createSequentialGroup().add((Component)this.bundleCheckBox).addPreferredGap(0).add((Component)this.jToggleButton2)).add((GroupLayout.Group)dataPanelLayout.createSequentialGroup().add((Component)this.dep0timeCheckBox).addPreferredGap(0, -1, Short.MAX_VALUE).add((Component)this.jToggleButton3).add(1, 1, 1))).add((Component)this.jSeparator1, -2, -1, -2).add((GroupLayout.Group)dataPanelLayout.createParallelGroup(1).add((GroupLayout.Group)dataPanelLayout.createSequentialGroup().add(4, 4, 4).add((Component)this.jLabel6)).add((GroupLayout.Group)dataPanelLayout.createSequentialGroup().add(5, 5, 5).add((Component)this.jLabel7))).addPreferredGap(0).add((GroupLayout.Group)dataPanelLayout.createParallelGroup(1).add((Component)this.validMinTextField, -1, 94, Short.MAX_VALUE).add((Component)this.fillValueTextField, -2, 116, -2)).addPreferredGap(0).add((GroupLayout.Group)dataPanelLayout.createParallelGroup(1).add((GroupLayout.Group)dataPanelLayout.createSequentialGroup().add((Component)this.jToggleButton4).addPreferredGap(0).add((Component)this.guessFillButton)).add((GroupLayout.Group)dataPanelLayout.createSequentialGroup().add((Component)this.jLabel8).addPreferredGap(0).add((Component)this.validMaxTextField, -2, 87, -2))).addPreferredGap(0, 28, Short.MAX_VALUE)).add((Component)this.dataStatusLabel, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        dataPanelLayout.linkSize(new Component[]{this.validMaxTextField, this.validMinTextField}, 1);
        dataPanelLayout.setVerticalGroup((GroupLayout.Group)dataPanelLayout.createParallelGroup(1).add((GroupLayout.Group)dataPanelLayout.createSequentialGroup().add((GroupLayout.Group)dataPanelLayout.createParallelGroup(1).add((GroupLayout.Group)dataPanelLayout.createSequentialGroup().add((GroupLayout.Group)dataPanelLayout.createParallelGroup(3).add((Component)this.columnsComboBox, -2, -1, -2).add((Component)this.jLabel3)).addPreferredGap(0).add((GroupLayout.Group)dataPanelLayout.createParallelGroup(3).add((Component)this.dep0Columns, -2, -1, -2).add((Component)this.jLabel4))).add((GroupLayout.Group)dataPanelLayout.createSequentialGroup().add((GroupLayout.Group)dataPanelLayout.createParallelGroup(3).add((Component)this.jLabel6).add((Component)this.jToggleButton4).add((Component)this.guessFillButton).add((Component)this.fillValueTextField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)dataPanelLayout.createParallelGroup(3).add((Component)this.jLabel7).add((Component)this.jLabel8).add((Component)this.validMinTextField, -2, -1, -2).add((Component)this.validMaxTextField, -2, -1, -2))).add((GroupLayout.Group)dataPanelLayout.createSequentialGroup().add(6, 6, 6).add((Component)this.jSeparator1, -2, 55, -2)).add((GroupLayout.Group)dataPanelLayout.createSequentialGroup().add((GroupLayout.Group)dataPanelLayout.createParallelGroup(3).add((Component)this.jToggleButton2).add((Component)this.bundleCheckBox)).addPreferredGap(0).add((GroupLayout.Group)dataPanelLayout.createParallelGroup(3).add((Component)this.dep0timeCheckBox).add((Component)this.jToggleButton3)))).addPreferredGap(0).add((Component)this.dataStatusLabel, -1, -1, Short.MAX_VALUE)));
        this.jTabbedPane1.addTab("data", this.dataPanel);
        this.jLabel10.setText("Title:");
        this.jLabel10.setToolTipText("Title for the data.");
        this.jLabel11.setText("Label:");
        this.jLabel11.setToolTipText("Short label for the data");
        this.titleTextField.setText(" ");
        this.jLabel12.setText("Units:");
        this.jLabel12.setToolTipText("units for the data");
        this.jLabel13.setText("Depend Units:");
        this.jLabel13.setToolTipText("Units of the depend0 column (typically x-axis), such as \"seconds\" or \"nanoseconds since 2000-01-01T12:00\"  Droplist shows examples.");
        this.depend0unitsCB.setEditable(true);
        this.depend0unitsCB.setModel(new DefaultComboBoxModel<String>(new String[]{"seconds since 2010-01-01T00:00", "seconds since 1970-01-01T00:00", "ms since 1970-01-01T00:00", "nanoseconds since 2000-01-01T12:00", "days since 1999-12-31T00:00", "seconds", "hr", "mjd", "decimalYear", " "}));
        this.depend0unitsCB.setToolTipText("units used to interpret the x tags (depends on)");
        GroupLayout jPanel4Layout = new GroupLayout((Container)this.jPanel4);
        this.jPanel4.setLayout((LayoutManager)jPanel4Layout);
        jPanel4Layout.setHorizontalGroup((GroupLayout.Group)jPanel4Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel4Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel4Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel4Layout.createSequentialGroup().add((Component)this.jLabel10).add(18, 18, 18).add((Component)this.titleTextField, -2, 326, -2)).add((GroupLayout.Group)jPanel4Layout.createSequentialGroup().add((Component)this.jLabel11).addPreferredGap(0).add((Component)this.labelTextField, -2, 116, -2))).add(36, 36, 36).add((GroupLayout.Group)jPanel4Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel4Layout.createSequentialGroup().add((Component)this.jLabel13).addPreferredGap(0).add(this.depend0unitsCB, -2, -1, -2)).add((GroupLayout.Group)jPanel4Layout.createSequentialGroup().add((Component)this.jLabel12).addPreferredGap(0).add((Component)this.unitsTF, -2, 150, -2))).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel4Layout.setVerticalGroup((GroupLayout.Group)jPanel4Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel4Layout.createSequentialGroup().add(6, 6, 6).add((GroupLayout.Group)jPanel4Layout.createParallelGroup(3).add((Component)this.jLabel10).add((Component)this.titleTextField, -2, -1, -2).add((Component)this.jLabel12).add((Component)this.unitsTF, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)jPanel4Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel4Layout.createParallelGroup(3).add((Component)this.jLabel11).add((Component)this.labelTextField, -2, -1, -2)).add((GroupLayout.Group)jPanel4Layout.createParallelGroup(3).add((Component)this.jLabel13).add(this.depend0unitsCB, -2, -1, -2))).addContainerGap(-1, Short.MAX_VALUE)));
        this.jTabbedPane1.addTab("labels", this.jPanel4);
        this.whereCB.setText("Only load data where:");
        this.whereParamList.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        AutoBinding binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.whereCB, (Property)ELProperty.create((String)"${selected}"), this.whereParamList, (Property)BeanProperty.create((String)"enabled"));
        this.bindingGroup.addBinding((Binding)binding);
        this.whereParamList.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AsciiTableDataSourceEditorPanel.this.whereParamListActionPerformed(evt);
            }
        });
        this.whereOp.setModel(new DefaultComboBoxModel<String>(new String[]{".eq", ".ne", ".ge", ".gt", ".le", ".lt", ".within", ".matches"}));
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.whereCB, (Property)ELProperty.create((String)"${selected}"), this.whereOp, (Property)BeanProperty.create((String)"enabled"));
        this.bindingGroup.addBinding((Binding)binding);
        this.whereValueCB.setEditable(true);
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.whereCB, (Property)ELProperty.create((String)"${selected}"), this.whereValueCB, (Property)BeanProperty.create((String)"enabled"));
        this.bindingGroup.addBinding((Binding)binding);
        GroupLayout jPanel5Layout = new GroupLayout((Container)this.jPanel5);
        this.jPanel5.setLayout((LayoutManager)jPanel5Layout);
        jPanel5Layout.setHorizontalGroup((GroupLayout.Group)jPanel5Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel5Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel5Layout.createParallelGroup(2).add(this.whereParamList, -2, 145, -2).add((Component)this.whereCB)).addPreferredGap(0).add(this.whereOp, -2, -1, -2).addPreferredGap(0).add(this.whereValueCB, -2, -1, -2).addContainerGap(410, Short.MAX_VALUE)));
        jPanel5Layout.setVerticalGroup((GroupLayout.Group)jPanel5Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel5Layout.createSequentialGroup().addContainerGap().add((Component)this.whereCB).addPreferredGap(0).add((GroupLayout.Group)jPanel5Layout.createParallelGroup(3).add(this.whereParamList, -2, -1, -2).add(this.whereOp, -2, -1, -2).add(this.whereValueCB, -2, -1, -2)).addContainerGap(28, Short.MAX_VALUE)));
        this.jTabbedPane1.addTab("subset", this.jPanel5);
        this.xComboBox.setEditable(true);
        this.xComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.xCheckBox.setText("X:");
        this.yCheckBox.setText("Y:");
        this.yComboBox.setEditable(true);
        this.yComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.zCheckBox.setText("Z:");
        this.zComboBox.setEditable(true);
        this.zComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jLabel15.setText("Select the columns which will be displayed as X, Y, and Z (typically color) coordinates.");
        GroupLayout xyzPanelLayout = new GroupLayout((Container)this.xyzPanel);
        this.xyzPanel.setLayout((LayoutManager)xyzPanelLayout);
        xyzPanelLayout.setHorizontalGroup((GroupLayout.Group)xyzPanelLayout.createParallelGroup(1).add((GroupLayout.Group)xyzPanelLayout.createSequentialGroup().add((GroupLayout.Group)xyzPanelLayout.createParallelGroup(1).add((GroupLayout.Group)xyzPanelLayout.createSequentialGroup().add(12, 12, 12).add((Component)this.xCheckBox).addPreferredGap(0).add(this.xComboBox, -2, 134, -2).add(18, 18, 18).add((Component)this.yCheckBox).addPreferredGap(0).add(this.yComboBox, -2, -1, -2).add(18, 18, 18).add((Component)this.zCheckBox).addPreferredGap(0).add(this.zComboBox, -2, -1, -2)).add((GroupLayout.Group)xyzPanelLayout.createSequentialGroup().addContainerGap().add((Component)this.jLabel15))).addContainerGap(239, Short.MAX_VALUE)));
        xyzPanelLayout.linkSize(new Component[]{this.xComboBox, this.yComboBox, this.zComboBox}, 1);
        xyzPanelLayout.setVerticalGroup((GroupLayout.Group)xyzPanelLayout.createParallelGroup(1).add((GroupLayout.Group)xyzPanelLayout.createSequentialGroup().addContainerGap().add((Component)this.jLabel15).addPreferredGap(0).add((GroupLayout.Group)xyzPanelLayout.createParallelGroup(3).add(this.xComboBox, -2, -1, -2).add((Component)this.xCheckBox).add((Component)this.yCheckBox).add(this.yComboBox, -2, -1, -2).add((Component)this.zCheckBox).add(this.zComboBox, -2, -1, -2)).addContainerGap(28, Short.MAX_VALUE)));
        this.jTabbedPane1.addTab("xyz", this.xyzPanel);
        this.jTable1.setAutoResizeMode(0);
        this.jScrollPane1.setViewportView(this.jTable1);
        GroupLayout jLayeredPane1Layout = new GroupLayout((Container)this.jLayeredPane1);
        this.jLayeredPane1.setLayout((LayoutManager)jLayeredPane1Layout);
        jLayeredPane1Layout.setHorizontalGroup((GroupLayout.Group)jLayeredPane1Layout.createParallelGroup(1).add(0, 100, Short.MAX_VALUE));
        jLayeredPane1Layout.setVerticalGroup((GroupLayout.Group)jLayeredPane1Layout.createParallelGroup(1).add(0, 100, Short.MAX_VALUE));
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jScrollPane1).add((Component)this.jTabbedPane1).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add(0, 341, Short.MAX_VALUE).add((Component)this.jLayeredPane1, -2, -1, -2).add(0, 341, Short.MAX_VALUE))));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jTabbedPane1, -2, 112, -2).addPreferredGap(0).add((Component)this.jScrollPane1, -1, 354, Short.MAX_VALUE)).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add(0, 0, Short.MAX_VALUE).add((Component)this.jLayeredPane1, -2, -1, -2).add(0, 0, Short.MAX_VALUE))));
        this.bindingGroup.bind();
    }

    private void whereParamListActionPerformed(ActionEvent evt) {
    }

    private void guessFillButtonActionPerformed(ActionEvent evt) {
        this.fillValueTextField.setText(MSG_MOMENT);
        this.guessFillButton.setEnabled(false);
        this.dataStatusLabel.setText("looking for outliers which could be interpretted as fill.");
        Runnable run = new Runnable(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void run() {
                String resultText;
                block9: {
                    DasProgressLabel mon = null;
                    resultText = null;
                    try {
                        DataSetBuilder builder = new DataSetBuilder(1, 100);
                        int[] cols = AsciiTableDataSourceEditorPanel.this.getDataColumns();
                        mon = new DasProgressLabel("looking for outliers which could be interpretted as fill");
                        mon.setLabelComponent(AsciiTableDataSourceEditorPanel.this.dataStatusLabel);
                        int rowCount = AsciiTableDataSourceEditorPanel.this.model.getRowCount();
                        mon.setTaskSize((long)rowCount);
                        mon.started();
                        for (int i = 0; i < rowCount; ++i) {
                            mon.setTaskProgress((long)i);
                            for (int j = cols[0]; j <= cols[1]; ++j) {
                                try {
                                    builder.putValue(-1, Double.parseDouble(String.valueOf(AsciiTableDataSourceEditorPanel.this.model.getValueAt(i, j))));
                                    builder.nextRecord();
                                    continue;
                                }
                                catch (NumberFormatException numberFormatException) {
                                    // empty catch block
                                }
                            }
                        }
                        mon.finished();
                        AutoHistogram ah = new AutoHistogram();
                        QDataSet hist = ah.doit((QDataSet)builder.getDataSet());
                        Map outliers = (Map)DataSetUtil.getUserProperty((QDataSet)hist, (String)"outliers");
                        resultText = outliers != null && outliers.size() == 1 ? String.valueOf(outliers.keySet().iterator().next()) : "";
                        if (mon == null) break block9;
                    }
                    catch (IllegalArgumentException ex) {
                        try {
                            resultText = "";
                            throw ex;
                        }
                        catch (Throwable throwable) {
                            if (mon != null) {
                                mon.finished();
                                mon.setLabelComponent(null);
                            }
                            String fresultText = resultText;
                            Runnable run = new Runnable(fresultText){
                                final /* synthetic */ String val$fresultText;
                                {
                                    this.val$fresultText = string;
                                }

                                @Override
                                public void run() {
                                    AsciiTableDataSourceEditorPanel.this.fillValueTextField.setText(this.val$fresultText);
                                    AsciiTableDataSourceEditorPanel.this.dataStatusLabel.setText("                    ");
                                    AsciiTableDataSourceEditorPanel.this.guessFillButton.setEnabled(true);
                                }
                            };
                            SwingUtilities.invokeLater(run);
                            throw throwable;
                        }
                    }
                    mon.finished();
                    mon.setLabelComponent(null);
                }
                String fresultText = resultText;
                Runnable run = new /* invalid duplicate definition of identical inner class */;
                SwingUtilities.invokeLater(run);
            }
        };
        new Thread(run).start();
    }

    private void validMaxTextFieldActionPerformed(ActionEvent evt) {
    }

    private void fillValueTextFieldFocusLost(FocusEvent evt) {
        String val = this.fillValueTextField.getText();
        if (val.trim().length() > 0) {
            try {
                double d = Double.parseDouble(val);
                if (val.contains("+")) {
                    this.fillValueTextField.setText(String.valueOf(d));
                }
            }
            catch (NumberFormatException ex) {
                JOptionPane.showMessageDialog(this, "Only enter numbers here.  Non-numbers are treated as fill.");
            }
        }
    }

    private void columnsComboBoxFocusGained(FocusEvent evt) {
        this.focusDep0 = false;
    }

    private void columnsComboBoxItemStateChanged(ItemEvent evt) {
        this.setColumn((String)this.columnsComboBox.getSelectedItem());
    }

    private void dep0ColumnsFocusGained(FocusEvent evt) {
        this.focusDep0 = true;
    }

    private void dep0ColumnsItemStateChanged(ItemEvent evt) {
        this.setDep0((String)this.dep0Columns.getSelectedItem());
    }

    private void guessTimeFormatToggleButtonActionPerformed(ActionEvent evt) {
        if (this.jTable1.getSelectedColumn() == -1) {
            this.timesStatusLabel.setText("select time columns, and the time format is guessed (4 digits implies $Y, 3 implies $j, etc)");
        } else {
            int[] jj = this.jTable1.getSelectedColumns();
            int imin = Integer.MAX_VALUE;
            int imax = Integer.MIN_VALUE;
            for (int j : jj) {
                if (j < imin) {
                    imin = j;
                }
                if (j <= imax) continue;
                imax = j;
            }
            this.timesStatusLabel.setText("selected time columns (" + imin + " though " + imax + ") were used to infer time");
        }
    }

    private void timeFormatToggleButtonActionPerformed(ActionEvent evt) {
        if (this.jTable1.getSelectedColumn() == -1) {
            this.timesStatusLabel.setText("select by dragging the data columns that together form the time");
        } else {
            int[] jj = this.jTable1.getSelectedColumns();
            int imin = Integer.MAX_VALUE;
            int imax = Integer.MIN_VALUE;
            for (int j : jj) {
                if (j < imin) {
                    imin = j;
                }
                if (j <= imax) continue;
                imax = j;
            }
            this.timesStatusLabel.setText("selected time columns (" + imin + " though " + imax + ") were copied to format");
        }
    }

    private void timeFormatFieldsComboBoxActionPerformed(ActionEvent evt) {
        String s = (String)this.timeFormatFieldsComboBox.getSelectedItem();
        int i = s.indexOf(":");
        String insert = s.substring(0, i);
        int i0 = ((JTextField)this.timeFormatCB.getEditor().getEditorComponent()).getCaret().getDot();
        int i1 = ((JTextField)this.timeFormatCB.getEditor().getEditorComponent()).getCaret().getMark();
        if (i1 < i0) {
            int t = i0;
            i0 = i1;
            i1 = t;
        }
        String text = this.timeFormatCB.getSelectedItem().toString();
        String n = text.substring(0, i0) + insert + text.substring(i1);
        this.timeFormatCB.setSelectedItem(n);
        this.timeFormatFieldsComboBox.setSelectedIndex(0);
    }

    private void commentComboBoxActionPerformed(ActionEvent evt) {
        String value = (String)this.commentComboBox.getSelectedItem();
        if (value.equals("# hash")) {
            this.params.remove(PARAMS_KEY_COMMENT);
            this.parser.setCommentPrefix("#");
            this.update();
        } else if (value.equals("none") || value.trim().equals("")) {
            this.params.put(PARAMS_KEY_COMMENT, "");
            this.parser.setCommentPrefix(null);
            this.update();
        } else {
            int i = value.indexOf(" ");
            String prefix = i == -1 ? value : value.substring(0, i);
            this.params.put(PARAMS_KEY_COMMENT, prefix);
            this.parser.setCommentPrefix(prefix);
            this.update();
        }
    }

    private void jToggleButton1ActionPerformed(ActionEvent evt) {
        this.headerLabel.setText("select the first column of data or column headings");
    }

    private void skipLinesTextFieldFocusLost(FocusEvent evt) {
    }

    private void skipLinesTextFieldFocusGained(FocusEvent evt) {
    }

    private int[] getDataColumns() {
        int[] result = new int[2];
        String scol = this.column;
        String ecol = this.column;
        if (this.column.contains("-")) {
            int i = this.column.indexOf("-");
            ecol = this.column.substring(i + 1);
        }
        for (Map.Entry<Integer, String> e : this.columns.entrySet()) {
            if (e.getValue().equals(scol)) {
                result[0] = e.getKey();
            }
            if (!e.getValue().equals(ecol)) continue;
            result[1] = e.getKey();
        }
        return result;
    }

    private boolean isIso8601TimeField0() {
        int i = this.getSkipLines();
        int nl = this.jTable1.getRowCount();
        String text1 = String.valueOf(this.jTable1.getValueAt(i, 0));
        String text2 = String.valueOf(this.jTable1.getValueAt(nl > i + 1 ? i + 1 : i, 0));
        return !text1.equals(text2) && TimeParser.isIso8601String((String)text1) && TimeParser.isIso8601String((String)text2);
    }

    private int guessTimeFormatColumn(String example, int column, int current, StringBuilder template) {
        int i = this.getSkipLines();
        int nl = this.jTable1.getRowCount();
        int step = 1;
        if (nl > 10000) {
            nl = 10000;
        }
        int digits = 0;
        int max = -999999999;
        int min = 999999999;
        while (i < nl) {
            String s = String.valueOf(this.jTable1.getValueAt(i, column));
            int slen = s.length();
            boolean isNumber = false;
            try {
                int value = (int)Double.parseDouble(s);
                isNumber = true;
                if (value > max) {
                    max = value;
                }
                if (value < min) {
                    min = value;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (this.model.isRecord(i) && slen > digits && isNumber) {
                digits = slen;
            }
            i += step;
        }
        switch (current) {
            case 1: {
                switch (digits) {
                    case 2: {
                        template.append("$y");
                        return 2;
                    }
                    case 4: {
                        template.append("$Y");
                        return 2;
                    }
                    case 5: {
                        template.append("$Y$j");
                        return 4;
                    }
                    case 6: {
                        template.append("$y$m$d");
                        return 4;
                    }
                    case 8: {
                        if (!Character.isDigit(example.charAt(4))) {
                            template.append("$Y").append(example.charAt(4)).append("$j");
                            return 4;
                        }
                        template.append("$Y$m$d");
                        return 4;
                    }
                    case 10: {
                        if (!Character.isDigit(example.charAt(4))) {
                            template.append("$Y").append(example.charAt(4)).append("$m").append(example.charAt(7)).append("$d");
                            return 4;
                        }
                        template.append("$X");
                        return current;
                    }
                }
                template.append("$X");
                return current;
            }
            case 2: {
                if (min == 999999999) {
                    template.append("$b");
                    return 3;
                }
                if (max <= 12) {
                    template.append("$m");
                    return 3;
                }
                if (max <= 366) {
                    template.append("$j");
                    return 4;
                }
                template.append("$x");
                return current;
            }
            case 3: {
                if (max <= 31) {
                    template.append("$d");
                    return 4;
                }
                template.append("$x");
                return current;
            }
            case 4: {
                if (digits < 3 && max < 25) {
                    template.append("$H");
                    return 5;
                }
                if (digits == 4) {
                    template.append("$H$M");
                    return 6;
                }
                if (digits == 5 && !Character.isDigit(example.charAt(2))) {
                    template.append("$H").append(example.charAt(2)).append("$M");
                    return 6;
                }
                if (digits == 6) {
                    template.append("$H$M$S");
                    return 7;
                }
                if (digits == 7 && !Character.isDigit(example.charAt(2))) {
                    template.append("$H").append(example.charAt(2)).append("$M").append(example.charAt(5)).append("$S");
                    return 7;
                }
                if (digits != 8 || Character.isDigit(example.charAt(2))) break;
                template.append("$H").append(example.charAt(2)).append("$M").append(example.charAt(5)).append("$S");
                return 7;
            }
            case 5: {
                template.append("$M");
                return 6;
            }
            case 6: {
                template.append("$S");
                return 7;
            }
            case 7: {
                template.append("$(milli)");
                return 8;
            }
        }
        template.append("$X");
        return current;
    }

    private void guessTimeFormatButtonAP(int row, int first, int last) {
        int curr = 1;
        StringBuilder template = new StringBuilder();
        if (first == last) {
            String example = String.valueOf(this.jTable1.getValueAt(row, first));
            if (TimeParser.isIso8601String((String)example)) {
                this.timeFormatCB.setSelectedItem("ISO8601");
                return;
            }
            logger.fine("time does not appear to be ISO8601");
        }
        for (int i = first; i <= last; ++i) {
            String example = String.valueOf(this.jTable1.getValueAt(row, i));
            curr = this.guessTimeFormatColumn(example, i, curr, template);
            if (i >= last) continue;
            template.append("+");
        }
        this.timeFormatCB.setSelectedItem(template.toString());
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) throws IOException {
        this.file = file;
        this.model.setFile(file);
    }

    public Map<Integer, String> getColumnNames() throws IOException {
        String[] lcolumns = this.parser.getFieldNames();
        LinkedHashMap<Integer, String> result = new LinkedHashMap<Integer, String>();
        for (int i = 0; i < lcolumns.length; ++i) {
            result.put(i, lcolumns[i]);
        }
        return result;
    }

    public int getSkipLines() {
        return this.skipLines;
    }

    public void setSkipLines(int row) {
        int oldRow = this.skipLines;
        this.skipLines = row;
        Rectangle rect = this.jTable1.getCellRect(Math.max(0, this.getSkipLines() - 3), 0, true);
        this.parser.setSkipLines(this.skipLines);
        this.update();
        this.jTable1.scrollRectToVisible(rect);
        this.firePropertyChange(PROP_FIRST_ROW, oldRow, row);
    }

    public String getColumn() {
        int i = this.column.indexOf(": ");
        if (i > -1) {
            return this.column.substring(0, i);
        }
        return this.column;
    }

    public void setColumn(String column) {
        String oldColumn = this.column;
        this.column = column;
        if (!this.initializing) {
            this.labelTextField.setText("");
            this.titleTextField.setText("");
            this.unitsTF.setText("");
            this.depend0unitsCB.setSelectedItem("");
        }
        this.firePropertyChange(PROP_COLUMN, oldColumn, column);
    }

    public String getDep0() {
        int i = this.dep0.indexOf(": ");
        if (i > -1) {
            return this.dep0.substring(0, i);
        }
        return this.dep0;
    }

    public void setDep0(String dep0) {
        String oldDep0 = this.dep0;
        this.dep0 = dep0;
        this.firePropertyChange(PROP_DEP0, oldDep0, dep0);
    }

    public JPanel getPanel() {
        return this;
    }

    public boolean reject(String url) throws IOException, URISyntaxException {
        this.split = URISplit.parse((String)url);
        FileSystem fs = FileSystem.create((URI)DataSetURI.toUri((String)this.split.path));
        return fs.isDirectory(this.split.file.substring(this.split.path.length()));
    }

    public boolean prepare(String url, Window parent, ProgressMonitor mon) throws Exception {
        this.split = URISplit.parse((String)url);
        DataSetURI.getFile((URI)DataSetURI.toUri((String)this.split.file), (ProgressMonitor)mon);
        return true;
    }

    public void setURI(String url) {
        try {
            this.split = URISplit.parse((String)url);
            this.params = URISplit.parseParams((String)this.split.params);
            File f = DataSetURI.getFile((URI)DataSetURI.toUri((String)this.split.file), (ProgressMonitor)new NullProgressMonitor());
            this.setFile(f);
            JPanel selectedTab = this.dataPanel;
            if (this.params.containsKey(PROP_FIRST_ROW)) {
                this.setSkipLines(Integer.parseInt(this.params.get(PROP_FIRST_ROW)));
            }
            if (this.params.containsKey("skip")) {
                this.setSkipLines(Integer.parseInt(this.params.get("skip")));
            }
            if (this.params.containsKey(PROP_COLUMN)) {
                this.setColumn(this.params.get(PROP_COLUMN));
            }
            if (this.params.containsKey("arg_0")) {
                this.setColumn(this.params.get("arg_0"));
            }
            if (this.params.containsKey("rank2")) {
                this.setColumn(this.params.get("rank2"));
            }
            if (this.params.containsKey("bundle")) {
                this.setColumn(this.params.get("bundle"));
                this.bundleCheckBox.setSelected(true);
            }
            if (this.params.containsKey("title")) {
                this.titleTextField.setText(this.params.get("title"));
            }
            if (this.params.containsKey("label")) {
                this.labelTextField.setText(this.params.get("label"));
            }
            if (this.params.containsKey("units")) {
                this.unitsTF.setText(this.params.get("units"));
            }
            if (this.params.containsKey("depend0Units")) {
                String depend0Units = this.params.get("depend0Units");
                depend0Units = depend0Units.replaceAll("\\+", " ");
                this.depend0unitsCB.setSelectedItem(depend0Units);
            } else {
                this.depend0unitsCB.setSelectedItem("");
            }
            String arg0 = this.params.get("arg_0");
            if (arg0 != null) {
                String col = ":";
                if (arg0.equals("rank2")) {
                    this.setColumn(col);
                } else if (arg0.equals("bundle")) {
                    this.setColumn(col);
                    this.bundleCheckBox.setSelected(true);
                }
            }
            if (this.params.containsKey("depend1Values")) {
                this.dep1Values.setSelectedItem(this.params.get("depend1Values"));
            } else {
                this.dep1Values.setSelectedItem("");
            }
            if (this.params.containsKey("depend0")) {
                this.setDep0(this.params.get("depend0"));
            }
            if (this.params.containsKey("time")) {
                this.setDep0(this.params.get("time"));
                this.dep0timeCheckBox.setSelected(true);
            }
            if (this.params.containsKey("X")) {
                this.xCheckBox.setSelected(true);
                this.xComboBox.setSelectedItem(this.params.get("X"));
                selectedTab = this.xyzPanel;
            } else {
                this.xComboBox.setSelectedItem("");
            }
            if (this.params.containsKey("Y")) {
                this.yCheckBox.setSelected(true);
                this.yComboBox.setSelectedItem(this.params.get("Y"));
            } else {
                this.yComboBox.setSelectedItem("");
            }
            if (this.params.containsKey("Z")) {
                this.zCheckBox.setSelected(true);
                this.zComboBox.setSelectedItem(this.params.get("Z"));
            } else {
                this.zComboBox.setSelectedItem("");
            }
            if (this.params.containsKey("timeFormat")) {
                this.timeFormatCB.setSelectedItem(this.params.get("timeFormat"));
            }
            this.fillValueTextField.setText(this.getParam(this.params, "fill"));
            this.validMinTextField.setText(this.getParam(this.params, "validMin"));
            this.validMaxTextField.setText(this.getParam(this.params, "validMax"));
            this.jTabbedPane1.setSelectedComponent(selectedTab);
            this.update();
            this.checkHeaders();
            if (this.columns != null) {
                this.whereParamList.setModel(new DefaultComboBoxModel<Object>(this.columns.values().toArray()));
                String where = this.getParam(this.params, "where");
                if (where != null && where.length() > 0) {
                    this.whereCB.setSelected(true);
                    int i = where.indexOf(".");
                    if (i > -1) {
                        this.whereParamList.setSelectedItem(where.substring(0, i));
                        int i0 = where.indexOf("(");
                        int i1 = where.indexOf(")", i0);
                        this.whereOp.setSelectedItem(where.substring(i, i0));
                        this.whereValueCB.setSelectedItem(where.substring(i0 + 1, i1).replaceAll("\\+", " "));
                    }
                } else {
                    this.whereCB.setSelected(false);
                }
            } else {
                this.whereParamList.setModel(new DefaultComboBoxModel<String>(new String[]{"not available"}));
                this.whereCB.setSelected(false);
            }
            this.initializing = false;
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
            throw new RuntimeException(ex);
        }
    }

    private String getParam(Map<String, String> params, String name) {
        String result = params.get(name);
        if (result == null) {
            return "";
        }
        return result;
    }

    private void setParam(Map<String, String> params, String name, String s) {
        if ((s = s.trim()).length() > 0) {
            params.put(name, s);
        } else {
            params.remove(name);
        }
    }

    public String getURI() {
        String s;
        if (this.skipLines > 0) {
            this.params.put(PROP_FIRST_ROW, "" + this.skipLines);
        } else {
            this.params.remove(PROP_FIRST_ROW);
        }
        this.params.remove("skip");
        if (!this.getDep0().equals("")) {
            if (this.dep0timeCheckBox.isSelected()) {
                this.params.put("time", this.getDep0());
                this.params.remove("depend0");
            } else {
                this.params.put("depend0", this.getDep0());
                this.params.remove("time");
            }
        } else {
            this.params.remove("time");
            this.params.remove("depend0");
        }
        this.params.remove("arg_0");
        this.params.remove(PROP_COLUMN);
        if (this.getColumn().contains(":") || this.getColumn().contains("-")) {
            if (this.bundleCheckBox.isSelected()) {
                this.params.put("bundle", this.getColumn());
                this.params.remove("rank2");
            } else {
                this.params.put("rank2", this.getColumn());
                this.params.remove("bundle");
            }
        } else {
            if (this.isIso8601TimeField0()) {
                if (this.getDep0().equals("") || this.getDep0().equals("field0")) {
                    this.params.put("arg_0", this.getColumn());
                    this.params.remove("depend0");
                } else {
                    this.params.put(PROP_COLUMN, this.getColumn());
                }
            } else {
                s = this.getColumn();
                if (s.trim().length() > 0) {
                    this.params.put(PROP_COLUMN, s);
                }
            }
            this.params.remove("rank2");
            this.params.remove("bundle");
        }
        this.params.remove("group");
        String string = s = this.dep1Values.getSelectedItem() == null ? "" : (String)this.dep1Values.getSelectedItem();
        if (s.length() > 0) {
            this.setParam(this.params, "depend1Values", s);
        } else {
            this.params.remove("depend1Values");
        }
        if (this.xCheckBox.isSelected()) {
            this.setParam(this.params, "X", this.xComboBox.getSelectedItem().toString());
        } else {
            this.params.remove("X");
        }
        if (this.yCheckBox.isSelected()) {
            this.setParam(this.params, "Y", this.yComboBox.getSelectedItem().toString());
        } else {
            this.params.remove("Y");
        }
        if (this.zCheckBox.isSelected()) {
            this.setParam(this.params, "Z", this.zComboBox.getSelectedItem().toString());
        } else {
            this.params.remove("Z");
        }
        this.setParam(this.params, "title", this.titleTextField.getText());
        this.setParam(this.params, "label", this.labelTextField.getText());
        this.setParam(this.params, "units", this.unitsTF.getText());
        if (this.depend0unitsCB.getSelectedItem() != null && this.depend0unitsCB.getSelectedItem().toString().trim().length() > 0) {
            String depend0Units = this.depend0unitsCB.getSelectedItem().toString();
            depend0Units = depend0Units.replaceAll(" ", "+");
            this.setParam(this.params, "depend0Units", depend0Units);
        } else {
            this.params.remove("depend0Units");
        }
        if (this.timeFormatCB.getSelectedItem() != null) {
            if (!this.timeFormatCB.getSelectedItem().toString().equals("ISO8601")) {
                this.setParam(this.params, "timeFormat", this.timeFormatCB.getSelectedItem().toString());
            } else {
                this.params.remove("timeFormat");
            }
        } else {
            this.params.remove("timeFormat");
        }
        String s2 = this.fillValueTextField.getText().trim();
        if (!s2.equals(MSG_MOMENT) && s2.length() > 0) {
            this.setParam(this.params, "fill", s2);
        }
        this.setParam(this.params, "validMin", this.validMinTextField.getText());
        this.setParam(this.params, "validMax", this.validMaxTextField.getText());
        if (this.whereCB.isSelected()) {
            this.setParam(this.params, "where", String.format("%s%s(%s)", this.whereParamList.getSelectedItem(), this.whereOp.getSelectedItem(), this.whereValueCB.getSelectedItem().toString().replaceAll(" ", "+")));
        } else {
            this.setParam(this.params, "where", "");
        }
        this.split.params = URISplit.formatParams(this.params);
        if (this.split.params != null && this.split.params.length() == 0) {
            this.split.params = null;
        }
        return URISplit.format((URISplit)this.split);
    }

    private static void updateColumns(JTable jTable1, Map<Integer, String> columns) {
        int n = jTable1.getColumnCount();
        int wide = n < 5 ? 210 : 170;
        int norm = n < 5 ? 100 : 70;
        int narrow = n < 5 ? 60 : 50;
        for (int i = 0; i < jTable1.getColumnCount(); ++i) {
            String label = i < columns.size() ? columns.get(i) : "x";
            jTable1.getColumnModel().getColumn(i).setHeaderValue(label);
            int nrow = jTable1.getRowCount();
            Object o = jTable1.getValueAt(nrow - 1, i);
            String s = String.valueOf(o);
            if (s.length() > 16) {
                jTable1.getColumnModel().getColumn(i).setPreferredWidth(wide);
                continue;
            }
            if (s.length() < 5) {
                jTable1.getColumnModel().getColumn(i).setPreferredWidth(narrow);
                continue;
            }
            jTable1.getColumnModel().getColumn(i).setPreferredWidth(norm);
        }
        jTable1.getTableHeader().repaint();
    }

    private void checkHeaders() {
        try {
            AsciiParser.DelimParser p = this.parser.guessSkipAndDelimParser(this.file.toString());
            if (p == null) {
                return;
            }
            this.model.setRecParser((AsciiParser.RecordParser)p);
            this.columns = this.getColumnNames();
            Exception richHeaderWarn = null;
            this.isRichHeader = AsciiParser.isRichHeader((String)p.header);
            if (this.isRichHeader) {
                try {
                    String[] columns1 = new String[p.fieldCount()];
                    for (int i = 0; i < columns1.length; ++i) {
                        columns1[i] = "";
                    }
                    AsciiHeadersParser.parseMetadata((String)p.header, (String[])columns1, (String[])columns1);
                }
                catch (IllegalArgumentException | ParseException ex) {
                    logger.log(Level.SEVERE, ex.getMessage(), ex);
                    richHeaderWarn = ex;
                }
            }
            if (richHeaderWarn != null) {
                JOptionPane.showMessageDialog(this.jTable1, "<html>Rich headers are JSON headers that provide additional information about the parameters in the text file.<br>There was an error when parsing the headers.<br><br>" + richHeaderWarn.toString() + "</html>", "Rich Headers parser error detected", 0);
            }
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
        }
    }

    private void update() {
        try {
            AsciiParser.DelimParser p = this.parser.guessSkipAndDelimParser(this.file.toString());
            if (p == null) {
                p = new AsciiParser().getDelimParser(2, "\\s+");
            }
            this.model.setRecParser((AsciiParser.RecordParser)p);
            LinkedHashMap<Integer, Object> list = new LinkedHashMap<Integer, Object>();
            this.columns = this.getColumnNames();
            Map xx = this.parser.getRichFields();
            int ij = this.columns.size();
            for (Map.Entry s : xx.entrySet()) {
                list.put(ij, s.getKey());
                ++ij;
            }
            list.putAll(this.columns);
            AsciiTableDataSourceEditorPanel.updateColumns(this.jTable1, this.columns);
            String lcol = this.getColumn();
            int icol = this.jTable1.getSelectedColumn();
            this.columnsComboBox.setModel(new DefaultComboBoxModel<Object>(list.values().toArray()));
            this.columnsComboBox.setSelectedItem(this.getColumn());
            if (icol != -1) {
                this.setColumn(this.columns.get(icol));
            } else {
                this.setColumn(lcol);
            }
            String depend1Values = this.dep1Values.getSelectedItem() == null ? "" : this.dep1Values.getSelectedItem().toString();
            this.dep1Values.setModel(new DefaultComboBoxModel<String>(new String[]{"", "field1-field" + (this.columns.size() - 1)}));
            this.dep1Values.setSelectedItem(depend1Values);
            ArrayList dep0Values = new ArrayList(list.values());
            String ldep0 = this.getDep0();
            dep0Values.add(0, "");
            this.dep0Columns.setModel(new DefaultComboBoxModel<Object>(dep0Values.toArray()));
            this.dep0Columns.setSelectedItem(ldep0);
            Object s = this.xComboBox.getSelectedItem();
            this.xComboBox.setModel(new DefaultComboBoxModel<Object>(list.values().toArray()));
            this.xComboBox.setSelectedItem(s);
            s = this.yComboBox.getSelectedItem();
            this.yComboBox.setModel(new DefaultComboBoxModel<Object>(list.values().toArray()));
            this.yComboBox.setSelectedItem(s);
            s = this.zComboBox.getSelectedItem();
            this.zComboBox.setModel(new DefaultComboBoxModel<Object>(list.values().toArray()));
            this.zComboBox.setSelectedItem(s);
            String comment = "#";
            if (this.params.containsKey(PARAMS_KEY_COMMENT) && (comment = this.params.get(PARAMS_KEY_COMMENT)).trim().length() == 0) {
                comment = "none";
            }
            ComboBoxModel model1 = this.commentComboBox.getModel();
            for (int i = 0; i < model1.getSize(); ++i) {
                if (!((String)model1.getElementAt(i)).startsWith(comment)) continue;
                this.commentComboBox.setSelectedIndex(i);
            }
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
        }
    }

    private static enum Tool {
        NONE,
        SKIPLINES,
        COLUMN,
        DEPEND_0,
        TIMEFORMAT,
        GUESSTIMEFORMAT,
        FILLVALUE,
        DEPEND_1;

    }
}

