/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.csv;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.autoplot.datasource.DataSourceFormatEditorPanel;
import org.autoplot.datasource.URISplit;
import org.das2.util.LoggerManager;
import org.jdesktop.layout.GroupLayout;

public class CsvDataSourceFormatEditorPanel
extends JPanel
implements DataSourceFormatEditorPanel {
    private static final Logger logger = LoggerManager.getLogger((String)"apdss");
    String file;
    private JCheckBox delimiterCheckBox;
    private JTextField delimiterTextField;
    private JPanel explicitFormatSpecPanel;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JTextField numberFormatSpecifierTF;
    private JCheckBox timeUnitsCB;
    private JComboBox timeUnitsDropList;
    private JComboBox timesFormatTF;
    private JCheckBox useFormatSpecCB;

    public CsvDataSourceFormatEditorPanel() {
        this.initComponents();
    }

    private void initComponents() {
        this.useFormatSpecCB = new JCheckBox();
        this.explicitFormatSpecPanel = new JPanel();
        this.jLabel1 = new JLabel();
        this.numberFormatSpecifierTF = new JTextField();
        this.timesFormatTF = new JComboBox();
        this.jLabel2 = new JLabel();
        this.timeUnitsDropList = new JComboBox();
        this.timeUnitsCB = new JCheckBox();
        this.delimiterCheckBox = new JCheckBox();
        this.delimiterTextField = new JTextField();
        this.useFormatSpecCB.setText("Explicit Format Specifiers");
        this.useFormatSpecCB.setToolTipText("Specify the format to for numbers and times.");
        this.jLabel1.setText("Numbers:");
        this.numberFormatSpecifierTF.setText("%5.2f");
        this.timesFormatTF.setModel(new DefaultComboBoxModel<String>(new String[]{"Day", "Minute", "Second", "Millisecond", "Microsecond", "Nanosecond"}));
        this.jLabel2.setText("Time Resolution:");
        GroupLayout explicitFormatSpecPanelLayout = new GroupLayout((Container)this.explicitFormatSpecPanel);
        this.explicitFormatSpecPanel.setLayout((LayoutManager)explicitFormatSpecPanelLayout);
        explicitFormatSpecPanelLayout.setHorizontalGroup((GroupLayout.Group)explicitFormatSpecPanelLayout.createParallelGroup(1).add((GroupLayout.Group)explicitFormatSpecPanelLayout.createSequentialGroup().add((GroupLayout.Group)explicitFormatSpecPanelLayout.createParallelGroup(1).add((Component)this.jLabel1).add((Component)this.jLabel2)).addPreferredGap(0).add((GroupLayout.Group)explicitFormatSpecPanelLayout.createParallelGroup(1).add((Component)this.numberFormatSpecifierTF, -2, 80, -2).add((Component)this.timesFormatTF, -2, -1, -2)).addContainerGap(144, Short.MAX_VALUE)));
        explicitFormatSpecPanelLayout.setVerticalGroup((GroupLayout.Group)explicitFormatSpecPanelLayout.createParallelGroup(1).add((GroupLayout.Group)explicitFormatSpecPanelLayout.createSequentialGroup().add((GroupLayout.Group)explicitFormatSpecPanelLayout.createParallelGroup(3).add((Component)this.jLabel1).add((Component)this.numberFormatSpecifierTF, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)explicitFormatSpecPanelLayout.createParallelGroup(3).add((Component)this.jLabel2).add((Component)this.timesFormatTF, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.timeUnitsDropList.setEditable(true);
        this.timeUnitsDropList.setModel(new DefaultComboBoxModel<String>(new String[]{"hours since 2015-01-01T00:00", "seconds since 2015-09-22T00:00"}));
        this.timeUnitsCB.setText("Time Units:");
        this.delimiterCheckBox.setText("Delimiter:");
        this.delimiterCheckBox.setToolTipText("The delimiter, or SPACE, NONE, COMMA, SEMICOLON, COLON, TAB");
        this.delimiterTextField.setText(" ");
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.timeUnitsCB).addPreferredGap(0).add((Component)this.timeUnitsDropList, 0, 365, Short.MAX_VALUE)).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.delimiterCheckBox).addPreferredGap(0).add((Component)this.delimiterTextField, -2, 26, -2)).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.useFormatSpecCB).add((GroupLayout.Group)layout.createSequentialGroup().add(12, 12, 12).add((Component)this.explicitFormatSpecPanel, -2, -1, -2))).add(0, 0, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.useFormatSpecCB).addPreferredGap(0).add((Component)this.explicitFormatSpecPanel, -2, -1, -2).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.timeUnitsDropList, -2, -1, -2).add((Component)this.timeUnitsCB)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.delimiterCheckBox).add((Component)this.delimiterTextField, -2, -1, -2)).addContainerGap(140, Short.MAX_VALUE)));
    }

    public JPanel getPanel() {
        return this;
    }

    public void setURI(String uri) {
        URISplit split = URISplit.parse((String)uri);
        this.file = split.file;
        LinkedHashMap args = URISplit.parseParams((String)split.params);
        this.useFormatSpecCB.setSelected(false);
        String s = (String)args.get("format");
        if (s != null) {
            this.numberFormatSpecifierTF.setText((String)args.get("format"));
            this.useFormatSpecCB.setSelected(true);
        }
        if ((s = (String)args.get("tformat")) != null) {
            this.timesFormatTF.setSelectedItem(s);
            this.useFormatSpecCB.setSelected(true);
        }
        if ((s = (String)args.get("depend0Units")) != null) {
            this.timeUnitsDropList.setSelectedItem(s);
            this.timeUnitsCB.setSelected(true);
        }
        this.delimiterCheckBox.setSelected(!(s = args.getOrDefault("delim", ",")).equals(","));
        if (this.delimiterCheckBox.isSelected()) {
            this.delimiterTextField.setText(s);
        }
    }

    public String getURI() {
        String result = this.file;
        HashMap<String, String> args = new HashMap<String, String>();
        if (this.useFormatSpecCB.isSelected()) {
            try {
                args.put("format", URLEncoder.encode(this.numberFormatSpecifierTF.getText(), "UTF-8"));
            }
            catch (UnsupportedEncodingException ex) {
                logger.log(Level.SEVERE, ex.getMessage(), ex);
            }
            String ts = String.valueOf(this.timesFormatTF.getSelectedItem());
            args.put("tformat", ts);
        }
        if (this.timeUnitsCB.isSelected()) {
            args.put("depend0Units", this.timeUnitsDropList.getSelectedItem().toString());
        }
        if (this.delimiterCheckBox.isSelected()) {
            String s = this.delimiterTextField.getText();
            if (s.equals(" ")) {
                s = "SPACE";
            }
            args.put("delim", s);
        }
        String params = URISplit.formatParams(args);
        if (result == null) {
            result = "file:///";
        }
        URISplit ss = URISplit.parse((String)result);
        if (params.length() > 0) {
            ss.params = params;
        }
        return URISplit.format((URISplit)ss);
    }
}

