/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.json;

import java.io.File;
import java.io.FileInputStream;
import java.net.URI;
import org.autoplot.datasource.AbstractDataSource;
import org.autoplot.json.JSONJIterator;
import org.das2.datum.Datum;
import org.das2.qds.DDataSet;
import org.das2.qds.QDataSet;
import org.das2.qds.ops.Ops;
import org.das2.qds.util.DataSetBuilder;
import org.das2.util.monitor.ProgressMonitor;
import org.json.JSONArray;
import org.json.JSONObject;

public class JSONDataSource
extends AbstractDataSource {
    public JSONDataSource(URI uri) {
        super(uri);
    }

    public QDataSet getDataSet(ProgressMonitor mon) throws Exception {
        File f = this.getFile(mon);
        String key = this.getParam("arg_0", "0");
        String dep0 = this.getParam("depend0", null);
        int ikey = -1;
        int idep0 = -1;
        Class<?> expecting = null;
        DataSetBuilder build = new DataSetBuilder(2, 100, 1 + (dep0 == null ? 0 : 1));
        try (FileInputStream ins = new FileInputStream(f);){
            JSONArray job;
            Object ob;
            JSONJIterator iter = new JSONJIterator(ins);
            if (iter.hasNext()) {
                Datum d0;
                Datum d;
                ob = iter.next();
                if (ob instanceof JSONArray) {
                    job = (JSONArray)ob;
                    ikey = Integer.parseInt(key);
                    idep0 = Integer.parseInt(dep0);
                    d = Ops.datum((Object)job.get(ikey));
                    if (dep0 == null) {
                        build.nextRecord(new Object[]{d});
                    } else {
                        d0 = Ops.datum((Object)job.get(idep0));
                        build.nextRecord(new Object[]{d0, d});
                    }
                } else if (ob instanceof JSONObject) {
                    job = (JSONObject)ob;
                    d = Ops.datum((Object)job.get(key));
                    if (dep0 == null) {
                        build.nextRecord(new Object[]{d});
                    } else {
                        d0 = Ops.datum((Object)job.get(dep0));
                        build.nextRecord(new Object[]{d0, d});
                    }
                }
                expecting = ob.getClass();
            }
            while (iter.hasNext()) {
                ob = iter.next();
                if (ob instanceof JSONArray && expecting == ob.getClass()) {
                    job = (JSONArray)ob;
                    if (dep0 == null) {
                        build.nextRecord(new Object[]{job.get(ikey)});
                        continue;
                    }
                    build.nextRecord(new Object[]{job.get(idep0), job.get(ikey)});
                    continue;
                }
                if (!(ob instanceof JSONObject) || expecting != ob.getClass()) continue;
                if (dep0 == null) {
                    job = (JSONObject)ob;
                    build.nextRecord(new Object[]{job.get(key)});
                    continue;
                }
                job = (JSONObject)ob;
                build.nextRecord(new Object[]{job.get(dep0), job.get(key)});
            }
        }
        DDataSet result = build.getDataSet();
        if (result.length(0) == 1) {
            return Ops.unbundle((QDataSet)result, (int)0);
        }
        return result;
    }
}

