
/*
 * AsciiTableDataSourceFormatEditorPanel.java
 *
 * Created on Mar 10, 2011, 3:20:04 PM
 */

package org.autoplot.ascii;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JPanel;
import org.das2.util.LoggerManager;
import org.autoplot.datasource.DataSourceFormatEditorPanel;
import org.autoplot.datasource.URISplit;

/**
 * Editor Panel for formatting data.
 * @author jbf
 */
public class AsciiTableDataSourceFormatEditorPanel extends javax.swing.JPanel implements DataSourceFormatEditorPanel {

    private static final Logger logger= LoggerManager.getLogger("apdss");
    String file;

    /** Creates new form AsciiTableDataSourceFormatEditorPanel */
    public AsciiTableDataSourceFormatEditorPanel() {
        initComponents();
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        bindingGroup = new org.jdesktop.beansbinding.BindingGroup();

        useFormatSpecCB = new javax.swing.JCheckBox();
        richHeadersCB = new javax.swing.JCheckBox();
        explicitFormatSpecPanel = new javax.swing.JPanel();
        jLabel1 = new javax.swing.JLabel();
        numberFormatSpecifierTF = new javax.swing.JTextField();
        timesFormatTF = new javax.swing.JComboBox();
        jLabel2 = new javax.swing.JLabel();
        noHeadersCB = new javax.swing.JCheckBox();
        justDataCB = new javax.swing.JCheckBox();
        timeUnitsDropList = new javax.swing.JComboBox();
        timeUnitsCB = new javax.swing.JCheckBox();
        delimiterCheckBox = new javax.swing.JCheckBox();
        delimiterTextField = new javax.swing.JTextField();
        commentCheckBox = new javax.swing.JCheckBox();
        commentTextField = new javax.swing.JTextField();

        useFormatSpecCB.setText("Explicit Format Specifiers");
        useFormatSpecCB.setToolTipText("Specify the format to for numbers and times.");

        org.jdesktop.beansbinding.Binding binding = org.jdesktop.beansbinding.Bindings.createAutoBinding(org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ_WRITE, explicitFormatSpecPanel, org.jdesktop.beansbinding.ELProperty.create("${enabled}"), useFormatSpecCB, org.jdesktop.beansbinding.BeanProperty.create("selected"));
        bindingGroup.addBinding(binding);

        richHeadersCB.setText("Rich Headers");
        richHeadersCB.setToolTipText("<html>Add additional information about the dataset, <br>\nsuch as titles and valid ranges, in a comment block <br>\nat the top of the ascii output.</html>");
        richHeadersCB.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                richHeadersCBActionPerformed(evt);
            }
        });

        jLabel1.setText("Numbers:");

        binding = org.jdesktop.beansbinding.Bindings.createAutoBinding(org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ_WRITE, explicitFormatSpecPanel, org.jdesktop.beansbinding.ELProperty.create("${enabled}"), jLabel1, org.jdesktop.beansbinding.BeanProperty.create("enabled"));
        bindingGroup.addBinding(binding);

        numberFormatSpecifierTF.setText("%5.2f");

        binding = org.jdesktop.beansbinding.Bindings.createAutoBinding(org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ_WRITE, explicitFormatSpecPanel, org.jdesktop.beansbinding.ELProperty.create("${enabled}"), numberFormatSpecifierTF, org.jdesktop.beansbinding.BeanProperty.create("enabled"));
        bindingGroup.addBinding(binding);

        timesFormatTF.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "Day", "Minute", "Second", "Millisecond", "Microsecond", "Nanosecond" }));

        binding = org.jdesktop.beansbinding.Bindings.createAutoBinding(org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ_WRITE, explicitFormatSpecPanel, org.jdesktop.beansbinding.ELProperty.create("${enabled}"), timesFormatTF, org.jdesktop.beansbinding.BeanProperty.create("enabled"));
        bindingGroup.addBinding(binding);

        jLabel2.setText("Time Resolution:");

        binding = org.jdesktop.beansbinding.Bindings.createAutoBinding(org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ_WRITE, explicitFormatSpecPanel, org.jdesktop.beansbinding.ELProperty.create("${enabled}"), jLabel2, org.jdesktop.beansbinding.BeanProperty.create("enabled"));
        bindingGroup.addBinding(binding);

        org.jdesktop.layout.GroupLayout explicitFormatSpecPanelLayout = new org.jdesktop.layout.GroupLayout(explicitFormatSpecPanel);
        explicitFormatSpecPanel.setLayout(explicitFormatSpecPanelLayout);
        explicitFormatSpecPanelLayout.setHorizontalGroup(
            explicitFormatSpecPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(explicitFormatSpecPanelLayout.createSequentialGroup()
                .add(explicitFormatSpecPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(jLabel1)
                    .add(jLabel2))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(explicitFormatSpecPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(numberFormatSpecifierTF, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 80, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(timesFormatTF, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addContainerGap(144, Short.MAX_VALUE))
        );
        explicitFormatSpecPanelLayout.setVerticalGroup(
            explicitFormatSpecPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(explicitFormatSpecPanelLayout.createSequentialGroup()
                .add(explicitFormatSpecPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(jLabel1)
                    .add(numberFormatSpecifierTF, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(explicitFormatSpecPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(jLabel2)
                    .add(timesFormatTF, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addContainerGap(org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        noHeadersCB.setText("No Headers");
        noHeadersCB.setToolTipText("Don't use any headers, making import into IDL and Matlab easier.");
        noHeadersCB.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                noHeadersCBActionPerformed(evt);
            }
        });

        justDataCB.setText("Just Data, don't format timetags and other dependencies");
        justDataCB.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                justDataCBActionPerformed(evt);
            }
        });

        timeUnitsDropList.setEditable(true);
        timeUnitsDropList.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "hours since 2015-01-01T00:00", "seconds since 2015-09-22T00:00" }));

        binding = org.jdesktop.beansbinding.Bindings.createAutoBinding(org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ_WRITE, timeUnitsCB, org.jdesktop.beansbinding.ELProperty.create("${selected}"), timeUnitsDropList, org.jdesktop.beansbinding.BeanProperty.create("enabled"));
        bindingGroup.addBinding(binding);

        timeUnitsCB.setText("Time Units:");

        delimiterCheckBox.setText("Delimiter:");
        delimiterCheckBox.setToolTipText("The delimiter, or SPACE, NONE, COMMA, SEMICOLON, COLON, TAB");

        delimiterTextField.setText(" ");

        binding = org.jdesktop.beansbinding.Bindings.createAutoBinding(org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ_WRITE, delimiterCheckBox, org.jdesktop.beansbinding.ELProperty.create("${selected}"), delimiterTextField, org.jdesktop.beansbinding.BeanProperty.create("enabled"));
        bindingGroup.addBinding(binding);

        commentCheckBox.setText("Comment:");
        commentCheckBox.setToolTipText("Comment to insert at top.  If empty, then no line is added");

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(layout.createSequentialGroup()
                        .add(timeUnitsCB)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(timeUnitsDropList, 0, 371, Short.MAX_VALUE))
                    .add(layout.createSequentialGroup()
                        .add(delimiterCheckBox)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(delimiterTextField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 26, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                    .add(layout.createSequentialGroup()
                        .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                            .add(useFormatSpecCB)
                            .add(justDataCB)
                            .add(layout.createSequentialGroup()
                                .add(12, 12, 12)
                                .add(explicitFormatSpecPanel, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                            .add(layout.createSequentialGroup()
                                .add(richHeadersCB)
                                .add(18, 18, 18)
                                .add(noHeadersCB)))
                        .add(0, 0, Short.MAX_VALUE))
                    .add(layout.createSequentialGroup()
                        .add(commentCheckBox)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(commentTextField)))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(richHeadersCB)
                    .add(noHeadersCB))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(commentCheckBox)
                    .add(commentTextField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .add(4, 4, 4)
                .add(justDataCB)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(useFormatSpecCB)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(explicitFormatSpecPanel, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(timeUnitsDropList, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(timeUnitsCB))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(delimiterCheckBox)
                    .add(delimiterTextField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addContainerGap(59, Short.MAX_VALUE))
        );

        bindingGroup.bind();
    }// </editor-fold>//GEN-END:initComponents

    private void richHeadersCBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_richHeadersCBActionPerformed
        if ( richHeadersCB.isSelected() ) {
            noHeadersCB.setSelected(false);
        }
    }//GEN-LAST:event_richHeadersCBActionPerformed

    private void noHeadersCBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_noHeadersCBActionPerformed
        if ( noHeadersCB.isSelected() ) {
            richHeadersCB.setSelected(false);
        }
    }//GEN-LAST:event_noHeadersCBActionPerformed

    private void justDataCBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_justDataCBActionPerformed
        // TODO add your handling code here:
    }//GEN-LAST:event_justDataCBActionPerformed


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JCheckBox commentCheckBox;
    private javax.swing.JTextField commentTextField;
    private javax.swing.JCheckBox delimiterCheckBox;
    private javax.swing.JTextField delimiterTextField;
    private javax.swing.JPanel explicitFormatSpecPanel;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JCheckBox justDataCB;
    private javax.swing.JCheckBox noHeadersCB;
    private javax.swing.JTextField numberFormatSpecifierTF;
    private javax.swing.JCheckBox richHeadersCB;
    private javax.swing.JCheckBox timeUnitsCB;
    private javax.swing.JComboBox timeUnitsDropList;
    private javax.swing.JComboBox timesFormatTF;
    private javax.swing.JCheckBox useFormatSpecCB;
    private org.jdesktop.beansbinding.BindingGroup bindingGroup;
    // End of variables declaration//GEN-END:variables

    @Override
    public JPanel getPanel() {
        return this;
    }

    @Override
    public void setURI(String uri) {
        URISplit split= URISplit.parse(uri);
        file= split.file;
        Map<String,String> args= URISplit.parseParams(split.params);
        String s;
        useFormatSpecCB.setSelected(false);
        s= args.get("format");
        if ( s!=null ) {
            numberFormatSpecifierTF.setText( args.get("format") );
            useFormatSpecCB.setSelected(true);
        }
        s= args.get("tformat");
        if ( s!=null ) {
            timesFormatTF.setSelectedItem(s);
            useFormatSpecCB.setSelected(true);
        }
        s= args.get("header");
        if ( "rich".equals(s) ) {
            richHeadersCB.setSelected(true);
        }
        s= args.get("depend0Units");
        if ( s!=null ) {
            timeUnitsDropList.setSelectedItem(s);
            timeUnitsCB.setSelected(true);
        }
        s= args.get("doDep");
        if ( s!=null && s.length()>0 && 'F'==s.substring(0,1).toUpperCase().charAt(0) ) {
            justDataCB.setSelected(true);
        }
        s= args.getOrDefault("delim",",");
        delimiterCheckBox.setSelected(!s.equals(","));
        if ( delimiterCheckBox.isSelected() ) {
            delimiterTextField.setText(s);
        } 
        s= args.get("comment");
        commentCheckBox.setSelected(s!=null);
        if ( commentCheckBox.isSelected() ) {
            commentTextField.setText(s.replaceAll("\\+"," "));
        }
    }

    @Override
    public String getURI() {
        String result= file;
        Map<String,String> args= new HashMap();

        if ( useFormatSpecCB.isSelected() ) {
            try {
                args.put("format", URLEncoder.encode(numberFormatSpecifierTF.getText(), "UTF-8"));
            } catch (UnsupportedEncodingException ex) {
                logger.log(Level.SEVERE, ex.getMessage(), ex);
            }
            String ts= String.valueOf( timesFormatTF.getSelectedItem() );
//            if ( includeZ.isSelected() ) {
            args.put( "tformat", ts );
//            } else {
//                args.put( "tformat", ts + "NoZ" );
//            }
        }
        if ( timeUnitsCB.isSelected() ) {
            args.put( "depend0Units",timeUnitsDropList.getSelectedItem().toString() );
        }

        if ( richHeadersCB.isSelected() ) {
            args.put( "header", "rich" );
        } else if ( noHeadersCB.isSelected() ) {
            args.put( "header", "none" );
        }

        if ( justDataCB.isSelected() ) {
            args.put( "doDep", "F" );
        }
        
        if ( commentCheckBox.isSelected() ) {
            args.put( "comment", commentTextField.getText().replaceAll("\\s", "+"));
        }
        
        if ( delimiterCheckBox.isSelected() ) {
            String s= delimiterTextField.getText();
            if ( s.equals(" ") ) s= "SPACE";
            args.put("delim", s );
        }
        String params= URISplit.formatParams(args);
        if ( result==null ) result= "file:///";
        URISplit ss= URISplit.parse(result);

        if ( params.length()>0 ) {
            ss.params= params;
        }
        return URISplit.format( ss );

    }


}
