/* This Java package, org.autoplot.das2Stream is part of the Autoplot application
 *
 * Copyright (C) 2018 Chris Piker <chris-piker@uiowa.edu>
 * 
 * Autoplot is free software; you can redistribute it and/or modify it under the 
 * terms of the GNU General Public License version 2 as published by the Free
 * Software Foundation, with the additional Classpath exception below.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A 
 * PARTICULAR PURPOSE.  See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License version 2
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 * Classpath Exception
 * -------------------
 * The copyright holders designate this particular java package as subject to the
 * "Classpath" exception as provided here.
 *
 * Linking this package statically or dynamically with other modules is making a
 * combined work based on this package.  Thus, the terms and conditions of the GNU
 * General Public License cover the whole combination.
 *
 * As a special exception, the copyright holders of this package give you
 * permission to link this package with independent modules to produce an
 * application, regardless of the license terms of these independent modules, and
 * to copy and distribute the resulting application under terms of your choice,
 * provided that you also meet, for each independent module, the terms and
 * conditions of the license of that module.  An independent module is a module
 * which is not derived from or based on this package.  If you modify this package,
 * you may extend this exception to your version of the package, but you are not
 * obligated to do so.  If you do not wish to do so, delete this exception
 * statement from your version.
 */

package org.autoplot.das2Stream;

import javax.swing.JPanel;
import javax.swing.JSpinner;
import org.autoplot.datasource.DataSourceFormatEditorPanel;
import org.autoplot.datasource.URISplit;
import org.das2.qstream.QdsToD2sStream;

/** Toggle options for das2 stream export.
 *
 * @author cwp
 */
public class Das2StreamDataSourceFormatEditorPanel extends javax.swing.JPanel 
	implements DataSourceFormatEditorPanel {

	URISplit split;
	
	static final int BASIC_2_2 = 0;
	static final int BASIC_2_3 = 1;
	static final int GENERAL_2_4 = 2;
	
	static final String[] lVersions = {
		QdsToD2sStream.FORMAT_2_2, QdsToD2sStream.FORMAT_2_3_BASIC,
		QdsToD2sStream.FORMAT_2_4_GENERAL,
	};
	
	static final String[] lVerInfo = {
		"<html>Version <b>"+QdsToD2sStream.FORMAT_2_2+"</b>:  The format "+
		"understood by most das2 clients and utility programs <i>(recommended)</i></html>",
		
		"<html>Version <b>"+QdsToD2sStream.FORMAT_2_3_BASIC+"</b>:  A new format with more "+
		"exact syntax for waveforms and offset spectragrams <i>(in beta test)</i></html>" 
	};
		//Add this in later if it ever get's implemented
		/*,
		
		"<html>Version <b>"+QdsToD2sStream.FORMAT_2_3_GENERAL+"</b>:  A pie-in-the sky general "+
		"format handling point spread functions, variable length arrays and other esoteric "+
		"cases <i>(not recommended)</i></html>"
	};
		*/
	
	private int iStreamVer = BASIC_2_2;
	private int nSigDigit = 5;
	private int nFracSec = 3;
	private boolean bBinary = false;

	public Das2StreamDataSourceFormatEditorPanel(){ 
		initComponents(); 
	}
	
	/**
	 * This method is called from within the constructor to initialize the form. WARNING:
	 * Do NOT modify this code. The content of this method is always regenerated by the
	 * Form Editor.
	 */
	@SuppressWarnings("unchecked")
   // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
   private void initComponents() {
      java.awt.GridBagConstraints gridBagConstraints;
      bindingGroup = new org.jdesktop.beansbinding.BindingGroup();

      buttonGroup1 = new javax.swing.ButtonGroup();
      lblVersion = new javax.swing.JLabel();
      comboVersion = new javax.swing.JComboBox();
      lblTitle = new javax.swing.JLabel();
      lblOutputOpts = new javax.swing.JLabel();
      btnText = new javax.swing.JRadioButton();
      btnBinary = new javax.swing.JRadioButton();
      lblSigDigits = new javax.swing.JLabel();
      spinSigDigits = new javax.swing.JSpinner();
      lblFracSec = new javax.swing.JLabel();
      spinFracSec = new javax.swing.JSpinner();
      lblFormatInfo = new javax.swing.JLabel();
      lblVersionInfo = new javax.swing.JLabel();

      setNextFocusableComponent(comboVersion);
      setPreferredSize(new java.awt.Dimension(407, 330));
      setLayout(new java.awt.GridBagLayout());

      lblVersion.setText("Stream Version");
      gridBagConstraints = new java.awt.GridBagConstraints();
      gridBagConstraints.gridx = 0;
      gridBagConstraints.gridy = 2;
      gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
      gridBagConstraints.insets = new java.awt.Insets(0, 10, 0, 0);
      add(lblVersion, gridBagConstraints);

      comboVersion.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "2.2", "2.3/basic" }));
      comboVersion.setMaximumSize(new java.awt.Dimension(200, 200));
      comboVersion.setMinimumSize(new java.awt.Dimension(84, 25));
      comboVersion.setNextFocusableComponent(btnText);
      comboVersion.addItemListener(new java.awt.event.ItemListener() {
         public void itemStateChanged(java.awt.event.ItemEvent evt) {
            comboVersionItemStateChanged(evt);
         }
      });
      comboVersion.addActionListener(new java.awt.event.ActionListener() {
         public void actionPerformed(java.awt.event.ActionEvent evt) {
            comboVersionActionPerformed(evt);
         }
      });
      gridBagConstraints = new java.awt.GridBagConstraints();
      gridBagConstraints.gridx = 1;
      gridBagConstraints.gridy = 2;
      gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
      gridBagConstraints.ipadx = 45;
      gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
      gridBagConstraints.weighty = 1.0;
      gridBagConstraints.insets = new java.awt.Insets(0, 5, 0, 150);
      add(comboVersion, gridBagConstraints);

      lblTitle.setText("Das2 Stream Export");
      gridBagConstraints = new java.awt.GridBagConstraints();
      gridBagConstraints.gridx = 0;
      gridBagConstraints.gridy = 0;
      gridBagConstraints.gridwidth = 2;
      gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
      gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
      gridBagConstraints.insets = new java.awt.Insets(10, 10, 0, 10);
      add(lblTitle, gridBagConstraints);

      lblOutputOpts.setText("Output Options");
      gridBagConstraints = new java.awt.GridBagConstraints();
      gridBagConstraints.gridx = 0;
      gridBagConstraints.gridy = 4;
      gridBagConstraints.gridwidth = 2;
      gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
      gridBagConstraints.ipady = 6;
      gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
      gridBagConstraints.insets = new java.awt.Insets(0, 10, 0, 10);
      add(lblOutputOpts, gridBagConstraints);

      buttonGroup1.add(btnText);
      btnText.setFont(new java.awt.Font("Dialog", 0, 12)); // NOI18N
      btnText.setSelected(true);
      btnText.setText("<html><b>Unicode Text</b> - Loadable by text editors</html>");
      btnText.setNextFocusableComponent(spinSigDigits);
      btnText.addActionListener(new java.awt.event.ActionListener() {
         public void actionPerformed(java.awt.event.ActionEvent evt) {
            btnTextActionPerformed(evt);
         }
      });
      gridBagConstraints = new java.awt.GridBagConstraints();
      gridBagConstraints.gridx = 0;
      gridBagConstraints.gridy = 5;
      gridBagConstraints.gridwidth = 2;
      gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
      gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
      gridBagConstraints.insets = new java.awt.Insets(0, 20, 0, 10);
      add(btnText, gridBagConstraints);

      buttonGroup1.add(btnBinary);
      btnBinary.setFont(new java.awt.Font("Dialog", 0, 12)); // NOI18N
      btnBinary.setText("<html><b>Binary</b> - Efficient</html>");
      btnBinary.setNextFocusableComponent(comboVersion);

      org.jdesktop.beansbinding.Binding binding = org.jdesktop.beansbinding.Bindings.createAutoBinding(org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ_WRITE, this, org.jdesktop.beansbinding.ELProperty.create("${binaryFormat}"), btnBinary, org.jdesktop.beansbinding.BeanProperty.create("selected"));
      bindingGroup.addBinding(binding);

      btnBinary.addActionListener(new java.awt.event.ActionListener() {
         public void actionPerformed(java.awt.event.ActionEvent evt) {
            btnBinaryActionPerformed(evt);
         }
      });
      gridBagConstraints = new java.awt.GridBagConstraints();
      gridBagConstraints.gridx = 0;
      gridBagConstraints.gridy = 8;
      gridBagConstraints.gridwidth = 2;
      gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
      gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
      gridBagConstraints.insets = new java.awt.Insets(0, 20, 10, 10);
      add(btnBinary, gridBagConstraints);

      lblSigDigits.setText("Significant digits in data values");
      gridBagConstraints = new java.awt.GridBagConstraints();
      gridBagConstraints.gridx = 1;
      gridBagConstraints.gridy = 6;
      gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
      gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
      gridBagConstraints.insets = new java.awt.Insets(0, 5, 0, 10);
      add(lblSigDigits, gridBagConstraints);

      spinSigDigits.setModel(new javax.swing.SpinnerNumberModel(5, 2, 14, 1));
      spinSigDigits.setNextFocusableComponent(spinFracSec);

      binding = org.jdesktop.beansbinding.Bindings.createAutoBinding(org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ_WRITE, this, org.jdesktop.beansbinding.ELProperty.create("${significantDigits}"), spinSigDigits, org.jdesktop.beansbinding.BeanProperty.create("value"));
      bindingGroup.addBinding(binding);
      binding = org.jdesktop.beansbinding.Bindings.createAutoBinding(org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ_WRITE, btnText, org.jdesktop.beansbinding.ELProperty.create("${selected}"), spinSigDigits, org.jdesktop.beansbinding.BeanProperty.create("enabled"));
      bindingGroup.addBinding(binding);

      spinSigDigits.addChangeListener(new javax.swing.event.ChangeListener() {
         public void stateChanged(javax.swing.event.ChangeEvent evt) {
            spinSigDigitsStateChanged(evt);
         }
      });
      gridBagConstraints = new java.awt.GridBagConstraints();
      gridBagConstraints.gridx = 0;
      gridBagConstraints.gridy = 6;
      gridBagConstraints.ipadx = 12;
      gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
      add(spinSigDigits, gridBagConstraints);

      lblFracSec.setText("Fractional seconds digits in time values");
      gridBagConstraints = new java.awt.GridBagConstraints();
      gridBagConstraints.gridx = 1;
      gridBagConstraints.gridy = 7;
      gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
      gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
      gridBagConstraints.insets = new java.awt.Insets(0, 5, 0, 10);
      add(lblFracSec, gridBagConstraints);

      spinFracSec.setModel(new javax.swing.SpinnerNumberModel(3, 0, 12, 1));
      spinFracSec.setNextFocusableComponent(btnBinary);

      binding = org.jdesktop.beansbinding.Bindings.createAutoBinding(org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ_WRITE, btnText, org.jdesktop.beansbinding.ELProperty.create("${selected}"), spinFracSec, org.jdesktop.beansbinding.BeanProperty.create("enabled"));
      bindingGroup.addBinding(binding);

      spinFracSec.addChangeListener(new javax.swing.event.ChangeListener() {
         public void stateChanged(javax.swing.event.ChangeEvent evt) {
            spinFracSecStateChanged(evt);
         }
      });
      gridBagConstraints = new java.awt.GridBagConstraints();
      gridBagConstraints.gridx = 0;
      gridBagConstraints.gridy = 7;
      gridBagConstraints.ipadx = 12;
      gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
      add(spinFracSec, gridBagConstraints);

      lblFormatInfo.setFont(new java.awt.Font("Dialog", 0, 12)); // NOI18N
      lblFormatInfo.setText("<html>Das2 streams may contain values and intrinsic metadata for multiple heterogeneous arrays.  Format ICD at <a href=\"http://das2.org\">http://das2.org</a></html>");
      lblFormatInfo.setVerticalAlignment(javax.swing.SwingConstants.TOP);
      lblFormatInfo.setPreferredSize(new java.awt.Dimension(325, 45));
      gridBagConstraints = new java.awt.GridBagConstraints();
      gridBagConstraints.gridx = 0;
      gridBagConstraints.gridy = 1;
      gridBagConstraints.gridwidth = 2;
      gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
      gridBagConstraints.ipadx = 5;
      gridBagConstraints.ipady = 5;
      gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
      gridBagConstraints.weightx = 1.0;
      gridBagConstraints.weighty = 1.0;
      gridBagConstraints.insets = new java.awt.Insets(0, 20, 20, 20);
      add(lblFormatInfo, gridBagConstraints);

      lblVersionInfo.setFont(new java.awt.Font("Dialog", 0, 12)); // NOI18N
      lblVersionInfo.setText("<html>Version <b>2.2</b>:  The current standard format understood by most das2 clients and utility programs <i>(recommended)</i></html>");
      lblVersionInfo.setVerticalAlignment(javax.swing.SwingConstants.TOP);
      lblVersionInfo.setMinimumSize(new java.awt.Dimension(158, 30));
      lblVersionInfo.setPreferredSize(new java.awt.Dimension(325, 30));
      gridBagConstraints = new java.awt.GridBagConstraints();
      gridBagConstraints.gridx = 0;
      gridBagConstraints.gridy = 3;
      gridBagConstraints.gridwidth = 2;
      gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
      gridBagConstraints.ipadx = 4;
      gridBagConstraints.ipady = 5;
      gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
      gridBagConstraints.weightx = 1.0;
      gridBagConstraints.weighty = 1.0;
      gridBagConstraints.insets = new java.awt.Insets(0, 20, 20, 20);
      add(lblVersionInfo, gridBagConstraints);

      bindingGroup.bind();
   }// </editor-fold>//GEN-END:initComponents

   private void comboVersionItemStateChanged(java.awt.event.ItemEvent evt) {//GEN-FIRST:event_comboVersionItemStateChanged
     iStreamVer = comboVersion.getSelectedIndex();
	  lblVersionInfo.setText(lVerInfo[iStreamVer]);
   }//GEN-LAST:event_comboVersionItemStateChanged

   private void btnTextActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btnTextActionPerformed
      bBinary = false;
   }//GEN-LAST:event_btnTextActionPerformed

   private void btnBinaryActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btnBinaryActionPerformed
      bBinary = true;
   }//GEN-LAST:event_btnBinaryActionPerformed

   private void spinSigDigitsStateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_spinSigDigitsStateChanged
		// Un-safe casts abound in Java.  
		nSigDigit = ((Number)spinSigDigits.getValue()).intValue();
   }//GEN-LAST:event_spinSigDigitsStateChanged

   private void spinFracSecStateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_spinFracSecStateChanged
      // So why can't we get the value from the event?
		nFracSec = ((Number)spinFracSec.getValue()).intValue();
   }//GEN-LAST:event_spinFracSecStateChanged

   private void comboVersionActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_comboVersionActionPerformed
      // TODO add your handling code here:
   }//GEN-LAST:event_comboVersionActionPerformed

	@Override
	public JPanel getPanel(){ return this; }

	@Override
	public void setURI(String uri){
		
		String sVersion = Das2StreamDataSourceFormat.getVersion(uri);
		
		switch(sVersion){
			case QdsToD2sStream.FORMAT_2_3_BASIC:   iStreamVer = BASIC_2_3; break;
			case QdsToD2sStream.FORMAT_2_4_GENERAL: iStreamVer = GENERAL_2_4; break;
			default:                                iStreamVer = BASIC_2_2; break;
		}
		comboVersion.setSelectedIndex(iStreamVer);
		
		bBinary = Das2StreamDataSourceFormat.getBinary(uri);
		btnBinary.setSelected(bBinary);
		btnText.setSelected(!bBinary);
		nSigDigit = Das2StreamDataSourceFormat.getSigDigits(uri);
		spinSigDigits.setValue(nSigDigit);
		nFracSec = Das2StreamDataSourceFormat.getFracSeconds(uri);
		spinFracSec.setValue(nFracSec);
		URISplit lsplit = URISplit.parse(uri);
		split = lsplit;
	}

	@Override
	public String getURI(){
	
		split = Das2StreamDataSourceFormat.setOptions(
			split, lVersions[this.iStreamVer], bBinary, nSigDigit, nFracSec
		);
		
		return URISplit.format(split);
	}


   // Variables declaration - do not modify//GEN-BEGIN:variables
   private javax.swing.JRadioButton btnBinary;
   private javax.swing.JRadioButton btnText;
   private javax.swing.ButtonGroup buttonGroup1;
   private javax.swing.JComboBox comboVersion;
   private javax.swing.JLabel lblFormatInfo;
   private javax.swing.JLabel lblFracSec;
   private javax.swing.JLabel lblOutputOpts;
   private javax.swing.JLabel lblSigDigits;
   private javax.swing.JLabel lblTitle;
   private javax.swing.JLabel lblVersion;
   private javax.swing.JLabel lblVersionInfo;
   private javax.swing.JSpinner spinFracSec;
   private javax.swing.JSpinner spinSigDigits;
   private org.jdesktop.beansbinding.BindingGroup bindingGroup;
   // End of variables declaration//GEN-END:variables

}
