/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.ascii;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.autoplot.ascii.MultiFieldTimeParser;
import org.autoplot.datasource.AbstractDataSource;
import org.autoplot.datasource.DataSourceUtil;
import org.das2.CancelledOperationException;
import org.das2.dataset.NoDataInIntervalException;
import org.das2.datum.Datum;
import org.das2.datum.EnumerationUnits;
import org.das2.datum.TimeParser;
import org.das2.datum.TimeUtil;
import org.das2.datum.Units;
import org.das2.datum.UnitsConverter;
import org.das2.datum.UnitsUtil;
import org.das2.qds.ArrayDataSet;
import org.das2.qds.DDataSet;
import org.das2.qds.DataSetOps;
import org.das2.qds.DataSetUtil;
import org.das2.qds.MutablePropertyDataSet;
import org.das2.qds.QDataSet;
import org.das2.qds.RankZeroDataSet;
import org.das2.qds.SemanticOps;
import org.das2.qds.SparseDataSetBuilder;
import org.das2.qds.ops.Ops;
import org.das2.qds.util.AsciiHeadersParser;
import org.das2.qds.util.AsciiParser;
import org.das2.util.ByteBufferInputStream;
import org.das2.util.ColorUtil;
import org.das2.util.LoggerManager;
import org.das2.util.monitor.ProgressMonitor;

public class AsciiTableDataSource
extends AbstractDataSource {
    AsciiParser parser;
    File file;
    String column = null;
    String depend0 = null;
    private static final Logger logger = LoggerManager.getLogger((String)"apdss.ascii");
    public static final String PARAM_INTERVAL_TAG = "intervalTag";
    TimeParser timeParser;
    String[] timeFormats;
    int timeColumn = -1;
    DDataSet ds = null;
    int[] rank2 = null;
    int[] bundle = null;
    int[] depend1Labels = null;
    String[] depend1Label = null;
    int[] depend1Values = null;
    private double validMin = Double.NEGATIVE_INFINITY;
    private double validMax = Double.POSITIVE_INFINITY;
    String eventListColumn = null;
    int eventListColorColumn = -1;

    public AsciiTableDataSource(URI uri) throws FileNotFoundException, IOException {
        super(uri);
    }

    public int[] parseColumns(String s, int fieldCount) {
        String[] ss = s.split(",");
        ArrayList<Integer> r = new ArrayList<Integer>();
        for (String sss : ss) {
            int i2;
            int i1;
            String[] sss4;
            if (sss.contains("-")) {
                sss4 = sss.split("-");
                if (sss4.length != 2) {
                    throw new IllegalArgumentException("range of columns must be START-END, and includes the END column.");
                }
                i1 = this.columnIndex(sss4[0], fieldCount);
                i2 = this.columnIndex(sss4[1], fieldCount);
                if (i2 < i1) {
                    throw new IllegalArgumentException("start column must be before end column");
                }
                for (int i = i1; i <= i2; ++i) {
                    r.add(i);
                }
                continue;
            }
            if (sss.contains(":")) {
                int st;
                sss4 = sss.split(":");
                i1 = this.columnIndex(sss4[0], fieldCount);
                i2 = this.columnIndex(sss4[1], fieldCount);
                int n = st = sss4.length == 3 ? Integer.parseInt(sss4[2]) : 1;
                if (sss4.length != 3) continue;
                for (int i = i1; i < i2; i += st) {
                    r.add(i);
                }
                continue;
            }
            r.add(this.columnIndex(sss, fieldCount));
        }
        int[] result = new int[r.size()];
        for (int i = 0; i < r.size(); ++i) {
            result[i] = (Integer)r.get(i);
        }
        return result;
    }

    public QDataSet getDataSet(ProgressMonitor mon) throws IOException, CancelledOperationException, NoDataInIntervalException {
        String title;
        MutablePropertyDataSet bds;
        logger.fine("read file");
        this.ds = this.doReadFile(mon);
        logger.fine("done read file");
        if (mon.isCancelled()) {
            throw new CancelledOperationException("cancelled data read");
        }
        Object vds = null;
        ArrayDataSet dep0 = null;
        if (this.eventListColumn == null && this.column == null && this.ds.length(0) > 2 && this.ds.length(0) < 5) {
            Units u0 = this.parser.getUnits(0);
            Units u1 = this.parser.getUnits(1);
            if (UnitsUtil.isTimeLocation((Units)u0) && u1 == u0) {
                this.eventListColumn = "field" + (this.ds.length(0) - 1);
            }
        }
        if (this.column == null && this.timeColumn != -1) {
            this.column = this.parser.getFieldNames()[this.timeColumn];
        }
        QDataSet bundleDescriptor = (QDataSet)this.ds.property("BUNDLE_1");
        if (this.eventListColumn != null) {
            Units u1;
            dep0 = ArrayDataSet.maybeCopy((QDataSet)DataSetOps.leafTrim((QDataSet)this.ds, (int)0, (int)2));
            Units u0 = this.parser.getUnits(0);
            if (u0 != (u1 = this.parser.getUnits(1))) {
                if (UnitsUtil.isTimeLocation((Units)u0) && UnitsUtil.isTimeLocation((Units)u1)) {
                    throw new IllegalArgumentException("somehow the parser was misconfigured to have two different time units.");
                }
                if (!u1.isConvertibleTo(u0.getOffsetUnits())) {
                    throw new IllegalArgumentException("first two columns should have the same units, or second column should be offset (e.g. seconds) from first");
                }
            }
            dep0.putProperty("UNITS", (Object)this.parser.getUnits(0));
            dep0.putProperty("BINS_1", (Object)"min,max");
            if (!this.eventListColumn.equals("")) {
                this.column = this.eventListColumn;
            }
        }
        if (this.ds.length() == 0) {
            logger.info("===========================================");
            logger.info("no records found when parsing ascii file!!!");
            logger.info("===========================================");
            throw new NoDataInIntervalException("no records found");
        }
        String group = this.getParam("group", null);
        if (group != null) {
            vds = ArrayDataSet.copy((QDataSet)DataSetOps.unbundle((QDataSet)this.ds, (String)group));
        } else if (this.column != null) {
            if (bundleDescriptor != null) {
                int[] columns = this.parseColumns(this.column, this.parser.getFieldCount());
                QDataSet vdss = null;
                for (int c : columns) {
                    try {
                        if (c == -1) {
                            vdss = Ops.bundle(vdss, (QDataSet)ArrayDataSet.copy((QDataSet)Ops.unbundle((QDataSet)this.ds, (String)this.column)));
                            continue;
                        }
                        vdss = Ops.bundle(vdss, (QDataSet)ArrayDataSet.copy((QDataSet)DataSetOps.unbundle((QDataSet)this.ds, (int)c)));
                    }
                    catch (IllegalArgumentException ex) {
                        int icol = this.parser.getFieldIndex(this.column);
                        if (icol != -1) {
                            ArrayDataSet vds1 = ArrayDataSet.copy((QDataSet)DataSetOps.slice1((QDataSet)this.ds, (int)icol));
                            vds1.putProperty("CONTEXT_0", null);
                            vds1.putProperty("UNITS", (Object)this.parser.getUnits(icol));
                            if (this.column.length() > 1) {
                                vds1.putProperty("NAME", (Object)this.column);
                            }
                            vds1.putProperty("LABEL", (Object)this.parser.getFieldNames()[icol]);
                            continue;
                        }
                        if (bundleDescriptor instanceof AsciiHeadersParser.BundleDescriptor) {
                            QDataSet _vds = AsciiHeadersParser.getInlineDataSet((QDataSet)bundleDescriptor, (String)this.column);
                            if (_vds == null) {
                                throw new IllegalArgumentException("No such dataset: " + this.column);
                            }
                            vdss = Ops.bundle((QDataSet)vdss, (QDataSet)ArrayDataSet.maybeCopy((QDataSet)_vds));
                            continue;
                        }
                        throw new IllegalArgumentException("No such dataset: " + this.column);
                    }
                }
                vds = columns.length == 1 ? (MutablePropertyDataSet)Ops.unbundle(vdss, (int)0) : Ops.maybeCopy(vdss);
            } else {
                int icol = this.parser.getFieldIndex(this.column);
                if (icol == -1) {
                    throw new IllegalArgumentException("bad column parameter: " + this.column + ", should be field1, or 1, or <name>");
                }
                vds = ArrayDataSet.copy((QDataSet)DataSetOps.slice1((QDataSet)this.ds, (int)icol));
                vds.putProperty("CONTEXT_0", null);
                vds.putProperty("UNITS", (Object)this.parser.getUnits(icol));
                if (this.column.length() > 1) {
                    vds.putProperty("NAME", (Object)this.column);
                }
                vds.putProperty("LABEL", (Object)this.parser.getFieldNames()[icol]);
            }
            if (this.validMax != Double.POSITIVE_INFINITY) {
                vds.putProperty("VALID_MAX", (Object)this.validMax);
            }
            if (this.validMin != Double.NEGATIVE_INFINITY) {
                vds.putProperty("VALID_MIN", (Object)this.validMin);
            }
        } else if (this.eventListColumn != null) {
            EnumerationUnits eu = EnumerationUnits.create((Object)"events");
            vds = ArrayDataSet.maybeCopy((QDataSet)Ops.replicate((QDataSet)DataSetUtil.asDataSet((Datum)eu.createDatum((Object)"event")), (int)this.ds.length()));
        }
        if (this.depend0 != null) {
            String dep0Units;
            Units xunits;
            RankZeroDataSet cadence;
            String intervalType;
            int icol = this.parser.getFieldIndex(this.depend0);
            if (icol == -1) {
                throw new IllegalArgumentException("bad depend0 parameter: " + this.depend0 + ", should be field1, or 1, or <name>");
            }
            dep0 = this.ds.property("BUNDLE_1") != null ? ArrayDataSet.copy((QDataSet)DataSetOps.unbundle((QDataSet)this.ds, (int)icol)) : ArrayDataSet.copy((QDataSet)DataSetOps.slice1((QDataSet)this.ds, (int)icol));
            dep0.putProperty("UNITS", (Object)this.parser.getUnits(icol));
            if (UnitsUtil.isTimeLocation((Units)this.parser.getUnits(icol))) {
                dep0.putProperty("LABEL", null);
                dep0.putProperty("NAME", (Object)"time");
            }
            if (DataSetUtil.isMonotonic((QDataSet)dep0)) {
                dep0.putProperty("MONOTONIC", (Object)Boolean.TRUE);
            }
            if ((intervalType = (String)this.params.get(PARAM_INTERVAL_TAG)) != null && intervalType.equals("start") && (cadence = DataSetUtil.guessCadenceNew((QDataSet)dep0, null)) != null && !"log".equals(cadence.property("SCALE_TYPE"))) {
                double add = cadence.value() / 2.0;
                logger.log(Level.FINE, "adding half-interval width to dep0 because of %s: %s", new Object[]{PARAM_INTERVAL_TAG, cadence});
                for (int i = 0; i < dep0.length(); ++i) {
                    dep0.putValue(i, dep0.value(i) + add);
                }
            }
            if (this.depend0.length() > 1) {
                dep0.putProperty("NAME", (Object)this.depend0);
            }
            if (!((xunits = (Units)dep0.property("UNITS")) != null && UnitsUtil.isTimeLocation((Units)xunits) || dep0.property("LABEL") != null)) {
                dep0.putProperty("LABEL", (Object)this.parser.getFieldNames()[icol]);
            }
            if ((dep0Units = this.getParam("depend0Units", null)) != null) {
                dep0Units = dep0Units.replaceAll("\\+", " ");
                Units newDep0Units = Units.lookupUnits((String)dep0Units);
                if (UnitsUtil.isTimeLocation((Units)SemanticOps.getUnits((QDataSet)dep0)) && UnitsUtil.isTimeLocation((Units)newDep0Units)) {
                    dep0 = ArrayDataSet.maybeCopy((QDataSet)Ops.convertUnitsTo((QDataSet)dep0, (Units)newDep0Units));
                } else {
                    dep0.putProperty("UNITS", (Object)newDep0Units);
                }
            }
        } else if (this.ds.rank() == 2 && (bds = (MutablePropertyDataSet)this.ds.property("BUNDLE_1")) != null) {
            for (int i = 0; i < bds.length(); ++i) {
                Units u = (Units)bds.property("UNITS", i);
                if (u == null || !UnitsUtil.isTimeLocation((Units)u)) continue;
                bds.putProperty("LABEL", i, null);
            }
        }
        String x = this.getParam("X", null);
        String y = this.getParam("Y", null);
        String z = this.getParam("Z", null);
        if (z != null) {
            ArrayDataSet xds;
            ArrayDataSet zds = ArrayDataSet.copy((QDataSet)DataSetOps.unbundle((QDataSet)this.ds, (int)this.parser.getFieldIndex(z)));
            if (y == null) {
                throw new IllegalArgumentException("expected param Y");
            }
            ArrayDataSet yds = ArrayDataSet.copy((QDataSet)DataSetOps.unbundle((QDataSet)this.ds, (int)this.parser.getFieldIndex(y)));
            if (x != null) {
                xds = ArrayDataSet.copy((QDataSet)DataSetOps.unbundle((QDataSet)this.ds, (int)this.parser.getFieldIndex(x)));
            } else if (dep0 != null) {
                xds = dep0;
            } else {
                throw new IllegalArgumentException("expected param X");
            }
            vds = (MutablePropertyDataSet)Ops.bundle((QDataSet)xds, (QDataSet)yds, (QDataSet)zds);
        } else if (y != null) {
            ArrayDataSet xds;
            ArrayDataSet yds = ArrayDataSet.copy((QDataSet)DataSetOps.unbundle((QDataSet)this.ds, (int)this.parser.getFieldIndex(y)));
            if (x != null) {
                xds = ArrayDataSet.copy((QDataSet)DataSetOps.unbundle((QDataSet)this.ds, (int)this.parser.getFieldIndex(x)));
            } else if (dep0 != null) {
                xds = dep0;
            } else {
                throw new IllegalArgumentException("expected param X");
            }
            vds = (MutablePropertyDataSet)Ops.link((QDataSet)xds, (QDataSet)yds);
        }
        if (this.bundle != null) {
            if (this.bundle[0] == -1) {
                throw new IllegalArgumentException("bad parameter: bundle");
            }
            this.rank2 = this.bundle;
        }
        if (this.rank2 != null) {
            String title2;
            String label;
            if (dep0 != null) {
                this.ds.putProperty("DEPEND_0", (Object)dep0);
            }
            if (this.rank2[0] == -1) {
                throw new IllegalArgumentException("bad parameter: rank2");
            }
            Units u = this.parser.getUnits(this.rank2[0]);
            for (int i = this.rank2[0]; i < this.rank2[1]; ++i) {
                if (u == this.parser.getUnits(i)) continue;
                u = null;
            }
            if (u != null) {
                this.ds.putProperty("UNITS", (Object)u);
            }
            if (this.validMax != Double.POSITIVE_INFINITY) {
                this.ds.putProperty("VALID_MAX", (Object)this.validMax);
            }
            if (this.validMin != Double.NEGATIVE_INFINITY) {
                this.ds.putProperty("VALID_MIN", (Object)this.validMin);
            }
            Object mds = this.rank2[0] == 0 && this.rank2[1] == this.ds.length(0) ? this.ds : DataSetOps.leafTrim((QDataSet)this.ds, (int)this.rank2[0], (int)this.rank2[1]);
            if (this.bundle != null) {
                int i;
                QDataSet labelsds = Ops.labelsDataset((String[])this.parser.getFieldLabels());
                labelsds = labelsds.trim(this.bundle[0], this.bundle[1]);
                mds.putProperty("DEPEND_1", (Object)labelsds);
                SparseDataSetBuilder sdsb = new SparseDataSetBuilder(2);
                sdsb.setLength(this.bundle[1] - this.bundle[0]);
                sdsb.setQube(new int[]{this.bundle[1] - this.bundle[0], 0});
                String[] names = this.parser.getFieldNames();
                String[] labels = this.parser.getFieldLabels();
                String[] sunits = this.parser.getFieldUnits();
                boolean nothingAdded = true;
                for (i = 0; nothingAdded && i < names.length; ++i) {
                    if (!("field" + i).equals(names[i])) {
                        nothingAdded = false;
                    }
                    if (!("field" + i).equals(labels[i])) {
                        nothingAdded = false;
                    }
                    if (sunits[i] == null) continue;
                    nothingAdded = false;
                }
                nothingAdded = false;
                logger.log(Level.FINER, "nothing added={0}", nothingAdded);
                for (i = this.bundle[0]; i < this.bundle[1]; ++i) {
                    int index = i - this.bundle[0];
                    sdsb.putProperty("NAME", index, (Object)names[i]);
                    sdsb.putProperty("LABEL", index, (Object)labels[i]);
                    sdsb.putProperty("UNITS", index, (Object)this.parser.getUnits(i));
                }
                mds.putProperty("BUNDLE_1", (Object)sdsb.getDataSet());
            }
            if (this.depend1Label != null) {
                mds.putProperty("DEPEND_1", (Object)Ops.labelsDataset((String[])this.depend1Label));
            }
            if (this.depend1Labels != null) {
                QDataSet labels = Ops.labelsDataset((String[])this.parser.getFieldLabels());
                labels = labels.trim(this.depend1Labels[0], this.depend1Labels[1]);
                mds.putProperty("DEPEND_1", (Object)labels);
            }
            if (this.depend1Values != null) {
                String[] fieldNames = this.parser.getFieldNames();
                String[] fieldUnits = this.parser.getFieldUnits();
                DDataSet dep1 = DDataSet.createRank1((int)(this.depend1Values[1] - this.depend1Values[0]));
                boolean firstRecordIsDep1 = false;
                for (int i = this.depend1Values[0]; i < this.depend1Values[1]; ++i) {
                    double d;
                    if (firstRecordIsDep1) {
                        d = mds.value(0, i - this.depend1Values[0]);
                    } else {
                        try {
                            d = Double.parseDouble(fieldNames[i]);
                        }
                        catch (NumberFormatException ex) {
                            try {
                                if (fieldUnits[i] != null) {
                                    d = Double.parseDouble(fieldUnits[i]);
                                } else {
                                    d = mds.value(0, i - this.depend1Values[0]);
                                    firstRecordIsDep1 = true;
                                }
                            }
                            catch (NumberFormatException ex2) {
                                d = i - this.depend1Values[0];
                            }
                        }
                    }
                    dep1.putValue(i - this.depend1Values[0], d);
                }
                mds.putProperty("DEPEND_1", (Object)dep1);
                if (firstRecordIsDep1) {
                    mds = (MutablePropertyDataSet)mds.trim(1, mds.length());
                }
            }
            if (this.bundle == null && this.rank2 != null && !this.parser.isRichHeader()) {
                mds.putProperty("BUNDLE_1", null);
            }
            if ((label = this.getParam("label", null)) != null) {
                mds.putProperty("LABEL", (Object)label);
            }
            if ((title2 = this.getParam("title", null)) != null) {
                mds.putProperty("TITLE", (Object)title2);
            }
            return mds;
        }
        if (vds == null) {
            if (this.column == null) {
                throw new IllegalArgumentException("column was not specified.  Use column, rank2, or bundle to specify data to plot.");
            }
            throw new IllegalArgumentException("didn't find column: " + this.column);
        }
        String label = this.getParam("label", null);
        if (label != null) {
            vds.putProperty("LABEL", (Object)label);
        }
        if ((title = this.getParam("title", null)) != null) {
            vds.putProperty("TITLE", (Object)title);
        }
        if (dep0 != null && x == null) {
            vds.putProperty("DEPEND_0", (Object)dep0);
        }
        if (this.eventListColumn != null && dep0 != null) {
            Units u1;
            Units u0 = this.parser.getUnits(0);
            if (u0 != (u1 = this.parser.getUnits(1)) && u1.isConvertibleTo(u0.getOffsetUnits())) {
                UnitsConverter uc = u1.getConverter(u0.getOffsetUnits());
                for (int i = 0; i < dep0.length(); ++i) {
                    dep0.putValue(i, 1, dep0.value(i, 0) + uc.convert(dep0.value(i, 1)));
                }
            }
            if (this.eventListColorColumn > -1) {
                vds = ArrayDataSet.copy((QDataSet)Ops.bundle((QDataSet)Ops.slice1((QDataSet)dep0, (int)0), (QDataSet)Ops.slice1((QDataSet)dep0, (int)1), (QDataSet)Ops.slice1((QDataSet)this.ds, (int)this.eventListColorColumn), (QDataSet)vds));
                ((MutablePropertyDataSet)vds.property("BUNDLE_1")).putProperty("FORMAT", 2, (Object)"0x%06x");
            }
            vds.putProperty("RENDER_TYPE", (Object)"eventsBar");
        }
        return vds;
    }

    private DDataSet doReadFile(ProgressMonitor mon) throws NumberFormatException, IOException, FileNotFoundException {
        DDataSet ds1;
        String w;
        Object u;
        String s;
        boolean haveColumn;
        int columnCount;
        AsciiParser.RegexParser p;
        logger.finer("maybe download file");
        this.file = this.getFile(mon.getSubtaskMonitor("getFile"));
        logger.finer("got file");
        if (this.file.isDirectory()) {
            throw new IOException("expected file but got directory");
        }
        this.parser = new AsciiParser();
        boolean fixedColumns = false;
        String o = (String)this.params.get("skip");
        if (o != null) {
            this.parser.setSkipLines(Integer.parseInt(o));
        }
        if ((o = (String)this.params.get("skipLines")) != null) {
            this.parser.setSkipLines(Integer.parseInt(o));
        }
        if ((o = (String)this.params.get("recCount")) != null) {
            this.parser.setRecordCountLimit(Integer.parseInt(o));
        }
        if ((o = (String)this.params.get("recStart")) != null) {
            this.parser.setRecordStart(Integer.parseInt(o));
        }
        this.parser.setKeepFileHeader(true);
        o = (String)this.params.get("comment");
        if (o != null) {
            if (o.equals("")) {
                this.parser.setCommentPrefix(null);
            } else {
                this.parser.setCommentPrefix(o);
            }
        }
        if ((o = (String)this.params.get("headerDelim")) != null) {
            this.parser.setHeaderDelimiter(o);
        }
        String delim = (String)this.params.get("delim");
        String spattern = (String)this.params.get("pattern");
        String format = (String)this.params.get("format");
        if (format != null) {
            spattern = AsciiParser.getRegexForFormat((String)format);
        }
        String sFixedColumns = (String)this.params.get("fixedColumns");
        if (spattern != null) {
            p = new AsciiParser.RegexParser(this.parser, spattern);
            this.parser.setRecordParser((AsciiParser.RecordParser)p);
            this.parser.setCommentPrefix(null);
            columnCount = p.fieldCount();
            delim = " ";
        } else if (sFixedColumns == null) {
            if (delim == null) {
                p = this.parser.guessSkipAndDelimParser(this.file.toString());
                if (p == null) {
                    String cc = (String)this.params.get("columnCount");
                    columnCount = cc == null ? 2 : Integer.parseInt(cc);
                    p = this.parser.getDelimParser(columnCount, "\\s+");
                }
                columnCount = p.fieldCount();
                delim = p.getDelim();
                p.setShowException(true);
                this.parser.setRecordParser((AsciiParser.RecordParser)p);
            } else {
                delim = delim.replaceAll("WHITESPACE", "\\s+");
                delim = delim.replaceAll("SPACE", " ");
                delim = delim.replaceAll("COMMA", ",");
                delim = delim.replaceAll("SEMICOLON", ";");
                delim = delim.replaceAll("COLON", ":");
                delim = delim.replaceAll("TAB", "\t");
                delim = delim.replaceAll("whitespace", "\\s+");
                delim = delim.replaceAll("space", " ");
                delim = delim.replaceAll("comma", ",");
                delim = delim.replaceAll("semicolon", ";");
                delim = delim.replaceAll("colon", ":");
                if ((delim = delim.replaceAll("tab", "\t")).equals("+")) {
                    delim = " ";
                }
                columnCount = this.parser.setDelimParser(this.file.toString(), delim).fieldCount();
            }
            this.parser.setPropertyPattern(AsciiParser.NAME_COLON_VALUE_PATTERN);
        } else {
            String s2 = sFixedColumns;
            AsciiParser.FixedColumnsParser p2 = this.parser.setFixedColumnsParser(this.file.toString(), "\\s+");
            try {
                columnCount = Integer.parseInt(sFixedColumns);
            }
            catch (NumberFormatException ex) {
                if (sFixedColumns.equals("")) {
                    columnCount = p2.fieldCount();
                }
                String[] ss = s2.split(",");
                int[] starts = new int[ss.length];
                int[] widths = new int[ss.length];
                AsciiParser.FieldParser[] fparsers = new AsciiParser.FieldParser[ss.length];
                for (int i = 0; i < ss.length; ++i) {
                    String[] ss2 = ss[i].split("-");
                    starts[i] = Integer.parseInt(ss2[0]);
                    widths[i] = Integer.parseInt(ss2[1]) - starts[i] + 1;
                    fparsers[i] = AsciiParser.DOUBLE_PARSER;
                }
                p2 = this.parser.setFixedColumnsParser(starts, widths, fparsers);
                columnCount = p2.fieldCount();
            }
            this.parser.setPropertyPattern(null);
            fixedColumns = true;
            delim = null;
        }
        o = (String)this.params.get("columnCount");
        if (columnCount == 0) {
            columnCount = o != null ? Integer.parseInt(o) : AsciiParser.guessFieldCount((String)this.file.toString());
        }
        if ((o = (String)this.params.get("fill")) != null) {
            this.parser.setFillValue(Double.parseDouble(o));
        }
        if ((o = (String)this.params.get("validMin")) != null) {
            this.validMin = Double.parseDouble(o);
        }
        if ((o = (String)this.params.get("validMax")) != null) {
            this.validMax = Double.parseDouble(o);
        }
        if ((o = (String)this.params.get("time")) != null) {
            int i = this.parser.getFieldIndex(o);
            if (i == -1) {
                throw new IllegalArgumentException("field not found for time in column named \"" + o + "\"");
            }
            this.parser.setFieldParser(i, this.parser.UNITS_PARSER);
            this.parser.setUnits(i, AsciiParser.UNIT_UTC);
            this.depend0 = o;
            this.timeColumn = i;
        }
        if ((o = (String)this.params.get("timeFormat")) != null) {
            Object timeFieldParser;
            Units u2;
            String timeFormat = o;
            if (",".equals(delim) && !timeFormat.contains(",")) {
                timeFormat = timeFormat.replaceAll("\\+", ",");
            }
            if (!timeFormat.contains(" ")) {
                timeFormat = "\t".equals(delim) || ";".equals(delim) ? timeFormat.replaceAll("\\+", delim) : timeFormat.replaceAll("\\+", " ");
            }
            timeFormat = timeFormat.replaceAll("\\%", "\\$");
            timeFormat = timeFormat.replaceAll("\\{", "(");
            timeFormat = timeFormat.replaceAll("\\}", ")");
            String timeColumnName = (String)this.params.get("time");
            if (timeColumnName == null) {
                this.timeColumn = 0;
            } else {
                int i = timeColumnName.indexOf("-");
                if (i > -1) {
                    timeColumnName = timeColumnName.substring(0, i);
                } else {
                    i = timeColumnName.indexOf(":");
                    if (i > -1) {
                        timeColumnName = timeColumnName.substring(0, i);
                    }
                }
                this.timeColumn = this.parser.getFieldIndex(timeColumnName);
            }
            String timeFormatDelim = delim;
            if (delim == null) {
                timeFormatDelim = " ";
            }
            this.timeFormats = timeFormat.split(timeFormatDelim, -2);
            if (timeFormat.equals("ISO8601")) {
                String line = this.parser.readFirstParseableRecord(this.file.toString());
                if (line == null) {
                    throw new IllegalArgumentException("file contains no parseable records.");
                }
                String[] ss = new String[this.parser.getRecordParser().fieldCount()];
                this.parser.getRecordParser().splitRecord(line, ss);
                int i = this.timeColumn;
                if (i == -1) {
                    i = 0;
                }
                String atime = ss[i];
                timeFormat = TimeParser.iso8601String((String)atime.trim());
                this.timeParser = TimeParser.create((String)timeFormat);
                final Units u3 = AsciiParser.UNIT_UTC;
                this.parser.setUnits(i, u3);
                AsciiParser.FieldParser timeFieldParser2 = new AsciiParser.FieldParser(){

                    public double parseField(String field, int fieldIndex) throws ParseException {
                        return AsciiTableDataSource.this.timeParser.parse(field).getTime(u3);
                    }
                };
                this.parser.setFieldParser(i, timeFieldParser2);
            } else if (delim != null && this.timeFormats.length > 1) {
                this.timeParser = TimeParser.create((String)timeFormat);
                this.parser.setUnits(this.timeColumn, Units.dimensionless);
                u2 = AsciiParser.UNIT_UTC;
                timeFieldParser = new MultiFieldTimeParser(this.timeColumn, this.timeFormats, this.timeParser, u2);
                for (int i = this.timeColumn; i < this.timeColumn + this.timeFormats.length; ++i) {
                    this.parser.setFieldParser(i, timeFieldParser);
                    this.parser.setUnits(i, Units.dimensionless);
                }
                if (this.parser.getRecordParser() instanceof AsciiParser.DelimParser) {
                    ((AsciiParser.DelimParser)this.parser.getRecordParser()).setGuessUnits(false);
                }
                this.timeColumn = this.timeColumn + this.timeFormats.length - 1;
                if (this.params.get("time") != null) {
                    this.depend0 = this.parser.getFieldNames()[this.timeColumn];
                }
                this.parser.setUnits(this.timeColumn, u2);
            } else {
                this.timeParser = TimeParser.create((String)timeFormat);
                u2 = AsciiParser.UNIT_UTC;
                this.parser.setUnits(this.timeColumn, u2);
                timeFieldParser = new AsciiParser.FieldParser(){

                    public double parseField(String field, int fieldIndex) throws ParseException {
                        if (AsciiTableDataSource.this.timeFormats[0].length() == 2 && AsciiTableDataSource.this.timeFormats.length == 1 && AsciiTableDataSource.this.timeFormats[0].equals("$Y")) {
                            if (field.length() > 4) {
                                double dyear = Double.parseDouble(field);
                                int year = (int)dyear;
                                double daysInYear = TimeUtil.dayOfYear((int)12, (int)31, (int)year);
                                double ddoy = (dyear - (double)year) * daysInYear;
                                int doy = (int)ddoy;
                                double t1970 = TimeUtil.createTimeDatum((int)year, (int)1, (int)doy, (int)0, (int)0, (int)0, (int)0).doubleValue(u2);
                                return t1970 + (ddoy - (double)doy) * 86400.0;
                            }
                            return TimeUtil.createTimeDatum((int)Integer.parseInt(field), (int)1, (int)1, (int)0, (int)0, (int)0, (int)0).doubleValue(u2);
                        }
                        return AsciiTableDataSource.this.timeParser.parse(field).getTime(u2);
                    }
                };
                this.parser.setFieldParser(this.timeColumn, timeFieldParser);
            }
        } else {
            this.timeParser = null;
        }
        o = (String)this.params.get("arg_0");
        if (o != null && o.length() > 0 && !o.equals("rank2")) {
            this.column = o;
            if (this.parser.getFieldIndex(this.column) != 0) {
                this.timeColumn = 0;
                if (UnitsUtil.isTimeLocation((Units)this.parser.getUnits(0))) {
                    Units u4 = AsciiParser.UNIT_UTC;
                    this.parser.setUnits(0, u4);
                }
                this.depend0 = "0";
            }
        }
        if ((o = (String)this.params.get("column")) != null) {
            this.column = o;
        }
        if ((o = (String)this.params.get("depend0")) != null) {
            this.depend0 = o;
        }
        if ((o = (String)this.params.get("Z")) != null) {
            this.column = o;
        } else {
            o = (String)this.params.get("Y");
            if (o != null) {
                this.column = o;
            }
        }
        o = (String)this.params.get("X");
        if (o != null) {
            this.depend0 = o;
        }
        if ((o = (String)this.params.get("rank2")) != null) {
            this.rank2 = this.parseRangeStr(o, columnCount);
            this.column = null;
        }
        if ((o = (String)this.params.get("bundle")) != null) {
            if (o.contains(",") || o.split(":", -2).length == 3) {
                this.column = o;
                this.bundle = null;
            } else {
                this.bundle = this.parseRangeStr(o, columnCount);
                this.column = null;
            }
        }
        if ((o = (String)this.params.get("arg_0")) != null) {
            if (o.equals("rank2")) {
                this.rank2 = new int[]{0, columnCount};
                this.column = null;
            } else if (o.equals("bundle")) {
                this.bundle = new int[]{0, columnCount};
                this.column = null;
            }
        }
        boolean bl = haveColumn = this.column != null;
        if (this.column == null && this.depend0 == null && this.rank2 == null) {
            if (this.parser.getFieldNames().length == 2) {
                this.depend0 = this.parser.getFieldNames()[0];
                this.column = this.parser.getFieldNames()[1];
            } else {
                this.column = this.parser.getFieldNames()[this.parser.getFieldNames().length - 1];
            }
        }
        if ((o = (String)this.params.get("depend1Labels")) != null) {
            if (o.contains(",")) {
                this.depend1Label = o.split(",");
            } else {
                this.depend1Labels = this.parseRangeStr(o, columnCount);
            }
        }
        if ((o = (String)this.params.get("depend1Values")) != null) {
            this.depend1Values = this.parseRangeStr(o, columnCount);
        }
        this.eventListColumn = (String)this.params.get("eventListColumn");
        if (this.parser.getFieldLabels().length >= 2 && this.parser.getFieldLabels().length <= 5 && UnitsUtil.isTimeLocation((Units)this.parser.getUnits(0)) && UnitsUtil.isTimeLocation((Units)this.parser.getUnits(1)) && !haveColumn) {
            if (this.parser.getFieldCount() > 2) {
                this.eventListColumn = "field" + (this.parser.getFieldLabels().length - 1);
            } else {
                this.eventListColumn = "";
                this.depend0 = null;
                this.column = null;
            }
        }
        if (this.eventListColumn != null) {
            this.parser.setUnits(0, AsciiParser.UNIT_UTC);
            this.parser.setUnits(1, AsciiParser.UNIT_UTC);
            this.parser.setFieldParser(0, this.parser.UNITS_PARSER);
            this.parser.setFieldParser(1, this.parser.UNITS_PARSER);
            if (!this.eventListColumn.equals("")) {
                int icol = this.parser.getFieldIndex(this.eventListColumn);
                EnumerationUnits eu = EnumerationUnits.create((Object)"events");
                this.parser.setUnits(icol, (Units)eu);
                this.parser.setFieldParser(icol, this.parser.ENUMERATION_PARSER);
                String[] fieldNames = this.parser.getFieldNames();
                if (icol > 2) {
                    String[] fields = new String[this.parser.getRecordParser().fieldCount()];
                    String s3 = this.parser.readFirstParseableRecord(this.file.toString());
                    this.parser.getRecordParser().splitRecord(s3, fields);
                    if (fields[2].startsWith("x") || fields[2].startsWith("0x") || fieldNames[2].equalsIgnoreCase("color")) {
                        this.parser.setUnits(2, Units.dimensionless);
                        this.parser.setFieldParser(2, new AsciiParser.FieldParser(){

                            public double parseField(String field, int columnIndex) throws ParseException {
                                if (field.startsWith("x")) {
                                    return Integer.decode("0" + field).intValue();
                                }
                                return ColorUtil.decodeColor((String)field).getRGB();
                            }
                        });
                        this.eventListColorColumn = 2;
                    }
                }
            }
        }
        if (this.timeColumn == -1 && (s = this.parser.readFirstParseableRecord(this.file.toString())) != null) {
            int icol;
            Object field;
            int idep0;
            String[] fields = new String[this.parser.getRecordParser().fieldCount()];
            this.parser.getRecordParser().splitRecord(s, fields);
            if (this.depend0 != null && (idep0 = this.parser.getFieldIndex(this.depend0)) != -1) {
                field = fields[idep0];
                try {
                    TimeUtil.parseTime((String)field);
                    if (new StringTokenizer((String)field, ":T-/").countTokens() > 1) {
                        this.parser.setUnits(idep0, AsciiParser.UNIT_UTC);
                        this.parser.setFieldParser(idep0, this.parser.UNITS_PARSER);
                    }
                }
                catch (ParseException s3) {
                    // empty catch block
                }
            }
            if (this.column != null && (icol = this.parser.getFieldIndex(this.column)) != -1) {
                field = fields[icol];
                try {
                    field = ((String)field).trim();
                    if (!UnitsUtil.isTimeLocation((Units)this.parser.getUnits(icol)) && !((String)field).startsWith("-")) {
                        TimeUtil.parseTime((String)field);
                        if (new StringTokenizer((String)field, ":T-/").countTokens() > 2) {
                            this.parser.setUnits(icol, AsciiParser.UNIT_UTC);
                            this.parser.setFieldParser(icol, this.parser.UNITS_PARSER);
                        }
                    }
                }
                catch (ParseException s3) {
                    // empty catch block
                }
            }
            for (icol = 0; icol < fields.length && icol < 2; ++icol) {
                field = fields[icol];
                try {
                    field = ((String)field).trim();
                    if (UnitsUtil.isTimeLocation((Units)this.parser.getUnits(icol)) || ((String)field).startsWith("-")) continue;
                    TimeUtil.parseTime((String)field);
                    if (new StringTokenizer((String)field, ":T-/").countTokens() <= 2) continue;
                    this.parser.setUnits(icol, AsciiParser.UNIT_UTC);
                    this.parser.setFieldParser(icol, this.parser.UNITS_PARSER);
                    continue;
                }
                catch (ParseException s3) {
                    // empty catch block
                }
            }
        }
        if ((o = (String)this.params.get("units")) != null) {
            String sunits = o;
            u = sunits.equals("enum") ? EnumerationUnits.create((Object)"default") : (sunits.equals("nominal") ? Units.nominal() : Units.lookupUnits((String)sunits));
            if (this.column != null) {
                int icol = this.parser.getFieldIndex(this.column);
                this.parser.setUnits(icol, (Units)u);
                if (sunits.equals("enum")) {
                    this.parser.setFieldParser(icol, this.parser.ENUMERATION_PARSER);
                } else {
                    this.parser.setFieldParser(icol, this.parser.UNITS_PARSER);
                }
            }
        }
        if ((o = (String)this.params.get("ordinal")) != null) {
            String sunits = o;
            u = EnumerationUnits.create((Object)"default");
            if (sunits.trim().length() > 0) {
                String[] ss = sunits.split(",");
                for (String s4 : ss) {
                    u.createDatum((Object)s4);
                }
            }
            if (this.column != null) {
                int icol = this.parser.getFieldIndex(this.column);
                this.parser.setUnits(icol, (Units)u);
                this.parser.setFieldParser(icol, this.parser.ENUMERATION_PARSER);
            }
        }
        if ((o = (String)this.params.get("where")) != null && (w = o).length() > 0) {
            Pattern p3 = Pattern.compile("\\.([nelg][qte])\\(");
            Matcher m = p3.matcher(w);
            if (!m.find()) {
                Pattern p2 = Pattern.compile("\\.(within|matches)\\(");
                Matcher m2 = p2.matcher(w);
                if (!m2.find()) {
                    throw new IllegalArgumentException("where can only contain .eq,.ne,.ge,.gt,.le,.lt, .within, or .matches");
                }
                int ieq = m2.start();
                String sop = m2.group(1);
                String sval = w.substring(ieq + sop.length() + 2, w.length() - 1);
                String sparm = w.substring(0, ieq);
                this.parser.setWhereConstraint(sparm, sop, DataSourceUtil.unescape((String)sval));
            } else {
                int ieq = m.start();
                String op = m.group(1);
                String sval = w.substring(ieq + 4, w.length() - 1);
                String sparm = w.substring(0, ieq);
                this.parser.setWhereConstraint(sparm, op, sval);
            }
        }
        logger.fine("done process parameters and peeking at file");
        o = (String)this.params.get("tail");
        if (o != null) {
            MappedByteBuffer buff = new FileInputStream(this.file).getChannel().map(FileChannel.MapMode.READ_ONLY, 0L, this.file.length());
            int tailNum = Integer.parseInt(o);
            int tailCount = 0;
            int ipos = (int)this.file.length();
            boolean foundNonEOL = false;
            block16: while (tailCount < tailNum && ipos > 0) {
                byte ch = buff.get(--ipos);
                switch (ch) {
                    case 10: {
                        if (ipos > 1 && buff.get(ipos - 1) == 13) {
                            --ipos;
                        }
                        if (!foundNonEOL) continue block16;
                        ++tailCount;
                        continue block16;
                    }
                    case 13: {
                        if (!foundNonEOL) continue block16;
                        ++tailCount;
                        continue block16;
                    }
                }
                foundNonEOL = true;
            }
            ((ByteBuffer)buff).position(tailCount < tailNum ? 0 : ipos + 1);
            ByteBufferInputStream in = new ByteBufferInputStream((ByteBuffer)buff);
            mon.setProgressMessage("reading " + this.file);
            ds1 = (DDataSet)this.parser.readStream((Reader)new InputStreamReader((InputStream)in), mon.getSubtaskMonitor("read file"));
        } else {
            int skipBytes = Integer.parseInt(this.getParam("skipBytes", "0"));
            int fileLength = (int)this.file.length();
            mon.setProgressMessage("reading " + this.file);
            mon.setTaskSize((long)(fileLength - skipBytes));
            if (skipBytes > 0) {
                int n;
                FileInputStream ins = new FileInputStream(this.file);
                byte[] bb = new byte[skipBytes];
                for (int bytesRead = 0; bytesRead < skipBytes; bytesRead += n) {
                    n = ((InputStream)ins).read(bb);
                    if (n != -1) continue;
                    throw new IllegalArgumentException("unable to read skipBytes from file");
                }
                ds1 = (DDataSet)this.parser.readStream((Reader)new InputStreamReader(ins), mon);
            } else {
                ds1 = (DDataSet)this.parser.readStream(AsciiParser.getReader((File)this.file), mon);
            }
        }
        logger.fine("done parsing file");
        return ds1;
    }

    public Map<String, Object> getMetadata(ProgressMonitor mon) throws Exception {
        String firstRecord;
        if (this.ds == null) {
            return new HashMap<String, Object>();
        }
        Map props = (Map)this.ds.property("USER_PROPERTIES");
        String header = (String)props.get("fileHeader");
        if (header != null) {
            header = header.replaceAll("\t", "\\\\t");
            props.put("fileHeader", header);
        }
        if ((firstRecord = (String)props.get("firstRecord")) != null) {
            firstRecord = firstRecord.replaceAll("\t", "\\\\t");
            props.put("firstRecord", firstRecord);
        }
        ArrayList<String> remove = new ArrayList<String>();
        for (Map.Entry e : props.entrySet()) {
            boolean isAllowed;
            String k = (String)e.getKey();
            Object v = e.getValue();
            if (v == null || (isAllowed = v instanceof Number || v instanceof String || v instanceof Datum || v.getClass().isArray())) continue;
            logger.log(Level.FINE, "removing user property because of type: {0}", k);
            remove.add(k);
        }
        for (String k : remove) {
            props.remove(k);
        }
        return props;
    }

    private int columnIndex(String name, int count) {
        if (Pattern.matches("\\d+", name)) {
            return Integer.parseInt(name);
        }
        if (Pattern.matches("-\\d+", name)) {
            return count + Integer.parseInt(name);
        }
        if (Pattern.matches("field\\d+", name)) {
            return Integer.parseInt(name.substring(5));
        }
        int idx = this.parser.getFieldIndex(name);
        return idx;
    }

    private int[] parseRangeStr(String o, int columnCount) throws NumberFormatException {
        String s = o;
        int first = 0;
        int last = columnCount;
        if (s.contains(":")) {
            String[] ss = s.split(":", -2);
            if (ss[0].length() > 0) {
                first = this.columnIndex(ss[0], columnCount);
            }
            if (ss[1].length() > 0) {
                last = this.columnIndex(ss[1], columnCount);
            }
        } else if (s.contains("--")) {
            int isplit = s.indexOf("--", 1);
            if (isplit > 0) {
                first = this.columnIndex(s.substring(0, isplit), columnCount);
            }
            if (isplit < s.length() - 2) {
                last = 1 + this.columnIndex(s.substring(isplit + 1), columnCount);
            }
        } else if (s.contains("-")) {
            String[] ss = s.split("-", -2);
            if (ss[0].length() > 0) {
                first = this.columnIndex(ss[0], columnCount);
            }
            if (ss[1].length() > 0) {
                last = 1 + this.columnIndex(ss[1], columnCount);
            }
        }
        return new int[]{first, last};
    }
}

