/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.ascii;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.autoplot.ascii.OdlDataSource;
import org.autoplot.datasource.AbstractDataSourceFactory;
import org.autoplot.datasource.CompletionContext;
import org.autoplot.datasource.DataSetURI;
import org.autoplot.datasource.DataSource;
import org.autoplot.datasource.DataSourceFactory;
import org.autoplot.datasource.URISplit;
import org.das2.qds.util.OdlParser;
import org.das2.util.monitor.ProgressMonitor;
import org.json.JSONException;
import org.json.JSONObject;

public class OdlDataSourceFactory
extends AbstractDataSourceFactory {
    public DataSource getDataSource(URI uri) throws Exception {
        return new OdlDataSource(uri);
    }

    public List<CompletionContext> getCompletions(CompletionContext cc, ProgressMonitor mon) throws Exception {
        if (cc.context.equals(CompletionContext.CONTEXT_PARAMETER_NAME)) {
            File ff = DataSetURI.getFile((URI)cc.resourceURI, (ProgressMonitor)mon);
            JSONObject record = new JSONObject();
            BufferedReader reader = new BufferedReader(new FileReader(ff));
            String ss = OdlParser.readOdl((BufferedReader)reader, (JSONObject)record);
            String[] nn = OdlParser.getNames((JSONObject)record, (String)"", (boolean)true, null);
            ArrayList<CompletionContext> ccresult = new ArrayList<CompletionContext>();
            String[] stringArray = nn;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String s;
                String key = s = stringArray[i];
                CompletionContext cc1 = new CompletionContext(CompletionContext.CONTEXT_PARAMETER_NAME, key, (DataSourceFactory)this, "arg_0", s, null, true);
                ccresult.add(cc1);
            }
            return ccresult;
        }
        return super.getCompletions(cc, mon);
    }

    public boolean reject(String suri, List<String> problems, ProgressMonitor mon) {
        URISplit split = URISplit.parse((String)suri);
        LinkedHashMap params = URISplit.parseParams((String)split.params);
        String arg_0 = (String)params.get("arg_0");
        if (split.resourceUri == null) {
            return true;
        }
        try {
            File ff = DataSetURI.getFile((URI)split.resourceUri, (ProgressMonitor)mon);
            JSONObject record = new JSONObject();
            BufferedReader reader = new BufferedReader(new FileReader(ff));
            String ss = OdlParser.readOdl((BufferedReader)reader, (JSONObject)record);
            String[] nn = OdlParser.getNames((JSONObject)record, (String)"", (boolean)true, null);
            if (arg_0 == null) {
                return nn.length > 2;
            }
            for (String s : nn) {
                if (!s.equals(arg_0)) continue;
                return false;
            }
            return true;
        }
        catch (IOException | JSONException ex) {
            return true;
        }
    }
}

