/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.csv;

import com.csvreader.CsvWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.autoplot.ascii.AsciiTableDataSourceFormat;
import org.autoplot.datasource.AbstractDataSourceFormat;
import org.autoplot.datasource.URISplit;
import org.das2.datum.Datum;
import org.das2.datum.EnumerationUnits;
import org.das2.datum.TimeParser;
import org.das2.datum.Units;
import org.das2.datum.UnitsUtil;
import org.das2.datum.format.DatumFormatter;
import org.das2.datum.format.DefaultDatumFormatter;
import org.das2.datum.format.FormatStringFormatter;
import org.das2.datum.format.TimeDatumFormatter;
import org.das2.datum.format.TimeDatumFormatterFactory;
import org.das2.qds.DataSetUtil;
import org.das2.qds.QDataSet;
import org.das2.qds.SemanticOps;
import org.das2.qds.ops.Ops;
import org.das2.util.LoggerManager;
import org.das2.util.monitor.ProgressMonitor;

public class CsvDataSourceFormat
extends AbstractDataSourceFormat {
    private static final Logger logger = LoggerManager.getLogger((String)"apdss.ascii.csv");

    private DatumFormatter getTimeFormatter() {
        Object timeFormatter;
        String tformat = this.getParam("tformat", "ISO8601");
        String ft = tformat.toLowerCase();
        String depend0Units = this.getParam("depend0Units", "");
        Units dep0units = null;
        if (depend0Units.length() > 0) {
            try {
                dep0units = Units.lookupTimeUnits((String)depend0Units);
            }
            catch (ParseException ex) {
                Logger.getLogger(AsciiTableDataSourceFormat.class.getName()).log(Level.SEVERE, null, ex);
            }
            final Units tu = dep0units;
            if (ft.equals("iso8601")) {
                ft = null;
            }
            final String sformat = ft;
            timeFormatter = new DefaultDatumFormatter(){

                public String format(Datum datum) {
                    return this.format(datum, tu);
                }

                public String format(Datum datum, Units units) {
                    if (datum.isFill()) {
                        return "fill";
                    }
                    if (sformat != null && sformat.startsWith("%")) {
                        return String.format(sformat, datum.doubleValue(tu));
                    }
                    return String.valueOf(datum.doubleValue(tu));
                }
            };
        } else if (ft.equals("iso8601")) {
            timeFormatter = TimeDatumFormatterFactory.getInstance().defaultFormatter();
        } else if (tformat.startsWith("%") || ft.startsWith("$")) {
            if (tformat.startsWith("$")) {
                tformat = tformat.replaceAll("\\$", "%");
            }
            tformat = tformat.replaceAll("\\+", this.getParam("delim", ","));
            try {
                timeFormatter = new TimeDatumFormatter(tformat);
            }
            catch (ParseException ex) {
                logger.log(Level.SEVERE, ex.getMessage(), ex);
                try {
                    timeFormatter = new TimeDatumFormatter("%Y-%m-%dT%H:%M:%S");
                }
                catch (ParseException ex1) {
                    throw new RuntimeException(ex1);
                }
            }
        } else {
            try {
                if (ft.equals("day")) {
                    timeFormatter = new TimeDatumFormatter("%Y-%m-%d");
                } else if (ft.equals("hour")) {
                    timeFormatter = new TimeDatumFormatter("%Y-%m-%dT%H:%MZ");
                } else if (ft.startsWith("min")) {
                    timeFormatter = new TimeDatumFormatter("%Y-%m-%dT%H:%MZ");
                } else if (ft.startsWith("sec")) {
                    timeFormatter = new TimeDatumFormatter("%Y-%m-%dT%H:%M:%SZ");
                } else if (ft.startsWith("millisec")) {
                    final TimeParser tp = TimeParser.create((String)"$Y-$m-$dT$H:$M:$S.$(subsec,places=3)");
                    timeFormatter = new DatumFormatter(){

                        public String format(Datum datum) {
                            return tp.format(datum);
                        }
                    };
                } else if (ft.startsWith("microsec")) {
                    final TimeParser tp = TimeParser.create((String)"$Y-$m-$dT$H:$M:$S.$(subsec,places=6)");
                    timeFormatter = new DatumFormatter(){

                        public String format(Datum datum) {
                            return tp.format(datum);
                        }
                    };
                } else if (ft.startsWith("nanosec")) {
                    final TimeParser tp = TimeParser.create((String)"$Y-$m-$dT$H:$M:$S.$(subsec,places=9)");
                    timeFormatter = new DatumFormatter(){

                        public String format(Datum datum) {
                            return tp.format(datum);
                        }
                    };
                } else {
                    logger.log(Level.FINE, "not implemented: {0}", ft);
                    timeFormatter = new TimeDatumFormatter("%Y-%m-%dT%H:%M:%S");
                }
            }
            catch (ParseException ex) {
                logger.log(Level.SEVERE, ex.getMessage(), ex);
                timeFormatter = TimeDatumFormatterFactory.getInstance().defaultFormatter();
            }
        }
        return timeFormatter;
    }

    private DatumFormatter getDataFormatter(String df, Units u) {
        try {
            if (!df.contains("%")) {
                df = "%" + df;
            }
            return new FormatStringFormatter(df, false);
        }
        catch (RuntimeException ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
            return u.getDatumFormatterFactory().defaultFormatter();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void formatData(String uri, QDataSet data, ProgressMonitor mon) throws Exception {
        super.setUri(uri);
        URISplit split = URISplit.parse((String)uri);
        LinkedHashMap params = URISplit.parseParams((String)split.params);
        char delim = ',';
        if (params.containsKey("delim")) {
            String sdelimiter = (String)params.get("delim");
            if (sdelimiter.equals("COMMA")) {
                sdelimiter = ",";
            }
            if (sdelimiter.equals("SEMICOLON")) {
                sdelimiter = ";";
            }
            delim = sdelimiter.charAt(0);
        }
        super.maybeMkdirs();
        mon.setTaskSize((long)data.length());
        mon.started();
        File outFile = new File(split.resourceUri);
        FileWriter fw = new FileWriter(outFile);
        CsvWriter writer = null;
        try {
            writer = new CsvWriter((Writer)fw, delim);
            writer.setForceQualifier(true);
            writer.setUseTextQualifier(true);
            int col = 0;
            ArrayList<QDataSet> ldss = new ArrayList<QDataSet>();
            ArrayList<QDataSet> lwdss = new ArrayList<QDataSet>();
            if (data.property("DEPEND_0") != null) {
                ldss.add((QDataSet)data.property("DEPEND_0"));
                lwdss.add(DataSetUtil.weightsDataSet((QDataSet)((QDataSet)data.property("DEPEND_0"))));
                ++col;
            }
            switch (data.rank()) {
                case 1: {
                    ldss.add(data);
                    lwdss.add(DataSetUtil.weightsDataSet((QDataSet)data));
                    ++col;
                    break;
                }
                case 2: {
                    if (SemanticOps.isBundle((QDataSet)data)) {
                        for (int k = 0; k < data.length(0); ++k) {
                            QDataSet d1 = Ops.unbundle((QDataSet)data, (int)k);
                            ldss.add(d1);
                            lwdss.add(DataSetUtil.weightsDataSet((QDataSet)d1));
                        }
                    } else {
                        ldss.add(data);
                        lwdss.add(DataSetUtil.weightsDataSet((QDataSet)data));
                    }
                    col += data.length(0);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("rank limit, data must be rank 1 sequence or a rank 2 table of data");
                }
            }
            QDataSet[] dss = ldss.toArray(new QDataSet[ldss.size()]);
            QDataSet[] wdss = lwdss.toArray(new QDataSet[lwdss.size()]);
            String[] values = new String[col];
            String[] labels = new String[col];
            col = 0;
            for (int ids = 0; ids < dss.length; ++ids) {
                Units units;
                String name = (String)dss[ids].property("LABEL");
                if (name == null) {
                    name = (String)dss[ids].property("NAME");
                }
                if (name == null) {
                    name = "data" + ids;
                }
                Object sunits = UnitsUtil.isTimeLocation((Units)(units = SemanticOps.getUnits((QDataSet)dss[ids]))) ? "UTC" : (units.isConvertibleTo(Units.dimensionless) ? null : String.valueOf(units));
                if (dss[ids].rank() == 1) {
                    labels[col++] = sunits == null ? name : name + " (" + (String)sunits + ")";
                    continue;
                }
                QDataSet dep1 = (QDataSet)dss[ids].property("DEPEND_1");
                if (dep1 != null && dep1.rank() == 1) {
                    Units dep1units = SemanticOps.getUnits((QDataSet)dep1);
                    for (int j = 0; j < dss[ids].length(0); ++j) {
                        labels[col++] = dep1units.format(Datum.create((double)dep1.value(j), (Units)dep1units));
                    }
                    continue;
                }
                for (int j = 0; j < dss[ids].length(0); ++j) {
                    labels[col++] = name + " " + j + " (" + (String)sunits + ")";
                }
            }
            writer.writeRecord(labels);
            writer.setForceQualifier(false);
            writer.setUseTextQualifier(true);
            QDataSet bundleDesc = (QDataSet)data.property("BUNDLE_1");
            DatumFormatter tf = this.getTimeFormatter();
            String df = this.getParam("format", "");
            DatumFormatter[] formats = new DatumFormatter[dss.length];
            for (int jj = 0; jj < dss.length; ++jj) {
                Units u;
                QDataSet dssjj = dss[jj];
                Units uu_jj = u = SemanticOps.getUnits((QDataSet)dssjj);
                formats[jj] = u.getDatumFormatterFactory().defaultFormatter();
                if (!(uu_jj instanceof EnumerationUnits)) {
                    String ff;
                    String string = ff = bundleDesc != null ? (String)dssjj.property("FORMAT") : null;
                    if (ff == null && bundleDesc != null) {
                        if (bundleDesc.length() == dss.length - 1 && jj > 0) {
                            ff = (String)bundleDesc.property("FORMAT", jj - 1);
                        } else if (bundleDesc.length() == dss.length) {
                            ff = (String)bundleDesc.property("FORMAT", jj);
                        }
                    }
                    if (df.equals("")) {
                        if (ff == null) {
                            double d1 = dssjj.rank() == 1 ? dssjj.value(0) : dssjj.value(0, 0);
                            formats[jj] = uu_jj.createDatum(d1).getFormatter();
                            continue;
                        }
                        formats[jj] = this.getDataFormatter(ff, uu_jj);
                        continue;
                    }
                    if (UnitsUtil.isTimeLocation((Units)uu_jj)) {
                        formats[jj] = tf;
                        continue;
                    }
                    if (ff == null) {
                        formats[jj] = this.getDataFormatter(df, uu_jj);
                        continue;
                    }
                    formats[jj] = this.getDataFormatter(ff, uu_jj);
                    continue;
                }
                formats[jj] = uu_jj.createDatum(dssjj.rank() == 1 ? dssjj.value(0) : dssjj.value(0, 0)).getFormatter();
            }
            for (int i = 0; i < data.length(); ++i) {
                mon.setTaskProgress((long)i);
                col = 0;
                for (int ids = 0; ids < dss.length; ++ids) {
                    Units u = SemanticOps.getUnits((QDataSet)dss[ids]);
                    if (dss[ids].rank() == 1) {
                        if (wdss[ids].value(i) == 0.0) {
                            values[col++] = "NaN";
                            continue;
                        }
                        values[col++] = formats[ids].format(u.createDatum(dss[ids].value(i)), u);
                        continue;
                    }
                    for (int j = 0; j < dss[ids].length(0); ++j) {
                        values[col++] = wdss[ids].value(i, j) == 0.0 ? "NaN" : formats[ids].format(u.createDatum(dss[ids].value(i, j)), u);
                    }
                }
                writer.writeRecord(values);
            }
        }
        finally {
            if (writer != null) {
                writer.close();
            }
            fw.close();
            mon.finished();
        }
    }

    public boolean canFormat(QDataSet ds) {
        return ds.rank() == 1 || ds.rank() == 2;
    }

    public String getDescription() {
        return "Comma Separated Values";
    }
}

