/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.das2Stream;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.autoplot.das2Stream.Das2StreamDataSource;
import org.autoplot.datasource.AbstractDataSourceFactory;
import org.autoplot.datasource.CompletionContext;
import org.autoplot.datasource.DataSetURI;
import org.autoplot.datasource.DataSource;
import org.autoplot.datasource.DataSourceFactory;
import org.autoplot.datasource.MetadataModel;
import org.das2.qstream.QDataSetStreamHandler;
import org.das2.qstream.StreamException;
import org.das2.qstream.StreamHandler;
import org.das2.qstream.StreamTool;
import org.das2.util.monitor.ProgressMonitor;

public class Das2StreamDataSourceFactory
extends AbstractDataSourceFactory
implements DataSourceFactory {
    public DataSource getDataSource(URI uri) throws IOException {
        return new Das2StreamDataSource(uri);
    }

    public List<CompletionContext> getCompletions(CompletionContext cc, ProgressMonitor mon) throws IOException, StreamException {
        ArrayList<CompletionContext> result = new ArrayList<CompletionContext>();
        if (cc.context == CompletionContext.CONTEXT_PARAMETER_NAME) {
            if (DataSetURI.fromUri((URI)cc.resourceURI).endsWith(".qds")) {
                result.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_NAME, "", (DataSourceFactory)this, "arg_0", "", "default dataset", true));
                Map<String, String> params = this.getNames(cc, mon);
                for (Map.Entry<String, String> e : params.entrySet()) {
                    result.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_NAME, e.getKey(), (DataSourceFactory)this, "arg_0", e.getValue(), null, true));
                }
            } else {
                result.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_NAME, "useOldD2sParser="));
            }
        } else if (cc.context == CompletionContext.CONTEXT_PARAMETER_VALUE) {
            result.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_VALUE, "T"));
            result.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_VALUE, "F"));
        }
        return result;
    }

    public MetadataModel getMetadataModel(URL url) {
        return MetadataModel.createNullModel();
    }

    private Map<String, String> getNames(CompletionContext cc, ProgressMonitor mon) throws IOException, StreamException {
        File file = DataSetURI.getFile((URI)cc.resourceURI, (ProgressMonitor)mon);
        QDataSetStreamHandler h = new QDataSetStreamHandler();
        h.setReadPackets(false);
        StreamTool.readStream((ReadableByteChannel)Channels.newChannel(new FileInputStream(file)), (StreamHandler)h);
        return h.getDataSetNamesAndDescriptions();
    }

    public String getDescription() {
        return "Das2Streams and QStreams";
    }
}

