/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.das2Stream;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.LinkedHashMap;
import java.util.Map;
import org.autoplot.datasource.DataSourceFormat;
import org.autoplot.datasource.URISplit;
import org.das2.qds.QDataSet;
import org.das2.qstream.QdsToDas22;
import org.das2.qstream.QdsToDas23;
import org.das2.qstream.StreamException;
import org.das2.util.monitor.ProgressMonitor;

public class Das2StreamDataSourceFormat
implements DataSourceFormat {
    public static String getVersion(String uri) {
        String sVer = URISplit.getParam((String)uri, (String)"version", (String)"2.2");
        if (sVer.equalsIgnoreCase("2.3/basic")) {
            return "2.3/basic";
        }
        return "2.2";
    }

    public static int getFracSeconds(String uri) {
        int nFracSec;
        String sVal = Integer.toString(3);
        String sFracSec = URISplit.getParam((String)uri, (String)"fracsec", (String)sVal);
        try {
            nFracSec = Integer.parseInt(sFracSec);
        }
        catch (NumberFormatException e) {
            nFracSec = 3;
        }
        return nFracSec;
    }

    public static int getSigDigits(String uri) {
        String sVal = URISplit.getParam((String)uri, (String)"precision", null);
        int nSigDigit = 5;
        if (sVal != null) {
            try {
                nSigDigit = Integer.parseInt(sVal);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return nSigDigit;
    }

    public static boolean getBinary(String uri) {
        String type = URISplit.getParam((String)uri, (String)"type", (String)"ascii");
        return type.equalsIgnoreCase("binary");
    }

    public static URISplit setOptions(URISplit lSplit, String version, boolean binary, int sigdigit, int fracsec) {
        if (lSplit == null) {
            return null;
        }
        LinkedHashMap args = URISplit.parseParams((String)lSplit.params);
        if (binary) {
            args.put("type", "binary");
        } else {
            args.remove("type");
        }
        if (sigdigit == 5) {
            args.remove("precision");
        } else {
            args.put("precision", Integer.toString(sigdigit));
        }
        if (fracsec == 3) {
            args.remove("fracsec");
        } else {
            args.put("fracsec", Integer.toString(fracsec));
        }
        if (version.equalsIgnoreCase("2.2")) {
            args.remove("version");
        } else {
            args.put("version", version);
        }
        lSplit.params = URISplit.formatParams((Map)args);
        return lSplit;
    }

    public void formatData(String url, QDataSet data, ProgressMonitor mon) throws Exception {
        URISplit split = URISplit.parse((String)url);
        boolean binary = Das2StreamDataSourceFormat.getBinary(url);
        int nSigDigit = Das2StreamDataSourceFormat.getSigDigits(url);
        int nFracSec = Das2StreamDataSourceFormat.getFracSeconds(url);
        String sVersion = Das2StreamDataSourceFormat.getVersion(url);
        try (FileOutputStream fo = new FileOutputStream(new File(split.resourceUri));){
            QdsToDas22 writer;
            switch (sVersion) {
                case "2.2": {
                    if (binary) {
                        writer = new QdsToDas22();
                        break;
                    }
                    writer = new QdsToDas22(nSigDigit, nFracSec);
                    break;
                }
                case "2.3/basic": {
                    if (binary) {
                        writer = new QdsToDas23();
                        break;
                    }
                    writer = new QdsToDas23(nSigDigit, nFracSec);
                    break;
                }
                default: {
                    throw new StreamException(String.format("Unknown stream format %s", sVersion));
                }
            }
            if (!writer.write(data, (OutputStream)fo)) {
                if (sVersion.equals("2.2")) {
                    throw new StreamException("This dataset looks to be rank 3 or otherwise incompatible with the original das2 stream fromat.  Hint: Try using das2.3/basic instead.");
                }
                throw new StreamException("This dataset looks to incompatable with any das2 stream format.");
            }
        }
    }

    public boolean canFormat(QDataSet ds) {
        QdsToDas23 writer = new QdsToDas23();
        return writer.canWrite(ds);
    }

    public String getDescription() {
        return "das2 stream";
    }
}

