/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.das2Stream;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.LinkedHashMap;
import org.autoplot.datasource.DataSourceFormat;
import org.autoplot.datasource.URISplit;
import org.das2.qds.QDataSet;
import org.das2.qds.SemanticOps;
import org.das2.qstream.BundleStreamFormatter;
import org.das2.qstream.SimpleStreamFormatter;
import org.das2.util.monitor.ProgressMonitor;

public class QStreamDataSourceFormat
implements DataSourceFormat {
    public void formatData(String url, QDataSet data, ProgressMonitor mon) throws Exception {
        URISplit split = URISplit.parse((String)url);
        LinkedHashMap params = URISplit.parseParams((String)split.params);
        boolean binary = "binary".equals(params.get("type"));
        try (FileOutputStream fo = new FileOutputStream(new File(split.resourceUri));){
            if (SemanticOps.isBundle((QDataSet)data)) {
                new BundleStreamFormatter().format(data, (OutputStream)fo, !binary);
            } else {
                new SimpleStreamFormatter().format(data, (OutputStream)fo, !binary);
            }
        }
    }

    public boolean canFormat(QDataSet ds) {
        return true;
    }

    public String getDescription() {
        return "QStream data transfer format";
    }
}

