/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.json;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UncheckedIOException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class JSONJIterator
implements Iterator<Object>,
AutoCloseable {
    private final BufferedReader reader;
    private String nextLine;

    public JSONJIterator(InputStream inputStream) {
        this.reader = new BufferedReader(new InputStreamReader(inputStream));
        this.advance();
    }

    private static String handleOddFileNest(String rec) {
        if (rec.startsWith("\"{\"\"") && rec.endsWith("}\"")) {
            rec = rec.substring(1, rec.length() - 1);
            rec = rec.replaceAll("\"\"", "\"");
        }
        return rec;
    }

    private void advance() {
        try {
            this.nextLine = this.reader.readLine();
            if (this.nextLine == null || (this.nextLine = this.nextLine.trim()).isEmpty()) {
                this.reader.close();
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public boolean hasNext() {
        return this.nextLine != null;
    }

    @Override
    public Object next() {
        JSONObject parsed;
        block6: {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            String jsonText = this.nextLine.trim();
            if (jsonText.startsWith("\"")) {
                jsonText = JSONJIterator.handleOddFileNest(jsonText);
            }
            parsed = null;
            try {
                if (jsonText.startsWith("{")) {
                    parsed = new JSONObject(jsonText);
                    break block6;
                }
                if (jsonText.startsWith("[")) {
                    parsed = new JSONArray(jsonText);
                    break block6;
                }
                throw new IllegalArgumentException("Invalid JSONJ record: " + jsonText);
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
        this.advance();
        return parsed;
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }

    public static void main(String[] args) {
        String jsonj = "                {\"name\": \"Alice\", \"age\": 30}\n{\"name\": \"Bob\", \"age\": 25}\n{\"name\": \"Charlie\", \"age\": 35}\n [1, 2, 3, 4, 5]\n";
        try (JSONJIterator iterator = new JSONJIterator(new ByteArrayInputStream(jsonj.getBytes()));){
            while (iterator.hasNext()) {
                Object record = iterator.next();
                System.out.println(record.getClass().getSimpleName() + ": " + record);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

