/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.fdc;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URI;
import java.net.URL;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.LayoutStyle;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import org.autoplot.datasource.DataSetURI;
import org.autoplot.datasource.DataSourceEditorPanel;
import org.autoplot.datasource.URISplit;
import org.autoplot.fdc.FedCatTreeModel;
import org.das2.catalog.DasNode;
import org.das2.catalog.DasNodeFactory;
import org.das2.util.filesystem.FileSystem;
import org.das2.util.monitor.ProgressMonitor;

public class FedCatSourceEditorPanel
extends JPanel
implements DataSourceEditorPanel {
    private static final Logger LOGGER = Logger.getLogger("apdss.dc");
    private DasNode nodeCur;
    private String sCurUri;
    private ImageIcon iconSiteDefault;
    private FedCatTreeModel catModel;
    private JRadioButton btnCustomTree;
    private ButtonGroup btnGroupRoot;
    private JRadioButton btnMainTree;
    private JRadioButton btnTestTree;
    private JLabel jLabel1;
    private JTextArea jTextArea1;
    private JLabel lblSiteImage;
    private JLabel lblSrcPath;
    private JPanel pnlCatalog;
    private JScrollPane pnlQueryCtrl;
    private JPanel pnlSource;
    private JPanel pnlWhichCat;
    private JScrollPane scrPaneCatalog;
    private JSplitPane splitPane;
    private JTree treeControl;
    private JTextField txtCustomUrl;

    public FedCatSourceEditorPanel() {
        String sDefaultIcon = "/org/das2/catalog/das2_circle.png";
        URL urlIcon = this.getClass().getResource(sDefaultIcon);
        ImageIcon imageIcon = new ImageIcon(urlIcon);
        Image image = imageIcon.getImage();
        Image newimg = image.getScaledInstance(60, 60, 4);
        this.iconSiteDefault = new ImageIcon(newimg);
        this.initComponents();
    }

    private void initComponents() {
        this.btnGroupRoot = new ButtonGroup();
        this.splitPane = new JSplitPane();
        this.pnlCatalog = new JPanel();
        this.pnlWhichCat = new JPanel();
        this.jLabel1 = new JLabel();
        this.btnMainTree = new JRadioButton();
        this.btnTestTree = new JRadioButton();
        this.btnCustomTree = new JRadioButton();
        this.txtCustomUrl = new JTextField();
        this.scrPaneCatalog = new JScrollPane();
        this.treeControl = new JTree();
        this.lblSiteImage = new JLabel();
        this.pnlSource = new JPanel();
        this.lblSrcPath = new JLabel();
        this.pnlQueryCtrl = new JScrollPane();
        this.jTextArea1 = new JTextArea();
        this.setLayout(new GridBagLayout());
        this.splitPane.setDividerLocation(200);
        this.splitPane.setOrientation(0);
        this.splitPane.setResizeWeight(0.5);
        this.splitPane.setMinimumSize(new Dimension(100, 100));
        this.pnlCatalog.setFocusable(false);
        this.pnlCatalog.setMinimumSize(new Dimension(200, 60));
        this.pnlCatalog.setPreferredSize(new Dimension(500, 200));
        this.pnlCatalog.setLayout(new GridBagLayout());
        this.jLabel1.setText("Catalog:");
        this.btnGroupRoot.add(this.btnMainTree);
        this.btnMainTree.setSelected(true);
        this.btnMainTree.setText("Main");
        this.btnMainTree.setNextFocusableComponent(this.btnTestTree);
        this.btnMainTree.setRequestFocusEnabled(false);
        this.btnMainTree.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FedCatSourceEditorPanel.this.btnMainTreeActionPerformed(evt);
            }
        });
        this.btnGroupRoot.add(this.btnTestTree);
        this.btnTestTree.setText("Test");
        this.btnTestTree.setNextFocusableComponent(this.btnCustomTree);
        this.btnGroupRoot.add(this.btnCustomTree);
        this.btnCustomTree.setText("Custom");
        this.btnCustomTree.setNextFocusableComponent(this.txtCustomUrl);
        this.btnCustomTree.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FedCatSourceEditorPanel.this.btnCustomTreeActionPerformed(evt);
            }
        });
        this.txtCustomUrl.setNextFocusableComponent(this.treeControl);
        this.txtCustomUrl.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FedCatSourceEditorPanel.this.txtCustomUrlActionPerformed(evt);
            }
        });
        GroupLayout pnlWhichCatLayout = new GroupLayout(this.pnlWhichCat);
        this.pnlWhichCat.setLayout(pnlWhichCatLayout);
        pnlWhichCatLayout.setHorizontalGroup(pnlWhichCatLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlWhichCatLayout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnMainTree).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.btnTestTree).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.btnCustomTree).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.txtCustomUrl, -1, 441, Short.MAX_VALUE).addContainerGap()));
        pnlWhichCatLayout.setVerticalGroup(pnlWhichCatLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlWhichCatLayout.createSequentialGroup().addContainerGap().addGroup(pnlWhichCatLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.btnMainTree).addComponent(this.btnTestTree).addComponent(this.btnCustomTree).addComponent(this.txtCustomUrl, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 278;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.pnlCatalog.add((Component)this.pnlWhichCat, gridBagConstraints);
        DefaultMutableTreeNode treeNode1 = new DefaultMutableTreeNode("Reading Catalog ...");
        this.treeControl.setModel(new DefaultTreeModel(treeNode1));
        this.treeControl.setNextFocusableComponent(this.pnlSource);
        this.scrPaneCatalog.setViewportView(this.treeControl);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 4;
        gridBagConstraints.ipady = 4;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.pnlCatalog.add((Component)this.scrPaneCatalog, gridBagConstraints);
        this.lblSiteImage.setIcon(this.iconSiteDefault);
        this.lblSiteImage.setFocusable(false);
        this.lblSiteImage.setMaximumSize(new Dimension(72, 72));
        this.lblSiteImage.setPreferredSize(new Dimension(72, 72));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.pnlCatalog.add((Component)this.lblSiteImage, gridBagConstraints);
        this.splitPane.setLeftComponent(this.pnlCatalog);
        this.pnlSource.setMinimumSize(new Dimension(200, 40));
        this.pnlSource.setPreferredSize(new Dimension(500, 200));
        this.pnlSource.setLayout(new GridBagLayout());
        this.lblSrcPath.setFont(new Font("Dialog", 0, 12));
        this.lblSrcPath.setText("<html>tag:das2.org,2012:<b>site:/uiowa/juno/wav/survey</b>");
        this.lblSrcPath.setFocusable(false);
        this.lblSrcPath.setHorizontalTextPosition(0);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        this.pnlSource.add((Component)this.lblSrcPath, gridBagConstraints);
        this.jTextArea1.setColumns(20);
        this.jTextArea1.setRows(5);
        this.jTextArea1.setTabSize(3);
        this.jTextArea1.setMinimumSize(new Dimension(150, 180));
        this.pnlQueryCtrl.setViewportView(this.jTextArea1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.pnlSource.add((Component)this.pnlQueryCtrl, gridBagConstraints);
        this.splitPane.setRightComponent(this.pnlSource);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 2;
        gridBagConstraints.ipady = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add((Component)this.splitPane, gridBagConstraints);
    }

    private void btnMainTreeActionPerformed(ActionEvent evt) {
    }

    private void btnCustomTreeActionPerformed(ActionEvent evt) {
    }

    private void txtCustomUrlActionPerformed(ActionEvent evt) {
    }

    public boolean reject(String sFullUri) throws Exception {
        if (sFullUri.equals("vap+dc:")) {
            return false;
        }
        URISplit split = URISplit.parse((String)sFullUri);
        String sCatPath = split.file;
        if (sCatPath.startsWith(DasNodeFactory.defaultDataPath()) || sCatPath.startsWith("site:") || sCatPath.startsWith("test:")) {
            return false;
        }
        if (split.resourceUri == null) {
            return true;
        }
        FileSystem fs = FileSystem.create((URI)DataSetURI.getWebURL((URI)DataSetURI.toUri((String)split.path)).toURI());
        return fs.isDirectory(split.file.substring(split.path.length()));
    }

    public boolean prepare(String sFullUri, Window parent, ProgressMonitor mon) throws Exception {
        this.sCurUri = sFullUri;
        String sNodeUrl = DasNodeFactory.defaultDataPath();
        URISplit split = URISplit.parse((String)sFullUri);
        if (!sFullUri.equals("vap+dc:")) {
            sNodeUrl = split.file;
        }
        this.nodeCur = DasNodeFactory.getNearestNode(sNodeUrl, mon, false);
        if (this.nodeCur.isDir()) {
            this.pnlCatalog.setVisible(true);
            DasNode theRoot = DasNodeFactory.getNode(null, mon, false);
            if (this.nodeCur.getRoot() != theRoot) {
                this.btnCustomTree.setSelected(true);
                this.txtCustomUrl.setText(split.surl);
            } else {
                this.txtCustomUrl.setEnabled(false);
                String sPath = this.nodeCur.path();
                this.btnMainTree.setSelected(sPath.startsWith(DasNodeFactory.defaultDataPath()));
                this.btnTestTree.setSelected(sPath.startsWith(DasNodeFactory.defaultTestPath()));
            }
            this.catModel = new FedCatTreeModel(this.nodeCur.getRoot());
            this.treeControl.setModel(this.catModel);
        }
        if (this.nodeCur.isSrc()) {
            if (this.nodeCur.isRoot()) {
                this.pnlCatalog.setVisible(false);
                this.lblSrcPath.setText("");
                this.lblSrcPath.setVisible(false);
            } else {
                this.lblSrcPath.setText(this.nodeCur.path());
                this.lblSrcPath.setVisible(true);
                this.catModel = new FedCatTreeModel(this.nodeCur.getRoot());
                this.treeControl.setModel(this.catModel);
            }
        }
        return true;
    }

    public void setURI(String sFullUri) {
        assert (sFullUri.equals(this.sCurUri)) : "URI changed after prepare";
        boolean bDebugRestStop = true;
    }

    public void markProblems(List<String> problems) {
    }

    public JPanel getPanel() {
        return this;
    }

    public String getURI() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

