/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.fdc;

import java.io.IOException;
import java.net.URI;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.logging.Logger;
import org.autoplot.datasource.AbstractDataSourceFactory;
import org.autoplot.datasource.CompletionContext;
import org.autoplot.datasource.DataSource;
import org.autoplot.datasource.URISplit;
import org.autoplot.fdc.FedCatSource;
import org.das2.catalog.DasNode;
import org.das2.catalog.DasNodeFactory;
import org.das2.catalog.DasResolveException;
import org.das2.catalog.DasSrcNode;
import org.das2.util.monitor.NullProgressMonitor;
import org.das2.util.monitor.ProgressMonitor;

public class FedCatSourceFactory
extends AbstractDataSourceFactory {
    private static final Logger LOGGER = Logger.getLogger("apdss.dc");

    public DataSource getDataSource(URI uri) throws Exception {
        NullProgressMonitor mon = new NullProgressMonitor();
        DasNode node = DasNodeFactory.getNearestNode(uri.toString(), (ProgressMonitor)mon, false);
        return new FedCatSource(uri, node);
    }

    public boolean supportsDiscovery() {
        return true;
    }

    public boolean isFileResource() {
        return false;
    }

    public boolean reject(String sUrl, List<String> lProblems, ProgressMonitor mon) {
        DasNode node;
        URISplit split = URISplit.parse((String)sUrl);
        LinkedHashMap dParams = URISplit.parseParams((String)split.params);
        String sNodeUrl = DasNodeFactory.defaultDataPath();
        if (!sUrl.equals("vap+dc:")) {
            sNodeUrl = split.file;
        }
        try {
            node = DasNodeFactory.getNode(sNodeUrl, mon, false);
        }
        catch (IOException | ParseException | DasResolveException ex) {
            return true;
        }
        if (node == null) {
            return true;
        }
        if (!node.isSrc()) {
            return true;
        }
        DasSrcNode srcNode = (DasSrcNode)node;
        return !srcNode.queryVerify(dParams);
    }

    public List<CompletionContext> getCompletions(CompletionContext cc, ProgressMonitor mon) throws Exception {
        DasNode node;
        String sUrl = cc.surl;
        URISplit split = URISplit.parse((String)sUrl);
        String sNodeUrl = DasNodeFactory.defaultDataPath();
        if (!sUrl.equals("vap+dc:")) {
            sNodeUrl = split.file;
        }
        try {
            node = DasNodeFactory.getNode(sNodeUrl, mon, false);
        }
        catch (IOException | ParseException | DasResolveException ex) {
            return Collections.emptyList();
        }
        if (node == null) {
            return Collections.emptyList();
        }
        ArrayList<CompletionContext> lComp = new ArrayList<CompletionContext>();
        return lComp;
    }
}

