/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.fdc;

import java.util.logging.Logger;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import org.das2.catalog.DasDirNode;
import org.das2.catalog.DasNode;
import org.das2.util.LoggerManager;

public class FedCatTreeModel
extends DefaultTreeModel {
    private static final Logger LOGGER = LoggerManager.getLogger((String)"apdss.dc");

    public FedCatTreeModel(DasNode dasRoot) {
        super(new DasCatTreeNode(dasRoot), true);
    }

    @Override
    public boolean isLeaf(Object treenode) {
        DasNode node = ((DasCatTreeNode)treenode).node;
        return !node.isDir();
    }

    @Override
    public int getChildCount(Object parent) {
        DasNode node = ((DasCatTreeNode)parent).node;
        if (node.isDir()) {
            DasDirNode dir = (DasDirNode)node;
            String[] aIds = dir.list();
            return aIds.length;
        }
        return 0;
    }

    @Override
    public Object getChild(Object parent, int index) {
        DasNode node = ((DasCatTreeNode)parent).node;
        if (!node.isDir()) {
            return null;
        }
        DasDirNode dir = (DasDirNode)node;
        String[] aIds = dir.list();
        if (index >= aIds.length) {
            return null;
        }
        return new DasCatTreeNode(dir.get(aIds[index]));
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        DasNode dnTmp = ((DasCatTreeNode)parent).node;
        if (!dnTmp.isDir()) {
            return -1;
        }
        DasDirNode dir = (DasDirNode)dnTmp;
        DasNode node = ((DasCatTreeNode)child).node;
        String[] aIds = dir.list();
        for (int i = 0; i < aIds.length; ++i) {
            if (dir.get(aIds[i]) != node) continue;
            return i;
        }
        return -1;
    }

    private static class DasCatTreeNode
    extends DefaultMutableTreeNode {
        DasNode node;

        DasCatTreeNode(DasNode node) {
            this.node = node;
        }

        @Override
        public String toString() {
            String s;
            String sRet = "";
            if (this.node.name() != null) {
                sRet = "<html><b>" + this.node.name() + "</b>";
            }
            if ((s = this.node.prop("title").str()) != null) {
                sRet = sRet + " " + s;
            }
            return sRet;
        }
    }
}

