/*
 * Decompiled with CFR 0.152.
 */
package org.das2.catalog.impl;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.das2.catalog.DasDirNode;
import org.das2.catalog.DasNode;
import org.das2.catalog.DasResolveException;
import org.das2.catalog.impl.AbstractNode;
import org.das2.util.LoggerManager;
import org.das2.util.monitor.ProgressMonitor;

public abstract class AbstractDirNode
extends AbstractNode
implements DasDirNode {
    private static final Logger LOGGER = LoggerManager.getLogger((String)"das2.catalog.absdir");
    static final String DEFAULT_PATH_SEP = "/";
    protected Map<String, AbstractNode> dSubNodes = Collections.synchronizedMap(new HashMap());
    protected String sSep = "/";

    AbstractDirNode(DasDirNode parent, String name, List<String> lUrls) {
        super(parent, name, lUrls);
    }

    @Override
    public String childPath(DasNode child) {
        String sPath = "";
        if (this.parent != null) {
            sPath = this.parent.childPath(this);
        }
        if (this.sSep != null) {
            sPath = sPath + this.sSep;
        }
        for (Map.Entry<String, AbstractNode> nId : this.dSubNodes.entrySet()) {
            String sId = nId.getKey();
            DasNode node = nId.getValue();
            if (node != child) continue;
            sPath = sPath + sId;
            return sPath;
        }
        throw new IllegalArgumentException("Object " + child.name() + ", is not a member of " + this.toString());
    }

    @Override
    public String pathSeparator(ProgressMonitor mon) {
        if (!this.isLoaded()) {
            try {
                this.load(mon);
            }
            catch (DasResolveException ex) {
                LOGGER.log(Level.INFO, "Can''t load full definition of {0} because: {1}", new Object[]{this.toString(), ex.getMessage()});
            }
        }
        return this.sSep;
    }

    @Override
    public String[] list() {
        Object[] aKeys = this.dSubNodes.keySet().toArray(new String[0]);
        Arrays.sort(aKeys);
        return aKeys;
    }

    @Override
    public DasNode resolve(String sSubPath, ProgressMonitor mon) throws DasResolveException {
        String sSubSubPath;
        if (!this.isLoaded()) {
            this.load(mon);
        }
        if (sSubPath == null) {
            return this;
        }
        if (this.sSep != null && this.sSep.length() > 0 && sSubPath.startsWith(this.sSep)) {
            sSubPath = sSubPath.substring(this.sSep.length());
        }
        String[] aSubs = this.list();
        String sChild = null;
        for (String sCheck : aSubs) {
            if (!sSubPath.startsWith(sCheck)) continue;
            if (sChild == null) {
                sChild = sCheck;
                continue;
            }
            if (sCheck.length() <= sChild.length()) continue;
            sChild = sCheck;
        }
        if (sChild == null) {
            while (this.canMerge()) {
                if (!this.merge(mon)) continue;
                return this.resolve(sSubPath, mon);
            }
        }
        if (sChild == null) {
            throw new DasResolveException("Cannot resolve (sub)path", sSubPath);
        }
        AbstractNode child = this.dSubNodes.get(sChild);
        if (!child.isLoaded()) {
            DasResolveException cause = null;
            while (true) {
                try {
                    child.load(mon);
                }
                catch (DasResolveException ex) {
                    LOGGER.log(Level.FINE, "load failure for child node {0}", ex.getMessage());
                    cause = ex;
                    if (this.canMerge()) continue;
                }
                break;
            }
            if (!child.isLoaded()) {
                throw new DasResolveException("Couldn't load", cause, sSubPath);
            }
        }
        if ((sSubSubPath = sSubPath.substring(sChild.length())).length() > 0) {
            if (child.isDir()) {
                AbstractDirNode childDir = (AbstractDirNode)child;
                return childDir.resolve(sSubSubPath, mon);
            }
            throw new DasResolveException("Sub node " + sChild + " is not a directory", sSubSubPath);
        }
        return child;
    }

    @Override
    public DasNode nearest(String sSubPath, ProgressMonitor mon) {
        String sSubSubPath;
        if (!this.isLoaded()) {
            try {
                this.load(mon);
            }
            catch (DasResolveException ex) {
                LOGGER.log(Level.INFO, "Couldn't resolve {0} using sources {1}", new Object[]{sSubPath, this.prettyPrintLoc(null, " ")});
                if (this.parent != null) {
                    return this.parent;
                }
                return this;
            }
        }
        if (sSubPath == null) {
            return this;
        }
        if (this.sSep != null && this.sSep.length() > 0 && sSubPath.startsWith(this.sSep)) {
            sSubPath = sSubPath.substring(this.sSep.length());
        }
        String[] aSubs = this.list();
        String sChild = null;
        for (String sCheck : aSubs) {
            if (!sSubPath.startsWith(sCheck)) continue;
            if (sChild == null) {
                sChild = sCheck;
                continue;
            }
            if (sCheck.length() <= sChild.length()) continue;
            sChild = sCheck;
        }
        if (sChild == null) {
            while (this.canMerge()) {
                if (!this.merge(mon)) continue;
                return this.nearest(sSubPath, mon);
            }
        }
        if (sChild == null) {
            LOGGER.log(Level.FINE, "Cannot resolve (sub)path {0}", sSubPath);
            return this;
        }
        AbstractNode node = this.dSubNodes.get(sChild);
        if (!node.isLoaded()) {
            while (true) {
                try {
                    node.load(mon);
                }
                catch (DasResolveException ex) {
                    LOGGER.log(Level.FINE, "load failure for child node {0}", ex.getMessage());
                    if (this.canMerge()) continue;
                }
                break;
            }
            if (!node.isLoaded()) {
                LOGGER.log(Level.FINE, "Couldn''t load {0}", sSubPath);
                return this;
            }
        }
        if ((sSubSubPath = sSubPath.substring(sChild.length())).length() > 0 && node.isDir()) {
            AbstractDirNode dirNode = (AbstractDirNode)node;
            return dirNode.nearest(sSubSubPath, mon);
        }
        return this;
    }

    @Override
    public DasNode get(String sChildId) {
        return this.dSubNodes.get(sChildId);
    }
}

