/*
 * Decompiled with CFR 0.152.
 */
package org.das2.catalog.impl;

import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.das2.catalog.DasDirNode;
import org.das2.catalog.DasProp;
import org.das2.catalog.DasResolveException;
import org.das2.catalog.impl.AbstractDirNode;
import org.das2.catalog.impl.AbstractNode;
import org.das2.catalog.impl.JsonUtil;
import org.das2.catalog.impl.NodeFactory;
import org.das2.util.LoggerManager;
import org.das2.util.monitor.ProgressMonitor;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class CollectionNode
extends AbstractDirNode {
    private static final Logger LOGGER = LoggerManager.getLogger((String)"das2.catalog.collection");
    JSONObject data = null;
    static final String TYPE = "Collection";
    static final String KEY_CATALOG = "sources";
    static final String KEY_TYPE = "type";
    static final String KEY_NAME = "name";
    static final String KEY_URLS = "urls";
    static final String KEY_SEPARATOR = "separator";
    static final String KEY_TITLE = "title";
    static final String KEY_VERSION = "version";
    static final String KEY_SCI_CONTACT = "sci_contacts";
    static final String KEY_UNTIS = "units";
    static final String KEY_CONVETION = "convertion";
    static final String KEY_COORDS = "coordinates";
    static final String KEY_DATA = "data";

    CollectionNode(DasDirNode parent, String name, List<String> lUrls) {
        super(parent, name, lUrls);
    }

    @Override
    public String type() {
        return TYPE;
    }

    @Override
    public boolean isSrc() {
        return false;
    }

    @Override
    public boolean isDir() {
        return true;
    }

    @Override
    public boolean isInfo() {
        return false;
    }

    @Override
    public boolean isLoaded() {
        return this.data != null;
    }

    @Override
    public DasProp prop(String sFragment, Object oDefault) {
        return JsonUtil.prop(this.data, sFragment, oDefault);
    }

    @Override
    public DasProp prop(String sFragment) {
        return JsonUtil.prop(this.data, sFragment);
    }

    protected void initFromJson(JSONObject jo) throws JSONException, ParseException {
        if (!jo.getString(KEY_TYPE).equals(TYPE)) {
            throw new ParseException("Node type missing or not equal to Collection", -1);
        }
        if (jo.has(KEY_CATALOG)) {
            JSONObject cat = jo.getJSONObject(KEY_CATALOG);
            Iterator keys = cat.sortedKeys();
            while (keys.hasNext()) {
                String sChildId = (String)keys.next();
                JSONObject joChild = cat.getJSONObject(sChildId);
                String sChildType = joChild.getString(KEY_TYPE);
                String sChildName = joChild.optString(KEY_NAME, null);
                JSONArray jaLocs = joChild.optJSONArray(KEY_URLS);
                ArrayList<String> lChildLocs = null;
                if (jaLocs != null) {
                    lChildLocs = new ArrayList<String>();
                    for (int i = 0; i < jaLocs.length(); ++i) {
                        lChildLocs.add(jaLocs.getString(i));
                    }
                }
                AbstractNode child = NodeFactory.newNode(sChildType, this, sChildName, lChildLocs);
                this.dSubNodes.put(sChildId, child);
            }
        }
        if (jo.has(KEY_SEPARATOR)) {
            this.sSep = jo.isNull(KEY_SEPARATOR) ? "" : jo.getString("/");
        }
        this.data = jo;
    }

    protected void mergeFromJson(JSONObject jo) throws JSONException, ParseException {
        if (!jo.getString(KEY_TYPE).equals(TYPE)) {
            throw new ParseException("Node type missing or not equal to Collection", -1);
        }
        if (jo.has(KEY_CATALOG)) {
            JSONObject cat = jo.getJSONObject(KEY_CATALOG);
            Iterator keys = cat.sortedKeys();
            while (keys.hasNext()) {
                AbstractNode child;
                String sChildId = (String)keys.next();
                JSONObject joChild = cat.getJSONObject(sChildId);
                String sChildType = joChild.getString(KEY_TYPE);
                String sChildName = joChild.optString(KEY_NAME, null);
                JSONArray jaLocs = joChild.optJSONArray(KEY_URLS);
                ArrayList<String> lChildLocs = null;
                if (jaLocs != null) {
                    lChildLocs = new ArrayList<String>();
                    for (int i = 0; i < jaLocs.length(); ++i) {
                        lChildLocs.add(jaLocs.getString(i));
                    }
                }
                if (!this.dSubNodes.containsKey(sChildName)) {
                    child = NodeFactory.newNode(sChildType, this, sChildName, lChildLocs);
                    this.dSubNodes.put(sChildId, child);
                    continue;
                }
                child = (AbstractNode)this.dSubNodes.get(sChildName);
                for (String sAvail : lChildLocs) {
                    boolean bNewLoc = true;
                    for (AbstractNode.NodeDefLoc has : child.lLocs) {
                        if (!has.sUrl.equals(sAvail)) continue;
                        bNewLoc = false;
                        break;
                    }
                    if (!bNewLoc) continue;
                    child.addLocation(sAvail);
                }
            }
        }
    }

    @Override
    public void load(ProgressMonitor mon) throws DasResolveException {
        for (AbstractNode.NodeDefLoc loc : this.lLocs) {
            loc.bLoaded = false;
            loc.bBad = false;
        }
        for (int i = 0; i < this.lLocs.size(); ++i) {
            AbstractNode.NodeDefLoc loc;
            loc = (AbstractNode.NodeDefLoc)this.lLocs.get(i);
            try {
                String sData = NodeFactory.getUtf8NodeDef(loc.sUrl, mon);
                JSONObject jo = new JSONObject(sData);
                String sVal = jo.getString(KEY_TYPE);
                if (!sVal.equals(this.type())) {
                    throw new DasResolveException("Expected type 'Collection' not '" + sVal + "'", loc.sUrl);
                }
                this.initFromJson(jo);
                loc.bLoaded = true;
                return;
            }
            catch (IOException | ParseException | DasResolveException | JSONException ex) {
                loc.bBad = true;
                LOGGER.log(Level.FINE, "Catalog location {0} marked as bad because {1}", new Object[]{loc.sUrl, ex.getMessage()});
                if (i + 1 != this.lLocs.size()) continue;
                DasResolveException resEx = new DasResolveException("Couldn't load collection node because " + ex.getMessage(), ex, loc.sUrl);
                throw resEx;
            }
        }
    }

    @Override
    boolean merge(ProgressMonitor mon) {
        for (AbstractNode.NodeDefLoc loc : this.lLocs) {
            if (loc.bLoaded || loc.bBad) continue;
            try {
                String sData = NodeFactory.getUtf8NodeDef(loc.sUrl, mon);
                JSONObject jo = new JSONObject(sData);
                this.mergeFromJson(jo);
                loc.bLoaded = true;
                return true;
            }
            catch (IOException | ParseException | JSONException ex) {
                loc.bBad = true;
                LOGGER.log(Level.FINE, "Catalog location {0} marked as bad because {1}", new Object[]{loc.sUrl, ex.getMessage()});
            }
        }
        return false;
    }

    @Override
    void parse(String sData, String sUrl) throws ParseException {
        try {
            JSONObject jo = new JSONObject(sData);
            this.initFromJson(jo);
        }
        catch (JSONException ex) {
            ParseException pe = new ParseException("Error reading node data.", -1);
            pe.initCause(ex);
            throw pe;
        }
        for (AbstractNode.NodeDefLoc loc : this.lLocs) {
            if (!loc.sUrl.equals(sUrl)) continue;
            loc.bLoaded = true;
            return;
        }
        AbstractNode.NodeDefLoc loc = new AbstractNode.NodeDefLoc(sUrl);
        loc.bLoaded = true;
    }
}

