/*
 * Decompiled with CFR 0.152.
 */
package org.das2.catalog.impl;

import java.io.IOException;
import java.text.ParseException;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.das2.catalog.DasDirNode;
import org.das2.catalog.DasProp;
import org.das2.catalog.DasResolveException;
import org.das2.catalog.impl.AbstractNode;
import org.das2.catalog.impl.AbstractSrcNode;
import org.das2.catalog.impl.JsonUtil;
import org.das2.catalog.impl.NodeFactory;
import org.das2.qds.QDataSet;
import org.das2.util.LoggerManager;
import org.das2.util.monitor.ProgressMonitor;
import org.json.JSONException;
import org.json.JSONObject;

public class HttpGetSrcNode
extends AbstractSrcNode {
    private static final Logger LOGGER = LoggerManager.getLogger((String)"das2.catalog.httpsrc");
    JSONObject data = null;
    public static final String TYPE = "HttpStreamSrc";
    static final String KEY_TYPE = "type";
    static final String KEY_NAME = "name";
    static final String KEY_TITLE = "title";
    static final String KEY_VERSION = "version";
    static final String KEY_FORMAT = "format";
    static final String KEY_IFACE = "interface";
    static final String KEY_PROTO = "protocol";
    static final String KEY_AUTH = "authentication";
    static final String KEY_URLS = "base_urls";
    static final String KEY_STYLE = "convertion";
    static final String KEY_EXAMPLES = "examples";
    static final String TECH_CONTACT = "tech_contacts";

    public HttpGetSrcNode(DasDirNode parent, String name, List<String> locations) {
        super(parent, name, locations);
    }

    @Override
    public String type() {
        return TYPE;
    }

    @Override
    public boolean isLoaded() {
        return this.data != null;
    }

    protected void initFromJson(JSONObject jo) throws JSONException, ParseException {
        this.data = jo;
        if (!this.data.getString(KEY_TYPE).equals(TYPE)) {
            throw new ParseException("Node type missing or not equal to HttpStreamSrc", -1);
        }
    }

    @Override
    public DasProp prop(String sFragment, Object oDefault) {
        if (this.isLoaded()) {
            return JsonUtil.prop(this.data, sFragment, oDefault);
        }
        return new DasProp(oDefault);
    }

    @Override
    public DasProp prop(String sFragment) {
        return JsonUtil.prop(this.data, sFragment);
    }

    private void mergeFromJson(JSONObject jo) throws JSONException, ParseException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    void parse(String sData, String sUrl) throws ParseException {
        try {
            JSONObject jo = new JSONObject(sData);
            this.initFromJson(jo);
        }
        catch (JSONException ex) {
            ParseException pe = new ParseException("Error reading node data.", -1);
            pe.initCause(ex);
            throw pe;
        }
        for (AbstractNode.NodeDefLoc loc : this.lLocs) {
            if (!loc.sUrl.equals(sUrl)) continue;
            loc.bLoaded = true;
            return;
        }
        AbstractNode.NodeDefLoc loc = new AbstractNode.NodeDefLoc(sUrl);
        loc.bLoaded = true;
    }

    @Override
    public void load(ProgressMonitor mon) throws DasResolveException {
        for (AbstractNode.NodeDefLoc loc : this.lLocs) {
            loc.bLoaded = false;
            loc.bBad = false;
        }
        for (int i = 0; i < this.lLocs.size(); ++i) {
            AbstractNode.NodeDefLoc loc;
            loc = (AbstractNode.NodeDefLoc)this.lLocs.get(i);
            try {
                String sData = NodeFactory.getUtf8NodeDef(loc.sUrl, mon);
                JSONObject jo = new JSONObject(sData);
                this.initFromJson(jo);
                loc.bLoaded = true;
                return;
            }
            catch (IOException | ParseException | JSONException ex) {
                loc.bBad = true;
                LOGGER.log(Level.FINE, "Catalog location {0} marked as bad because {1}", new Object[]{loc.sUrl, ex.getMessage()});
                if (i + 1 != this.lLocs.size()) continue;
                DasResolveException resEx = new DasResolveException("Couldn't load catalog node because " + ex.getMessage(), ex, loc.sUrl);
                throw resEx;
            }
        }
    }

    @Override
    boolean merge(ProgressMonitor mon) {
        for (AbstractNode.NodeDefLoc loc : this.lLocs) {
            if (loc.bLoaded || loc.bBad) continue;
            try {
                String sData = NodeFactory.getUtf8NodeDef(loc.sUrl, mon);
                JSONObject jo = new JSONObject(sData);
                this.mergeFromJson(jo);
                loc.bLoaded = true;
                return true;
            }
            catch (IOException | ParseException | JSONException ex) {
                loc.bBad = true;
                LOGGER.log(Level.FINE, "Catalog location {0} marked as bad because {1}", new Object[]{loc.sUrl, ex.getMessage()});
            }
        }
        return false;
    }

    @Override
    public QDataSet query(Map<String, String> dQuery) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean queryVerify(Map<String, String> dQuery) {
        return false;
    }
}

