/*
 * Decompiled with CFR 0.152.
 */
package org.das2.catalog.impl;

import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import org.autoplot.datasource.DataSetURI;
import org.das2.catalog.DasDirNode;
import org.das2.catalog.DasNode;
import org.das2.catalog.DasResolveException;
import org.das2.catalog.impl.AbstractDirNode;
import org.das2.catalog.impl.AbstractNode;
import org.das2.catalog.impl.CatalogNode;
import org.das2.catalog.impl.CollectionNode;
import org.das2.catalog.impl.HttpGetSrcNode;
import org.das2.catalog.impl.XmlUtil;
import org.das2.util.FileUtil;
import org.das2.util.LoggerManager;
import org.das2.util.monitor.ProgressMonitor;
import org.json.JSONException;
import org.json.JSONObject;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class NodeFactory {
    private static final Logger LOGGER = LoggerManager.getLogger((String)"das2.catalog");
    private static final Map<String, AbstractNode> ROOT_NODES = Collections.synchronizedMap(new HashMap());
    public static final String DAS_ROOT_PATH = "tag:das2.org,2012:";
    public static final String DEFAULT_DATA_PATH = "tag:das2.org,2012:site";
    public static final String DEFAULT_TEST_PATH = "tag:das2.org,2012:test";

    static AbstractNode newNode(String sType, DasDirNode parent, String sName, List<String> lLocs) throws ParseException {
        switch (sType) {
            case "Catalog": {
                return new CatalogNode(parent, sName, lLocs);
            }
            case "Collection": {
                return new CollectionNode(parent, sName, lLocs);
            }
            case "HttpStreamSrc": {
                return new HttpGetSrcNode(parent, sName, lLocs);
            }
        }
        throw new ParseException("Unknown node type '" + sType + "'.", -1);
    }

    public static String getUtf8NodeDef(String sUrl, ProgressMonitor mon) throws IOException {
        File f = DataSetURI.getFile((String)sUrl, (ProgressMonitor)mon);
        return FileUtil.readFileToString((File)f);
    }

    static DasNode getDetachedRoot(String sUrl, ProgressMonitor mon, boolean bReload) throws ParseException, IOException {
        if (!bReload && ROOT_NODES.containsKey(sUrl)) {
            return ROOT_NODES.get(sUrl);
        }
        String sData = NodeFactory.getUtf8NodeDef(sUrl, mon);
        if (sData.startsWith("{")) {
            AbstractNode node;
            String sType;
            try {
                JSONObject json = new JSONObject(sData);
                sType = json.getString("type");
            }
            catch (JSONException ex) {
                ParseException pe = new ParseException("Error reading " + sUrl + ": " + ex.getMessage(), -1);
                pe.initCause(ex);
                throw pe;
            }
            switch (sType) {
                case "Catalog": {
                    node = new CatalogNode(null, null, null);
                    break;
                }
                case "Collection": {
                    node = new CollectionNode(null, null, null);
                    break;
                }
                case "HttpStreamSrc": {
                    node = new HttpGetSrcNode(null, null, null);
                    break;
                }
                default: {
                    throw new ParseException("Unknown node type '" + sType + "' at " + sUrl + ".", -1);
                }
            }
            node.parse(sData, sUrl);
            ROOT_NODES.put(sUrl, node);
            return node;
        }
        if (sData.startsWith("<?xml")) {
            try {
                Document doc = XmlUtil.getXmlDoc(sData);
                LOGGER.log(Level.FINE, "parsed doc successfully: {0}", doc);
            }
            catch (ParserConfigurationException | SAXException ex) {
                ParseException pe = new ParseException("Error reading " + sUrl + ": " + ex.getMessage(), -1);
                pe.initCause(ex);
                throw pe;
            }
            throw new UnsupportedOperationException("SPASE catalog objects not yet supported");
        }
        throw new ParseException("Couldn't determine node type of document at " + sUrl, -1);
    }

    public static DasNode getNode(String sUrl, ProgressMonitor mon, boolean bReload) throws DasResolveException, IOException, ParseException {
        if (sUrl == null || sUrl.length() == 0) {
            AbstractNode node = ROOT_NODES.get(null);
            if (!node.isLoaded()) {
                node.load(mon);
            }
            return node;
        }
        if (sUrl.startsWith("site") || sUrl.startsWith("test")) {
            sUrl = DAS_ROOT_PATH + sUrl;
        }
        if (sUrl.startsWith("tag:")) {
            AbstractDirNode node = (AbstractDirNode)ROOT_NODES.get(null);
            if (!node.isLoaded()) {
                node.load(mon);
            }
            return node.resolve(sUrl, mon);
        }
        return NodeFactory.getDetachedRoot(sUrl, mon, bReload);
    }

    public static DasNode getNearestNode(String sUrl, ProgressMonitor mon, boolean bReload) throws DasResolveException {
        if (sUrl != null && sUrl.length() > 5) {
            String[] aFileSysPrefixes;
            for (String sPrefix : aFileSysPrefixes = new String[]{"file:", "http:", "https:", "ftp:"}) {
                if (!sUrl.toLowerCase().startsWith(sPrefix)) continue;
                try {
                    DasNode node = NodeFactory.getNode(sUrl, mon, bReload);
                    return node;
                }
                catch (IOException | ParseException ex) {
                    DasResolveException re = new DasResolveException("Could not resolve URL to node", sUrl);
                    re.initCause(ex);
                    throw re;
                }
            }
        }
        try {
            DasNode node = NodeFactory.getNode(sUrl, mon, bReload);
            return node;
        }
        catch (IOException | ParseException | DasResolveException ex) {
            LOGGER.log(Level.FINE, "Exact resolution of {0} failed due to {1}, looking for longest resolvable path", new Object[]{sUrl, ex.getMessage()});
            AbstractDirNode root = (AbstractDirNode)ROOT_NODES.get(null);
            if (!root.isLoaded()) {
                try {
                    root.load(mon);
                }
                catch (DasResolveException ex2) {
                    LOGGER.log(Level.INFO, "Root node could not be resolved tried {0}", root.prettyPrintLoc(null, " "));
                }
            }
            if (sUrl == null || sUrl.length() == 0) {
                return root;
            }
            if (sUrl.startsWith("site") || sUrl.startsWith("test")) {
                sUrl = DAS_ROOT_PATH + sUrl;
            }
            return root.nearest(sUrl, mon);
        }
    }

    static {
        ArrayList<String> lUrls = new ArrayList<String>();
        lUrls.add("http://das2.org/catalog/index.json");
        lUrls.add("https://raw.githubusercontent.com/das-developers/das-cat/master/cat/index.json");
        ROOT_NODES.put(null, new CatalogNode(null, null, lUrls));
    }
}

