/*
 * Decompiled with CFR 0.152.
 */
package org.das2.catalog;

import java.text.ParseException;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;
import org.das2.datum.Datum;
import org.das2.datum.TimeUtil;

public class DasProp {
    private static final ZoneOffset UTC_ZONE = ZoneOffset.UTC;
    public static final Type NULL = Type.NULL;
    public static final Type BOOL = Type.BOOL;
    public static final int STR = 20;
    public static final int INT = 30;
    public static final int DATUM = 40;
    public static final int TIME = 50;
    public static final int LIST = 60;
    public static final int MAP = 70;
    protected Object obj;
    protected Type type;

    public DasProp(Object item) {
        if (item == null) {
            this.type = Type.NULL;
            this.obj = null;
            return;
        }
        if (item instanceof String) {
            this.type = Type.STR;
            this.obj = item;
            return;
        }
        if (item instanceof Integer) {
            this.type = Type.LONG;
            this.obj = new Long(((Integer)item).intValue());
            return;
        }
        if (item instanceof Long) {
            this.type = Type.LONG;
            this.obj = item;
            return;
        }
        if (item instanceof Float) {
            this.type = Type.DOUBLE;
            this.obj = new Double(((Float)item).floatValue());
            return;
        }
        if (item instanceof Double) {
            this.type = Type.DOUBLE;
            this.obj = item;
            return;
        }
        if (item instanceof Datum) {
            this.type = Type.DATUM;
            this.obj = item;
            return;
        }
        if (item instanceof Double) {
            this.type = Type.DATUM;
            this.obj = Datum.create((double)((Double)item));
            return;
        }
        try {
            List list = (List)item;
            this.type = Type.LIST;
            this.obj = list;
        }
        catch (ClassCastException e1) {
            try {
                Map map = (Map)item;
                this.type = Type.MAP;
                this.obj = map;
            }
            catch (ClassCastException e2) {
                throw new IllegalArgumentException("Object " + item.toString() + "cannot be wrapped as a Das Catalog Property");
            }
        }
    }

    public String str() {
        if (this.obj == null) {
            return null;
        }
        return this.obj.toString();
    }

    public ZonedDateTime time() throws ParseException {
        TimeUtil.TimeStruct ts = TimeUtil.parseTime((String)this.obj.toString());
        int nSec = (int)ts.seconds;
        int nNano = (int)((ts.seconds - (double)nSec) * 1.0E9);
        ZonedDateTime zdt = ZonedDateTime.of(ts.year, ts.month, ts.day, ts.hour, ts.minute, nSec, nNano, UTC_ZONE);
        return zdt;
    }

    public List<String> list() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Map<String, DasProp> map() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public DasProp map(String sKey) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    Datum datum() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public static enum Type {
        NULL,
        BOOL,
        STR,
        LONG,
        DOUBLE,
        DATUM,
        TIME,
        LIST,
        MAP;

    }
}

