/*
 * Decompiled with CFR 0.152.
 */
package org.das2.catalog.impl;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.das2.catalog.DasDirNode;
import org.das2.catalog.DasNode;
import org.das2.util.LoggerManager;
import org.das2.util.monitor.ProgressMonitor;

public abstract class AbstractNode
implements DasNode {
    private static final Logger LOGGER = LoggerManager.getLogger((String)"das2.catalog.adsnode");
    protected String sName;
    protected DasDirNode parent;
    protected List<NodeDefLoc> lLocs;

    AbstractNode(DasDirNode parent, String name, List<String> lUrls) {
        this.parent = parent;
        this.sName = name;
        this.lLocs = new ArrayList<NodeDefLoc>();
        if (lUrls != null) {
            for (String sLoc : lUrls) {
                this.lLocs.add(new NodeDefLoc(sLoc));
            }
        }
    }

    @Override
    public String name() {
        return this.sName;
    }

    @Override
    public String path() {
        if (this.parent != null) {
            return this.parent.childPath(this);
        }
        return null;
    }

    @Override
    public String toString() {
        String sType = this.type();
        if (this.isRoot()) {
            return sType + " [root]";
        }
        String sPath = this.parent.childPath(this);
        return sType + " @ " + sPath;
    }

    void addLocation(String sUrl) {
        this.lLocs.add(new NodeDefLoc(sUrl));
    }

    public String prettyPrintLoc(String sPre, String sSep) {
        StringBuilder bldr = new StringBuilder();
        for (int i = 0; i < this.lLocs.size(); ++i) {
            if (i > 0 && sSep != null) {
                bldr.append(sSep);
            }
            if (sPre != null) {
                bldr.append(sPre);
            }
            bldr.append(this.lLocs.get(i));
        }
        return bldr.toString();
    }

    boolean canMerge() {
        for (NodeDefLoc loc : this.lLocs) {
            if (loc.bLoaded || loc.bBad) continue;
            return true;
        }
        return false;
    }

    abstract boolean merge(ProgressMonitor var1);

    @Override
    public boolean isRoot() {
        return this.parent == null;
    }

    @Override
    public DasNode getRoot() {
        if (this.parent == null) {
            return this;
        }
        return this.parent.getRoot();
    }

    abstract void parse(String var1, String var2) throws ParseException;

    class NodeDefLoc {
        String sUrl;
        boolean bLoaded = false;
        boolean bBad = false;

        NodeDefLoc(String _sUrl) {
            this.sUrl = _sUrl;
        }

        public String toString() {
            if (this.bLoaded) {
                return this.sUrl + " [loaded]";
            }
            if (this.bBad) {
                return this.sUrl + " [load error]";
            }
            return this.sUrl + " [unused]";
        }
    }
}

