/*
 * Decompiled with CFR 0.152.
 */
package org.das2.catalog.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import org.das2.catalog.DasProp;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class JsonUtil {
    private static final DasProp nullProp = new DasProp(null);

    JsonUtil() {
    }

    private static DasProp JdoToProp(Object obj) {
        String sType;
        switch (sType = obj.getClass().getSimpleName()) {
            case "Boolean": 
            case "Integer": 
            case "Long": 
            case "Float": 
            case "Double": 
            case "String": {
                return new DasProp(obj);
            }
        }
        if (sType.equals("JSONArray")) {
            JSONArray ja = (JSONArray)obj;
            ArrayList<DasProp> list = new ArrayList<DasProp>();
            for (int i = 0; i < ja.length(); ++i) {
                DasProp subProp;
                if (ja.isNull(i)) {
                    subProp = new DasProp(null);
                } else {
                    try {
                        subProp = JsonUtil.JdoToProp(ja.get(i));
                    }
                    catch (JSONException ex) {
                        throw new AssertionError((Object)"Do you have a thread sync problem? (JSONArray)");
                    }
                }
                list.add(subProp);
            }
            return new DasProp(list);
        }
        if (sType.equals("JSONObject")) {
            JSONObject jo = (JSONObject)obj;
            JSONArray ja = jo.names();
            HashMap<String, DasProp> map = new HashMap<String, DasProp>();
            for (int i = 0; i < ja.length(); ++i) {
                DasProp subProp;
                String sKey;
                try {
                    sKey = ja.getString(i);
                    subProp = jo.isNull(sKey) ? new DasProp(null) : JsonUtil.JdoToProp(jo.get(sKey));
                }
                catch (JSONException ex) {
                    throw new AssertionError((Object)"Do you have a thread sync problem? (JSONobject)");
                }
                map.put(sKey, subProp);
            }
            return new DasProp(map);
        }
        throw new UnsupportedOperationException("Conversion for org.json type " + sType + " not supported yet.");
    }

    private static DasProp propAtPath(Object data, String[] aFragPath) {
        if (data instanceof JSONObject) {
            Object item;
            JSONObject jo = (JSONObject)data;
            if (!jo.has(aFragPath[0])) {
                return nullProp;
            }
            if (jo.isNull(aFragPath[0])) {
                return new DasProp(null);
            }
            try {
                item = jo.get(aFragPath[0]);
            }
            catch (JSONException ex) {
                return nullProp;
            }
            if (aFragPath.length == 1) {
                return JsonUtil.JdoToProp(item);
            }
            return JsonUtil.propAtPath(item, Arrays.copyOfRange(aFragPath, 1, aFragPath.length));
        }
        if (data instanceof JSONArray) {
            Object item;
            JSONArray ja = (JSONArray)data;
            int i = Integer.parseInt(aFragPath[0]);
            if (i < 0 || i >= ja.length()) {
                return nullProp;
            }
            if (ja.isNull(i)) {
                return new DasProp(null);
            }
            try {
                item = ja.get(i);
            }
            catch (JSONException ex) {
                return nullProp;
            }
            if (aFragPath.length == 1) {
                return JsonUtil.JdoToProp(item);
            }
            return JsonUtil.propAtPath(item, Arrays.copyOfRange(aFragPath, 1, aFragPath.length));
        }
        return nullProp;
    }

    public static DasProp prop(Object data, String sFragment) {
        String sTmp = sFragment.replaceAll("^/+", "").replaceAll("/+$", "");
        String[] aFragPath = sTmp.split("/+");
        if (aFragPath.length == 0) {
            return nullProp;
        }
        return JsonUtil.propAtPath(data, aFragPath);
    }

    public static DasProp prop(Object data, String sFragment, Object oDefault) {
        DasProp prop = JsonUtil.prop(data, sFragment);
        if (prop == null) {
            return new DasProp(oDefault);
        }
        return prop;
    }
}

