/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.fits;

import java.net.URI;
import java.text.ParseException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import org.autoplot.datasource.AbstractDataSource;
import org.autoplot.datasource.MetadataModel;
import org.autoplot.fits.FitsDataSourceFactory;
import org.autoplot.fits.FitsMetadataModel;
import org.das2.datum.Units;
import org.das2.qds.AbstractDataSet;
import org.das2.qds.DataSetOps;
import org.das2.qds.DataSetUtil;
import org.das2.qds.FDataSet;
import org.das2.qds.MutablePropertyDataSet;
import org.das2.qds.QDataSet;
import org.das2.qds.ops.Ops;
import org.das2.util.monitor.ProgressMonitor;
import org.eso.fits.FitsColumn;
import org.eso.fits.FitsData;
import org.eso.fits.FitsFile;
import org.eso.fits.FitsHDUnit;
import org.eso.fits.FitsKeyword;
import org.eso.fits.FitsMatrix;
import org.eso.fits.FitsTable;

public class FitsDataSource
extends AbstractDataSource {
    FitsDataSource(URI uri) {
        super(uri);
    }

    public QDataSet getDataSet(ProgressMonitor mon) throws Exception {
        FitsFile file;
        FitsHDUnit hdu;
        FitsData fd;
        int ihdu = 0;
        Map<String, Integer> plottable = FitsDataSourceFactory.getPlottable(this.resourceURI, mon);
        String name = (String)this.getParams().get("arg_0");
        if (name != null) {
            ihdu = plottable.get(name);
        }
        if (ihdu == 0 && !plottable.containsValue(0) && plottable.size() > 0) {
            ihdu = plottable.values().iterator().next();
        }
        if ((fd = (hdu = (file = new FitsFile(this.getFile(mon))).getHDUnit(ihdu)).getData()) instanceof FitsMatrix) {
            FitsMatrix dm = (FitsMatrix)fd;
            int[] naxis = dm.getNaxis();
            double[] crval = dm.getCrval();
            double[] crpix = dm.getCrpix();
            double[] cdelt = dm.getCdelt();
            float[] fdata = new float[dm.getNoValues()];
            dm.getFloatValues(0, dm.getNoValues(), fdata);
            if (naxis.length == 3) {
                naxis = new int[]{naxis[2], naxis[0], naxis[1]};
                crval = new double[]{crval[2], crval[1], crval[0]};
                crpix = new double[]{crpix[2], crpix[1], crpix[0]};
                cdelt = new double[]{cdelt[2], cdelt[1], cdelt[0]};
            } else if (naxis.length == 2) {
                naxis = new int[]{naxis[1], naxis[0]};
                crval = new double[]{crval[1], crval[0]};
                crpix = new double[]{crpix[1], crpix[0]};
                cdelt = new double[]{cdelt[1], cdelt[0]};
            } else if (naxis.length == 0) {
                throw new IllegalArgumentException("Unable to use fits file");
            }
            FDataSet result = FDataSet.wrap((float[])fdata, (int[])naxis);
            int rank = result.rank();
            if (rank == 2) {
                MutablePropertyDataSet xx = DataSetUtil.tagGenDataSet((int)naxis[0], (double)(crval[0] - cdelt[0] * crpix[0]), (double)cdelt[0]);
                xx.putProperty("NAME", (Object)"axis0");
                result.putProperty("DEPEND_0", (Object)xx);
                xx = DataSetUtil.tagGenDataSet((int)naxis[1], (double)(crval[1] - cdelt[1] * crpix[1]), (double)cdelt[1]);
                xx.putProperty("NAME", (Object)"axis1");
                result.putProperty("DEPEND_1", (Object)xx);
                return DataSetOps.transpose2((QDataSet)result);
            }
            MutablePropertyDataSet xx = DataSetUtil.tagGenDataSet((int)naxis[2], (double)(crval[1] - cdelt[0] * crpix[0]), (double)cdelt[0]);
            xx.putProperty("NAME", (Object)"axis0");
            result.putProperty("DEPEND_2", (Object)xx);
            xx = DataSetUtil.tagGenDataSet((int)naxis[1], (double)(crval[1] - cdelt[1] * crpix[1]), (double)cdelt[1]);
            xx.putProperty("NAME", (Object)"axis1");
            result.putProperty("DEPEND_1", (Object)xx);
            xx = DataSetUtil.indexGenDataSet((int)naxis[0]);
            xx.putProperty("NAME", (Object)"bundle");
            result.putProperty("DEPEND_0", (Object)xx);
            return result;
        }
        if (fd instanceof FitsTable) {
            MutablePropertyDataSet mpds;
            FitsTable ft = (FitsTable)fd;
            if (ft.getNoColumns() == 2) {
                mpds = this.adaptColumn(ft.getColumn(1), ft.getNoRows());
                mpds.putProperty("QUBE", (Object)Boolean.TRUE);
                mpds.putProperty("NAME", (Object)Ops.safeName((String)ft.getColumn(1).getLabel()));
                MutablePropertyDataSet dep0 = this.adaptColumn(ft.getColumn(0), ft.getNoRows());
                dep0.putProperty("NAME", (Object)Ops.safeName((String)ft.getColumn(0).getLabel()));
                mpds.putProperty("DEPEND_0", (Object)Ops.copy((QDataSet)dep0));
            } else {
                mpds = this.adaptColumn(ft.getColumn(0), ft.getNoRows());
                mpds.putProperty("NAME", (Object)Ops.safeName((String)ft.getColumn(0).getLabel()));
            }
            return Ops.copy((QDataSet)mpds);
        }
        throw new IllegalArgumentException("fitsdata type not supported: " + fd.getClass());
    }

    private MutablePropertyDataSet adaptColumn(final FitsColumn fc, final int len0) {
        String fcunit;
        final int rank = fc.getRepeat() == 1 ? 1 : 2;
        final int len1 = fc.getRepeat();
        AbstractDataSet result = new AbstractDataSet(){

            public int rank() {
                return rank;
            }

            public double value(int i0) {
                return fc.getReal(i0);
            }

            public double value(int i0, int i1) {
                double[] dd = fc.getReals(i0);
                return dd[i1];
            }

            public int length() {
                return len0;
            }

            public int length(int i0) {
                return len1;
            }
        };
        String string = fcunit = fc.getUnit() != null ? fc.getUnit() : "";
        if ("s".equals(fcunit)) {
            try {
                result.putProperty("UNITS", (Object)Units.lookupTimeUnits((String)"seconds since 2000-01-01T00:00Z"));
            }
            catch (ParseException ex) {
                logger.log(Level.SEVERE, null, ex);
            }
        } else {
            result.putProperty("UNITS", (Object)Units.lookupUnits((String)fcunit));
        }
        return result;
    }

    public Map<String, Object> getMetadata(ProgressMonitor mon) throws Exception {
        int ihdu = 0;
        Map<String, Integer> plottable = FitsDataSourceFactory.getPlottable(this.uri, mon);
        String name = (String)this.getParams().get("arg_0");
        if (name != null) {
            ihdu = plottable.get(name);
        }
        FitsFile file = new FitsFile(this.getFile(mon));
        FitsHDUnit hdu = file.getHDUnit(ihdu);
        HashMap<String, Object> meta = new HashMap<String, Object>();
        Enumeration e = hdu.getHeader().getKeywords();
        while (e.hasMoreElements()) {
            Object val;
            FitsKeyword key = (FitsKeyword)e.nextElement();
            switch (key.getType()) {
                case 3: {
                    val = key.getBool();
                    break;
                }
                case 1: {
                    val = key.getComment();
                    break;
                }
                case 6: {
                    val = key.getDate();
                    break;
                }
                case 4: {
                    val = key.getInt();
                    break;
                }
                case 0: {
                    val = "NONE";
                    break;
                }
                case 5: {
                    val = key.getReal();
                    break;
                }
                case 2: {
                    val = key.getString();
                    break;
                }
                default: {
                    val = "????";
                }
            }
            meta.put(key.getName(), val);
        }
        return meta;
    }

    public MetadataModel getMetadataModel() {
        return new FitsMetadataModel();
    }
}

