/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.autoplot.hapi;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JPanel;
import org.autoplot.datasource.DataSourceFormatEditorPanel;
import org.autoplot.datasource.URISplit;

/**
 *
 * @author jbf
 */
public class HapiDataSourceFormatEditorPanel extends javax.swing.JPanel implements DataSourceFormatEditorPanel  {

    /**
     * Creates new form HapiDataSourceFormatEditorPanel
     */
    public HapiDataSourceFormatEditorPanel() {
        initComponents();
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jLabel1 = new javax.swing.JLabel();
        idTextField = new javax.swing.JTextField();
        jLabel2 = new javax.swing.JLabel();
        hapiRootTextField = new javax.swing.JTextField();
        jLabel3 = new javax.swing.JLabel();

        jLabel1.setText("id, an identifier for the data source:");

        idTextField.setText("data");

        jLabel2.setText("HAPI root:");

        hapiRootTextField.setText("/home/jbf/hapi2.hapi");

        jLabel3.setText("<html>Export data to the Autoplot-based HAPI server configured at the given root.  Note the .hapi extension will be converted to /hapi.  It should also be noted that these files are for reference only, and will not support HAPI without additional human effort.");

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(jLabel3, javax.swing.GroupLayout.PREFERRED_SIZE, 0, Short.MAX_VALUE)
                        .addContainerGap())
                    .addGroup(layout.createSequentialGroup()
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(jLabel2)
                            .addComponent(jLabel1))
                        .addGap(0, 274, Short.MAX_VALUE))
                    .addGroup(layout.createSequentialGroup()
                        .addGap(12, 12, 12)
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(hapiRootTextField)
                            .addComponent(idTextField)))))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jLabel3, javax.swing.GroupLayout.PREFERRED_SIZE, 66, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jLabel2, javax.swing.GroupLayout.PREFERRED_SIZE, 15, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(hapiRootTextField, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jLabel1)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(idTextField, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addContainerGap(78, Short.MAX_VALUE))
        );
    }// </editor-fold>//GEN-END:initComponents

    @Override
    public JPanel getPanel() {
        return this;
    }

    @Override
    public void setURI(String uri) {
        URISplit split= URISplit.parse(uri);
        Map<String,String> params= URISplit.parseParams(split.params);
        File hapiDir= new File( split.resourceUri );
        this.hapiRootTextField.setText( hapiDir.toString() );
        String id= params.get("id");
        if ( id==null ) id= "data";
        this.idTextField.setText( id );
    }

    @Override
    public String getURI() {
        Map<String,String> args= new HashMap<>();
        args.put( "id", this.idTextField.getText() );
        
        String params= URISplit.formatParams(args);
        
        URISplit ss= URISplit.parse( "file://"+hapiRootTextField.getText() );
        if ( params.length()>0 ) {
            ss.params= params;
        }
        return URISplit.format( ss );
    }


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JTextField hapiRootTextField;
    private javax.swing.JTextField idTextField;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel3;
    // End of variables declaration//GEN-END:variables
}
