/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.netCDF;

import java.awt.Dimension;
import java.awt.Window;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.autoplot.datasource.DataSetURI;
import org.autoplot.datasource.DataSourceEditorPanel;
import org.autoplot.datasource.URISplit;
import org.autoplot.netCDF.NetCDFDataSourceFactory;
import org.das2.util.DasExceptionHandler;
import org.das2.util.LoggerManager;
import org.das2.util.filesystem.FileSystem;
import org.das2.util.monitor.NullProgressMonitor;
import org.das2.util.monitor.ProgressMonitor;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.ELProperty;
import org.jdesktop.beansbinding.Property;
import ucar.ma2.DataType;
import ucar.nc2.Attribute;
import ucar.nc2.AttributeContainer;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.NetcdfDatasets;

public class HDF5DataSourceEditorPanel
extends JPanel
implements DataSourceEditorPanel {
    private String vapScheme;
    Map<String, String> allParameterInfo;
    private JPanel advancedPanel;
    private JLabel jLabel5;
    private JPanel jPanel1;
    private JPanel jPanel3;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane3;
    private JScrollPane jScrollPane4;
    private JSplitPane jSplitPane1;
    private JSplitPane jSplitPane2;
    private JTabbedPane jTabbedPane1;
    private JLabel parameterInfoLabel;
    private JTree parameterTree;
    private JComboBox subsetComboBox;
    private JCheckBox whereCB;
    private JComboBox whereOp;
    private JComboBox whereParamList;
    private JTextField whereTF;
    private JCheckBox xCheckBox;
    private JTree xParameterTree;
    private JCheckBox yCheckBox;
    private JTree yParameterTree;
    private BindingGroup bindingGroup;
    private static final Logger logger = LoggerManager.getLogger((String)"apdss.hdf5");
    URISplit split;
    Map<String, String> params;
    Map<String, String> parameters = new LinkedHashMap<String, String>();
    String parameter;
    List<Variable> vars;

    public HDF5DataSourceEditorPanel() {
        this.initComponents();
    }

    private void initComponents() {
        this.bindingGroup = new BindingGroup();
        this.jSplitPane2 = new JSplitPane();
        this.jSplitPane1 = new JSplitPane();
        this.advancedPanel = new JPanel();
        this.jLabel5 = new JLabel();
        this.subsetComboBox = new JComboBox();
        this.whereCB = new JCheckBox();
        this.whereParamList = new JComboBox();
        this.whereOp = new JComboBox();
        this.whereTF = new JTextField();
        this.jTabbedPane1 = new JTabbedPane();
        this.jScrollPane1 = new JScrollPane();
        this.parameterTree = new JTree();
        this.jPanel1 = new JPanel();
        this.jScrollPane3 = new JScrollPane();
        this.xParameterTree = new JTree();
        this.xCheckBox = new JCheckBox();
        this.jPanel3 = new JPanel();
        this.jScrollPane4 = new JScrollPane();
        this.yParameterTree = new JTree();
        this.yCheckBox = new JCheckBox();
        this.parameterInfoLabel = new JLabel();
        this.jSplitPane2.setOrientation(0);
        this.jSplitPane2.setResizeWeight(0.5);
        this.advancedPanel.setBorder(BorderFactory.createTitledBorder("Advanced"));
        this.advancedPanel.setMaximumSize(new Dimension(285, Short.MAX_VALUE));
        this.jLabel5.setText("Load subset of the data:");
        this.jLabel5.setToolTipText("<html>Load a subset of the data records, for example:<br>[0:100]  first 100 records<br> [-100:] last 100 records<br> [::10] every tenth record<br> </html>");
        this.subsetComboBox.setEditable(true);
        this.subsetComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"", "::10", "0:100", "-100:", "0:10000:5"}));
        this.subsetComboBox.setToolTipText("<html>Load a subset of the data records, for example:<br>[0:100]  first 100 records<br> [-100:] last 100 records<br> [::10] every tenth record<br> </html>");
        this.whereCB.setText("Only load data where:");
        this.whereCB.setToolTipText("return only the records where the condition is true");
        this.whereParamList.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        AutoBinding binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.whereCB, (Property)ELProperty.create((String)"${selected}"), (Object)this.whereParamList, (Property)BeanProperty.create((String)"enabled"));
        this.bindingGroup.addBinding((Binding)binding);
        this.whereOp.setModel(new DefaultComboBoxModel<String>(new String[]{".eq", ".gt", ".lt", ".ne", ".within"}));
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.whereCB, (Property)ELProperty.create((String)"${selected}"), (Object)this.whereOp, (Property)BeanProperty.create((String)"enabled"));
        this.bindingGroup.addBinding((Binding)binding);
        this.whereTF.setText("0");
        this.whereTF.setToolTipText("enter the value, or \"mode\" for the most frequently occuring value.");
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.whereCB, (Property)ELProperty.create((String)"${selected}"), (Object)this.whereTF, (Property)BeanProperty.create((String)"enabled"));
        this.bindingGroup.addBinding((Binding)binding);
        GroupLayout advancedPanelLayout = new GroupLayout(this.advancedPanel);
        this.advancedPanel.setLayout(advancedPanelLayout);
        advancedPanelLayout.setHorizontalGroup(advancedPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(advancedPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.whereParamList, 0, 161, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.whereOp, -2, 84, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.whereTF, -2, 53, -2)).addGroup(advancedPanelLayout.createSequentialGroup().addGroup(advancedPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel5).addComponent(this.whereCB).addGroup(advancedPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.subsetComboBox, -2, 175, -2))).addGap(0, 135, Short.MAX_VALUE)));
        advancedPanelLayout.setVerticalGroup(advancedPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(advancedPanelLayout.createSequentialGroup().addComponent(this.jLabel5).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.subsetComboBox, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.whereCB).addGap(8, 8, 8).addGroup(advancedPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.whereParamList, -2, -1, -2).addComponent(this.whereOp, -2, -1, -2).addComponent(this.whereTF, -2, -1, -2)).addContainerGap(245, Short.MAX_VALUE)));
        this.jSplitPane1.setRightComponent(this.advancedPanel);
        this.jTabbedPane1.setToolTipText("\"plot\" selects the dependent parameter for plotting.  \"x\" allows specification of an independent parameter upon which the \"plot\" parameter depends.");
        this.jTabbedPane1.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                HDF5DataSourceEditorPanel.this.jTabbedPane1StateChanged(evt);
            }
        });
        this.parameterTree.setRootVisible(false);
        this.parameterTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent evt) {
                HDF5DataSourceEditorPanel.this.parameterTreeValueChanged(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.parameterTree);
        this.jTabbedPane1.addTab("select variable", this.jScrollPane1);
        this.xParameterTree.setRootVisible(false);
        this.xParameterTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent evt) {
                HDF5DataSourceEditorPanel.this.xParameterTreeValueChanged(evt);
            }
        });
        this.jScrollPane3.setViewportView(this.xParameterTree);
        this.xCheckBox.setText("Set Variable for X");
        this.xCheckBox.setToolTipText("Specify the parameter to use for the X tags, overriding any settings found in the file.\n");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane3).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.xCheckBox).addContainerGap(196, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.xCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane3, -1, 338, Short.MAX_VALUE)));
        this.jTabbedPane1.addTab("X", this.jPanel1);
        this.jPanel3.setAlignmentX(0.0f);
        this.yParameterTree.setRootVisible(false);
        this.yParameterTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent evt) {
                HDF5DataSourceEditorPanel.this.yParameterTreeValueChanged(evt);
            }
        });
        this.jScrollPane4.setViewportView(this.yParameterTree);
        this.yCheckBox.setText("Set Variable for Y");
        this.yCheckBox.setToolTipText("Specify the parameter to use for the X tags, overriding any settings found in the file. ");
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane4).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addComponent(this.yCheckBox).addGap(0, 196, Short.MAX_VALUE)));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.yCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane4, -1, 338, Short.MAX_VALUE)));
        this.jTabbedPane1.addTab("Y", this.jPanel3);
        this.jSplitPane1.setLeftComponent(this.jTabbedPane1);
        this.jSplitPane2.setTopComponent(this.jSplitPane1);
        this.parameterInfoLabel.setText("jLabel1");
        this.parameterInfoLabel.setVerticalAlignment(1);
        this.parameterInfoLabel.setMinimumSize(new Dimension(49, 100));
        this.jSplitPane2.setRightComponent(this.parameterInfoLabel);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSplitPane2));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSplitPane2, GroupLayout.Alignment.TRAILING, -1, 505, Short.MAX_VALUE));
        this.bindingGroup.bind();
    }

    private void parameterTreeValueChanged(TreeSelectionEvent evt) {
        TreePath tp = evt.getPath();
        this.parameter = String.valueOf(tp.getPathComponent(1));
        String longName = this.parameters.get(this.parameter);
        int ibr = longName.indexOf("<br>");
        String longNameSansDescription = ibr > -1 ? longName.substring(0, ibr) : longName;
        this.parameterInfoLabel.setText("<html>" + longName + "<br><em>" + this.allParameterInfo.get(this.parameter) + "</em>");
        String dims = longNameSansDescription.substring(this.parameter.length());
        ArrayList<String> varnames = new ArrayList<String>();
        for (Map.Entry<String, String> ps : this.parameters.entrySet()) {
            String v = ps.getValue();
            int i = v.indexOf("[");
            String vdims = v.substring(i, v.length() - 1);
            if ((i = vdims.indexOf("]")) > -1) {
                vdims = vdims.substring(0, i + 1);
            }
            if (!vdims.startsWith(dims)) continue;
            varnames.add(ps.getKey());
        }
        Object item = this.whereParamList.getSelectedItem();
        this.whereParamList.setModel(new DefaultComboBoxModel<Object>(varnames.toArray()));
        if (item != null) {
            this.whereParamList.setSelectedItem(item);
        }
    }

    private void xParameterTreeValueChanged(TreeSelectionEvent evt) {
        this.xCheckBox.setSelected(true);
        this.updateMetadata(1);
    }

    private void yParameterTreeValueChanged(TreeSelectionEvent evt) {
        this.yCheckBox.setSelected(true);
        this.updateMetadata(2);
    }

    private void jTabbedPane1StateChanged(ChangeEvent evt) {
        int tab = this.jTabbedPane1.getSelectedIndex();
        this.updateMetadata(tab);
    }

    private void updateMetadata(int tab) {
        switch (tab) {
            case 0: {
                if (this.parameter == null) break;
                String longName = "<html>" + this.parameters.get(this.parameter) + "<br><em>" + this.allParameterInfo.get(this.parameter) + "</em>";
                this.parameterInfoLabel.setText(longName);
                break;
            }
            case 1: {
                String xparameter;
                TreePath tp = this.xParameterTree.getSelectionPath();
                if (tp == null || (xparameter = String.valueOf(tp.getPathComponent(1))) == null) break;
                String longName = "<html>" + this.parameters.get(xparameter) + "<br><em>" + this.allParameterInfo.get(xparameter) + "</em>";
                this.parameterInfoLabel.setText(longName);
                break;
            }
            case 2: {
                String yparameter;
                TreePath tp = this.yParameterTree.getSelectionPath();
                if (tp == null || (yparameter = String.valueOf(tp.getPathComponent(1))) == null) break;
                String longName = "<html>" + this.parameters.get(yparameter) + "<br><em>" + this.allParameterInfo.get(yparameter) + "</em>";
                this.parameterInfoLabel.setText(longName);
                break;
            }
        }
    }

    public boolean reject(String uri) throws Exception {
        this.split = URISplit.parse((String)uri);
        if (this.split.resourceUri == null) {
            return true;
        }
        FileSystem fs = FileSystem.create((URI)DataSetURI.toUri((String)this.split.path));
        return fs.isDirectory(this.split.file.substring(this.split.path.length()));
    }

    public boolean prepare(String uri, Window parent, ProgressMonitor mon) throws Exception {
        this.split = URISplit.parse((String)uri);
        File cdfFile = DataSetURI.getFile((URI)this.split.resourceUri, (ProgressMonitor)mon);
        DataSetURI.checkLength((File)cdfFile);
        return true;
    }

    private void fillTree(JTree parameterTree, Map<String, String> mm, String param) {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode("");
        ArrayList expand = new ArrayList(mm.size());
        TreePath selection = null;
        for (Map.Entry<String, String> e : mm.entrySet()) {
            try {
                DefaultMutableTreeNode node = new DefaultMutableTreeNode(e.getKey());
                root.add(node);
                if (!e.getKey().equals(param)) continue;
                selection = new TreePath(new Object[]{root, node});
            }
            catch (Exception t) {
                logger.log(Level.WARNING, t.getMessage(), t);
            }
        }
        DefaultTreeModel tm = new DefaultTreeModel(root);
        parameterTree.setModel(tm);
        if (selection != null) {
            parameterTree.setSelectionPath(selection);
            parameterTree.scrollPathToVisible(selection);
        }
        for (TreePath tp : expand) {
            parameterTree.expandPath(tp);
        }
    }

    public void setURI(String uri) {
        this.split = URISplit.parse((String)uri);
        this.vapScheme = this.split.vapScheme;
        this.params = URISplit.parseParams((String)this.split.params);
        try {
            int i;
            File cdfFile = DataSetURI.getFile((URI)this.split.resourceUri, (ProgressMonitor)new NullProgressMonitor());
            String fileName = cdfFile.toString();
            logger.log(Level.FINE, "opening cdf file {0}", fileName);
            String resource = fileName;
            NetCDFDataSourceFactory.checkMatlab(resource);
            try (NetcdfDataset dataset = NetcdfDatasets.openDataset((String)resource);){
                this.vars = dataset.getVariables();
            }
            this.allParameterInfo = new LinkedHashMap<String, String>(this.vars.size());
            for (Variable v : this.vars) {
                if (v.getDimensions().isEmpty()) continue;
                String name = v.getFullName();
                if (v instanceof Structure) {
                    for (Variable v2 : ((Structure)v).getVariables()) {
                        if (!v2.getDataType().isNumeric()) continue;
                        String v2name = v2.getFullName();
                        StringBuilder description = new StringBuilder(v2name + "[");
                        for (int k = 0; k < v2.getDimensions().size(); ++k) {
                            ucar.nc2.Dimension d = v2.getDimension(k);
                            if (k > 0) {
                                description.append(",");
                            }
                            String n = d.getName();
                            if (n != null && !n.equals(v2name)) {
                                description.append(d.getName()).append("=");
                            }
                            description.append(d.getLength());
                            continue;
                        }
                        description.append("]");
                        this.parameters.put(v2name, description.toString());
                    }
                } else {
                    boolean isFormattedStringsOrTime;
                    boolean bl = isFormattedStringsOrTime = v.getDataType() == DataType.CHAR && v.getRank() == 2;
                    if (isFormattedStringsOrTime) {
                        logger.log(Level.FINE, "detected formatted time: {0}", name);
                    }
                    if (!isFormattedStringsOrTime && !v.getDataType().isNumeric()) continue;
                    StringBuilder description = new StringBuilder(v.getFullName() + "[");
                    for (int k = 0; k < v.getDimensions().size(); ++k) {
                        ucar.nc2.Dimension d = v.getDimension(k);
                        if (k > 0) {
                            description.append(",");
                        }
                        String n = d.getName();
                        if (n != null && !n.equals(name)) {
                            description.append(d.getName()).append("=");
                        }
                        description.append(d.getLength());
                        continue;
                    }
                    description.append("]");
                    AttributeContainer ac = v.attributes();
                    for (Attribute a : ac) {
                        if (!a.getName().equals("CATDESC")) continue;
                        description.append("<br>").append(a.getStringValue());
                    }
                    this.parameters.put(name, description.toString());
                }
                StringBuilder info = new StringBuilder();
                info.append(v.getDescription());
                this.allParameterInfo.put(name, info.toString());
            }
            int numData = this.parameters.size();
            this.jTabbedPane1.setTitleAt(0, "Select Variable (of " + numData + ")");
            String param = this.params.get("arg_0");
            String subset = null;
            if (param != null && (i = param.indexOf("[")) != -1) {
                subset = param.substring(i);
                param = param.substring(0, i);
            }
            this.fillTree(this.parameterTree, this.parameters, param);
            this.xParameterTree.setModel(this.parameterTree.getModel());
            String sx = this.params.get("X");
            if (sx == null) {
                sx = this.params.get("x");
            }
            if (sx != null) {
                this.fillTree(this.xParameterTree, this.parameters, sx);
            }
            this.yParameterTree.setModel(this.parameterTree.getModel());
            String sy = this.params.get("Y");
            if (sy == null) {
                sy = this.params.get("y");
            }
            if (sy != null) {
                this.fillTree(this.yParameterTree, this.parameters, sy);
            }
            logger.finest("close hdf");
            DefaultComboBoxModel<String> cbmodel = new DefaultComboBoxModel<String>();
            for (String p : this.params.keySet()) {
                cbmodel.addElement(p);
            }
            if (param == null) {
                if (!this.params.isEmpty()) {
                    param = this.parameter = this.params.entrySet().iterator().next().getKey();
                    this.parameterInfoLabel.setText("");
                } else {
                    this.parameterInfoLabel.setText("(no plottable parameters)");
                }
            }
            if (param != null) {
                if (subset != null) {
                    if (subset.startsWith("[")) {
                        subset = subset.substring(1);
                    }
                    if (subset.endsWith("]")) {
                        subset = subset.substring(0, subset.length() - 1);
                    }
                    this.subsetComboBox.setSelectedItem(subset);
                } else {
                    this.subsetComboBox.setSelectedItem("");
                }
            }
            if (this.parameter != null) {
                this.parameter = this.parameter.replaceAll("%3D", "=");
            }
            ArrayList<String> varnames = new ArrayList<String>();
            for (Map.Entry<String, String> p : this.parameters.entrySet()) {
                varnames.add(p.getKey());
            }
            this.whereParamList.setModel(new DefaultComboBoxModel<Object>(varnames.toArray()));
            String where = this.params.get("where");
            if (where != null && where.length() > 0) {
                this.whereCB.setSelected(true);
                int i2 = where.indexOf(".");
                if (i2 > -1) {
                    this.whereParamList.setSelectedItem(where.substring(0, i2));
                    int i0 = where.indexOf("(");
                    int i1 = where.indexOf(")", i0);
                    this.whereOp.setSelectedItem(where.substring(i2, i0));
                    this.whereTF.setText(where.substring(i0 + 1, i1).replaceAll("\\+", " "));
                }
            } else {
                this.whereCB.setSelected(false);
            }
        }
        catch (IOException | IllegalArgumentException | NullPointerException ex) {
            DasExceptionHandler.handle((Throwable)ex);
            logger.log(Level.SEVERE, ex.getMessage(), ex);
        }
    }

    public void markProblems(List<String> problems) {
        logger.log(Level.FINE, "markProblems: {0}", problems.toString());
    }

    public JPanel getPanel() {
        return this;
    }

    public String getURI() {
        String subset = this.subsetComboBox.getSelectedItem().toString().trim();
        if (subset.length() > 0 && subset.charAt(0) != '[') {
            subset = "[" + subset + "]";
        }
        String p = this.parameter;
        if (subset.length() > 0) {
            p = p + subset;
        }
        this.params.put("arg_0", p);
        if (this.xCheckBox.isSelected()) {
            TreePath xtp = this.xParameterTree.getSelectionPath();
            if (xtp != null) {
                Object odep0 = xtp.getLastPathComponent();
                this.params.put("x", odep0.toString());
            }
        } else {
            this.params.remove("x");
        }
        if (this.yCheckBox.isSelected()) {
            TreePath ytp = this.yParameterTree.getSelectionPath();
            if (ytp != null) {
                Object oy = ytp.getLastPathComponent();
                this.params.put("y", oy.toString());
            }
        } else {
            this.params.remove("y");
        }
        if (this.whereCB.isSelected()) {
            if (this.whereParamList.getSelectedItem() != null) {
                this.params.put("where", String.format("%s%s(%s)", this.whereParamList.getSelectedItem(), this.whereOp.getSelectedItem(), this.whereTF.getText().replaceAll(" ", "+")));
            } else {
                this.params.remove("where");
            }
        } else {
            this.params.remove("where");
        }
        this.split.vapScheme = this.vapScheme;
        this.split.params = URISplit.formatParams(this.params);
        if (this.split.params != null && this.split.params.length() == 0) {
            this.split.params = null;
        }
        return URISplit.format((URISplit)this.split);
    }

    public static void main(String[] args) throws Exception {
        HDF5DataSourceEditorPanel ep = new HDF5DataSourceEditorPanel();
        String uri = "/home/jbf/ct/autoplot/data/hdf/brian/FU1_ZEP_Counts_v1-5681_20110301_v1.0.0.h5";
        if (!ep.reject(uri)) {
            ep.prepare(uri, null, (ProgressMonitor)new NullProgressMonitor());
            ep.setURI(uri);
            if (JOptionPane.showConfirmDialog(null, ep) == 0) {
                System.err.println(ep.getURI());
            }
        }
    }
}

