/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.netCDF;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.autoplot.datasource.AbstractDataSourceFormat;
import org.das2.datum.Units;
import org.das2.datum.UnitsUtil;
import org.das2.qds.ArrayDataSet;
import org.das2.qds.DDataSet;
import org.das2.qds.DataSetOps;
import org.das2.qds.DataSetUtil;
import org.das2.qds.MutablePropertyDataSet;
import org.das2.qds.QDataSet;
import org.das2.qds.QubeDataSetIterator;
import org.das2.qds.SemanticOps;
import org.das2.util.LoggerManager;
import org.das2.util.monitor.ProgressMonitor;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.ma2.InvalidRangeException;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;
import ucar.nc2.write.NetcdfFileFormat;
import ucar.nc2.write.NetcdfFormatWriter;

public class HDF5DataSourceFormat
extends AbstractDataSourceFormat {
    Map<QDataSet, String> names = new HashMap<QDataSet, String>();
    private static final Logger logger = LoggerManager.getLogger((String)"apdss.netcdf");

    private synchronized String nameFor(QDataSet dep0) {
        String name = this.names.get(dep0);
        if (name != null) {
            return name;
        }
        name = (String)dep0.property("NAME");
        Units units = (Units)dep0.property("UNITS");
        if (name == null) {
            name = units != null && UnitsUtil.isTimeLocation((Units)units) ? "Epoch" : "Variable_" + this.names.size();
        }
        if (this.names.containsValue(name)) {
            name = name + "_" + this.names.size();
        }
        this.names.put(dep0, name);
        return name;
    }

    private synchronized DataType typeFor(QDataSet dep0, String suggest) {
        Units units = (Units)dep0.property("UNITS");
        if (units != null && UnitsUtil.isTimeLocation((Units)units)) {
            return DataType.DOUBLE;
        }
        switch (suggest) {
            case "double": {
                return DataType.DOUBLE;
            }
            case "float": {
                return DataType.FLOAT;
            }
            case "long": {
                return DataType.LONG;
            }
            case "int": {
                return DataType.INT;
            }
            case "short": {
                return DataType.SHORT;
            }
        }
        return DataType.DOUBLE;
    }

    private static Object getProperty(QDataSet src, String name, Object deft) {
        Object o = src.property(name);
        if (o == null) {
            return deft;
        }
        return o;
    }

    private void copy(NetcdfFile in, NetcdfFormatWriter.Builder out) {
        for (Dimension d : in.getDimensions()) {
            logger.log(Level.FINER, "out.addDimension({0})", d.getName());
            out.getRootGroup().addDimension(d);
        }
        for (Variable v : in.getVariables()) {
            logger.log(Level.FINER, "out.addVariable({0})", v.getShortName());
            out.addVariable(v.getShortName(), v.getDataType(), (List)v.getDimensions());
            this.names.put((QDataSet)DDataSet.create((int[])new int[0]), v.getShortName());
        }
    }

    private Dimension getDimension(NetcdfFile ncfile, String name) {
        try {
            logger.log(Level.FINER, "ncfile.getDimensions() (looking for {0})", name);
            for (Dimension d : ncfile.getDimensions()) {
                if (!d.getName().equals(name)) continue;
                return d;
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public void formatData(String uri, QDataSet data, ProgressMonitor mon) throws Exception {
        NetcdfFormatWriter writer;
        Object depi;
        String namei;
        int i;
        NetcdfFile oldfile;
        NetcdfFormatWriter.Builder ncfile;
        String doDep;
        this.setUri(uri);
        this.maybeMkdirs();
        String typeSuggest = this.getParam("type", "double");
        File file = new File(this.getResourceURI().toURL().getFile());
        ArrayList<void> dims = new ArrayList<void>();
        HashMap<String, Object> dim = new HashMap<String, Object>();
        HashMap<String, Dimension[]> dimss = new HashMap<String, Dimension[]>();
        String name1 = this.getParam("arg_0", this.getParam("name", null));
        if (name1 != null) {
            this.names.put(data, name1);
        }
        if ((doDep = this.getParam("doDep", "")).length() > 0 && doDep.toUpperCase().charAt(0) == 'F') {
            MutablePropertyDataSet mpds = DataSetOps.makePropertiesMutable((QDataSet)data);
            mpds.putProperty("DEPEND_0", null);
            mpds.putProperty("DEPEND_1", null);
            mpds.putProperty("DEPEND_2", null);
            mpds.putProperty("DEPEND_3", null);
            mpds.putProperty("BUNDLE_1", null);
            data = mpds;
        }
        boolean append = "T".equals(this.getParam("append", "F"));
        String tempFileName = file.toString() + ".temp";
        if (!append) {
            if (file.exists() && !file.delete()) {
                throw new IllegalArgumentException("Unable to delete file" + file);
            }
            logger.log(Level.FINE, "create HDF5 file {0}", file);
            logger.log(Level.FINER, "NetcdfFileWriteable.createNew( {0}, true )", tempFileName);
            ncfile = NetcdfFormatWriter.createNewNetcdf4((NetcdfFileFormat)NetcdfFileFormat.NETCDF4_CLASSIC, (String)tempFileName, null);
            oldfile = null;
        } else {
            logger.log(Level.FINER, "oldfile= NetcdfFile.open( {0} );", file.toString());
            oldfile = NetcdfFile.open((String)file.toString());
            logger.log(Level.FINER, "ncfile=NetcdfFileWriteable.createNew( {0}, true )", tempFileName);
            ncfile = NetcdfFormatWriter.createNewNetcdf4((NetcdfFileFormat)NetcdfFileFormat.NETCDF4_CLASSIC, (String)tempFileName, null);
            this.copy(oldfile, ncfile);
            for (Dimension d : oldfile.getDimensions()) {
                dim.put(d.getName(), d);
            }
            dims.addAll((Collection<void>)oldfile.getDimensions());
        }
        int[] qube = DataSetUtil.qubeDims((QDataSet)data);
        if (qube == null) {
            throw new IllegalArgumentException("data is not a qube");
        }
        for (i = 0; i < data.rank(); ++i) {
            void var19_23;
            namei = "dim" + i;
            depi = (QDataSet)data.property("DEPEND_" + i);
            if (depi != null) {
                namei = this.nameFor((QDataSet)depi);
            }
            if (append) continue;
            Dimension dimension = (Dimension)dim.get(namei);
            if (dimension == null) {
                logger.log(Level.FINER, "ncfile.addDimension({0},{1})", new Object[]{namei, DataSetUtil.toString((int[])qube)});
                Dimension dimension2 = ncfile.addDimension(namei, qube[i]);
            }
            dim.put(var19_23.getName(), var19_23);
            dims.add(var19_23);
            if (depi == null) continue;
            if (depi.rank() == 2) {
                dimss.put(namei, new Dimension[]{(Dimension)dims.get(0), var19_23});
                continue;
            }
            dimss.put(namei, new Dimension[]{var19_23});
        }
        for (i = 0; i < data.rank(); ++i) {
            depi = (QDataSet)data.property("DEPEND_" + i);
            if (depi == null || depi == data) continue;
            namei = this.nameFor((QDataSet)depi);
            Units units = SemanticOps.getUnits((QDataSet)depi);
            String typeSuggest1 = UnitsUtil.isTimeLocation((Units)units) ? "double" : typeSuggest;
            this.defineVariableOne(ncfile, (QDataSet)depi, typeSuggest1, (Dimension[])dimss.get(namei));
        }
        this.defineVariableOne(ncfile, data, typeSuggest, dims.toArray(new Dimension[dims.size()]));
        LinkedHashMap<String, Array> dataStore = new LinkedHashMap<String, Array>();
        if (append) {
            assert (oldfile != null);
            logger.log(Level.FINER, "oldFile.getVariables()");
            for (Variable variable : oldfile.getVariables()) {
                logger.log(Level.FINER, "v.read()");
                Array a = variable.read();
                logger.log(Level.FINE, "a={0}", a);
                dataStore.put(variable.getFullName(), a);
            }
            oldfile.close();
            for (Map.Entry entry : dataStore.entrySet()) {
                Array array = (Array)entry.getValue();
                ncfile.addVariable((String)entry.getKey(), array.getDataType(), dims);
            }
            writer = ncfile.build();
        } else {
            writer = ncfile.build();
        }
        for (int i2 = 0; i2 < data.rank(); ++i2) {
            QDataSet qDataSet = (QDataSet)data.property("DEPEND_" + i2);
            if (qDataSet == null) continue;
            this.nameFor(qDataSet);
            Units u = SemanticOps.getUnits((QDataSet)qDataSet);
            String typeSuggest1 = UnitsUtil.isTimeLocation((Units)u) ? "double" : typeSuggest;
            this.formatDataOne(writer, qDataSet, typeSuggest1);
        }
        this.formatDataOne(writer, data, typeSuggest);
        logger.log(Level.FINER, "ncfile.flush()");
        writer.flush();
        logger.log(Level.FINER, "ncfile.close()");
        writer.close();
        if (!new File(tempFileName).renameTo(file)) {
            throw new IOException("unable to rename file " + tempFileName);
        }
    }

    private void defineVariableOne(NetcdfFormatWriter.Builder ncfile, QDataSet data, String typeSuggest, Dimension[] dims) {
        String varName = this.nameFor(data);
        DataType t = this.typeFor(data, typeSuggest);
        logger.log(Level.FINER, "ncfile.addVariable({0},{1},<dims>)", new Object[]{varName, t});
        Variable.Builder vbuilder = ncfile.addVariable(varName, t, Arrays.asList(dims));
        Number nfill = (Number)data.property("FILL_VALUE");
        double fill = nfill == null ? -1.0E38 : nfill.doubleValue();
        String meta = this.getParam("metadata", "");
        if (meta.equals("istp")) {
            logger.finer("adding ISTP metadata");
            vbuilder.addAttribute(new Attribute("FIELDNAM", varName));
            vbuilder.addAttribute(new Attribute("UNITS", SemanticOps.getUnits((QDataSet)data).toString()));
            vbuilder.addAttribute(new Attribute("VAR_TYPE", "data"));
            vbuilder.addAttribute(new Attribute("FILLVAL", (Number)fill));
            vbuilder.addAttribute(new Attribute("VALIDMIN", (Number)((Double)HDF5DataSourceFormat.getProperty(data, "VALID_MIN", -1.0E38))));
            vbuilder.addAttribute(new Attribute("VALIDMAX", (Number)((Double)HDF5DataSourceFormat.getProperty(data, "VALID_MAX", 1.0E38))));
            if (data.property("TYPICAL_MIN") != null) {
                vbuilder.addAttribute(new Attribute("SCALEMIN", (Number)((Double)HDF5DataSourceFormat.getProperty(data, "TYPICAL_MIN", -1.0E38))));
            }
            if (data.property("TYPICAL_MAX") != null) {
                vbuilder.addAttribute(new Attribute("SCALEMAX", (Number)((Double)HDF5DataSourceFormat.getProperty(data, "TYPICAL_MAX", 1.0E38))));
            }
            if (data.property("SCALE_TYPE") != null) {
                vbuilder.addAttribute(new Attribute("SCALETYP", (String)HDF5DataSourceFormat.getProperty(data, "SCALE_TYPE", "linear")));
            }
            if (data.property("TITLE") != null) {
                vbuilder.addAttribute(new Attribute("CATDESC", (String)HDF5DataSourceFormat.getProperty(data, "TITLE", "")));
            }
            if (data.property("LABEL") != null) {
                vbuilder.addAttribute(new Attribute("LABLAXIS", (String)HDF5DataSourceFormat.getProperty(data, "LABEL", "")));
            }
        } else {
            vbuilder.addAttribute(new Attribute("_FillValue", (Number)fill));
            if (UnitsUtil.isTimeLocation((Units)SemanticOps.getUnits((QDataSet)data))) {
                Units u = SemanticOps.getUnits((QDataSet)data);
                String unitsStr = u.getOffsetUnits().toString() + " " + u.getBasis().getDescription();
                vbuilder.addAttribute(new Attribute("units", unitsStr));
            }
        }
    }

    private void formatDataOne(NetcdfFormatWriter ncfile, QDataSet data, String typeSuggest) throws IllegalArgumentException, InvalidRangeException, IOException {
        String varName = this.nameFor(data);
        int[] qube = DataSetUtil.qubeDims((QDataSet)data);
        if (qube == null) {
            throw new IllegalArgumentException("data is not a qube");
        }
        ArrayDataSet ads = ArrayDataSet.copy((QDataSet)data);
        DataType dataType = this.typeFor(data, typeSuggest);
        logger.log(Level.FINER, "ddata= Array.factory( {0}, qube );", dataType);
        Array ddata = Array.factory((DataType)dataType, (int[])qube);
        QubeDataSetIterator it = new QubeDataSetIterator((QDataSet)ads);
        int i = 0;
        while (it.hasNext()) {
            it.next();
            ddata.setDouble(i, it.getValue((QDataSet)ads));
            ++i;
        }
        logger.log(Level.FINER, "ncfile.write({0},ddata)", varName);
        ncfile.write(varName, ddata);
    }

    public boolean canFormat(QDataSet ds) {
        int[] qube = DataSetUtil.qubeDims((QDataSet)ds);
        return qube != null;
    }

    public String getDescription() {
        return "HDF5";
    }
}

