/*
 * HDF5DataSourceFormatEditorPanel.java
 *
 */
package org.autoplot.netCDF;

import java.util.HashMap;
import java.util.Map;
import javax.swing.JPanel;
import org.autoplot.datasource.AbstractDataSourceFormatEditorPanel;
import org.autoplot.datasource.URISplit;

/**
 * Options for formatting to HDF5.
 * @author jbf
 */
public class HDF5DataSourceFormatEditorPanel extends AbstractDataSourceFormatEditorPanel {

    /** Creates new form BinaryDataSourceFormatEditorPanel */
    public HDF5DataSourceFormatEditorPanel() {
        initComponents();
    }

    String file;

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jLabel1 = new javax.swing.JLabel();
        typeComboBox = new javax.swing.JComboBox();
        istpMetadata = new javax.swing.JCheckBox();
        justDataCB = new javax.swing.JCheckBox();

        jLabel1.setText("Type:");

        typeComboBox.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "double", "float", "byte" }));

        istpMetadata.setText("Use ISTP Metadata Conventions");
        istpMetadata.setToolTipText("Use ISTP metadata conventions for the data, like LABLAXIS, UNITS and VALIDMIN");

        justDataCB.setText("Just Data, don't format timetags and other dependencies");

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(layout.createSequentialGroup()
                        .add(jLabel1)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(typeComboBox, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 123, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                        .addContainerGap())
                    .add(layout.createSequentialGroup()
                        .add(istpMetadata, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                        .add(24, 24, 24))))
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(justDataCB)
                .addContainerGap(org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(jLabel1)
                    .add(typeComboBox, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(istpMetadata)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(justDataCB)
                .addContainerGap(203, Short.MAX_VALUE))
        );
    }// </editor-fold>//GEN-END:initComponents


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JCheckBox istpMetadata;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JCheckBox justDataCB;
    private javax.swing.JComboBox typeComboBox;
    // End of variables declaration//GEN-END:variables

    @Override
    public JPanel getPanel() {
        return this;
    }

    private String getParam( Map<String,String> args, String name, String defl ) {
        String s= args.get(name);
        if ( s==null ) {
            return defl;
        } else {
            return s;
        }
    }
    @Override
    public void setURI(String uri) {
        
        super.setURI(uri);
        
        URISplit split= URISplit.parse(uri);
        Map<String,String> args= URISplit.parseParams(split.params);

        String s;
        s= getParam( args,"type","double");
        typeComboBox.setSelectedItem(s);

        s= getParam( args,"metadata","");
        istpMetadata.setSelected(s.equals("istp"));

        justDataCB.setSelected( ! getBooleanParam("doDep",false) );
    
        file= split.file;
    }

    @Override
    public String getURI() {
        String result= file;
        Map<String,String> args= new HashMap();

        String s;
        s= (String) typeComboBox.getSelectedItem();
        if ( !s.equals("double") ) args.put( "type", s );
        if ( istpMetadata.isSelected() ) args.put( "metadata", "istp" );

        if ( justDataCB.isSelected() ) args.put( "doDep", "F" );
        
        String params= URISplit.formatParams(args);
        if ( result==null ) result= "file:///";
        URISplit ss= URISplit.parse(result);

        if ( params.length()>0 ) {
            ss.params= params;
        }
        return URISplit.format( ss );

    }

}
