/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.dods;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.parser.ParserDelegator;
import org.das2.util.LoggerManager;

public class MetaDataScraper {
    private static final Logger logger = LoggerManager.getLogger((String)"apdss.opendap");
    HashMap varAttrs;
    HashMap varAttrsData;
    HashMap recDims;

    public void parseURL(URL url) throws IOException {
        if (!url.toString().endsWith(".html")) {
            throw new IllegalArgumentException("must end in .html");
        }
        this.varAttrs = new HashMap();
        this.varAttrsData = new HashMap();
        this.recDims = new HashMap();
        logger.log(Level.FINE, "parseURL opening {0}", url);
        try (InputStream in = url.openStream();){
            new ParserDelegator().parse(new InputStreamReader(in), new MyCallBack(), true);
        }
    }

    private Map parseData(char[] data) {
        String[] ss;
        HashMap<String, Object> result = new HashMap<String, Object>();
        String s = new String(data);
        for (String s1 : ss = s.split("\n")) {
            int ic = s1.indexOf(":");
            String name = s1.substring(0, ic);
            String value = s1.substring(ic + 1).trim();
            if (value.startsWith("\"")) {
                value = value.substring(1, value.length() - 1);
                result.put(name, value);
                continue;
            }
            result.put(name, Double.parseDouble(value));
        }
        return result;
    }

    public Map getAttr(String varName) {
        if (this.varAttrs == null) {
            throw new IllegalArgumentException("need to parse URL first");
        }
        Map result = (Map)this.varAttrs.get(varName);
        if (result == null) {
            char[] data = (char[])this.varAttrsData.get(varName);
            if (data == null) {
                throw new IllegalArgumentException("variable not found: " + varName);
            }
            result = this.parseData(data);
            this.varAttrs.put(varName, result);
        }
        return result;
    }

    public int[] getRecDims(String varName) {
        String rds = (String)this.recDims.get(varName);
        if (rds == null) {
            throw new IllegalArgumentException("variable not found: " + varName);
        }
        String[] ss = rds.split("]");
        int[] result = new int[ss.length];
        for (int i = 0; i < ss.length; ++i) {
            int idd = ss[i].indexOf("..");
            result[i] = Integer.parseInt(ss[i].substring(idd + 2));
        }
        return result;
    }

    class MyCallBack
    extends HTMLEditorKit.ParserCallback {
        String varName;
        String recDim;
        Object nameKey = HTML.getAttributeKey("name");

        MyCallBack() {
        }

        @Override
        public void handleText(char[] data, int pos) {
            if (this.varName != null) {
                MetaDataScraper.this.varAttrsData.put(this.varName, data);
            } else {
                String s = new String(data);
                int i = s.indexOf("[RecDim =");
                if (i == -1) {
                    i = s.indexOf("[Dim0 =");
                }
                if (i != -1) {
                    this.recDim = s.substring(i);
                }
            }
        }

        @Override
        public void handleStartTag(HTML.Tag t, MutableAttributeSet a, int pos) {
            super.handleStartTag(t, a, pos);
            if (t == HTML.Tag.TEXTAREA) {
                String nameAttr = (String)a.getAttribute(this.nameKey);
                if (nameAttr != null && nameAttr.endsWith("_attr")) {
                    this.varName = nameAttr.substring(0, nameAttr.length() - 5);
                    if (this.recDim != null) {
                        MetaDataScraper.this.recDims.put(this.varName, this.recDim);
                        this.recDim = null;
                    }
                } else {
                    this.varName = null;
                }
            } else {
                this.varName = null;
            }
        }

        @Override
        public void handleEndTag(HTML.Tag t, int pos) {
            super.handleEndTag(t, pos);
            this.varName = null;
        }
    }
}

