/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.dods;

import java.io.IOException;
import java.net.URL;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Map;
import org.autoplot.dods.DodsAdapter;
import org.autoplot.dods.MetaDataScraper;
import org.das2.datum.DatumRange;
import org.das2.datum.Units;

public class SPDFUtil {
    public static void interpretAttributes(DodsAdapter da) throws IOException {
        int i;
        MetaDataScraper meta = new MetaDataScraper();
        meta.parseURL(new URL(da.getSource().toString() + ".html"));
        Map m = SPDFUtil.interpretProps(meta.getAttr(da.getVariable()));
        if (m.containsKey("UNITS")) {
            da.setUnits((Units)m.get("UNITS"));
        }
        if (m.containsKey("VALID_MIN") || m.containsKey("VALID_MAX")) {
            Double min = (Double)m.get("VALID_MIN");
            Double max = (Double)m.get("VALID_MAX");
            if (min == null) {
                min = Double.NEGATIVE_INFINITY;
            }
            if (max == null) {
                max = Double.POSITIVE_INFINITY;
            }
            da.setValidRange(min, max);
        }
        StringBuffer constraint = new StringBuffer("?");
        constraint.append(da.getVariable());
        int[] ii = meta.getRecDims(da.getVariable());
        for (i = 0; i < ii.length; ++i) {
            constraint.append("[0:1:" + ii[i] + "]");
        }
        da.putAllProperties(m);
        for (i = 0; i < 3; ++i) {
            String dkey = "DEPEND_" + i + "_ID";
            if (!m.containsKey(dkey)) continue;
            String var = (String)m.get(dkey);
            da.setDependName(i, var);
            int[] ii2 = meta.getRecDims(var);
            constraint.append(",").append(var).append("[0:1:" + ii2[0] + "]");
            Map m0 = SPDFUtil.interpretProps(meta.getAttr(var));
            if (m0.containsKey("UNITS")) {
                da.setDimUnits(i, (Units)m0.get("UNITS"));
            }
            da.setDimProperties(i, m0);
        }
        da.setConstraint(constraint.toString());
    }

    public static Map interpretProps(Map attr) {
        double v1;
        Units units;
        attr = new HashMap(attr);
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            units = Units.getByName((String)((String)attr.remove("UNITS")));
        }
        catch (IllegalArgumentException e) {
            units = Units.dimensionless;
        }
        if (units == Units.milliseconds && "Epoch".equalsIgnoreCase((String)attr.get("LABLAXIS"))) {
            units = Units.cdfEpoch;
        }
        result.put("UNITS", units);
        try {
            double v0 = SPDFUtil.getDouble(attr.remove("SCALEMIN"), units);
            v1 = SPDFUtil.getDouble(attr.remove("SCALEMAX"), units);
            result.put("TYPICAL_RANGE", new DatumRange(v0, v1, units));
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            double v0 = SPDFUtil.getDouble(attr.remove("VALIDMIN"), units);
            v1 = SPDFUtil.getDouble(attr.remove("VALIDMAX"), units);
            result.put("VALID_RANGE", new DatumRange(v0, v1, units));
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        String s = (String)attr.remove("LABLAXIS");
        if (s != null) {
            result.put("LABEL", s);
        }
        try {
            double v0 = SPDFUtil.getDouble(attr.remove("FILLVAL"), units);
            result.put("FILL", new Double(v0));
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        s = (String)attr.remove("DEPEND_0");
        if (s != null) {
            result.put("DEPEND_0_ID", s);
        }
        if ((s = (String)attr.remove("DEPEND_1")) != null) {
            result.put("DEPEND_1_ID", s);
        }
        if ((s = (String)attr.remove("DEPEND_2")) != null) {
            result.put("DEPEND_2_ID", s);
        }
        result.putAll(attr);
        return result;
    }

    private static double getDouble(Object o, Units units) {
        if (o == null) {
            throw new NullPointerException("o was null");
        }
        if (o instanceof Float) {
            return ((Float)o).doubleValue();
        }
        if (o instanceof Double) {
            return (Double)o;
        }
        if (o instanceof Short) {
            return ((Short)o).doubleValue();
        }
        if (o instanceof String) {
            try {
                return units.parse((String)o).doubleValue(units);
            }
            catch (ParseException ex) {
                throw new IllegalArgumentException("unable to parse " + o);
            }
        }
        throw new RuntimeException("Unsupported Data Type: " + o.getClass().getName());
    }
}

