/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.pds;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.das2.util.FileUtil;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DocumentUtil {
    public static void dumpToXML(Document doc, File f) throws IllegalArgumentException {
        Transformer transformer;
        try {
            transformer = TransformerFactory.newInstance().newTransformer();
        }
        catch (TransformerConfigurationException ex) {
            throw new RuntimeException(ex);
        }
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
        StreamResult result = new StreamResult(new StringWriter());
        DOMSource source = new DOMSource(doc);
        try {
            transformer.transform(source, result);
        }
        catch (TransformerException ex) {
            throw new RuntimeException(ex);
        }
        String xmlString = result.getWriter().toString();
        try {
            FileUtil.writeStringToFile((File)f, (String)xmlString);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static void dumpToFile(JSONObject jo, File f) throws Exception {
        try (PrintWriter p = new PrintWriter(new FileWriter(f));){
            p.print(jo.toString(4));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean isLeaf(Node node) {
        return node.getChildNodes().getLength() == 1 && node.getFirstChild().getNodeType() == 3;
    }

    private static String getName(Node node) {
        NodeList nn = node.getChildNodes();
        for (int i = 0; i < nn.getLength(); ++i) {
            Node item = nn.item(i);
            if (item.getNodeName().equals("name")) {
                return item.getTextContent();
            }
            if (item.getNodeName().equals("Field_Binary")) {
                return DocumentUtil.getName(item);
            }
            if (!item.getNodeName().equals("Field_Character")) continue;
            return DocumentUtil.getName(item);
        }
        return "";
    }

    private static String[] makeUnique(String[] arr, NodeList nodes) {
        HashMap<String, Integer> counts = new HashMap<String, Integer>();
        String[] result = new String[arr.length];
        for (int i = 0; i < arr.length; ++i) {
            boolean isFieldOrGroup;
            String name = arr[i];
            int count = counts.getOrDefault(name, 0) + 1;
            counts.put(name, count);
            boolean bl = isFieldOrGroup = name.equals("Field_Binary") || name.equals("Group_Field_Binary") || name.equals("Field_Character") || name.equals("Group_Field_Character");
            if (isFieldOrGroup) {
                String nname = DocumentUtil.getName(nodes.item(i));
                if (nname != null && nname.length() > 0) {
                    result[i] = name + " (" + nname + ")";
                    continue;
                }
                result[i] = name + " (" + count + ")";
                continue;
            }
            result[i] = count == 1 ? name : name + " (" + count + ")";
        }
        return result;
    }

    public static Map<String, Object> convertDocumentToMap(Node root) {
        String key;
        Node node;
        int i;
        LinkedHashMap<String, Object> resultMap = new LinkedHashMap<String, Object>();
        NodeList nodeList = root.getChildNodes();
        String[] nodeNames = new String[nodeList.getLength()];
        for (i = 0; i < nodeList.getLength(); ++i) {
            node = nodeList.item(i);
            nodeNames[i] = key = node.getNodeName();
        }
        nodeNames = DocumentUtil.makeUnique(nodeNames, nodeList);
        for (i = 0; i < nodeList.getLength(); ++i) {
            node = nodeList.item(i);
            key = node.getNodeName();
            if (DocumentUtil.isLeaf(node)) {
                String value = node.getTextContent();
                if (key.equalsIgnoreCase("DESCRIPTION")) {
                    value = DocumentUtil.cleanDescriptionString(value);
                }
                resultMap.put(nodeNames[i], value);
                continue;
            }
            if (node.getNodeType() != 1) continue;
            Map<String, Object> subNode = DocumentUtil.convertDocumentToMap(node);
            resultMap.put(nodeNames[i], subNode);
        }
        return resultMap;
    }

    public static String cleanDescriptionString(String desc) {
        if (desc == null) {
            return null;
        }
        desc = String.join((CharSequence)" ", desc.trim().split("\\s+"));
        desc = String.join((CharSequence)"<br>", desc.split("\\&\\#13\\;"));
        return "<html>" + desc;
    }

    public static String cleanString(String desc) {
        if (desc == null) {
            return null;
        }
        desc = String.join((CharSequence)" ", desc.trim().split("\\s+"));
        desc = String.join((CharSequence)"<br>", desc.split("\\&\\#13\\;"));
        return "<html>" + desc;
    }

    public static JSONArray cleanJSONArray(JSONArray jo) {
        for (int i = 0; i < jo.length(); ++i) {
            try {
                Object o2 = jo.get(i);
                if (o2 instanceof JSONObject) {
                    DocumentUtil.cleanJSONObject((JSONObject)o2);
                    continue;
                }
                if (o2 instanceof JSONArray) {
                    DocumentUtil.cleanJSONArray((JSONArray)o2);
                    continue;
                }
                if (!(o2 instanceof String)) continue;
                jo.put(i, o2);
                continue;
            }
            catch (JSONException ex) {
                Logger.getLogger(DocumentUtil.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return jo;
    }

    public static JSONObject cleanJSONObject(JSONObject jo) {
        Iterator o = jo.keys();
        while (o.hasNext()) {
            try {
                String k = (String)o.next();
                Object o2 = jo.get(k);
                if (o2 instanceof JSONObject) {
                    DocumentUtil.cleanJSONObject((JSONObject)o2);
                    continue;
                }
                if (o2 instanceof JSONArray) {
                    DocumentUtil.cleanJSONArray((JSONArray)o2);
                    continue;
                }
                if (!(o2 instanceof String)) continue;
                if (k.equals("DESCRIPTION")) {
                    jo.put(k, (Object)DocumentUtil.cleanString((String)o2));
                    continue;
                }
                jo.put(k, (Object)((String)o2));
            }
            catch (JSONException ex) {
                Logger.getLogger(DocumentUtil.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return jo;
    }

    public static String createTitleFrom(String desc) {
        if (desc == null) {
            return null;
        }
        int i = (desc = DocumentUtil.cleanString(desc)).indexOf(". ");
        if (i > 10) {
            desc = desc.substring(0, i);
        }
        if (desc.startsWith("<html>")) {
            desc = desc.substring(6);
        }
        return desc;
    }

    public static Document readXML(File f) throws IOException, SAXException {
        Document document;
        DocumentBuilder builder = null;
        try {
            builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (ParserConfigurationException ex) {
            throw new RuntimeException(ex);
        }
        try (FileInputStream in = new FileInputStream(f);){
            InputSource source = new InputSource(in);
            document = builder.parse(source);
        }
        return document;
    }
}

