/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.pds.ppi.label;

import gov.nasa.pds.ppi.label.PDSException;
import gov.nasa.pds.ppi.label.PDSValue;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.charset.MalformedInputException;
import java.util.ArrayList;

public class PDSElement {
    public static final int TYPE_NONE = 0;
    public static final int TYPE_ORDERED = 1;
    public static final int TYPE_UNORDERED = 2;
    public static final int TYPE_BLANK_LINE = 3;
    public static final int TYPE_COMMENT = 4;
    public String mKeyword = "";
    public ArrayList mValue = new ArrayList();
    public int mType = 0;
    public String mComment = "";
    public char[] mRaw = null;
    public int mMaxLength = 78;
    public int mLineCount = 0;
    public String mSource = "<unknown>";
    public boolean mSyntaxError = false;

    public PDSElement() {
    }

    public PDSElement(int line) {
        this.mLineCount = line;
    }

    public PDSElement(int line, String source) {
        this.mSource = source;
    }

    public void clear() {
        this.mKeyword = "";
        this.mValue.clear();
        this.mType = 0;
        this.mComment = "";
        this.mRaw = null;
        this.mMaxLength = 78;
        this.mLineCount = 0;
        this.mSyntaxError = false;
    }

    public boolean parse(BufferedReader reader) throws PDSException {
        int i;
        char lastC = '\u0000';
        char c = '\u0000';
        int quote = 32;
        int total = 0;
        boolean inQuote = false;
        boolean inBlock = false;
        boolean inComment = false;
        boolean inUnits = false;
        boolean add = true;
        boolean scanning = true;
        this.clear();
        while (scanning) {
            this.mRaw = this.readLine(reader);
            if (this.mRaw == null) {
                return false;
            }
            total = this.strlen(this.mRaw);
            int commentStart = 0;
            int commentEnd = 0;
            inComment = false;
            inQuote = false;
            lastC = '\u0000';
            for (i = 0; i < total; ++i) {
                c = this.mRaw[i];
                if (!inComment && c == '\"') {
                    inQuote = !inQuote;
                }
                if (!inQuote) {
                    if (lastC == '/' && c == '*') {
                        commentStart = i - 1;
                        inComment = true;
                    }
                    if (lastC == '*' && c == '/') {
                        commentEnd = i;
                        inComment = false;
                        add = false;
                    }
                }
                lastC = c;
                if (!inComment) continue;
                this.mComment = this.mComment + c;
            }
            if (this.mComment.length() > 0) {
                this.mComment = this.mComment.substring(1);
            }
            if (this.mComment.length() > 0) {
                this.mComment = this.mComment.substring(0, this.mComment.length() - 1);
            }
            if (commentStart != commentEnd) {
                this.deleteString(this.mRaw, commentStart, commentEnd);
            }
            this.trimSpace(this.mRaw);
            total = this.strlen(this.mRaw);
            if (total == 0) {
                this.mType = commentEnd > 0 ? 4 : 3;
                return true;
            }
            scanning = false;
        }
        if (total >= 3) {
            String buffer = new String(this.mRaw, 0, 3);
            c = total > 3 ? this.mRaw[3] : (char)' ';
            if (buffer.compareTo("END") == 0 && Character.isWhitespace(c)) {
                this.mKeyword = "END";
                return false;
            }
        }
        if ((i = this.indexOf(this.mRaw, '=')) == -1) {
            this.mKeyword = new String(this.mRaw, 0, total);
            if (total > 14 && this.mKeyword.substring(0, 14).compareTo("CCSD3ZF0000100") == 0) {
                return true;
            }
            if (this.mKeyword.compareTo("END") == 0) {
                return false;
            }
            throw new PDSException("Syntax error. Unrecognized plain word (" + this.mKeyword + ") at line " + this.mLineCount);
        }
        this.mKeyword = new String(this.mRaw, 0, i);
        this.mKeyword = this.mKeyword.trim();
        return this.parseValue(this.mRaw, i + 1);
    }

    public int indexOf(char[] cbuff, char c) {
        for (int i = 0; i < cbuff.length; ++i) {
            if (cbuff[i] != c) continue;
            return i;
        }
        return -1;
    }

    public void deleteString(char[] cbuff, int start, int end) {
        int i;
        int n = start;
        for (i = end + 1; i < cbuff.length; ++i) {
            cbuff[n++] = cbuff[i];
        }
        for (i = n; i < cbuff.length; ++i) {
            cbuff[i] = '\u0000';
        }
    }

    public int strlen(char[] cbuff) {
        return this.strlen(cbuff, 0);
    }

    public int strlen(char[] cbuff, int startAt) {
        int total = cbuff.length;
        for (int i = startAt; i < total; ++i) {
            if (cbuff[i] != '\u0000') continue;
            return i - startAt;
        }
        return cbuff.length - startAt;
    }

    public char[] readLine(BufferedReader reader) throws PDSException {
        int lastC = 0;
        int c = 0;
        int quote = 32;
        boolean inQuote = false;
        boolean inLiteral = false;
        boolean inList = false;
        boolean inOrderedList = false;
        boolean inComment = false;
        boolean inUnits = false;
        boolean inValue = false;
        boolean foundValue = false;
        boolean foundComment = false;
        int n = 0;
        int total = 0;
        int maxBuffer = 4048;
        char[] buffer2 = new char[maxBuffer];
        ArrayList<char[]> buffList = new ArrayList<char[]>();
        this.mSyntaxError = false;
        try {
            while ((c = reader.read()) != -1) {
                buffer2[n] = (char)c;
                ++total;
                if (++n == maxBuffer) {
                    buffList.add(buffer2);
                    buffer2 = new char[4048];
                    n = 0;
                }
                if (c == 10) {
                    ++this.mLineCount;
                }
                if (!inComment && c == 34) {
                    inQuote = !inQuote;
                }
                if (!inQuote) {
                    if (lastC == 47 && c == 42) {
                        inComment = true;
                    }
                    if (lastC == 42 && c == 47) {
                        inComment = false;
                        foundComment = true;
                    }
                }
                lastC = c;
                if (inQuote || inComment) continue;
                if (inValue && !this.isSpace(c)) {
                    foundValue = true;
                }
                if (c == 123) {
                    if (inList) {
                        throw new PDSException("List in a list");
                    }
                    inList = true;
                }
                if (c == 125) {
                    if (!inList) {
                        throw new PDSException("End of list without start of list");
                    }
                    inList = false;
                }
                if (c == 40) {
                    if (inOrderedList) {
                        throw new PDSException("Ordered list in an ordered list");
                    }
                    inOrderedList = true;
                }
                if (c == 41) {
                    if (!inOrderedList) {
                        throw new PDSException("End of ordered list without start of ordered list");
                    }
                    inOrderedList = false;
                }
                if (c == 39) {
                    inLiteral = !inLiteral;
                }
                if (c == 60) {
                    if (inUnits) {
                        this.mSyntaxError = true;
                        return null;
                    }
                    inUnits = true;
                }
                if (c == 62) {
                    if (!inUnits) {
                        this.mSyntaxError = true;
                        return null;
                    }
                    inUnits = false;
                }
                if (c == 61) {
                    inValue = true;
                }
                if (!(c == 10 && !foundValue && foundComment || c == 10 && foundValue && !inComment && !inQuote && !inList && !inOrderedList && !inLiteral && !inUnits) && (c != 10 || inValue || inComment || inQuote || inList || inOrderedList || inLiteral || inUnits)) continue;
                break;
            }
        }
        catch (MalformedInputException e) {
            buffer2 = null;
            throw new PDSException("Malformed Label Input, file is not 7-Bit ASCII safe");
        }
        catch (IOException e) {
            buffer2 = null;
            throw new PDSException(e);
        }
        if (c == -1 && total == 0) {
            return null;
        }
        if (n > 0) {
            buffList.add(buffer2);
        }
        int start = 0;
        int remaining = total;
        char[] cbuff = new char[total];
        for (char[] buffer2 : buffList) {
            n = remaining;
            if (n > maxBuffer) {
                n = maxBuffer;
            }
            for (int i = 0; i < n; ++i) {
                cbuff[start + i] = buffer2[i];
            }
            start += n;
            remaining -= n;
        }
        return cbuff;
    }

    public void trimSpace(char[] cbuff) {
        this.trimSpace(cbuff, 0);
    }

    public void trimSpace(char[] cbuff, int startAt) {
        int start;
        int end;
        int total = cbuff.length;
        for (end = total - 1; end > -1 && this.isSpace(cbuff[end]); --end) {
        }
        for (start = startAt; start < end && this.isSpace(cbuff[start]); ++start) {
        }
        if (start > startAt || end < total - 1) {
            int i;
            int n = startAt;
            for (i = start; i <= end; ++i) {
                cbuff[n++] = cbuff[i];
            }
            for (i = end + 1; i < total; ++i) {
                cbuff[n++] = '\u0000';
            }
        }
    }

    public boolean isSpace(int c) {
        if (c == 32) {
            return true;
        }
        if (c == 10) {
            return true;
        }
        if (c == 13) {
            return true;
        }
        return c == 9;
    }

    public boolean isObject() {
        return this.mKeyword.compareToIgnoreCase("OBJECT") == 0;
    }

    public boolean parseValue(char[] cbuff, int startAt) throws PDSException {
        char c = '\u0000';
        char quote = ' ';
        boolean inQuote = false;
        boolean inComment = false;
        boolean inUnits = false;
        boolean inList = false;
        int maxValBuff = 8192;
        char[] valBuff = new char[maxValBuff];
        int valN = 0;
        inQuote = false;
        inUnits = false;
        this.mValue.clear();
        if (this.strlen(cbuff) <= startAt || startAt >= this.strlen(cbuff)) {
            throw new PDSException("Empty value at line " + this.mLineCount);
        }
        PDSValue value = new PDSValue();
        this.mValue.add(value);
        if (cbuff[startAt] == '\"' && cbuff[startAt + this.strlen(cbuff, startAt) - 1] == '\"') {
            value.mValue = new String(cbuff, startAt + 1, this.strlen(cbuff, startAt) - 2);
            value.mType = 1;
            return true;
        }
        valN = 0;
        for (int i = startAt; i < cbuff.length && (c = cbuff[i]) != '\u0000'; ++i) {
            if (inQuote && c == quote) {
                inQuote = false;
                quote = ' ';
                continue;
            }
            if (!inQuote && this.isSpace(c)) continue;
            if (!(inQuote || c != '\"' && c != '\'')) {
                inQuote = true;
                if (c == '\"') {
                    quote = '\"';
                    value.mType = 1;
                }
                if (c != 39) continue;
                quote = '\'';
                value.mType = 2;
                continue;
            }
            if (inQuote) {
                if (valN >= maxValBuff) continue;
                valBuff[valN++] = c;
                continue;
            }
            if (c == '{' || c == '(') {
                if (inList) {
                    throw new PDSException("Syntax error - list in list - at line: " + this.mLineCount);
                }
                switch (c) {
                    case '{': {
                        this.mType = 1;
                        break;
                    }
                    case '(': {
                        this.mType = 2;
                    }
                }
                inList = true;
                continue;
            }
            if (c == '}' || c == ')') {
                if (!inList) {
                    throw new PDSException("Syntax error - end of list without start of list - at line: " + this.mLineCount + new String(cbuff));
                }
                inList = false;
                continue;
            }
            if (c == '<') {
                inUnits = true;
                continue;
            }
            if (c == '>') {
                inUnits = false;
                continue;
            }
            if (!inUnits && c == ',') {
                value.mValue = new String(valBuff, 0, valN);
                valN = 0;
                value = new PDSValue();
                this.mValue.add(value);
                continue;
            }
            if (inUnits) {
                value.mUnits = value.mUnits + c;
                continue;
            }
            if (valN >= maxValBuff) continue;
            valBuff[valN++] = c;
        }
        if (valN > 0) {
            value.mValue = new String(valBuff, 0, valN);
        }
        return true;
    }

    public boolean setValue(String buffer) throws PDSException {
        return this.setValue(buffer, 0);
    }

    public boolean setValue(String buffer, int type) throws PDSException {
        this.mValue.clear();
        PDSValue value = new PDSValue();
        value.mValue = buffer;
        value.mType = type;
        this.mValue.add(value);
        return true;
    }

    public boolean parseValue(String buffer) throws PDSException {
        int c = 0;
        int quote = 32;
        boolean inQuote = false;
        boolean inComment = false;
        boolean inUnits = false;
        inQuote = false;
        inUnits = false;
        this.mValue.clear();
        if (buffer.length() == 0) {
            throw new PDSException("Empty value at line " + this.mLineCount);
        }
        PDSValue value = new PDSValue();
        this.mValue.add(value);
        c = buffer.charAt(0);
        switch (c) {
            case 123: {
                this.mType = 1;
                break;
            }
            case 40: {
                this.mType = 2;
                break;
            }
            default: {
                this.mType = 0;
            }
        }
        for (int i = 0; i < buffer.length() && (c = buffer.charAt(i)) != 0; ++i) {
            if (inQuote && c == quote) {
                inQuote = false;
                quote = 32;
                continue;
            }
            if (!inQuote && Character.isWhitespace((char)c)) continue;
            if (!(inQuote || c != 34 && c != 39)) {
                inQuote = true;
                if (c == 34) {
                    quote = 34;
                    value.mType = 1;
                }
                if (c != 39) continue;
                quote = 39;
                value.mType = 2;
                continue;
            }
            if (inQuote) {
                value.mValue = value.mValue + (char)c;
                continue;
            }
            if (c == 123 || c == 40 || c == 125 || c == 41) continue;
            if (c == 60) {
                inUnits = true;
                continue;
            }
            if (c == 62) {
                inUnits = false;
                continue;
            }
            if (!inUnits && c == 44) {
                value = new PDSValue();
                this.mValue.add(value);
                continue;
            }
            if (inUnits) {
                value.mUnits = value.mUnits + (char)c;
                continue;
            }
            value.mValue = value.mValue + (char)c;
        }
        return true;
    }

    public int valueSize() {
        return this.mValue.size();
    }

    public String value(int index) {
        if (index < 0 || index >= this.mValue.size()) {
            return "";
        }
        PDSValue value = (PDSValue)this.mValue.get(index);
        return value.mValue;
    }

    public String units(int index) {
        if (index < 0 || index >= this.mValue.size()) {
            return "";
        }
        PDSValue value = (PDSValue)this.mValue.get(index);
        return value.mUnits;
    }

    public PDSElement copy() {
        PDSElement element = new PDSElement();
        element.mComment = this.mComment;
        element.mKeyword = this.mKeyword;
        element.mRaw = this.mRaw;
        element.mType = this.mType;
        element.mValue = this.mValue;
        return element;
    }

    public void print(int indent, int equal, int level) {
        this.print(System.out, indent, equal, level);
    }

    public void print(PrintStream out, int indent, int equal, int level) {
        int n;
        int realIndent = 0;
        String newline = "\r\n";
        switch (this.mType) {
            case 3: {
                out.print(newline);
                return;
            }
            case 4: {
                out.print("/*" + this.mComment + "*/" + newline);
                return;
            }
        }
        if (this.mKeyword.length() != 0) {
            realIndent = indent * level;
            this.printSpaces(out, realIndent);
            out.print(this.mKeyword);
        }
        if ((n = this.mValue.size()) != 0) {
            int k = equal - this.mKeyword.length() - realIndent;
            if (k < 0) {
                k = 1;
            }
            this.printSpaces(out, k);
            out.print("= ");
            int col = equal + 2;
            if (n > 1) {
                switch (this.mType) {
                    case 1: {
                        out.print("{");
                        ++col;
                        break;
                    }
                    case 2: {
                        out.print("(");
                        ++col;
                    }
                }
            }
            boolean checkWrap = true;
            for (int i = 0; i < n; ++i) {
                PDSValue value = (PDSValue)this.mValue.get(i);
                if (i != 0) {
                    out.print(", ");
                    col += 2;
                }
                if ((checkWrap = this.mType != 0 || !value.isQuoted()) && col + value.length() > this.mMaxLength) {
                    out.print("\r\n");
                    col = equal + 2;
                    this.printSpaces(out, col);
                }
                col += value.length();
                value.print(out, equal + 2, 4, this.mMaxLength);
                checkWrap = true;
            }
            if (n > 1) {
                switch (this.mType) {
                    case 1: {
                        out.print("}");
                        break;
                    }
                    case 2: {
                        out.print(")");
                    }
                }
            }
        }
        if (this.mComment.length() > 0) {
            if (this.mKeyword.length() > 0) {
                out.print(" ");
            }
            out.print("/*" + this.mComment + "*/");
        }
        out.print(newline);
    }

    public String valueString() {
        return this.valueString(false, false);
    }

    public String valueString(boolean plain) {
        return this.valueString(plain, true);
    }

    public String valueString(boolean plain, boolean odl) {
        String buffer = "";
        int n = this.mValue.size();
        if (n != 0) {
            for (int i = 0; i < n; ++i) {
                if (i != 0) {
                    buffer = buffer + ", ";
                }
                PDSValue value = (PDSValue)this.mValue.get(i);
                buffer = buffer + value.formatValue(plain);
            }
            if (n > 1 && odl) {
                switch (this.mType) {
                    case 1: {
                        buffer = "{" + buffer + "}";
                        break;
                    }
                    case 2: {
                        buffer = "(" + buffer + ")";
                    }
                }
            }
        }
        return buffer;
    }

    public void dump(PrintStream out) {
        out.println("Keyword: " + this.mKeyword);
        out.println("Line Count: " + this.mLineCount);
        out.println("Type: " + this.mType);
        out.println("Comment: " + this.mComment);
        out.println("Raw line: " + this.mRaw);
        out.println("--- Parsed values ---");
        out.println("Number of values: " + this.mValue.size());
        for (int i = 0; i < this.mValue.size(); ++i) {
            PDSValue value = (PDSValue)this.mValue.get(i);
            value.dump(out);
        }
    }

    public void printSpaces(PrintStream out, int count) {
        for (int i = 0; i < count; ++i) {
            out.print(" ");
        }
    }

    public String toString() {
        if (this.mType == 3) {
            return "<blank line>";
        }
        if (this.mType == 4) {
            return this.mComment;
        }
        if (this.mValue.size() > 1) {
            return this.mKeyword + " = (" + this.value(0) + ", ...)";
        }
        if (this.mValue.size() == 1) {
            return this.mKeyword + " = " + this.value(0);
        }
        return this.mKeyword + " = <blank>";
    }
}

