/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.pds;

import java.io.ByteArrayOutputStream;
import java.net.URL;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.autoplot.datasource.URISplit;
import org.autoplot.pds.DocumentUtil;
import org.autoplot.pds.FilePointer;
import org.autoplot.pds.Pds3DataSource;
import org.das2.util.LoggerManager;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.XML;
import org.w3c.dom.Node;

public class PDS3DataObject {
    private static final Logger logger = LoggerManager.getLogger((String)"apdss.pds");
    private String name;
    private String uri;
    private FilePointer filePointer;
    private int recordBytes;
    private int rowBytes;
    private int rowPrefixBytes;
    private int rowSuffixBytes;
    private int rows;
    private String interchangeFormat;
    private String dataType;
    private int startByte;
    private int items;
    private int itemBytes;
    private int bytes;
    private String dims;
    private double validMinimum;
    private double validMaximum;
    private double missingConstant;
    private String unit;
    private String description;
    private int fieldNumber;
    private int columnNumber;
    JSONObject labelJSONObject;
    JSONObject columnJSONObject;
    JSONObject tableJSONObject;

    public PDS3DataObject(Node label, Node table, Node column) {
        try {
            JSONObject j;
            JSONObject jtable;
            this.labelJSONObject = PDS3DataObject.toJSONObject(label);
            this.tableJSONObject = jtable = PDS3DataObject.toJSONObject(table);
            this.interchangeFormat = jtable.optString("INTERCHANGE_FORMAT", "ASCII");
            this.rowBytes = jtable.getInt("ROW_BYTES");
            this.recordBytes = this.labelJSONObject.optInt("RECORD_BYTES", -1);
            this.rowPrefixBytes = jtable.optInt("ROW_PREFIX_BYTES", 0);
            this.rowSuffixBytes = jtable.optInt("ROW_SUFFIX_BYTES", 0);
            this.rows = jtable.optInt("ROWS", -1);
            this.columnJSONObject = j = PDS3DataObject.toJSONObject(column);
            this.items = j.has("ITEMS") ? j.getInt("ITEMS") : -1;
            this.startByte = j.optInt("START_BYTE", 0);
            if (this.items > 1) {
                this.bytes = j.optInt("BYTES", -1);
                if (this.bytes > -1) {
                    if (this.bytes > this.items) {
                        this.bytes /= this.items;
                    } else {
                        logger.fine("bytes don't appear to be needing normalization.");
                    }
                }
            } else {
                this.bytes = j.optInt("BYTES", -1);
            }
            if (column.getNodeName().equals("CONTAINER")) {
                XPathFactory factory = XPathFactory.newInstance();
                XPath xpath = factory.newXPath();
                Node column1 = (Node)xpath.evaluate("COLUMN", column, XPathConstants.NODE);
                if (column1 == null) {
                    column1 = (Node)xpath.evaluate("CONTAINER/COLUMN", column, XPathConstants.NODE);
                    String dim0 = (String)xpath.evaluate("REPETITIONS/text()", column, XPathConstants.STRING);
                    String dim1 = (String)xpath.evaluate("CONTAINER/REPETITIONS/text()", column, XPathConstants.STRING);
                    this.dims = "[" + dim0 + "," + dim1 + "]";
                    this.itemBytes = this.bytes / Integer.parseInt(dim1);
                } else {
                    String sitems = (String)xpath.evaluate("REPETITIONS/text()", column, XPathConstants.STRING);
                    this.dims = "[" + sitems + "]";
                    this.itemBytes = this.bytes / Integer.parseInt(sitems);
                }
                j = PDS3DataObject.toJSONObject(column1);
            } else if (this.items > -1) {
                this.itemBytes = j.optInt("ITEM_BYTES", -1);
                if (this.itemBytes == -1 && this.bytes > this.items) {
                    this.itemBytes = this.bytes / this.items;
                }
            } else {
                this.itemBytes = this.bytes;
            }
            this.dataType = j.optString("DATA_TYPE", "");
            this.fieldNumber = j.optInt("FIELD_NUMBER", -1);
            if (this.tableJSONObject.has("FIELD")) {
                JSONArray fields = this.tableJSONObject.getJSONArray("FIELD");
                int acolumnNumber = 1;
                for (int i = 0; i < fields.length() && this.fieldNumber != i + 1; ++i) {
                    JSONObject field = fields.getJSONObject(i);
                    if (field.has("ITEMS")) {
                        acolumnNumber += field.getInt("ITEMS");
                        continue;
                    }
                    ++acolumnNumber;
                }
                this.columnNumber = acolumnNumber;
            } else {
                this.columnNumber = this.fieldNumber;
            }
            this.unit = j.optString("UNIT", "");
            if (this.unit.trim().equals("") && j.optString("NAME", "").equals("UTC")) {
                this.unit = "UTC";
            }
            this.validMaximum = j.optDouble("VALID_MAXIMUM", Double.POSITIVE_INFINITY);
            this.validMinimum = j.optDouble("VALID_MINIMUM", Double.NEGATIVE_INFINITY);
            this.missingConstant = j.optDouble("MISSING_CONSTANT", Double.NaN);
            if (Double.isNaN(this.missingConstant) && j.has("MISSING")) {
                logger.fine("MISSING used instead of MISSING_CONSTANT, which is okay");
                this.missingConstant = j.optDouble("MISSING", this.missingConstant);
            }
            if (Double.isNaN(this.missingConstant)) {
                this.missingConstant = j.optDouble("INVALID_CONSTANT", Double.NaN);
            }
            this.description = DocumentUtil.cleanDescriptionString(j.optString("DESCRIPTION", ""));
        }
        catch (TransformerException | JSONException ex) {
            throw new IllegalArgumentException("unable to run", ex);
        }
        catch (XPathExpressionException ex) {
            Logger.getLogger(PDS3DataObject.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    protected static JSONObject toJSONObject(Node n) throws TransformerConfigurationException, TransformerException, JSONException {
        TransformerFactory transfac = TransformerFactory.newInstance();
        transfac.setAttribute("indent-number", 4);
        Transformer trans = transfac.newTransformer();
        trans.setOutputProperty("omit-xml-declaration", "yes");
        trans.setOutputProperty("indent", "yes");
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        StreamResult streamResult = new StreamResult(out);
        DOMSource source = new DOMSource(n);
        trans.transform(source, streamResult);
        JSONObject result = XML.toJSONObject((String)out.toString());
        return result.getJSONObject(n.getNodeName());
    }

    public String resolveUri(URL resource) {
        if (this.interchangeFormat.equals("ASCII") && this.fieldNumber > -1) {
            return this.getAsciiUri(resource);
        }
        return this.getBinaryUri(resource);
    }

    private String getAsciiUri(URL resource) {
        LinkedHashMap<String, String> args = new LinkedHashMap<String, String>();
        if (this.filePointer != null) {
            switch (this.filePointer.getOffsetUnits()) {
                case LINES: {
                    args.put("skipLines", String.valueOf(this.filePointer.getOffset()));
                    break;
                }
                case BYTES: {
                    int offsetBytes = this.filePointer.getOffset();
                    offsetBytes = (int)((double)offsetBytes * 0.98);
                    args.put("skipBytes", String.valueOf(offsetBytes));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unsupported file pointer");
                }
            }
        }
        if (this.items == 1 || this.items == -1) {
            args.put("column", String.valueOf(this.columnNumber - 1));
        } else {
            args.put("column", String.format("%d-%d", this.columnNumber - 1, this.columnNumber - 1 + this.items - 1));
        }
        return "vap+txt:" + resource.toString() + "?" + URISplit.formatParams(args);
    }

    private String getBinaryUri(URL resource) throws IllegalArgumentException {
        LinkedHashMap<String, String> args = new LinkedHashMap<String, String>();
        if (this.recordBytes > -1) {
            args.put("recLength", String.valueOf(this.recordBytes));
        } else {
            args.put("recLength", String.valueOf(this.rowPrefixBytes + this.rowBytes + this.rowSuffixBytes));
        }
        if (Pds3DataSource.isTimeTag(this.dataType, this.unit)) {
            args.put("type", "time" + this.bytes);
        } else if (this.dataType.equals("ASCII_REAL")) {
            args.put("type", "ascii" + this.bytes);
        } else if (this.dataType.equals("ASCII_INTEGER")) {
            args.put("type", "ascii" + this.bytes);
        } else if (this.dataType.equals("PC_REAL")) {
            args.put("type", "float");
            args.put("byteOrder", "little");
        } else if (this.dataType.equals("SUN_REAL") || this.dataType.equals("IEEE_REAL") || this.dataType.equals("FLOAT") || this.dataType.equals("MAC_REAL")) {
            args.put("type", "float");
            args.put("byteOrder", "big");
        } else if (this.dataType.equals("LSB_UNSIGNED_INTEGER")) {
            switch (this.itemBytes) {
                case 1: {
                    args.put("type", "ubyte");
                    break;
                }
                case 2: {
                    args.put("type", "ushort");
                    break;
                }
                case 4: {
                    args.put("type", "uint");
                    break;
                }
                case 8: {
                    args.put("type", "ulong");
                    break;
                }
                default: {
                    throw new IllegalArgumentException("PDS label has LSB_UNSIGNED_INTEGER with " + this.bytes + " bytes, must be 2, 4, or 8");
                }
            }
            args.put("byteOrder", "little");
        } else if (this.dataType.equals("LSB_INTEGER")) {
            switch (this.itemBytes) {
                case 1: {
                    args.put("type", "ubyte");
                    break;
                }
                case 2: {
                    args.put("type", "short");
                    break;
                }
                case 4: {
                    args.put("type", "int");
                    break;
                }
                case 8: {
                    args.put("type", "long");
                    break;
                }
                default: {
                    throw new IllegalArgumentException("PDS label has LSB_INTEGER with " + this.bytes + " bytes, must be 2, 4, or 8");
                }
            }
            args.put("byteOrder", "little");
        } else if (this.dataType.equals("MSB_UNSIGNED_INTEGER")) {
            switch (this.itemBytes) {
                case 1: {
                    args.put("type", "ubyte");
                    break;
                }
                case 2: {
                    args.put("type", "ushort");
                    break;
                }
                case 4: {
                    args.put("type", "uint");
                    break;
                }
                case 8: {
                    args.put("type", "ulong");
                    break;
                }
                default: {
                    throw new IllegalArgumentException("PDS label has MSB_UNSIGNED_INTEGER with " + this.bytes + " bytes, must be 2, 4, or 8");
                }
            }
            args.put("byteOrder", "big");
        } else if (this.dataType.equals("MSB_INTEGER") || this.dataType.equals("INTEGER")) {
            switch (this.itemBytes) {
                case 1: {
                    args.put("type", "ubyte");
                    break;
                }
                case 2: {
                    args.put("type", "short");
                    break;
                }
                case 4: {
                    args.put("type", "int");
                    break;
                }
                case 8: {
                    args.put("type", "long");
                    break;
                }
                default: {
                    throw new IllegalArgumentException("PDS label has MSB_INTEGER with " + this.bytes + " bytes, must be 2, 4, or 8");
                }
            }
            args.put("byteOrder", "big");
        } else if (this.dataType.equals("UNSIGNED_INTEGER") && this.bytes == 1) {
            args.put("type", "ubyte");
        } else if (this.dataType.equals("UNSIGNED_INTEGER")) {
            args.put("type", "ubyte");
            args.put("dims", "[" + this.bytes + "]");
        } else if (this.dataType.equals("LSB_BIT_STRING")) {
            args.put("type", "ubyte");
            args.put("dims", "[" + this.bytes + "]");
        } else if (this.dataType.equals("CHARACTER")) {
            args.put("type", "ascii" + this.bytes);
            this.unit = "nominal";
        } else if (this.dataType.equals("BIT_STRING")) {
            args.put("type", "ubyte");
            args.put("dims", "[" + this.bytes + "]");
        } else {
            throw new IllegalArgumentException("unsupported type:" + this.dataType);
        }
        if (this.filePointer != null) {
            switch (this.filePointer.getOffsetUnits()) {
                case LINES: {
                    args.put("byteOffset", String.valueOf(this.filePointer.getOffset() * this.recordBytes));
                    break;
                }
                case BYTES: {
                    args.put("byteOffset", String.valueOf(this.filePointer.getOffset()));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Hmmm, uncoded case.  Contact Jeremy Faden.");
                }
            }
        }
        args.put("recOffset", String.valueOf(this.startByte - 1));
        if (this.missingConstant != Double.NaN) {
            args.put("fillValue", String.valueOf(this.missingConstant));
        }
        if (this.validMaximum != Double.POSITIVE_INFINITY) {
            args.put("validMax", String.valueOf(this.validMaximum));
        }
        if (this.validMinimum != Double.NEGATIVE_INFINITY) {
            args.put("validMin", String.valueOf(this.validMinimum));
        }
        if (this.unit.trim().length() != 0 && !((String)args.get("type")).startsWith("time")) {
            args.put("units", this.unit);
        }
        if (this.items > -1) {
            args.put("dims", "[" + this.items + "]");
        } else if (this.dims != null) {
            args.put("dims", this.dims);
        }
        return "vap+bin:" + resource.toString() + "?" + URISplit.formatParams(args);
    }

    public String getDescription() {
        return this.description;
    }

    private Map<String, Object> getMetadata(JSONObject jo) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        Iterator it = jo.keys();
        while (it.hasNext()) {
            String k = (String)it.next();
            try {
                Object v = jo.get(k);
                if (v instanceof JSONObject) {
                    result.put(k, this.getMetadata((JSONObject)v));
                    continue;
                }
                result.put(k, v);
            }
            catch (JSONException jSONException) {}
        }
        return result;
    }

    public Map<String, Object> getMetadata() {
        Map<String, Object> result = this.getMetadata(this.columnJSONObject);
        result.put("_table", this.getMetadata(this.tableJSONObject));
        result.put("_label", this.getMetadata(this.labelJSONObject));
        return result;
    }

    public FilePointer getFilePointer() {
        return this.filePointer;
    }

    public void setFilePointer(FilePointer p) {
        this.filePointer = p;
    }
}

