/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.pds;

import gov.nasa.pds.ppi.label.PDSLabel;
import java.io.File;
import java.io.FileNotFoundException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.autoplot.datasource.AbstractDataSource;
import org.autoplot.datasource.DataSetURI;
import org.autoplot.datasource.DataSource;
import org.autoplot.datasource.URISplit;
import org.autoplot.pds.DocumentUtil;
import org.autoplot.pds.FilePointer;
import org.autoplot.pds.PDS3DataObject;
import org.autoplot.pds.Pds3DataSourceFactory;
import org.das2.qds.MutablePropertyDataSet;
import org.das2.qds.QDataSet;
import org.das2.qds.ops.Ops;
import org.das2.util.LoggerManager;
import org.das2.util.monitor.NullProgressMonitor;
import org.das2.util.monitor.ProgressMonitor;
import org.json.JSONArray;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Pds3DataSource
extends AbstractDataSource {
    private static final Logger logger = LoggerManager.getLogger((String)"apdss.pds");

    public Pds3DataSource(URI uri) {
        super(uri);
    }

    public static boolean isTimeTag(String dataType, String unit) {
        return dataType.equals("DATE") || dataType.equals("TIME") || dataType.equals("CHARACTER") && (unit.equals("UTC") || unit.equals("TIME"));
    }

    public static List<String> seekDependencies(Document doc, List<String> depend) throws XPathExpressionException {
        if (depend.size() == 1) {
            String units;
            Node time;
            String dataType;
            ArrayList<String> result = new ArrayList<String>();
            XPathFactory factory = XPathFactory.newInstance();
            XPath xpath = factory.newXPath();
            String name = depend.get(0);
            NodeList oo = (NodeList)xpath.evaluate("//LABEL/TABLE/COLUMN[NAME='" + name + "']", doc, XPathConstants.NODESET);
            if (oo.getLength() == 1 && Pds3DataSource.isTimeTag(dataType = (String)xpath.evaluate("DATA_TYPE/text()", time = (Node)xpath.evaluate("//LABEL/TABLE/COLUMN[1]", doc, XPathConstants.NODE), XPathConstants.STRING), units = (String)xpath.evaluate("UNIT/text()", time, XPathConstants.STRING))) {
                String timeName = (String)xpath.evaluate("NAME/text()", time, XPathConstants.STRING);
                result.add(timeName);
                result.add(name);
                depend = result;
            }
        }
        return depend;
    }

    private static Map<String, Object> transferAndCleanMeta(Iterator<Map.Entry<String, Object>> entries, Map<String, Object> result) throws Exception {
        while (entries.hasNext()) {
            Map.Entry<String, Object> entry = entries.next();
            String key = entry.getKey();
            LinkedHashMap<String, Object> value = entry.getValue();
            if (value instanceof Map) {
                LinkedHashMap<String, Object> childResult = new LinkedHashMap<String, Object>();
                Pds3DataSource.transferAndCleanMeta(((Map)value).entrySet().iterator(), childResult);
                value = childResult;
            } else {
                if (key.equals("DESCRIPTION") && value instanceof String) {
                    value = DocumentUtil.cleanString((String)((Object)value));
                }
                if (key.equals("CONTAINER") && value instanceof JSONArray) {
                    JSONArray ja = (JSONArray)value;
                    DocumentUtil.cleanJSONArray(ja);
                }
            }
            result.put(key, value);
        }
        return result;
    }

    public Map<String, Object> getMetadata(ProgressMonitor mon) throws Exception {
        URISplit split = URISplit.parse((String)this.getURI());
        String lbl = split.file;
        PDSLabel label = new PDSLabel();
        File f = this.getFile(split.resourceUri, mon);
        if (!label.parse(f.getPath())) {
            throw new IllegalArgumentException("unable to use file " + lbl);
        }
        Document doc = label.getDocument();
        Map<String, Object> metadata = DocumentUtil.convertDocumentToMap(doc);
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        String name = (String)URISplit.parseParams((String)split.params).get("arg_0");
        PDS3DataObject obj = Pds3DataSourceFactory.getDataObjectPds3(split.resourceUri.toURL(), name);
        Pds3DataSource.transferAndCleanMeta(obj.getMetadata().entrySet().iterator(), result);
        result.put("_label", metadata.get("LABEL"));
        return result;
    }

    private String toLowerCase(String s) {
        int i = s.lastIndexOf("/");
        if (i == -1) {
            return s;
        }
        return s.substring(0, i) + s.substring(i).toLowerCase();
    }

    private String toUpperCase(String s) {
        int i = s.lastIndexOf("/");
        if (i == -1) {
            return s;
        }
        return s.substring(0, i) + s.substring(i).toUpperCase();
    }

    public QDataSet getDataSet(ProgressMonitor mon) throws Exception {
        FilePointer fp;
        String Z;
        String Y;
        String name = this.getParam("arg_0", "");
        URISplit split = URISplit.parse((String)this.getURI());
        URL labelUrl = split.resourceUri.toURL();
        File xmlfile = DataSetURI.getFile((URL)labelUrl, (ProgressMonitor)new NullProgressMonitor());
        Document doc = Pds3DataSourceFactory.getDocumentWithImports(labelUrl);
        PDSLabel label = new PDSLabel();
        if (!label.parse(xmlfile.getPath())) {
            throw new IllegalArgumentException("unable to use file " + labelUrl);
        }
        List<String> names = new ArrayList<String>();
        String X = this.getParam("X", "");
        if (!X.equals("")) {
            names.add(X);
        }
        if (!(Y = this.getParam("Y", "")).equals("")) {
            names.add(Y);
        }
        if (!(Z = this.getParam("Z", "")).equals("")) {
            names.add(Z);
        }
        if (!name.equals("")) {
            names.add(name);
        }
        names = Pds3DataSource.seekDependencies(doc, names);
        QDataSet result = null;
        QDataSet[] results = new QDataSet[names.size()];
        XPathFactory factory = XPathFactory.newInstance();
        XPath xpath = factory.newXPath();
        String datafile = (String)xpath.evaluate("/LABEL/POINTER[@object=\"ASCII_TABLE\"]", doc, XPathConstants.STRING);
        if (datafile.length() == 0) {
            datafile = (String)xpath.evaluate("/LABEL/POINTER[@object=\"BINARY_TABLE\"]", doc, XPathConstants.STRING);
        }
        if (datafile.length() == 0) {
            datafile = (String)xpath.evaluate("/LABEL/POINTER[@object=\"TABLE\"]", doc, XPathConstants.STRING);
        }
        if (datafile.length() == 0) {
            datafile = (String)xpath.evaluate("/LABEL/FILE/POINTER[@object='SPREADSHEET']/text()", doc, XPathConstants.STRING);
        }
        if (datafile.length() == 0) {
            datafile = (String)xpath.evaluate("/LABEL/POINTER[@object='SPREADSHEET']/text()", doc, XPathConstants.STRING);
        }
        if (!datafile.equals("")) {
            fp = new FilePointer(labelUrl, datafile);
        } else {
            String l = labelUrl.getFile();
            int i1 = l.lastIndexOf("/");
            l = l.substring(i1 + 1).replace(".LBL", ".DAT");
            fp = new FilePointer(labelUrl, l);
        }
        for (int i = 0; i < names.size(); ++i) {
            File f;
            if (results[i] != null) continue;
            name = names.get(i);
            PDS3DataObject obj = Pds3DataSourceFactory.getDataObjectPds3(labelUrl, name);
            try {
                f = DataSetURI.getFile((URL)fp.getUrl(), (ProgressMonitor)new NullProgressMonitor());
            }
            catch (FileNotFoundException ex) {
                URL furl = fp.getUrl();
                String ff = furl.getFile();
                if (Character.isUpperCase(ff.charAt(ff.length() - 1))) {
                    ff = this.toLowerCase(ff);
                    URL lowerCaseUrl = new URL(furl.getProtocol(), furl.getHost(), ff);
                    f = DataSetURI.getFile((URL)lowerCaseUrl, (ProgressMonitor)new NullProgressMonitor());
                    fp.setUrl(lowerCaseUrl);
                }
                ff = this.toUpperCase(ff);
                URL upperCaseURL = new URL(furl.getProtocol(), furl.getHost(), ff);
                f = DataSetURI.getFile((URL)upperCaseURL, (ProgressMonitor)new NullProgressMonitor());
                fp.setUrl(upperCaseURL);
            }
            String delegateUri = obj.resolveUri(fp.getUrl());
            logger.log(Level.FINE, "loading PDS data using delegate URI {0}", delegateUri);
            DataSource delegate = DataSetURI.getDataSource((String)delegateUri);
            QDataSet ds = delegate.getDataSet(mon.getSubtaskMonitor("dataset " + i));
            ds = Ops.putProperty((QDataSet)ds, (String)"NAME", (Object)Ops.safeName((String)name));
            ds = Ops.putProperty((QDataSet)ds, (String)"LABEL", (Object)name);
            ds = Ops.putProperty((QDataSet)ds, (String)"DESCRIPTION", (Object)DocumentUtil.cleanDescriptionString(obj.getDescription()));
            HashMap<String, String> user = new HashMap<String, String>();
            user.put("delegate_uri", delegateUri);
            results[i] = ds = Ops.putProperty((QDataSet)ds, (String)"USER_PROPERTIES", user);
        }
        if (result == null) {
            switch (results.length) {
                case 1: {
                    result = results[0];
                    break;
                }
                case 2: {
                    result = Ops.link((QDataSet)results[0], (QDataSet)results[1]);
                    break;
                }
                case 3: {
                    try {
                        result = Ops.link((QDataSet)results[0], (QDataSet)results[1], (QDataSet)results[2]);
                    }
                    catch (Exception ex) {
                        ((MutablePropertyDataSet)results[2]).putProperty("DEPEND_1", null);
                        result = results[2];
                    }
                    break;
                }
            }
        }
        if (result instanceof MutablePropertyDataSet) {
            ((MutablePropertyDataSet)result).makeImmutable();
        }
        return result;
    }
}

