/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.pds;

import gov.nasa.pds.ppi.label.PDSException;
import gov.nasa.pds.ppi.label.PDSLabel;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.autoplot.datasource.AbstractDataSourceFactory;
import org.autoplot.datasource.CompletionContext;
import org.autoplot.datasource.DataSetURI;
import org.autoplot.datasource.DataSource;
import org.autoplot.datasource.DataSourceFactory;
import org.autoplot.datasource.URISplit;
import org.autoplot.pds.FilePointer;
import org.autoplot.pds.PDS3DataObject;
import org.autoplot.pds.Pds3DataSource;
import org.autoplot.pds.PdsDataSource;
import org.das2.datum.LoggerManager;
import org.das2.util.filesystem.FileSystem;
import org.das2.util.monitor.NullProgressMonitor;
import org.das2.util.monitor.ProgressMonitor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class Pds3DataSourceFactory
extends AbstractDataSourceFactory {
    private static Logger logger = LoggerManager.getLogger((String)"apdss.pds");
    private static WeakHashMap<String, Document> documents = new WeakHashMap();
    private static WeakHashMap<String, Long> documentBirthMilli = new WeakHashMap();

    public DataSource getDataSource(URI uri) throws Exception {
        URISplit split = URISplit.parse((URI)uri);
        if (split.file.toLowerCase().endsWith(".lbl")) {
            return new Pds3DataSource(uri);
        }
        return new PdsDataSource(uri);
    }

    public static PDS3DataObject getDataObjectPds3(URL url, String name) throws IOException, PDSException, XPathExpressionException {
        String pointer;
        Document doc = Pds3DataSourceFactory.getDocumentWithImports(url);
        XPathFactory factory = XPathFactory.newInstance();
        XPath xpath = factory.newXPath();
        Node table = (Node)xpath.evaluate(String.format("/LABEL/TABLE[1]", name), doc, XPathConstants.NODE);
        Node column = (Node)xpath.evaluate(String.format("/LABEL/TABLE[1]/COLUMN[NAME='%s']", name), doc, XPathConstants.NODE);
        FilePointer p = null;
        if (table == null || column == null) {
            table = (Node)xpath.evaluate(String.format("/LABEL/*[contains(name(),'_TABLE')][1]", name), doc, XPathConstants.NODE);
            column = (Node)xpath.evaluate(String.format("/LABEL/*[contains(name(),'_TABLE')]/COLUMN[NAME='%s']", name), doc, XPathConstants.NODE);
            if (table != null) {
                String tableName = table.getNodeName();
                String pointer2 = (String)xpath.evaluate("/LABEL/POINTER[@object='" + tableName + "']/text()", doc, XPathConstants.STRING);
                if (pointer2 != null && pointer2.length() > 0) {
                    p = new FilePointer(url, pointer2);
                }
            }
        }
        if (table == null || column == null) {
            table = (Node)xpath.evaluate(String.format("/LABEL/BINARY_TABLE[1]", name), doc, XPathConstants.NODE);
            column = (Node)xpath.evaluate(String.format("/LABEL/BINARY_TABLE[1]/COLUMN[NAME='%s']", name), doc, XPathConstants.NODE);
            if (table != null && (pointer = (String)xpath.evaluate("/LABEL/POINTER[@object='BINARY_TABLE']/text()", doc, XPathConstants.STRING)) != null && pointer.length() > 0) {
                p = new FilePointer(url, pointer);
            }
        }
        if (table == null || column == null) {
            table = (Node)xpath.evaluate(String.format("/LABEL/ASCII_TABLE[1]", name), doc, XPathConstants.NODE);
            column = (Node)xpath.evaluate(String.format("/LABEL/ASCII_TABLE[1]/COLUMN[NAME='%s']", name), doc, XPathConstants.NODE);
            if (table != null && (pointer = (String)xpath.evaluate("/LABEL/POINTER[@object='ASCII_TABLE']/text()", doc, XPathConstants.STRING)) != null && pointer.length() > 0) {
                p = new FilePointer(url, pointer);
            }
        }
        if (table == null || column == null) {
            table = (Node)xpath.evaluate(String.format("/LABEL/TIME_SERIES[1]", name), doc, XPathConstants.NODE);
            column = (Node)xpath.evaluate(String.format("/LABEL/TIME_SERIES[1]/COLUMN[NAME='%s']", name), doc, XPathConstants.NODE);
            if (table != null && (pointer = (String)xpath.evaluate("/LABEL/POINTER[@object='TIME_SERIES']/text()", doc, XPathConstants.STRING)) != null && pointer.length() > 0) {
                p = new FilePointer(url, pointer);
            }
        }
        if (table == null || column == null) {
            table = (Node)xpath.evaluate(String.format("/LABEL/FILE/SPREADSHEET", new Object[0]), doc, XPathConstants.NODE);
            column = (Node)xpath.evaluate(String.format("/LABEL/FILE/SPREADSHEET/FIELD[NAME='%s']", name), doc, XPathConstants.NODE);
            if (table != null && (pointer = (String)xpath.evaluate("/LABEL/FILE/POINTER[@object='SPREADSHEET']/text()", doc, XPathConstants.STRING)) != null && pointer.length() > 0) {
                p = new FilePointer(url, pointer);
            }
        }
        if (table == null || column == null) {
            table = (Node)xpath.evaluate(String.format("/LABEL/SPREADSHEET", new Object[0]), doc, XPathConstants.NODE);
            column = (Node)xpath.evaluate(String.format("/LABEL/SPREADSHEET/FIELD[NAME='%s']", name), doc, XPathConstants.NODE);
            if (table != null && (pointer = (String)xpath.evaluate("/LABEL/POINTER[@object='SPREADSHEET']/text()", doc, XPathConstants.STRING)) != null && pointer.length() > 0) {
                p = new FilePointer(url, pointer);
            }
        }
        if (table == null) {
            table = (Node)xpath.evaluate(String.format("/LABEL/TABLE[1]", name), doc, XPathConstants.NODE);
            if (table == null) {
                throw new IllegalArgumentException("Unable to find table");
            }
            column = (Node)xpath.evaluate(String.format("/LABEL/TABLE[1]/CONTAINER/COLUMN[NAME='%s']", name), doc, XPathConstants.NODE);
            if (column == null) {
                column = (Node)xpath.evaluate(String.format("/LABEL/TABLE[1]/CONTAINER/CONTAINER/COLUMN[NAME='%s']", name), doc, XPathConstants.NODE);
                if (column != null) {
                    column = column.getParentNode().getParentNode();
                }
            } else {
                column = column.getParentNode();
            }
        }
        if (column == null) {
            throw new IllegalArgumentException("Unable to find column: " + name);
        }
        PDS3DataObject obj = new PDS3DataObject(doc.getDocumentElement(), table, column);
        obj.setFilePointer(p);
        return obj;
    }

    public static URL lowerCaseFile(URL url) {
        try {
            String ss = url.toString();
            int i = ss.lastIndexOf("/");
            URL newURL = new URL(ss.substring(0, i) + ss.substring(i).toLowerCase());
            return newURL;
        }
        catch (MalformedURLException ex) {
            return null;
        }
    }

    public boolean reject(String suri, List<String> problems, ProgressMonitor mon) {
        try {
            FilePointer filePointer;
            URISplit split = URISplit.parse((String)suri);
            LinkedHashMap params = URISplit.parseParams((String)split.params);
            String id = (String)params.get("arg_0");
            if (id == null) {
                id = (String)params.get("id");
            }
            if (id == null) {
                id = (String)params.get("X");
            }
            if (id == null) {
                id = (String)params.get("Y");
            }
            if (id == null) {
                id = (String)params.get("Z");
            }
            File xmlfile = DataSetURI.getFile((URL)split.resourceUri.toURL(), (ProgressMonitor)new NullProgressMonitor());
            try {
                filePointer = Pds3DataSourceFactory.getFileResource(split.resourceUri.toURL(), mon);
            }
            catch (IOException | URISyntaxException | ParserConfigurationException | XPathExpressionException | SAXException ex) {
                problems.add("uri should point to xml or lblx file");
                return true;
            }
            try {
                DataSetURI.getFile((URL)filePointer.getUrl(), (ProgressMonitor)mon);
            }
            catch (FileNotFoundException ex) {
                logger.warning("unable to find the file referenced in the label, looking for lower case filename.");
                URL urlLower = Pds3DataSourceFactory.lowerCaseFile(filePointer.getUrl());
                DataSetURI.getFile((URL)urlLower, (ProgressMonitor)mon);
            }
            if (id == null) {
                return true;
            }
            try {
                Pds3DataSourceFactory.getDataObjectPds3(split.resourceUri.toURL(), id);
                return false;
            }
            catch (Exception ex) {
                problems.add(ex.getMessage());
                return true;
            }
        }
        catch (PDSException | IOException | IllegalArgumentException ex) {
            logger.log(Level.SEVERE, null, ex);
            problems.add(ex.getMessage());
            return true;
        }
    }

    public static Document getDocumentWithImports(URL labelUrl) throws IOException, PDSException {
        return Pds3DataSourceFactory.getDocumentWithImports(labelUrl, 0);
    }

    public static URL identifyRoot(URL location) throws FileSystem.FileSystemOfflineException, UnknownHostException, FileNotFoundException, IOException {
        String[] ffs;
        String p = location.toString();
        int r = p.lastIndexOf("DATA/");
        FileSystem fs = FileSystem.create((String)p.substring(0, r));
        for (String f : ffs = fs.listDirectory("/")) {
            if (!f.equalsIgnoreCase("document")) continue;
            return fs.getRootURI().toURL();
        }
        Pattern patt = Pattern.compile("/cassini-|/clps-|/CO-|/DS1-|/galileo-|/GIO-|/GO-|/go-|/ICE-|/insight-|/JNO-|/juno-|/lp-|/LP-|/LRO-|/lunar-|/M10-|/maven-|/mess-|/messenger-|/MEX-|/MGN-|/mgs-|/MR9|/MSL-|/NEAR-|/NH-|/ODY-|/P10-|/P11-|/pvo-|/radiojove-|/suisei-|/ULY-|/ulysses-|/V15_V16-|/VEGA1-|/VEGA2-|/vex-|/vg1-|/vg2-|/voyager-|/voyager1-|/voyager2-", 2);
        Matcher m = patt.matcher(p);
        if (m.find()) {
            int i2 = p.indexOf("/", m.start() + 1);
            return new URL(p.substring(0, i2));
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Document getDocumentWithImports(URL labelUrl, int depth) throws IOException, PDSException {
        NodeList structures;
        logger.entering("Pds3DataSourceFactory", "getDocumentWithImports", labelUrl);
        String slabelUrl = labelUrl.toString();
        Document doc1 = documents.get(labelUrl.toString());
        if (doc1 != null) {
            WeakHashMap<String, Document> weakHashMap = documents;
            synchronized (weakHashMap) {
                Long birthTime;
                doc1 = documents.get(labelUrl.toString());
                if (doc1 != null && (birthTime = documentBirthMilli.get(slabelUrl)) != null && System.currentTimeMillis() - birthTime < 10000L) {
                    return doc1;
                }
            }
        }
        if (depth > 4) {
            throw new IllegalArgumentException("something has gone terribly wrong, too many nested structures");
        }
        PDSLabel label = new PDSLabel();
        File xmlfile = DataSetURI.getFile((URL)labelUrl, (ProgressMonitor)new NullProgressMonitor());
        if (!label.parse(xmlfile.getPath())) {
            throw new IllegalArgumentException("unable to use file " + labelUrl);
        }
        Document doc = label.getDocument();
        XPathFactory factory = XPathFactory.newInstance();
        XPath xpath = factory.newXPath();
        try {
            structures = (NodeList)xpath.evaluate("/LABEL/*/POINTER[@object=\"STRUCTURE\"]", doc, XPathConstants.NODESET);
            if (structures.getLength() == 0) {
                structures = (NodeList)xpath.evaluate("/LABEL/POINTER[@object=\"STRUCTURE\"]", doc, XPathConstants.NODESET);
            }
        }
        catch (XPathExpressionException ex) {
            throw new RuntimeException(ex);
        }
        for (int i = 0; i < structures.getLength(); ++i) {
            File childfile;
            Node child = structures.item(i);
            Node parent = child.getParentNode();
            URL childUrl = new URL(labelUrl, child.getTextContent());
            try {
                childfile = DataSetURI.getFile((URL)childUrl, (ProgressMonitor)new NullProgressMonitor());
            }
            catch (FileNotFoundException ex) {
                String p = labelUrl.toString();
                int r = p.lastIndexOf("DATA/");
                childUrl = new URL(new URL(p.substring(0, r) + "LABEL/"), child.getTextContent());
                try {
                    childfile = DataSetURI.getFile((URL)childUrl, (ProgressMonitor)new NullProgressMonitor());
                }
                catch (FileNotFoundException ex2) {
                    URL root = Pds3DataSourceFactory.identifyRoot(labelUrl);
                    childUrl = new URL(new URL(root.toString() + "/LABEL/"), child.getTextContent());
                    try {
                        childfile = DataSetURI.getFile((URL)childUrl, (ProgressMonitor)new NullProgressMonitor());
                    }
                    catch (FileNotFoundException ex3) {
                        throw ex;
                    }
                }
            }
            Document doc2 = Pds3DataSourceFactory.getDocumentWithImports(childUrl, depth + 1);
            Element newChild = doc2.getDocumentElement();
            NodeList importKids = newChild.getChildNodes();
            List importK = Pds3DataSourceFactory.removeComments(importKids);
            for (int j = 0; j < importK.size(); ++j) {
                Node kid = (Node)importK.get(j);
                doc.adoptNode(kid);
                parent.insertBefore(kid, child);
            }
        }
        WeakHashMap<String, Document> weakHashMap = documents;
        synchronized (weakHashMap) {
            documents.put(slabelUrl, doc);
            documentBirthMilli.put(slabelUrl, System.currentTimeMillis());
        }
        logger.exiting("Pds3DataSourceFactory", "getDocumentWithImports");
        return doc;
    }

    private String summarizeDescription(String name, String desc) {
        if (desc.length() > name.length() + 6) {
            char nextChar = desc.charAt(name.length() + 6);
            String test = desc.substring(6, name.length() + 6).toLowerCase().replace(" ", "_");
            if (!Character.isAlphabetic(nextChar) && test.equals(name.toLowerCase())) {
                String d = desc.substring(name.length() + 6 + 1).trim();
                if (d.startsWith("<br>")) {
                    d = d.substring(4).trim();
                }
                desc = "<html>" + d;
            }
        }
        int i = desc.indexOf(".");
        int l = desc.length();
        int limit = 86;
        if (i == -1) {
            if (l > limit) {
                i = desc.lastIndexOf(" ", limit);
                if (i == -1) {
                    i = limit;
                }
                desc = desc.substring(0, i) + "...";
            }
        } else if (i > limit) {
            i = desc.lastIndexOf(" ", limit);
            if (i == -1) {
                i = limit;
            }
            desc = desc.substring(0, i) + "...";
        } else {
            desc = desc.substring(0, i + 1);
        }
        desc = String.join((CharSequence)" ", desc.split("[\\s|\\&\\#13\\;]+"));
        return desc;
    }

    private static List appendNodeList(List nl1, NodeList nodeList2) {
        for (int i = 0; i < nodeList2.getLength(); ++i) {
            Node node = nodeList2.item(i);
            Node copiedNode = node.cloneNode(true);
            nl1.add(copiedNode);
        }
        return nl1;
    }

    private static List removeComments(NodeList nodeList2) {
        ArrayList<Node> result = new ArrayList<Node>();
        for (int i = 0; i < nodeList2.getLength(); ++i) {
            Node node = nodeList2.item(i);
            if (!node.getNodeName().equals("COLUMN")) continue;
            result.add(node);
        }
        return result;
    }

    private Map<String, String> getDataObjectNames(URL url, ProgressMonitor mon) throws Exception {
        Node n;
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        Document doc = Pds3DataSourceFactory.getDocumentWithImports(url);
        XPathFactory factory = XPathFactory.newInstance();
        XPath xpath = factory.newXPath();
        ArrayList alldat = new ArrayList();
        NodeList dat = (NodeList)xpath.evaluate("/LABEL/TABLE/COLUMN/NAME/text()", doc, XPathConstants.NODESET);
        if (dat.getLength() > 0) {
            Pds3DataSourceFactory.appendNodeList(alldat, dat);
        }
        if ((dat = (NodeList)xpath.evaluate("/LABEL/*[contains(name(),'_TABLE')]/COLUMN/NAME/text()", doc, XPathConstants.NODESET)).getLength() > 0) {
            Pds3DataSourceFactory.appendNodeList(alldat, dat);
        }
        if ((dat = (NodeList)xpath.evaluate("/LABEL/BINARY_TABLE/COLUMN/NAME/text()", doc, XPathConstants.NODESET)).getLength() > 0) {
            Pds3DataSourceFactory.appendNodeList(alldat, dat);
        }
        if ((dat = (NodeList)xpath.evaluate("/LABEL/ASCII_TABLE/COLUMN/NAME/text()", doc, XPathConstants.NODESET)).getLength() > 0) {
            Pds3DataSourceFactory.appendNodeList(alldat, dat);
        }
        if ((dat = (NodeList)xpath.evaluate("/LABEL/TIME_SERIES/COLUMN/NAME/text()", doc, XPathConstants.NODESET)).getLength() > 0) {
            Pds3DataSourceFactory.appendNodeList(alldat, dat);
        }
        if ((dat = (NodeList)xpath.evaluate("/LABEL/FILE/SPREADSHEET/FIELD/NAME/text()", doc, XPathConstants.NODESET)).getLength() > 0) {
            Pds3DataSourceFactory.appendNodeList(alldat, dat);
        }
        if ((dat = (NodeList)xpath.evaluate("/LABEL/SPREADSHEET/FIELD/NAME/text()", doc, XPathConstants.NODESET)).getLength() > 0) {
            Pds3DataSourceFactory.appendNodeList(alldat, dat);
        }
        for (int i = 0; i < alldat.size(); ++i) {
            n = (Node)alldat.get(i);
            String name = n.getTextContent();
            PDS3DataObject dd = Pds3DataSourceFactory.getDataObjectPds3(url, name);
            result.put(name, this.summarizeDescription(name, dd.getDescription()));
        }
        Node table = null;
        if (table == null) {
            n = doc.getDocumentElement();
            table = (Node)xpath.evaluate(String.format("/LABEL/TABLE[1]", new Object[0]), n, XPathConstants.NODE);
            if (table != null) {
                PDS3DataObject dd;
                String name;
                Node column;
                int i;
                NodeList columns = (NodeList)xpath.evaluate("CONTAINER/COLUMN", table, XPathConstants.NODESET);
                for (i = 0; i < columns.getLength(); ++i) {
                    column = columns.item(i);
                    name = (String)xpath.evaluate("NAME/text()", column, XPathConstants.STRING);
                    dd = Pds3DataSourceFactory.getDataObjectPds3(url, name);
                    result.put(name, this.summarizeDescription(name, dd.getDescription()));
                }
                columns = (NodeList)xpath.evaluate("CONTAINER/CONTAINER/COLUMN", table, XPathConstants.NODESET);
                for (i = 0; i < columns.getLength(); ++i) {
                    column = columns.item(i);
                    if (column == null) continue;
                    name = (String)xpath.evaluate("NAME/text()", column, XPathConstants.STRING);
                    dd = Pds3DataSourceFactory.getDataObjectPds3(url, name);
                    result.put(name, this.summarizeDescription(name, dd.getDescription()));
                }
            }
        }
        return result;
    }

    protected static FilePointer getFileResource(URL labelFile, ProgressMonitor mon) throws IOException, URISyntaxException, ParserConfigurationException, SAXException, XPathExpressionException, PDSException {
        PDSLabel label = new PDSLabel();
        String suri = DataSetURI.fromUri((URI)labelFile.toURI());
        File file = DataSetURI.getFile((String)suri, (ProgressMonitor)mon);
        File labelfile = file;
        if (!label.parse(labelfile.toString())) {
            throw new IllegalArgumentException("unable to use file " + labelFile);
        }
        Document doc = label.getDocument();
        XPathFactory factory = XPathFactory.newInstance();
        XPath xpath = factory.newXPath();
        NodeList dat = (NodeList)xpath.evaluate("/LABEL/POINTER/text()", doc, XPathConstants.NODESET);
        if (dat == null || dat.getLength() == 0) {
            dat = (NodeList)xpath.evaluate("/LABEL/FILE/POINTER/text()", doc, XPathConstants.NODESET);
        }
        String f = dat.item(0).getNodeValue();
        FilePointer result = new FilePointer(labelFile, f);
        return result;
    }

    private static String removeHtml(String description) {
        if (description == null) {
            return null;
        }
        if (description.startsWith("<html>") && (description = description.substring(6)).startsWith("<br>")) {
            description = description.substring(4);
        }
        String more = "";
        int i = description.indexOf("<br>");
        if (i > -1) {
            description = description.substring(0, i);
            more = "...";
        }
        return description.trim() + more;
    }

    public List<CompletionContext> getCompletions(CompletionContext cc, ProgressMonitor mon) throws Exception {
        String parmname;
        if (cc.context.equals(CompletionContext.CONTEXT_PARAMETER_NAME)) {
            logger.log(Level.FINE, "getCompletions {0}", cc.resourceURI);
            DataSetURI.getFile((URL)cc.resourceURI.toURL(), (ProgressMonitor)new NullProgressMonitor());
            Map<String, String> result = this.getDataObjectNames(cc.resourceURI.toURL(), mon);
            ArrayList<CompletionContext> ccresult = new ArrayList<CompletionContext>();
            ccresult.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_NAME, "", (DataSourceFactory)this, "arg_0", "Select parameter to plot", "", false));
            for (Map.Entry<String, String> e : result.entrySet()) {
                String key = e.getKey();
                String desc = e.getValue();
                desc = Pds3DataSourceFactory.removeHtml(desc);
                CompletionContext cc1 = new CompletionContext(CompletionContext.CONTEXT_PARAMETER_NAME, key, (DataSourceFactory)this, "arg_0", desc, null, true);
                ccresult.add(cc1);
            }
            ccresult.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_NAME, "X=", "values typically displayed in horizontal dimension"));
            ccresult.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_NAME, "Y=", "values typically displayed in vertical dimension"));
            ccresult.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_NAME, "Z=", "values typically color coded"));
            return ccresult;
        }
        if (cc.context == CompletionContext.CONTEXT_PARAMETER_VALUE && ((parmname = CompletionContext.get((Object)CompletionContext.CONTEXT_PARAMETER_NAME, (CompletionContext)cc)).equals("id") || parmname.equals("X") || parmname.equals("Y") || parmname.equals("Z"))) {
            Map<String, String> result = this.getDataObjectNames(cc.resourceURI.toURL(), mon);
            ArrayList<CompletionContext> ccresult = new ArrayList<CompletionContext>();
            ccresult.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_VALUE, "", (DataSourceFactory)this, "arg_0", "", null, true));
            for (Map.Entry<String, String> e : result.entrySet()) {
                String key = e.getKey();
                String desc = e.getValue();
                desc = Pds3DataSourceFactory.removeHtml(desc);
                CompletionContext cc1 = new CompletionContext(CompletionContext.CONTEXT_PARAMETER_VALUE, key, (DataSourceFactory)this, "arg_0", desc, null, true);
                ccresult.add(cc1);
            }
            return ccresult;
        }
        return Collections.emptyList();
    }
}

