/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.pds;

import gov.nasa.pds.label.Label;
import gov.nasa.pds.label.object.ArrayObject;
import gov.nasa.pds.label.object.FieldDescription;
import gov.nasa.pds.label.object.FieldType;
import gov.nasa.pds.label.object.TableObject;
import gov.nasa.pds.label.object.TableRecord;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.autoplot.datasource.AbstractDataSource;
import org.autoplot.datasource.DataSetURI;
import org.autoplot.datasource.URISplit;
import org.autoplot.pds.DocumentUtil;
import org.autoplot.pds.PdsDataSourceFactory;
import org.das2.datum.DatumRangeUtil;
import org.das2.datum.NumberUnits;
import org.das2.datum.TimeLocationUnits;
import org.das2.datum.Units;
import org.das2.datum.UnitsUtil;
import org.das2.qds.ArrayDataSet;
import org.das2.qds.DDataSet;
import org.das2.qds.MutablePropertyDataSet;
import org.das2.qds.QDataSet;
import org.das2.qds.ops.Ops;
import org.das2.qds.util.DataSetBuilder;
import org.das2.util.monitor.NullProgressMonitor;
import org.das2.util.monitor.ProgressMonitor;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class PdsDataSource
extends AbstractDataSource {
    public PdsDataSource(URI uri) {
        super(uri);
    }

    private static TableRecord readNextTableRecord(TableObject t) throws Exception {
        return t.readNext();
    }

    private QDataSet getFromTable(TableObject t, String[] columnNames) throws Exception {
        TableRecord r;
        int ncols = columnNames.length;
        int[] icols = new int[ncols];
        DataSetBuilder dsb = new DataSetBuilder(2, 100, ncols);
        int currentColumn = -1;
        int firstColumn = -1;
        for (int i = 0; i < ncols; ++i) {
            int icol = -1;
            FieldDescription[] fields = t.getFields();
            for (int j = 0; j < fields.length; ++j) {
                if (!fields[j].getName().equals(columnNames[i])) continue;
                icol = j;
                break;
            }
            if (icol == currentColumn) {
                icols[i] = currentColumn + (i - firstColumn);
            } else {
                icols[i] = icol;
                currentColumn = icol;
                firstColumn = i;
            }
            FieldDescription fieldDescription = t.getFields()[icol];
            dsb.setName(i, fieldDescription.getName());
            dsb.setLabel(i, fieldDescription.getName());
            if (PdsDataSource.isTimeType(fieldDescription)) {
                dsb.setUnits(i, (Units)Units.us2000);
                continue;
            }
            if (fieldDescription.getType() == FieldType.ASCII_STRING) {
                dsb.setUnits(i, (Units)Units.nominal((String)fieldDescription.getName()));
                continue;
            }
            dsb.setUnits(i, Units.dimensionless);
        }
        boolean doTimeCheck = true;
        while ((r = PdsDataSource.readNextTableRecord(t)) != null) {
            for (int i = 0; i < ncols; ++i) {
                try {
                    String s;
                    if (doTimeCheck && DatumRangeUtil.parseISO8601((String)(s = r.getString(icols[i] + 1))) != null && !(dsb.getUnits(i) instanceof NumberUnits)) {
                        dsb.setUnits(i, (Units)Units.us2000);
                    }
                    dsb.putValue(-1, i, r.getString(icols[i] + 1));
                    continue;
                }
                catch (ParseException ex) {
                    dsb.putValue(-1, i, dsb.getUnits(i).getFillDatum());
                }
            }
            doTimeCheck = false;
            dsb.nextRecord();
        }
        return dsb.getDataSet();
    }

    private double[] flatten(double[][] dd) {
        double[] rank1 = new double[dd.length * dd[0].length];
        int nj = dd[0].length;
        int kk = 0;
        for (int i = 0; i < dd.length; ++i) {
            double[] d = dd[i];
            for (int j = 0; j < nj; ++j) {
                rank1[kk++] = d[j];
            }
        }
        return rank1;
    }

    private double[] flatten3d(double[][][] dd) {
        double[] rank1 = new double[dd.length * dd[0].length * dd[0][0].length];
        int kk = 0;
        int[] qube = new int[]{dd.length, dd[0].length, dd[0][0].length};
        for (int i0 = 0; i0 < qube[0]; ++i0) {
            for (int i1 = 0; i1 < qube[1]; ++i1) {
                double[] d1 = dd[i0][i1];
                for (int i2 = 0; i2 < qube[2]; ++i2) {
                    rank1[kk++] = d1[i2];
                }
            }
        }
        return rank1;
    }

    public static Document readXML(File f) throws IOException, SAXException {
        Document document;
        DocumentBuilder builder = null;
        try {
            builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (ParserConfigurationException ex) {
            throw new RuntimeException(ex);
        }
        try (FileInputStream in = new FileInputStream(f);){
            InputSource source = new InputSource(in);
            document = builder.parse(source);
        }
        return document;
    }

    private static void addAxisArray(Node n, Map<Integer, String> axisNames) throws XPathExpressionException {
        XPathFactory factory = XPathFactory.newInstance();
        XPath xpath = factory.newXPath();
        String name = (String)xpath.evaluate("axis_name", n, XPathConstants.STRING);
        Double sequence_number = (Double)xpath.evaluate("sequence_number", n, XPathConstants.NUMBER);
        axisNames.put(sequence_number.intValue(), name);
    }

    public static String resolveIndependentAxis(Document doc, String axisName) throws XPathExpressionException {
        String s;
        XPathFactory factory = XPathFactory.newInstance();
        XPath xpath = factory.newXPath();
        NodeList oo = (NodeList)xpath.evaluate(s = "Product_Observational/File_Area_Observational/Array[Axis_Array/axis_name='" + axisName + "']", doc, XPathConstants.NODESET);
        if (oo.getLength() > 0) {
            String name;
            int best = 0;
            for (int i = 0; i < oo.getLength(); ++i) {
                Node o = oo.item(i);
                name = (String)xpath.evaluate("name", o, XPathConstants.STRING);
                if (!axisName.equals("pitch angle") || !name.equals("pa")) continue;
                best = i;
            }
            Node o = oo.item(best);
            String axes = (String)xpath.evaluate("axes", o, XPathConstants.STRING);
            if (Integer.parseInt(axes) == 1) {
                name = (String)xpath.evaluate("name", o, XPathConstants.STRING);
                return name;
            }
            return null;
        }
        return null;
    }

    public static List<String> seekDependencies(Document doc, List<String> depend) throws XPathExpressionException {
        if (depend.size() == 1) {
            String n2;
            XPathFactory factory = XPathFactory.newInstance();
            XPath xpath = factory.newXPath();
            String name = depend.get(0);
            LinkedHashMap<Integer, String> axisNames = new LinkedHashMap<Integer, String>();
            NodeList oo = (NodeList)xpath.evaluate("//Product_Observational/File_Area_Observational/Array[name='" + name + "']/Axis_Array", doc, XPathConstants.NODESET);
            for (int i = 0; i < oo.getLength(); ++i) {
                Node n = oo.item(i);
                PdsDataSource.addAxisArray(n, axisNames);
            }
            if (axisNames.get(4) != null) {
                String n1 = PdsDataSource.resolveIndependentAxis(doc, (String)axisNames.get(1));
                n2 = PdsDataSource.resolveIndependentAxis(doc, (String)axisNames.get(2));
                String n3 = PdsDataSource.resolveIndependentAxis(doc, (String)axisNames.get(3));
                String n4 = PdsDataSource.resolveIndependentAxis(doc, (String)axisNames.get(4));
                depend = new LinkedList<String>(depend);
                depend.add(0, n1);
                depend.add(1, n2);
                depend.add(2, n3);
                if (n4 != null && !n4.equals(name)) {
                    depend.add(3, n4);
                }
            } else if (axisNames.get(3) != null) {
                String n1 = PdsDataSource.resolveIndependentAxis(doc, (String)axisNames.get(1));
                n2 = PdsDataSource.resolveIndependentAxis(doc, (String)axisNames.get(2));
                String n3 = PdsDataSource.resolveIndependentAxis(doc, (String)axisNames.get(3));
                depend = new LinkedList<String>(depend);
                depend.add(0, n1);
                depend.add(1, n2);
                if (n3 != null && !n3.equals(name)) {
                    depend.add(2, n3);
                }
            } else if (axisNames.get(2) != null) {
                String n1 = PdsDataSource.resolveIndependentAxis(doc, (String)axisNames.get(1));
                n2 = PdsDataSource.resolveIndependentAxis(doc, (String)axisNames.get(2));
                depend = new LinkedList<String>(depend);
                depend.add(0, n1);
                if (n2 != null && !n2.equals(name)) {
                    depend.add(1, n2);
                }
            } else if (axisNames.get(1) != null) {
                String n1 = PdsDataSource.resolveIndependentAxis(doc, (String)axisNames.get(1));
                depend = new LinkedList<String>(depend);
                if (n1 != null && !n1.equals(name)) {
                    depend.add(0, n1);
                }
            }
        }
        return depend;
    }

    public QDataSet getDataSetFromBundle(Document doc, ProgressMonitor mon) throws Exception {
        XPathExpression xp = XPathFactory.newInstance().newXPath().compile("//Product_Bundle/Bundle_Member_Entry/lidvid_reference/text()");
        String lidvid = (String)xp.evaluate(doc, XPathConstants.STRING);
        if (lidvid.trim().length() == 0) {
            throw new IllegalArgumentException("lidvid is empty or not found at //Product_Bundle/Bundle_Member_Entry/lidvid_reference/text()");
        }
        return Ops.dataset((Object)lidvid, (Units)Units.nominal());
    }

    public QDataSet getDataSetFromCollection(Document doc, ProgressMonitor mon) throws Exception {
        XPathExpression xp = XPathFactory.newInstance().newXPath().compile("//Product_Collection/File_Area_Inventory/File/file_name/text()");
        String csvfile = (String)xp.evaluate(doc, XPathConstants.STRING);
        if (csvfile.trim().length() == 0) {
            throw new IllegalArgumentException("file name is empty or not found at //Product_Collection/File_Area_Inventory/File/file_name/text()");
        }
        return Ops.dataset((Object)csvfile, (Units)Units.nominal());
    }

    private static boolean isTimeType(FieldDescription ff) {
        if (ff.getType() == FieldType.ASCII_STRING && ff.getName().equals("UTC")) {
            return true;
        }
        FieldType ft = ff.getType();
        return ft == FieldType.ASCII_DATE || ft == FieldType.ASCII_DATE_DOY || ft == FieldType.ASCII_DATE_TIME || ft == FieldType.ASCII_DATE_TIME_DOY_UTC || ft == FieldType.ASCII_DATE_TIME_UTC || ft == FieldType.ASCII_DATE_TIME_YMD || ft == FieldType.ASCII_DATE_TIME_YMD_UTC;
    }

    public QDataSet getDataSet(ProgressMonitor mon) throws Exception {
        String Z;
        String Y;
        Label label;
        String name = this.getParam("arg_0", "");
        URISplit split = URISplit.parse((String)this.getURI());
        File xmlfile = DataSetURI.getFile((URL)split.resourceUri.toURL(), (ProgressMonitor)new NullProgressMonitor());
        Document doc = PdsDataSource.readXML(xmlfile);
        if (doc.getDocumentElement().getNodeName().equals("Product_Bundle")) {
            return this.getDataSetFromBundle(doc, mon);
        }
        if (doc.getDocumentElement().getNodeName().equals("Product_Collection")) {
            return this.getDataSetFromCollection(doc, mon);
        }
        URL fileUrl = PdsDataSourceFactory.getFileResource(split.resourceUri.toURL(), mon);
        DataSetURI.getFile((URL)fileUrl, (ProgressMonitor)mon);
        try {
            label = Label.open((URL)xmlfile.toURI().toURL());
        }
        catch (NoClassDefFoundError ex) {
            throw new Exception("Java 8 must be used to read PDS4 files.  Please use dmg, exe, deb, or rpm releases, or the single jar with Java 8.");
        }
        List<String> names = new ArrayList<String>();
        String X = this.getParam("X", "");
        if (!X.equals("")) {
            X = X.replaceAll("\\+", " ");
            names.add(X);
        }
        if (!(Y = this.getParam("Y", "")).equals("")) {
            Y = Y.replaceAll("\\+", " ");
            names.add(Y);
        }
        if (!(Z = this.getParam("Z", "")).equals("")) {
            Z = Z.replaceAll("\\+", " ");
            names.add(Z);
        }
        if (!name.equals("")) {
            name = name.replaceAll("\\+", " ");
            names.add(name);
        }
        List<String> names1 = PdsDataSource.seekDependencies(doc, names);
        boolean okay = true;
        for (int i = 0; i < names1.size(); ++i) {
            if (names1.get(i) != null) continue;
            okay = false;
        }
        if (okay) {
            names = names1;
        }
        if (names.size() == 1) {
            for (TableObject t : label.getObjects(TableObject.class)) {
                if (!PdsDataSource.isTimeType(t.getFields()[0])) continue;
                String dep0name = t.getFields()[0].getName();
                ArrayList<String> newNames = new ArrayList<String>(names);
                for (int i = 0; i < names.size(); ++i) {
                    name = names.get(i);
                    if (name == null) continue;
                    for (FieldDescription fd : t.getFields()) {
                        if (!name.equals(fd.getName()) || ((String)newNames.get(0)).equals(dep0name)) continue;
                        newNames.add(0, dep0name);
                    }
                }
                if (newNames.size() <= names.size()) continue;
                names = newNames;
            }
        }
        QDataSet result = null;
        QDataSet[] results = new QDataSet[names.size()];
        for (TableObject t : label.getObjects(TableObject.class)) {
            ArrayList<String> tableColumnNames = new ArrayList<String>();
            ArrayList<Integer> datasetColumnIndexes = new ArrayList<Integer>();
            for (int i = 0; i < names.size(); ++i) {
                name = names.get(i);
                if (name == null) continue;
                for (FieldDescription fd : t.getFields()) {
                    if (!name.equals(fd.getName())) continue;
                    tableColumnNames.add(fd.getName());
                    datasetColumnIndexes.add(i);
                }
            }
            if (tableColumnNames.isEmpty()) continue;
            QDataSet bresults = this.getFromTable(t, tableColumnNames.toArray(new String[tableColumnNames.size()]));
            int iii = 0;
            while (iii < datasetColumnIndexes.size()) {
                int iii2;
                int i = (Integer)datasetColumnIndexes.get(iii);
                name = (String)tableColumnNames.get(iii);
                for (iii2 = i + 1; iii2 < datasetColumnIndexes.size() && (Integer)datasetColumnIndexes.get(iii2) == i; ++iii2) {
                }
                ArrayDataSet result1 = iii2 - iii > 1 ? DDataSet.copy((QDataSet)Ops.trim1((QDataSet)bresults, (int)i, (int)(i + (iii2 - iii)))) : DDataSet.copy((QDataSet)Ops.unbundle((QDataSet)bresults, (int)i));
                results[i] = result1;
                Units units = (Units)result1.property("UNITS");
                XPathFactory factory = XPathFactory.newInstance();
                XPath xpath = factory.newXPath();
                String s = "Table_Character/Record_Character/Field_Character[name='" + name + "']/";
                String sunits = xpath.evaluate("//Product_Observational/File_Area_Observational/" + s + "unit/text()", doc);
                if ((sunits = sunits.trim()).length() == 0) {
                    s = "Table_Binary/Record_Binary/Field_Binary[name='" + name + "']/";
                    sunits = xpath.evaluate("//Product_Observational/File_Area_Observational/" + s + "unit/text()", doc);
                    sunits = sunits.trim();
                }
                if (sunits.length() == 0) {
                    s = "Table_Binary/Record_Binary/Group_Field_Character/Field_Character[name='" + name + "']/";
                    sunits = xpath.evaluate("//Product_Observational/File_Area_Observational/" + s + "unit/text()", doc);
                    sunits = sunits.trim();
                }
                if (sunits.length() == 0) {
                    s = "Table_Binary/Record_Binary/Group_Field_Binary/Field_Binary[name='" + name + "']/";
                    sunits = xpath.evaluate("//Product_Observational/File_Area_Observational/" + s + "unit/text()", doc);
                    sunits = sunits.trim();
                }
                if (sunits.length() > 0) {
                    result1.putProperty("UNITS", (Object)Units.lookupUnits((String)sunits));
                }
                if (units == null || !UnitsUtil.isTimeLocation((Units)units)) {
                    String sfillValue;
                    String labl = xpath.evaluate("//Product_Observational/File_Area_Observational/" + s + "name/text()", doc);
                    if (labl.length() == 0) {
                        labl = name;
                    }
                    ((MutablePropertyDataSet)results[i]).putProperty("LABEL", (Object)labl);
                    String title = xpath.evaluate("//Product_Observational/File_Area_Observational/" + s + "description/text()", doc);
                    if (title.length() > 0) {
                        title = DocumentUtil.createTitleFrom(title);
                        result1.putProperty("TITLE", (Object)title);
                    }
                    if ((sfillValue = xpath.evaluate("//Product_Observational/File_Area_Observational/" + s + "Special_Constants/invalid_constant/text()", doc)).length() == 0) {
                        sfillValue = xpath.evaluate("//Product_Observational/File_Area_Observational/" + s + "Special_Constants/missing_constant/text()", doc);
                    }
                    String svalidMax = xpath.evaluate("//Product_Observational/File_Area_Observational/" + s + "Special_Constants/valid_maximum/text()", doc);
                    String svalidMin = xpath.evaluate("//Product_Observational/File_Area_Observational/" + s + "Special_Constants/valid_minimum/text()", doc);
                    if (sfillValue.trim().length() > 0) {
                        double fillValue = Double.parseDouble(sfillValue);
                        result1.putProperty("FILL_VALUE", (Object)fillValue);
                    }
                    if (svalidMax.trim().length() > 0) {
                        double validMax = Double.parseDouble(svalidMax);
                        result1.putProperty("VALID_MAX", (Object)validMax);
                    }
                    if (svalidMin.trim().length() > 0) {
                        double validMin = Double.parseDouble(svalidMin);
                        result1.putProperty("VALID_MIN", (Object)validMin);
                    }
                }
                iii = iii2;
            }
        }
        for (int i = 0; i < names.size(); ++i) {
            if (results[i] != null) continue;
            name = names.get(i);
            block27: for (ArrayObject a : label.getObjects(ArrayObject.class)) {
                String sfillValue;
                DDataSet result1;
                TimeLocationUnits units = null;
                if (!a.getName().equals(name)) continue;
                switch (a.getAxes()) {
                    case 1: {
                        Object dd = a.getElements1D();
                        int[] qube = new int[]{((double[])dd).length};
                        DDataSet ddresult = DDataSet.wrap((double[])dd, (int[])qube);
                        if (name.equalsIgnoreCase("Epoch") || name.equalsIgnoreCase("tt2000")) {
                            logger.info("Epoch kludge results in CDF_TT2000 units");
                            units = Units.cdfTT2000;
                            ddresult.putProperty("UNITS", (Object)units);
                        }
                        results[i] = ddresult;
                        result1 = ddresult;
                        break;
                    }
                    case 2: {
                        Object dd = a.getElements2D();
                        double[] rank1 = this.flatten((double[][])dd);
                        int[] qube = new int[]{((double[])dd).length, ((double)dd[0]).length};
                        DDataSet ddresult = DDataSet.wrap((double[])rank1, (int[])qube);
                        results[i] = ddresult;
                        result1 = ddresult;
                        break;
                    }
                    case 3: {
                        Object dd = a.getElements3D();
                        double[] rank1 = this.flatten3d((double[][][])dd);
                        int[] qube = new int[]{((double[])dd).length, ((double)dd[0]).length, ((void)dd[0][0]).length};
                        DDataSet ddresult = DDataSet.wrap((double[])rank1, (int[])qube);
                        results[i] = ddresult;
                        result1 = ddresult;
                        break;
                    }
                    default: {
                        logger.warning("Unsupported number of axes, only one, two, or three.");
                        results[i] = null;
                        continue block27;
                    }
                }
                if (result1 == null || doc == null) continue;
                XPathFactory factory = XPathFactory.newInstance();
                XPath xpath = factory.newXPath();
                String sunits = xpath.evaluate("//Product_Observational/File_Area_Observational/Array[name='" + name + "']/Element_Array/unit/text()", doc);
                if ((sunits = sunits.trim()).length() > 0 && units == null) {
                    result1.putProperty("UNITS", (Object)Units.lookupUnits((String)sunits));
                }
                if (units == null || !UnitsUtil.isTimeLocation((Units)units)) {
                    String labl = xpath.evaluate("//Product_Observational/File_Area_Observational/Array[name='" + name + "']/name/text()", doc);
                    if (labl.length() == 0) {
                        labl = name;
                    }
                    ((MutablePropertyDataSet)results[i]).putProperty("LABEL", (Object)labl);
                    String title = xpath.evaluate("//Product_Observational/File_Area_Observational/Array[name='" + name + "']/description/text()", doc);
                    if (title.length() > 0) {
                        result1.putProperty("TITLE", (Object)title.trim());
                    }
                }
                if ((sfillValue = xpath.evaluate("//Product_Observational/File_Area_Observational/Array[name='" + name + "']/Special_Constants/invalid_constant/text()", doc)).length() == 0) {
                    sfillValue = xpath.evaluate("//Product_Observational/File_Area_Observational/Array[name='" + name + "']/Special_Constants/missing_constant/text()", doc);
                }
                String svalidMax = xpath.evaluate("//Product_Observational/File_Area_Observational/Array[name='" + name + "']/Special_Constants/valid_maximum/text()", doc);
                String svalidMin = xpath.evaluate("//Product_Observational/File_Area_Observational/Array[name='" + name + "']/Special_Constants/valid_minimum/text()", doc);
                if (sfillValue.trim().length() > 0) {
                    double fillValue = Double.parseDouble(sfillValue);
                    result1.putProperty("FILL_VALUE", (Object)fillValue);
                }
                if (svalidMax.trim().length() > 0) {
                    double validMax = Double.parseDouble(svalidMax);
                    if (Math.log10(validMax) > -50.0) {
                        result1.putProperty("VALID_MAX", (Object)validMax);
                    } else {
                        logger.warning("Unbelievable value found for Special_Constants/valid_maximum, ignoring: " + svalidMax);
                    }
                }
                if (svalidMin.trim().length() <= 0) continue;
                double validMin = Double.parseDouble(svalidMin);
                result1.putProperty("VALID_MIN", (Object)validMin);
            }
        }
        if (result == null) {
            switch (results.length) {
                case 1: {
                    result = results[0];
                    break;
                }
                case 2: {
                    result = Ops.link((QDataSet)results[0], (QDataSet)results[1]);
                    break;
                }
                case 3: {
                    try {
                        result = Ops.link((QDataSet)results[0], (QDataSet)results[1], (QDataSet)results[2]);
                    }
                    catch (Exception ex) {
                        ((MutablePropertyDataSet)results[2]).putProperty("DEPEND_1", null);
                        result = results[2];
                    }
                    break;
                }
                case 4: {
                    try {
                        result = Ops.link((QDataSet)results[0], (QDataSet)results[1], (QDataSet)results[2], (QDataSet)results[3]);
                    }
                    catch (Exception ex) {
                        ((MutablePropertyDataSet)results[3]).putProperty("DEPEND_1", null);
                        ((MutablePropertyDataSet)results[3]).putProperty("DEPEND_2", null);
                        result = results[3];
                    }
                    break;
                }
            }
        }
        if (result instanceof MutablePropertyDataSet) {
            ((MutablePropertyDataSet)result).makeImmutable();
        }
        return result;
    }

    public Map<String, Object> getMetadata(ProgressMonitor mon) throws Exception {
        URISplit split = URISplit.parse((String)this.getURI());
        File xmlfile = DataSetURI.getFile((URL)split.resourceUri.toURL(), (ProgressMonitor)mon);
        Document doc = PdsDataSource.readXML(xmlfile);
        return DocumentUtil.convertDocumentToMap(doc);
    }
}

