/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.pdsppi;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.autoplot.datasource.DataSetURI;
import org.autoplot.datasource.DataSourceUtil;
import org.autoplot.spase.VOTableReader;
import org.das2.datum.HttpUtil;
import org.das2.qds.QDataSet;
import org.das2.util.LoggerManager;
import org.das2.util.filesystem.FileSystem;
import org.das2.util.monitor.ProgressMonitor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class PDSPPIDB {
    private static final Logger logger = LoggerManager.getLogger((String)"apdss.pdsppi");
    Logger loggerUrl = LoggerManager.getLogger((String)"das2.url");
    private static final PDSPPIDB instance = new PDSPPIDB();
    public static final String PDSPPI = "https://pds-ppi.igpp.ucla.edu/";
    List<String> ids = new ArrayList<String>(1100);
    String[] _spacecraft = null;

    public static PDSPPIDB getInstance() {
        return instance;
    }

    public synchronized String[] getSpacecraft() {
        if (this._spacecraft == null) {
            try {
                this._spacecraft = this.getStringArrayFromXML(PDSPPIDB.class.getResource("/resources/spacecraft.xml"), "/Doc/SPACECRAFT_NAME[text()]");
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
        return Arrays.copyOf(this._spacecraft, this._spacecraft.length);
    }

    public List<String> getIds() {
        return Collections.unmodifiableList(this.ids);
    }

    public List<String> getIds(Pattern p) {
        ArrayList<String> result = new ArrayList<String>(this.ids.size());
        for (String s : this.ids) {
            if (!p.matcher(s).matches()) continue;
            result.add(s);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] getStringArray(URL src, String reqPrefix) throws IOException {
        ArrayList<String> result = new ArrayList<String>();
        try (BufferedReader reader = null;){
            this.loggerUrl.log(Level.FINE, "openConnection {0}", src);
            URLConnection connect = src.openConnection();
            connect.setReadTimeout(FileSystem.settings().getConnectTimeoutMs());
            connect = HttpUtil.checkRedirect((URLConnection)connect);
            reader = new BufferedReader(new InputStreamReader(connect.getInputStream()));
            String line = reader.readLine();
            while (line != null) {
                if (!line.startsWith(reqPrefix)) {
                    line = reqPrefix + line;
                }
                result.add(line);
                line = reader.readLine();
            }
        }
        return result.toArray(new String[result.size()]);
    }

    private String[] getStringArrayFromXML(URL url, String path) throws IOException {
        ArrayList<String> result = new ArrayList<String>();
        try (InputStream fin = null;){
            logger.log(Level.FINE, "opening {0}", url);
            this.loggerUrl.log(Level.FINE, "GET to get data {0}", url);
            URLConnection connect = url.openConnection();
            connect = HttpUtil.checkRedirect((URLConnection)connect);
            fin = connect.getInputStream();
            InputSource source = new InputSource(fin);
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document document = builder.parse(source);
            XPathFactory xpf = DataSourceUtil.getXPathFactory();
            XPath xp = xpf.newXPath();
            NodeList nodes = (NodeList)xp.evaluate(path, document, XPathConstants.NODESET);
            if (nodes == null) {
                String[] stringArray = new String[]{};
                return stringArray;
            }
            for (int i = 0; i < nodes.getLength(); ++i) {
                Element node = (Element)nodes.item(i);
                result.add(node.getChildNodes().item(0).getNodeValue());
            }
        }
        String[] listing = result.toArray(new String[result.size()]);
        return listing;
    }

    public static String removeExtraSlashes(String root) {
        int i = root.indexOf("/");
        return root.substring(0, ++i) + root.substring(i).replaceAll("/", "_");
    }

    public static boolean isPlottable(String ds) {
        return ds.endsWith(".lbl") || ds.endsWith(".LBL") || ds.endsWith(".tab") || ds.endsWith(".DAT") || ds.endsWith(".dat") || ds.endsWith(".TAB") || ds.endsWith(".csv") || ds.endsWith(".CSV");
    }

    public String[] getIds(String constraint, String reqPrefix) throws IOException {
        Pattern p = Pattern.compile("sc=[a-zA-Z_ 0-9/\\(\\)]*");
        if (!p.matcher(constraint).matches()) {
            throw new IllegalArgumentException("constraint doesn't match (sc=[a-zA-Z_ 0-9/]*): " + constraint);
        }
        URL url = new URL(String.format("https://pds-ppi.igpp.ucla.edu/ditdos/inventory?%s&o=txt", constraint.replaceAll(" ", "+")));
        logger.log(Level.FINE, "getIds {0}", url);
        String[] dss = this.getStringArray(url, reqPrefix);
        return dss;
    }

    protected String checkXML(File f) throws IOException {
        try (BufferedReader read = new BufferedReader(new InputStreamReader(new FileInputStream(f)));){
            String s = read.readLine();
            if (s != null && s.length() >= 6 && s.substring(0, 6).equals("<?xml ")) {
                String string = null;
                return string;
            }
            String string = s;
            return string;
        }
    }

    public String checkTimeSeriesBrowse(String uri) {
        return null;
    }

    public Map<String, String> getParams(String id, ProgressMonitor mon) throws IllegalArgumentException {
        String url = "https://pds-ppi.igpp.ucla.edu/ditdos/write?f=vo&id=pds://" + id;
        try {
            VOTableReader read = new VOTableReader();
            mon.setProgressMessage("downloading data");
            logger.log(Level.FINE, "getParams {0}", url);
            File f = DataSetURI.downloadResourceAsTempFile((URL)new URL(url), (int)3600, (ProgressMonitor)mon.getSubtaskMonitor("downloading file"));
            String s = this.checkXML(f);
            if (s != null) {
                throw new IllegalArgumentException("file does not appear to be xml: " + s);
            }
            mon.setProgressMessage("reading data");
            QDataSet ds = read.readHeader(f.toString(), mon.getSubtaskMonitor("reading data"));
            LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
            for (int i = 0; i < ds.length(); ++i) {
                String n = (String)ds.property("NAME", i);
                String l = (String)ds.property("LABEL", i);
                String t = (String)ds.property("TITLE", i);
                result.put(l, t);
            }
            return result;
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, "IOException from " + url, ex);
            return Collections.singletonMap("(IOException from " + url + ")", ex.getMessage());
        }
        catch (SAXException ex) {
            logger.log(Level.SEVERE, "SAXException from " + url, ex);
            return Collections.singletonMap("(SAXException from " + url + ")", ex.getMessage());
        }
        catch (ParserConfigurationException ex) {
            logger.log(Level.SEVERE, "ParserConfigurationException", ex);
            return Collections.singletonMap("(ParserConfigurationException)", ex.getMessage());
        }
    }

    public static void main(String[] args) {
        String[] scs;
        for (String sc : scs = PDSPPIDB.getInstance().getSpacecraft()) {
            System.err.println(sc);
        }
    }
}

