/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.pdsppi;

import java.io.File;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.autoplot.datasource.AbstractDataSourceFactory;
import org.autoplot.datasource.CompletionContext;
import org.autoplot.datasource.DataSetURI;
import org.autoplot.datasource.DataSource;
import org.autoplot.datasource.DataSourceFactory;
import org.autoplot.datasource.URISplit;
import org.autoplot.pdsppi.PDSPPIDB;
import org.autoplot.pdsppi.PDSPPIDataSource;
import org.autoplot.pdsppi.PDSPPIFileSystem;
import org.autoplot.spase.VOTableReader;
import org.das2.qds.QDataSet;
import org.das2.util.LoggerManager;
import org.das2.util.monitor.ProgressMonitor;

public class PDSPPIDataSourceFactory
extends AbstractDataSourceFactory
implements DataSourceFactory {
    protected static final Logger logger = LoggerManager.getLogger((String)"apdss.pdsppi");

    public DataSource getDataSource(URI uri) throws Exception {
        return new PDSPPIDataSource(uri);
    }

    private List<CompletionContext> getDataSetCompletions(String id, ProgressMonitor mon) throws Exception {
        String url = "https://pds-ppi.igpp.ucla.edu/ditdos/write?f=vo&id=pds://" + id;
        VOTableReader read = new VOTableReader();
        mon.setProgressMessage("downloading data");
        logger.log(Level.FINE, "getDataSetCompletions {0}", url);
        File f = DataSetURI.downloadResourceAsTempFile((URL)new URL(url), (int)3600, (ProgressMonitor)mon);
        mon.setProgressMessage("reading data");
        QDataSet ds = read.readHeader(f.toString(), mon.getSubtaskMonitor("reading data"));
        ArrayList<CompletionContext> ccresult = new ArrayList<CompletionContext>();
        for (int i = 0; i < ds.length(); ++i) {
            String l = (String)ds.property("LABEL", i);
            String t = (String)ds.property("TITLE", i);
            CompletionContext cc1 = new CompletionContext(CompletionContext.CONTEXT_PARAMETER_VALUE, l, (DataSourceFactory)this, l, l, t, true);
            ccresult.add(cc1);
        }
        return ccresult;
    }

    public List<CompletionContext> getCompletions(CompletionContext cc, ProgressMonitor mon) throws Exception {
        if (cc.context == CompletionContext.CONTEXT_PARAMETER_NAME) {
            ArrayList<CompletionContext> ccresult = new ArrayList<CompletionContext>(10);
            ccresult.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_NAME, "id=", "id=", "table id"));
            ccresult.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_NAME, "param=", "param=", "dataset within a table"));
            return ccresult;
        }
        if (cc.context == CompletionContext.CONTEXT_PARAMETER_VALUE) {
            String param = CompletionContext.get((Object)CompletionContext.CONTEXT_PARAMETER_NAME, (CompletionContext)cc);
            if (param.equals("param")) {
                URISplit split = URISplit.parse((String)cc.surl);
                LinkedHashMap pp = URISplit.parseParams((String)split.params);
                String id = (String)pp.get("id");
                if (id == null) {
                    return Collections.singletonList(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_NAME, "", "", "(Select id first)"));
                }
                return this.getDataSetCompletions(id, mon);
            }
            if (param.equals("sc")) {
                String[] scs = PDSPPIDB.getInstance().getSpacecraft();
                ArrayList<CompletionContext> ccresult = new ArrayList<CompletionContext>();
                for (String sc : scs) {
                    CompletionContext cc1 = new CompletionContext(CompletionContext.CONTEXT_PARAMETER_VALUE, sc, (DataSourceFactory)this, null, sc, sc, false);
                    ccresult.add(cc1);
                }
                return ccresult;
            }
            if (param.equals("id")) {
                String u = cc.surl.substring(0, cc.surlpos);
                URISplit split = URISplit.parse((String)u);
                LinkedHashMap params = URISplit.parseParams((String)split.params);
                String sc = (String)params.get("sc");
                if (sc != null) {
                    String[] ss;
                    sc = sc.replaceAll("\\+", " ");
                    String[] ids = PDSPPIDB.getInstance().getIds("sc=" + sc, "PPI/");
                    ArrayList<CompletionContext> ccresult = new ArrayList<CompletionContext>();
                    String id1 = (String)params.get("id");
                    if (id1 != null && (ss = id1.split("/", -2)).length == 2) {
                        id1 = "";
                    }
                    if (id1 != null && id1.length() > 0) {
                        String file = null;
                        String iid = null;
                        for (String id : ids) {
                            if (!id1.startsWith(id)) continue;
                            file = id1.substring(id.length());
                            iid = id;
                        }
                        if (file != null) {
                            String[] ff;
                            PDSPPIFileSystem fs = new PDSPPIFileSystem(PDSPPIDB.removeExtraSlashes(iid));
                            int i = file.lastIndexOf("/");
                            file = file.substring(0, i + 1);
                            for (String ff1 : ff = fs.listDirectory(file, mon)) {
                                CompletionContext cc1;
                                String theid = iid + file + ff1;
                                if (PDSPPIDB.isPlottable(theid)) {
                                    int dotpos = theid.lastIndexOf(".");
                                    theid = theid.substring(0, dotpos);
                                    cc1 = new CompletionContext(CompletionContext.CONTEXT_PARAMETER_VALUE, theid, (DataSourceFactory)this, null, theid, theid, true);
                                    ccresult.add(cc1);
                                    continue;
                                }
                                if (!theid.endsWith("/")) continue;
                                cc1 = new CompletionContext(CompletionContext.CONTEXT_PARAMETER_VALUE, theid, (DataSourceFactory)this, null, theid, theid, false);
                                ccresult.add(cc1);
                            }
                            return ccresult;
                        }
                        return Collections.singletonList(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_VALUE, "", "error", "error"));
                    }
                    for (String id : ids) {
                        if (id.contains("\t")) {
                            logger.log(Level.FINE, "tab in id from PDSPPIDB.getInstance().getIds(sc={0})", sc);
                            continue;
                        }
                        CompletionContext cc1 = new CompletionContext(CompletionContext.CONTEXT_PARAMETER_VALUE, id + "/", (DataSourceFactory)this, null, id + "/", id + "/", false);
                        ccresult.add(cc1);
                    }
                    return ccresult;
                }
                return Collections.singletonList(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_VALUE, "", "enter sc first", "sc constraint needed"));
            }
        }
        return new ArrayList<CompletionContext>(){};
    }

    public <T> T getCapability(Class<T> clazz) {
        return null;
    }

    public boolean reject(String surl, List<String> problems, ProgressMonitor mon) {
        String id;
        URISplit split = URISplit.parse((String)surl);
        LinkedHashMap params = URISplit.parseParams((String)split.params);
        String param = (String)params.get("param");
        if (param == null) {
            param = (String)params.get("ds");
        }
        if (param == null) {
            problems.add("missing param");
        }
        if ((id = (String)params.get("id")) == null) {
            problems.add("missing id");
        }
        return param == null || id == null;
    }

    public boolean supportsDiscovery() {
        return true;
    }

    public boolean isFileResource() {
        return false;
    }
}

