/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.wav;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.autoplot.datasource.DataSourceFormatEditorPanel;
import org.autoplot.datasource.URISplit;
import org.das2.datum.LoggerManager;
import org.jdesktop.layout.GroupLayout;

public class WavDataSourceFormatEditorPanel
extends JPanel
implements DataSourceFormatEditorPanel {
    private static final Logger logger = LoggerManager.getLogger((String)"apdss.wav");
    String file;
    private JComboBox<String> jComboBox1;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JCheckBox scaleCB;
    private JTextField timeScaleTF;
    private JCheckBox timetagsCheckbox;

    public WavDataSourceFormatEditorPanel() {
        this.initComponents();
    }

    private void initComponents() {
        this.scaleCB = new JCheckBox();
        this.jComboBox1 = new JComboBox();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.timeScaleTF = new JTextField();
        this.timetagsCheckbox = new JCheckBox();
        this.scaleCB.setText("Scale data to utilize full dynamic range");
        this.jComboBox1.setModel(new DefaultComboBoxModel<String>(new String[]{"short: 16 bit signed numbers", "ushort: 16 bit usigned numbers", "int: 32 bit signed numbers", "int24: 24 bit signed numbers"}));
        this.jLabel1.setText("Data Type:");
        this.jLabel2.setText("Time scale (2.0 is twice as fast):");
        this.timeScaleTF.setText("1.0");
        this.timeScaleTF.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WavDataSourceFormatEditorPanel.this.timeScaleTFActionPerformed(evt);
            }
        });
        this.timetagsCheckbox.setText("Writing timing metadata as well.");
        this.timetagsCheckbox.setToolTipText("<html>Write another file next to the file, which shows the DEPEND_0 (Time) offset at indeces.  The file (...ttag.txt) will contain one line per contiguous data chunk.");
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createParallelGroup(1, false).add((Component)this.scaleCB).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabel1).addPreferredGap(0).add(this.jComboBox1, -2, 264, -2)).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabel2).addPreferredGap(0).add((Component)this.timeScaleTF))).add((Component)this.timetagsCheckbox)).addContainerGap(21, Short.MAX_VALUE)));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.scaleCB).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add(this.jComboBox1, -2, -1, -2).add((Component)this.jLabel1)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel2).add((Component)this.timeScaleTF, -2, -1, -2)).addPreferredGap(0).add((Component)this.timetagsCheckbox).addContainerGap(180, Short.MAX_VALUE)));
    }

    private void timeScaleTFActionPerformed(ActionEvent evt) {
    }

    public JPanel getPanel() {
        return this;
    }

    private String getParam(Map<String, String> args, String name, String defl) {
        String s = args.get(name);
        if (s == null) {
            return defl;
        }
        return s;
    }

    public void setURI(String uri) {
        URISplit split = URISplit.parse((String)uri);
        LinkedHashMap args = URISplit.parseParams((String)split.params);
        String s = this.getParam(args, "scale", "T");
        this.scaleCB.setSelected(s.equals("T"));
        s = this.getParam(args, "timeScale", "1.0");
        this.timeScaleTF.setText(s);
        switch (s = this.getParam(args, "type", "short")) {
            case "short": {
                this.jComboBox1.setSelectedIndex(0);
                break;
            }
            case "ushort": {
                this.jComboBox1.setSelectedIndex(1);
                break;
            }
            case "int": {
                this.jComboBox1.setSelectedIndex(2);
                break;
            }
            case "int32": {
                this.jComboBox1.setSelectedIndex(3);
                break;
            }
        }
        s = this.getParam(args, "timetags", "F");
        this.timetagsCheckbox.setSelected(s.equals("T"));
        this.file = split.file;
    }

    public String getURI() {
        String result = this.file;
        HashMap<String, String> args = new HashMap<String, String>();
        if (!this.scaleCB.isSelected()) {
            args.put("scale", "F");
        }
        if (this.timetagsCheckbox.isSelected()) {
            args.put("timetags", "T");
        }
        try {
            double ts = Double.parseDouble(this.timeScaleTF.getText());
            args.put("timeScale", String.valueOf(ts));
        }
        catch (NumberFormatException ex) {
            logger.warning("unable to parse timeScale");
        }
        if (this.jComboBox1.getSelectedIndex() > 0) {
            String s = (String)this.jComboBox1.getSelectedItem();
            int i = s.indexOf(":");
            s = s.substring(0, i);
            args.put("type", s);
        }
        String params = URISplit.formatParams(args);
        if (result == null) {
            result = "file:///";
        }
        URISplit ss = URISplit.parse((String)result);
        if (params.length() > 0) {
            ss.params = params;
        }
        return URISplit.format((URISplit)ss);
    }
}

