/*
 * Decompiled with CFR 0.152.
 */
package ProGAL.dataStructures;

import java.util.Iterator;

public class DLCyclicList<T>
implements Iterable<T> {
    protected DLNode<T> entry = null;
    protected int size = 0;

    public boolean isEmpty() {
        return this.entry == null;
    }

    public DLNode<T> getFirst() {
        return this.entry;
    }

    public DLNode<T> findNode(Object obj) {
        DLNode<T> elem = this.entry;
        while (elem != null && elem.obj != obj) {
            elem = elem.next;
        }
        return elem;
    }

    public DLNode<T> getEntry() {
        return this.entry;
    }

    public void setEntry(DLNode<T> n) {
        this.entry = n;
    }

    public void pushBefore(T obj) {
        this.pushBefore(obj, this.entry);
    }

    public void pushBefore(T obj, DLNode<T> n) {
        DLNode<T> nd = n == null ? new DLNode<T>(obj) : new DLNode<T>(obj, n.prev, n);
        if (this.entry == null) {
            this.entry = nd;
        }
        ++this.size;
    }

    public void pushAfter(T obj, DLNode<T> n) {
        DLNode<T> nd = n == null ? new DLNode<T>(obj) : new DLNode<T>(obj, n, n.next);
        if (this.entry == null) {
            this.entry = nd;
        }
        ++this.size;
    }

    public T delete(DLNode<T> nd) {
        if (this.entry == null) {
            throw new RuntimeException("Cannot delete from empty list");
        }
        if (this.entry == nd) {
            this.entry = nd.next;
        }
        nd.next.prev = nd.prev;
        nd.prev.next = nd.next;
        --this.size;
        return nd.obj;
    }

    public int getSize() {
        return this.size;
    }

    @Override
    public Iterator<T> iterator() {
        return new DLListIterator(this);
    }

    public static void main(String[] args) {
        DLCyclicList<Integer> L = new DLCyclicList<Integer>();
        L.pushBefore(0, L.getEntry());
        L.pushBefore(1, L.getEntry());
        L.pushBefore(2, L.getEntry());
        L.pushBefore(3, L.getEntry());
        L.pushBefore(4, L.getEntry());
        L.pushBefore(5, L.getEntry());
        for (Integer i : L) {
            System.out.println(i);
        }
    }

    private static class DLListIterator<T>
    implements Iterator<T> {
        private DLCyclicList<T> lst;
        private DLNode<T> current;

        public DLListIterator(DLCyclicList<T> lst) {
            this.lst = lst;
            this.current = null;
        }

        @Override
        public boolean hasNext() {
            if (this.lst.isEmpty()) {
                return false;
            }
            return this.current != this.lst.entry;
        }

        @Override
        public T next() {
            if (this.hasNext()) {
                T ret = null;
                if (this.current == null) {
                    ret = this.lst.entry.obj;
                    this.current = this.lst.entry.next;
                } else {
                    ret = this.current.obj;
                    this.current = this.current.next;
                }
                return ret;
            }
            return null;
        }

        @Override
        public void remove() {
        }
    }

    public static class DLNode<T> {
        protected T obj;
        protected DLNode<T> prev;
        protected DLNode<T> next;

        public DLNode(T obj) {
            this.obj = obj;
            this.prev = this;
            this.next = this;
        }

        public DLNode(T obj, DLNode<T> prev, DLNode<T> next) {
            this.obj = obj;
            this.prev = prev;
            this.next = next;
            prev.next = this;
            next.prev = this;
        }

        public T getObject() {
            return this.obj;
        }

        public DLNode<T> getPrev() {
            return this.prev;
        }

        public DLNode<T> getNext() {
            return this.next;
        }

        public T clear() {
            this.prev = null;
            this.next = null;
            return this.obj;
        }
    }
}

