/*
 * Decompiled with CFR 0.152.
 */
package ProGAL.geom2d;

import ProGAL.geom2d.LineSegment;
import ProGAL.geom2d.Point;
import ProGAL.geom2d.Shape;

public class LSC
implements Shape {
    protected LineSegment segment;
    protected double radius;

    public LSC(LineSegment segment, double radius) {
        this.segment = segment;
        this.radius = radius;
    }

    public LSC(Point p1, Point p2, double radius) {
        this(new LineSegment(p1, p2), radius);
    }

    public void setRadius(double rad) {
        this.radius = rad;
    }

    public LineSegment getSegment() {
        return this.segment;
    }

    public double getRadius() {
        return this.radius;
    }

    public double getArea() {
        return (Math.PI * this.radius + 2.0 * this.segment.getLength()) * this.radius;
    }

    @Override
    public Point getCenter() {
        return this.segment.getCenter();
    }

    public LSC clone() {
        return new LSC(this.segment.clone(), this.radius);
    }

    @Override
    public boolean contains(Point p) {
        double dist = this.segment.distance(p);
        return dist <= this.radius;
    }
}

