/*
 * Decompiled with CFR 0.152.
 */
package ProGAL.geom2d;

import ProGAL.dataStructures.Set;
import ProGAL.geom2d.Point;
import ProGAL.geom2d.Vector;
import ProGAL.math.Constants;
import java.util.Random;

public class PointSet
extends Set<Point> {
    public PointSet() {
    }

    public PointSet(int n) {
        Random random = new Random(3L);
        for (int i = 0; i < n; ++i) {
            this.insert(new Point(new Double(random.nextDouble()) - 0.5, new Double(random.nextDouble()) - 0.5));
        }
    }

    public static PointSet createUnitSquareCorners() {
        PointSet points = new PointSet();
        points.insert(new Point(0.0, 0.0));
        points.insert(new Point(1.0, 0.0));
        points.insert(new Point(0.0, 1.0));
        points.insert(new Point(1.0, 1.0));
        return points;
    }

    public Point getCentroid() {
        double x = 0.0;
        double y = 0.0;
        int sz = this.getSize();
        for (Point p : this) {
            x += p.x();
            y += p.y();
        }
        return new Point(x / (double)sz, y / (double)sz);
    }

    public Point[] getClosestPair() {
        Point[] closestPair = new Point[2];
        double minDist = Constants.bigDouble;
        int n = this.getSize();
        for (int i = 0; i < n - 1; ++i) {
            Point p = (Point)this.get(i);
            for (int j = i + 1; j < n; ++j) {
                double dist = p.distanceSquared((ProGAL.geomNd.Point)this.get(j));
                if (!(dist < minDist)) continue;
                minDist = dist;
                closestPair[0] = p;
                closestPair[1] = (Point)this.get(j);
            }
        }
        return closestPair;
    }

    public int leftExtremePointIndx() {
        int k = 0;
        for (int i = 1; i < this.n; ++i) {
            if (!(((Point)this.get(i)).x() < ((Point)this.get(k)).x()) && (((Point)this.get(i)).x() != ((Point)this.get(k)).x() || !(((Point)this.get(k)).y() > ((Point)this.get(i)).y()))) continue;
            k = i;
        }
        return k;
    }

    public Point leftExtremePoint() {
        return (Point)this.get(this.leftExtremePointIndx());
    }

    public Point getNextExtremePoint(Point p) {
        Point r = this.get(0) != p ? (Point)this.get(0) : (Point)this.get(1);
        for (Point q : this) {
            if (q == p || q == r || !Point.rightTurn(p, r, q) && (!Point.collinear(p, r, q) || !(p.distanceSquared(r) < p.distanceSquared(q)))) continue;
            r = q;
        }
        return r;
    }

    public void translate(Vector v) {
        for (Point p : this) {
            p.addThis(v);
        }
    }

    public void toConsole(int dec) {
        for (Point p : this) {
            p.toConsole(dec);
        }
    }
}

