/*
 * Decompiled with CFR 0.152.
 */
package ProGAL.geom2d;

import ProGAL.geom2d.ConvexPolygon;
import ProGAL.geom2d.LineSegment;
import ProGAL.geom2d.Point;
import ProGAL.geom2d.PointSet;
import ProGAL.geom2d.Shape;
import ProGAL.geom2d.Vector;
import ProGAL.geom2d.viewer.J2DScene;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;

public class Polygon
extends ArrayList<Point>
implements Shape {
    private static final long serialVersionUID = 1L;

    public Polygon() {
    }

    public Polygon(List<Point> corners) {
        super(corners);
    }

    public Polygon(Point p0, Point p1, Point p2) {
        this.add(p0);
        if (Point.leftTurn(p0, p1, p2)) {
            this.add(p1);
            this.add(p2);
        } else {
            this.add(p2);
            this.add(p1);
        }
    }

    public Polygon(PointSet points) {
        for (Point p : points) {
            this.add(p);
        }
    }

    public Polygon(Point[] points) {
        for (Point p : points) {
            this.add(p);
        }
    }

    public Point getCorner(int i) {
        return (Point)this.get(i);
    }

    public void setCorner(Point p, int i) {
        this.set(i, p);
    }

    public void insertAfter(Point p, int index) {
        this.add(index, p);
    }

    public void deleteLast() {
        this.remove(this.size() - 1);
    }

    public int leftExtremePointIndx() {
        int k = 0;
        for (int i = 1; i < this.size(); ++i) {
            if (!(((Point)this.get(i)).x() < ((Point)this.get(k)).x()) && (((Point)this.get(i)).x() != ((Point)this.get(k)).x() || !(((Point)this.get(k)).y() > ((Point)this.get(i)).y()))) continue;
            k = i;
        }
        return k;
    }

    public int rightExtremePointIndx() {
        int k = 0;
        for (int i = 1; i < this.size(); ++i) {
            if (!(((Point)this.get(i)).x() > ((Point)this.get(k)).x()) && (((Point)this.get(i)).x() != ((Point)this.get(k)).x() || !(((Point)this.get(k)).y() < ((Point)this.get(i)).y()))) continue;
            k = i;
        }
        return k;
    }

    public void shift(int shiftStep) {
        int i;
        Point[] front = new Point[shiftStep];
        for (i = 0; i < shiftStep; ++i) {
            front[i] = (Point)this.get(i);
        }
        for (i = shiftStep; i < this.size(); ++i) {
            this.set(i - shiftStep, this.get(i));
        }
        for (i = 0; i < shiftStep; ++i) {
            this.set(this.size() - shiftStep + i, front[i]);
        }
    }

    public boolean isConvex() {
        if (this.size() < 4) {
            return true;
        }
        Point p0 = (Point)this.get(0);
        Point p1 = (Point)this.get(1);
        Point p2 = (Point)this.get(2);
        boolean ccw = Point.leftTurn(p0, p1, p2);
        for (int i = 1; i < this.size(); ++i) {
            p0 = p1;
            if (ccw == Point.leftTurn(p0, p1 = p2, p2 = (Point)this.get((i + 2) % this.size()))) continue;
            return false;
        }
        return true;
    }

    @Override
    public Point getCenter() {
        Vector v = new Vector(0.0, 0.0);
        for (Point p : this) {
            v.addThis(p);
        }
        return new Point(v.x() / (double)this.size(), v.y() / (double)this.size());
    }

    public void draw(J2DScene scene, Color clr) {
        for (int i = 1; i < this.size(); ++i) {
            scene.addShape(new LineSegment((Point)this.get(i - 1), (Point)this.get(i)), clr);
        }
        scene.addShape(new LineSegment((Point)this.get(this.size() - 1), (Point)this.get(0)), clr);
    }

    public void draw(J2DScene scene) {
        this.draw(scene, Color.black);
    }

    public ConvexPolygon getConvexPolygon() {
        return new ConvexPolygon(this);
    }

    @Override
    public boolean contains(Point p) {
        boolean result = false;
        for (int i = 0; i < this.size(); ++i) {
            Point p0 = (Point)this.get(i);
            Point p1 = (Point)this.get((i + 1) % this.size());
            if (p0.y() > p.y() == p1.y() > p.y() || !(p.x() < (p1.x() - p0.x()) * (p.y() - p0.y()) / (p1.y() - p0.y()) + p0.x())) continue;
            result = !result;
        }
        return result;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Polygon[");
        for (Point p : this) {
            sb.append(p.toString());
            sb.append(",");
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append("]");
        return sb.toString();
    }
}

