/*
 * Decompiled with CFR 0.152.
 */
package ProGAL.geom2d;

import ProGAL.geom2d.Circle;
import ProGAL.geom2d.Line;
import ProGAL.geom2d.Point;
import ProGAL.geom2d.Shape;
import ProGAL.geom2d.Vector;

public class Triangle
implements Shape {
    protected final Point[] points;

    public Triangle(Point p1, Point p2, Point p3) {
        this.points = new Point[]{p1, p2, p3};
    }

    public Point getCorner(int i) {
        return this.points[i];
    }

    public void setCorner(Point p, int i) {
        this.points[i] = p;
    }

    public double getAltitude(int i) {
        Line line = new Line(this.points[(i + 1) % 3], this.points[(i + 2) % 3]);
        return line.getDistance(this.points[i]);
    }

    public static double calculateArea(double a, double b, double c) {
        double s = (a + b + c) * 0.5;
        return Math.sqrt(s * (s - a) * (s - b) * (s - c));
    }

    public static double calculateHeight(double a, double b, double c) {
        double A = Triangle.calculateArea(a, b, c);
        return 2.0 * A / c;
    }

    @Override
    public Point getCenter() {
        Point p = this.points[0].clone();
        p.addThis(this.points[1]);
        p.addThis(this.points[2]);
        return new Point(p.x() / 3.0, p.y() / 3.0);
    }

    public double getCos(int i) {
        double a01 = this.points[0].distance(this.points[1]);
        double a12 = this.points[1].distance(this.points[2]);
        double a20 = this.points[2].distance(this.points[0]);
        if (i == 0) {
            return (a01 * a01 + a20 * a20 - a12 * a12) / (2.0 * a01 * a20);
        }
        if (i == 1) {
            return (a01 * a01 + a12 * a12 - a20 * a20) / (2.0 * a01 * a12);
        }
        return (a12 * a12 + a20 * a20 - a01 * a01) / (2.0 * a12 * a20);
    }

    public Circle getCircumCircle() {
        Line bisectorAB = Point.getBisector(this.points[0], this.points[1]);
        Line bisectorAC = Point.getBisector(this.points[0], this.points[2]);
        Point d = Line.getIntersection(bisectorAB, bisectorAC);
        return new Circle(d, d.distance(this.points[0]));
    }

    public Point getSteinerPoint() {
        Vector v = this.points[0].vectorTo(this.points[1]);
        if (Point.leftTurn(this.points[0], this.points[1], this.points[2])) {
            v.rotateThis(-1.0471975511965976);
            Point eqPoint = this.points[0].add(v);
            Triangle eqTri = new Triangle(eqPoint, this.points[1], this.points[0]);
            if (!Point.rightTurn(eqPoint, this.points[0], this.points[2])) {
                return this.points[0];
            }
            if (!Point.leftTurn(eqPoint, this.points[1], this.points[2])) {
                return this.points[1];
            }
            Circle ccirc = eqTri.getCircumCircle();
            Line l = new Line(eqPoint, eqPoint.vectorTo(this.points[2]));
            Point[] intersections = ccirc.intersections(l);
            return intersections[1];
        }
        v.rotateThis(1.0471975511965976);
        Point eqPoint = this.points[0].add(v);
        Triangle eqTri = new Triangle(eqPoint, this.points[1], this.points[0]);
        if (!Point.leftTurn(eqPoint, this.points[0], this.points[2])) {
            return this.points[0];
        }
        if (!Point.rightTurn(eqPoint, this.points[1], this.points[2])) {
            return this.points[1];
        }
        Circle ccirc = eqTri.getCircumCircle();
        Line l = new Line(eqPoint, eqPoint.vectorTo(this.points[2]));
        Point[] intersections = ccirc.intersections(l);
        return intersections[1];
    }

    public boolean inCircumCircle(Point s) {
        Point p = this.points[0];
        Point q = this.points[1];
        Point r = this.points[2];
        double pD2 = p.x() * p.x() + p.y() * p.y();
        double qD2 = q.x() * q.x() + q.y() * q.y();
        double rD2 = r.x() * r.x() + r.y() * r.y();
        double sD2 = s.x() * s.x() + s.y() * s.y();
        return -s.x() * (p.y() * (qD2 - rD2) + q.y() * (rD2 - pD2) + r.y() * (pD2 - qD2)) + s.y() * (p.x() * (qD2 - rD2) + q.x() * (rD2 - pD2) + r.x() * (pD2 - qD2)) - sD2 * (p.x() * (q.y() - r.y()) + q.x() * (r.y() - p.y()) + r.x() * (p.y() - q.y())) + p.x() * (q.y() * rD2 - r.y() * qD2) + p.y() * (r.x() * qD2 - q.x() * rD2) + pD2 * (q.x() * r.y() - r.x() * q.y()) < 0.0;
    }

    public static void main(String[] args) {
        Triangle tr = new Triangle(new Point(-3.2, -1.5), new Point(-1.0, 3.0), new Point(3.1, 0.0));
        if (tr.inCircumCircle(new Point(0.0, -4.0))) {
            System.out.println("TRUE");
        } else {
            System.out.println("FALSE");
        }
    }

    @Override
    public boolean contains(Point p) {
        boolean l1 = Point.leftTurn(this.points[0], this.points[1], p);
        boolean l2 = Point.leftTurn(this.points[1], this.points[2], p);
        boolean l3 = Point.leftTurn(this.points[2], this.points[0], p);
        return l1 == l2 && l1 == l3;
    }

    public String toString() {
        StringBuilder vertices = new StringBuilder("");
        for (int i = 0; i < 3; ++i) {
            vertices = vertices.append(this.getCorner(i).toString());
            if (i >= 3) continue;
            vertices.append(", ");
        }
        return String.format("Tessel[%s]", vertices.toString());
    }
}

