/*
 * Decompiled with CFR 0.152.
 */
package ProGAL.geom2d;

import ProGAL.dataStructures.Set;
import ProGAL.dataStructures.SortTool;
import ProGAL.dataStructures.SortToolLineSegment2dAroundCommonPoint;
import ProGAL.dataStructures.SortToolLineSegment2dByLength;
import ProGAL.dataStructures.SortToolPoint2dXY;
import ProGAL.dataStructures.Sorter;
import ProGAL.dataStructures.SorterQuick;
import ProGAL.geom2d.LineSegment;
import ProGAL.geom2d.Point;
import ProGAL.geom2d.PointSet;
import ProGAL.geom2d.TriangulationFace;
import ProGAL.geom2d.TriangulationVertex;
import ProGAL.geom2d.viewer.J2DScene;
import ProGAL.geom3d.Plane;
import ProGAL.geom3d.predicates.ExactJavaPredicates;
import ProGAL.math.Constants;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class Triangulation {
    public List<TriangulationVertex> vertices = new ArrayList<TriangulationVertex>();
    public List<TriangulationFace> triangulationFaces = new ArrayList<TriangulationFace>();
    private final ExactJavaPredicates pred = new ExactJavaPredicates();
    Sorter sort = new SorterQuick();
    J2DScene scene = this.scene;

    public Triangulation(PointSet points, TriangulationAlgorithm algorithm) {
        switch (algorithm) {
            case Delaunay: {
                int i;
                this.sort.Sort(points, new SortToolPoint2dXY());
                for (Point p : points) {
                    this.vertices.add(new TriangulationVertex(p.x(), p.y()));
                }
                for (int i2 = 0; i2 < this.vertices.size(); ++i2) {
                    this.vertices.get(i2).setId(i2);
                    if (!(Math.abs(this.vertices.get(i2).x()) > 10.0) && !(Math.abs(this.vertices.get(i2).y()) > 10.0)) continue;
                    this.vertices.get(i2).setBigPoint(true);
                }
                TriangulationFace newTriangulationFace = Point.leftTurn(this.vertices.get(0), this.vertices.get(1), this.vertices.get(2)) ? new TriangulationFace(this.vertices.get(0), this.vertices.get(1), this.vertices.get(2)) : new TriangulationFace(this.vertices.get(0), this.vertices.get(2), this.vertices.get(1));
                for (i = 0; i < 3; ++i) {
                    this.vertices.get((int)i).face = newTriangulationFace;
                }
                this.triangulationFaces.add(newTriangulationFace);
                newTriangulationFace.id = 0;
                for (i = 3; i < this.vertices.size(); ++i) {
                    TriangulationVertex p = this.vertices.get(i);
                    TriangulationVertex q = this.vertices.get(i - 1);
                    TriangulationFace oppTriangulationFace = q.face;
                    TriangulationVertex r = oppTriangulationFace.corners[(oppTriangulationFace.getIndex(q) + 1) % 3];
                    while (Point.rightTurn(q, r, p)) {
                        newTriangulationFace = new TriangulationFace(p, r, q);
                        newTriangulationFace.neighbors[0] = oppTriangulationFace;
                        if (p.face == null) {
                            q.face = p.face = newTriangulationFace;
                        } else {
                            newTriangulationFace.neighbors[1] = p.face;
                            p.face.neighbors[2] = newTriangulationFace;
                            p.face = newTriangulationFace;
                        }
                        oppTriangulationFace.neighbors[(oppTriangulationFace.getIndex((TriangulationVertex)q) + 2) % 3] = newTriangulationFace;
                        this.triangulationFaces.add(newTriangulationFace);
                        newTriangulationFace.id = this.triangulationFaces.size() - 1;
                        this.legalizeEdge(newTriangulationFace, 0, true);
                        q = r;
                        oppTriangulationFace = q.face;
                        r = oppTriangulationFace.corners[(oppTriangulationFace.getIndex(q) + 1) % 3];
                    }
                    q = this.vertices.get(i - 1);
                    oppTriangulationFace = this.findLastTriangulationFace(q);
                    r = oppTriangulationFace.corners[(oppTriangulationFace.getIndex(q) + 2) % 3];
                    while (Point.leftTurn(q, r, p)) {
                        newTriangulationFace = new TriangulationFace(p, q, r);
                        newTriangulationFace.neighbors[0] = oppTriangulationFace;
                        oppTriangulationFace.neighbors[(oppTriangulationFace.getIndex((TriangulationVertex)q) + 1) % 3] = newTriangulationFace;
                        if (p.face == null) {
                            r.face = p.face = newTriangulationFace;
                        } else {
                            TriangulationFace lastTriangulationFace;
                            newTriangulationFace.neighbors[2] = lastTriangulationFace = this.findLastTriangulationFace(p);
                            lastTriangulationFace.neighbors[1] = newTriangulationFace;
                            r.face = newTriangulationFace;
                        }
                        this.triangulationFaces.add(newTriangulationFace);
                        newTriangulationFace.id = this.triangulationFaces.size() - 1;
                        this.legalizeEdge(newTriangulationFace, 0, true);
                        q = r;
                        oppTriangulationFace = this.findLastTriangulationFace(q);
                        r = oppTriangulationFace.corners[(oppTriangulationFace.getIndex(q) + 2) % 3];
                    }
                }
                break;
            }
            case Greedy: {
                for (Point p : points) {
                    this.vertices.add(new TriangulationVertex(p.x(), p.y()));
                }
                Set<LineSegment> segments = new Set<LineSegment>();
                for (int i = 0; i < this.vertices.size(); ++i) {
                    TriangulationVertex u = this.vertices.get(i);
                    u.setId(i);
                    for (int j = i + 1; j < this.vertices.size(); ++j) {
                        TriangulationVertex v = this.vertices.get(j);
                        segments.insert(new LineSegment(u, v));
                    }
                }
                this.sort.Sort(segments, new SortToolLineSegment2dByLength());
                ArrayList<LineSegment> acceptedSegments = new ArrayList<LineSegment>();
                for (LineSegment seg : segments) {
                    LineSegment segA;
                    boolean cont = true;
                    Iterator lastTriangulationFace = acceptedSegments.iterator();
                    while (lastTriangulationFace.hasNext() && (cont = !seg.intersects(segA = (LineSegment)lastTriangulationFace.next()))) {
                    }
                    if (!cont) continue;
                    acceptedSegments.add(seg);
                }
                Set<LineSegment> incidentSegments = new Set<LineSegment>();
                for (TriangulationVertex v : this.vertices) {
                    for (LineSegment seg : acceptedSegments) {
                        if ((TriangulationVertex)seg.a == v) {
                            incidentSegments.insert(seg);
                            continue;
                        }
                        if ((TriangulationVertex)seg.b != v) continue;
                        incidentSegments.insert(seg.reverse());
                    }
                    this.sort.Sort(incidentSegments, new SortToolLineSegment2dAroundCommonPoint(v));
                    int sz = incidentSegments.getSize();
                    TriangulationVertex q = (TriangulationVertex)((LineSegment)incidentSegments.get(0)).getB();
                    for (int j = 0; j < sz; ++j) {
                        TriangulationVertex p = q;
                        q = (TriangulationVertex)((LineSegment)incidentSegments.get((j + 1) % sz)).getB();
                        System.out.println(p.id + "," + v.id + "," + q.id);
                        if (!Point.rightTurn(p, v, q)) continue;
                        TriangulationFace triangulationFace = this.findTriangulationFace(v, p, q);
                    }
                    incidentSegments.clear();
                }
                for (TriangulationFace TriangulationFace2 : this.triangulationFaces) {
                    for (int i = 0; i < 3; ++i) {
                        TriangulationVertex v = TriangulationFace2.corners[i];
                        TriangulationVertex w = TriangulationFace2.corners[(i + 1) % 3];
                        TriangulationVertex z = TriangulationFace2.corners[(i + 2) % 3];
                        TriangulationFace prevTriangulationFace = this.findPrevTriangulationFace(v, w);
                        if (v.face == null || prevTriangulationFace == null) {
                            v.face = TriangulationFace2;
                        }
                        TriangulationFace2.neighbors[(i + 2) % 3] = prevTriangulationFace;
                        TriangulationFace2.neighbors[(i + 1) % 3] = this.findNextTriangulationFace(v, z);
                        TriangulationFace2.neighbors[i] = this.findPrevTriangulationFace(w, z);
                    }
                }
                break;
            }
        }
    }

    public TriangulationFace findTriangulationFace(TriangulationVertex u, TriangulationVertex v, TriangulationVertex w) {
        for (TriangulationFace TriangulationFace2 : this.triangulationFaces) {
            if (!(TriangulationFace2.hasVertex(u) & TriangulationFace2.hasVertex(v) & TriangulationFace2.hasVertex(w))) continue;
            return TriangulationFace2;
        }
        TriangulationFace newTriangulationFace = new TriangulationFace(u, v, w);
        this.triangulationFaces.add(newTriangulationFace);
        newTriangulationFace.id = this.triangulationFaces.size() - 1;
        return newTriangulationFace;
    }

    public TriangulationFace findNextTriangulationFace(TriangulationVertex u, TriangulationVertex v) {
        for (TriangulationFace TriangulationFace2 : this.triangulationFaces) {
            if (!TriangulationFace2.hasVertex(u) || !TriangulationFace2.hasVertex(v) || TriangulationFace2.corners[(TriangulationFace2.getIndex(u) + 1) % 3] != v) continue;
            return TriangulationFace2;
        }
        return null;
    }

    public TriangulationFace findPrevTriangulationFace(TriangulationVertex u, TriangulationVertex v) {
        for (TriangulationFace TriangulationFace2 : this.triangulationFaces) {
            if (!TriangulationFace2.hasVertex(u) || !TriangulationFace2.hasVertex(v) || TriangulationFace2.corners[(TriangulationFace2.getIndex(v) + 1) % 3] != u) continue;
            return TriangulationFace2;
        }
        return null;
    }

    public TriangulationFace findLastTriangulationFace(TriangulationVertex v) {
        TriangulationFace TriangulationFace2 = v.face;
        int indx = TriangulationFace2.getIndex(v);
        if (TriangulationFace2.neighbors[(indx + 2) % 3] != null) {
            return null;
        }
        TriangulationFace nextTriangulationFace = TriangulationFace2.neighbors[(indx + 1) % 3];
        while (nextTriangulationFace != null) {
            TriangulationFace2 = nextTriangulationFace;
            indx = TriangulationFace2.getIndex(v);
            nextTriangulationFace = TriangulationFace2.neighbors[(indx + 1) % 3];
        }
        return TriangulationFace2;
    }

    public TriangulationFace findFirstTriangulationFace(TriangulationVertex v) {
        int indx = v.face.getIndex(v);
        if (v.face.neighbors[(indx + 2) % 3] != null) {
            return null;
        }
        return v.face;
    }

    public void legalizeEdge(TriangulationFace triangulationFace, int indx, boolean recursive) {
        this.legalizeEdge(triangulationFace, indx, recursive, null);
    }

    public void legalizeEdge(TriangulationFace triangulationFace, int indx, boolean recursive, J2DScene scene) {
        TriangulationFace oppTriangulationFace = triangulationFace.neighbors[indx];
        int oppIndx = (oppTriangulationFace.getIndex(triangulationFace.corners[(indx + 1) % 3]) + 1) % 3;
        double inc = this.pred.incircle(triangulationFace.corners[0].getCoords(), triangulationFace.corners[1].getCoords(), triangulationFace.corners[2].getCoords(), oppTriangulationFace.corners[oppIndx].getCoords());
        if (inc > 0.0) {
            this.flip(triangulationFace, oppTriangulationFace, recursive, scene, false);
        }
    }

    public TriangulationFace[] flip(TriangulationFace t013, TriangulationFace t123, boolean recursive) {
        return this.flip(t013, t123, recursive, null, false);
    }

    public TriangulationFace[] flip(TriangulationFace t013, TriangulationFace t123, boolean recursive, J2DScene scene, boolean testing) {
        t013.setAlive(false);
        if (testing) {
            t013.hide(scene);
        }
        this.triangulationFaces.remove(t013);
        t123.setAlive(false);
        if (testing) {
            t123.hide(scene);
        }
        this.triangulationFaces.remove(t123);
        int p0Indx = t013.getIndex(t123);
        int p2Indx = t123.getIndex(t013);
        TriangulationVertex p0 = t013.corners[p0Indx];
        TriangulationVertex p1 = t013.corners[(p0Indx + 1) % 3];
        TriangulationVertex p2 = t123.corners[p2Indx];
        TriangulationVertex p3 = t123.corners[(p2Indx + 1) % 3];
        TriangulationFace t012 = new TriangulationFace(p0, p1, p2);
        this.triangulationFaces.add(t012);
        if (testing) {
            t012.draw(scene);
        }
        TriangulationFace t023 = new TriangulationFace(p0, p2, p3);
        this.triangulationFaces.add(t023);
        if (testing) {
            t023.draw(scene);
        }
        TriangulationFace t01 = t013.neighbors[(p0Indx + 2) % 3];
        TriangulationFace t12 = t123.neighbors[(p2Indx + 1) % 3];
        TriangulationFace t23 = t123.neighbors[(p2Indx + 2) % 3];
        TriangulationFace t30 = t013.neighbors[(p0Indx + 1) % 3];
        t012.neighbors[0] = t12;
        t012.neighbors[1] = t023;
        t012.neighbors[2] = t01;
        t023.neighbors[0] = t23;
        t023.neighbors[1] = t30;
        t023.neighbors[2] = t012;
        if (t01 != null) {
            t01.neighbors[t01.getIndex((TriangulationFace)t013)] = t012;
        }
        if (t12 != null) {
            t12.neighbors[t12.getIndex((TriangulationFace)t123)] = t012;
        }
        if (t23 != null) {
            t23.neighbors[t23.getIndex((TriangulationFace)t123)] = t023;
        }
        if (t30 != null) {
            t30.neighbors[t30.getIndex((TriangulationFace)t013)] = t023;
        }
        if (p0.face == t013) {
            p0.face = t012;
        }
        if (p1.face == t123 || p1.face == t013) {
            p1.face = t012;
        }
        if (p2.face == t123) {
            p2.face = t023;
        }
        if (p3.face == t013 || p3.face == t123) {
            p3.face = t023;
        }
        t012.setId(t013.id);
        t023.setId(t123.id);
        t013 = t012;
        t123 = t023;
        if (recursive) {
            if (t12 != null) {
                this.legalizeEdge(t012, 0, true, scene);
            }
            if (t23 != null) {
                this.legalizeEdge(t023, 0, true, scene);
            }
        }
        TriangulationFace[] newFaces = new TriangulationFace[]{t012, t023};
        return newFaces;
    }

    public void boundaryFlipOut(TriangulationVertex v, TriangulationFace face, J2DScene scene, boolean testing) {
        int indx = face.getIndex(v);
        face.setAlive(false);
        if (testing) {
            face.hide(scene);
        }
        this.triangulationFaces.remove(face);
        TriangulationVertex a = face.getCorner((indx + 2) % 3);
        TriangulationVertex b = face.getCorner((indx + 1) % 3);
        if (this.triangulationFaces.isEmpty()) {
            TriangulationFace newFace = new TriangulationFace(v, a, b);
            this.triangulationFaces.add(newFace);
            newFace.setId(this.triangulationFaces.size());
            if (testing) {
                newFace.draw(scene, testing);
            }
        } else {
            TriangulationFace firstFace = v.face;
            TriangulationFace lastFace = v.getLastFace();
            TriangulationFace nextFace = face.getNeighbor((indx + 1) % 3);
            TriangulationFace prevFace = face.getNeighbor((indx + 2) % 3);
            if (firstFace == lastFace) {
                v.face = nextFace;
                b.face = prevFace;
                nextFace.setNeighbor((nextFace.getIndex(v) + 2) % 3, null);
                prevFace.setNeighbor((prevFace.getIndex(v) + 1) % 3, null);
            } else {
                if (prevFace != null) {
                    b = firstFace.getCorner((firstFace.getIndex(v) + 1) % 3);
                }
                if (nextFace != null) {
                    a = lastFace.getCorner((lastFace.getIndex(v) + 2) % 3);
                }
                TriangulationFace newFace = new TriangulationFace(v, a, b);
                newFace.setNeighbor(0, null);
                newFace.setNeighbor(1, prevFace);
                newFace.setNeighbor(2, nextFace);
                if (prevFace != null) {
                    prevFace.setNeighbor((prevFace.getIndex(v) + 2) % 3, newFace);
                }
                if (nextFace != null) {
                    nextFace.setNeighbor((nextFace.getIndex(v) + 1) % 3, newFace);
                }
                this.triangulationFaces.add(newFace);
                newFace.setId(this.triangulationFaces.size());
                a.face = newFace;
                v.face = newFace;
                if (prevFace != null) {
                    prevFace.setNeighbor((prevFace.getIndex(v) + 2) % 3, newFace);
                } else {
                    face.setNeighbor((face.getIndex(v) + 2) % 3, newFace);
                }
                if (nextFace != null) {
                    nextFace.setNeighbor((nextFace.getIndex(v) + 1) % 3, newFace);
                } else {
                    face.setNeighbor((face.getIndex(v) + 1) % 3, newFace);
                }
            }
        }
    }

    public void boundaryFlipIn(TriangulationVertex a, TriangulationVertex b, TriangulationVertex c) {
        this.boundaryFlipIn(a, b, c, null, false);
    }

    public void boundaryFlipIn(TriangulationVertex a, TriangulationVertex b, TriangulationVertex c, J2DScene scene, boolean testing) {
        TriangulationFace bcFace = b.getFace();
        if (b.getNextFace(bcFace) != null) {
            TriangulationFace abFace;
            TriangulationFace newFace = new TriangulationFace(a, c, b);
            newFace.neighbors[0] = bcFace;
            newFace.neighbors[1] = abFace = a.getFace();
            newFace.neighbors[2] = null;
            bcFace.setNeighbor((bcFace.getIndex(b) + 2) % 3, newFace);
            abFace.setNeighbor((abFace.getIndex(a) + 2) % 3, newFace);
            a.face = newFace;
            this.triangulationFaces.add(newFace);
            newFace.id = this.triangulationFaces.size() - 1;
            newFace.draw(scene, testing);
        } else if (bcFace.getOppFace(b) == null) {
            b.getFace().setAlive(false);
            TriangulationFace newFace = new TriangulationFace(a, c, b, scene, testing);
            for (int i = 0; i < 3; ++i) {
                newFace.neighbors[i] = null;
            }
            a.face = newFace;
            b.face = newFace;
            c.face = newFace;
            this.triangulationFaces.add(newFace);
            newFace.id = this.triangulationFaces.size() - 1;
            newFace.draw(scene, testing);
        } else {
            System.out.println("This boundaryFlipIn case should not occur");
        }
    }

    private double getPower(Point a, Point b, Point c, Point p) {
        double area = Point.area(a, b, c);
        if (area <= 0.0) {
            return Constants.bigDouble;
        }
        return -Point.inCircle(b, a, c, p) / area;
    }

    private double getPower(TriangulationVertex a, TriangulationVertex b, TriangulationVertex c) {
        double area = Point.area(a, b, c);
        if (area <= 0.0) {
            return Constants.bigDouble;
        }
        Plane plane = new Plane(a.liftedPoint, b.liftedPoint, c.liftedPoint);
        return -Math.abs(plane.getNormal().z());
    }

    private boolean isBig(Point p) {
        return Math.abs(p.x()) > 1000.0 || Math.abs(p.y()) > 1000.0;
    }

    public boolean isDelaunay() {
        boolean cont = true;
        for (TriangulationFace t : this.triangulationFaces) {
            if (t.isBigFace() || !t.circumCircleContains(this.vertices, 10000.0 * Constants.EPSILON)) continue;
            t.circumCircle.toScene(this.scene, Color.red);
            cont = false;
            break;
        }
        return cont;
    }

    private int getIndxBurried(TriangulationFace face) {
        for (int indx = 0; indx < 3; ++indx) {
            if (!face.corners[indx].burried) continue;
            return indx;
        }
        return -1;
    }

    private boolean faesible(ProGAL.geom3d.Point a, ProGAL.geom3d.Point b, ProGAL.geom3d.Point c, TriangulationFace prevFace, TriangulationFace nextFace) {
        TriangulationFace pFace = prevFace;
        TriangulationFace nFace = nextFace;
        boolean forward = true;
        do {
            if (forward) {
                TriangulationVertex next = nFace.corners[(nFace.uIndx + 2) % 3];
                if (ProGAL.geom3d.Point.orientation(a, b, c, next.liftedPoint) <= 0.0) {
                    return false;
                }
                nFace = next.getPrevFace(nFace);
                while (nFace.delCount != 1) {
                    nFace = next.getPrevFace(nFace);
                }
            } else {
                TriangulationVertex prev = pFace.corners[(pFace.uIndx + 1) % 3];
                if (ProGAL.geom3d.Point.orientation(a, b, c, prev.liftedPoint) <= 0.0) {
                    return false;
                }
                pFace = prev.getNextFace(pFace);
                while (pFace.delCount != 1) {
                    pFace = prev.getNextFace(pFace);
                }
            }
            boolean bl = forward = !forward;
        } while (pFace != nFace);
        return true;
    }

    public void print() {
        for (TriangulationVertex v : this.vertices) {
            System.out.print("Vertex " + v.id);
            if (v.face != null) {
                System.out.println(" has first TriangulationFace " + v.face.toString());
                continue;
            }
            System.out.println(" has no TriangulationFaces.");
        }
        for (TriangulationFace TriangulationFace2 : this.triangulationFaces) {
            System.out.print("TriangulationFace " + TriangulationFace2.id + " " + TriangulationFace2.toString() + " has neighbors: ");
            for (int i = 0; i < 3; ++i) {
                if (TriangulationFace2.neighbors[i] == null) continue;
                System.out.print(TriangulationFace2.neighbors[i].toString() + " ");
            }
            System.out.println();
        }
    }

    private class SortToolHeapItems
    implements SortTool {
        private SortToolHeapItems() {
        }

        @Override
        public int compare(Object x1, Object x2) {
            if (x1 instanceof HeapItem && x2 instanceof HeapItem) {
                double d2;
                double d1 = ((HeapItem)x1).getPower();
                if (d1 < (d2 = ((HeapItem)x2).getPower())) {
                    return -1;
                }
                if (d1 > d2) {
                    return 1;
                }
                return 0;
            }
            throw SortTool.err1;
        }
    }

    private class HeapItem<T> {
        private double power;
        private TriangulationFace face;
        private TriangulationFace nextFace;
        private TriangulationVertex b;

        private HeapItem(TriangulationFace face, TriangulationFace nextFace, TriangulationVertex b, double power) {
            this.power = power;
            this.face = face;
            this.nextFace = nextFace;
            this.b = b;
        }

        private double getPower() {
            return this.power;
        }

        private TriangulationFace getFace() {
            return this.face;
        }

        private TriangulationFace getNextFace() {
            return this.nextFace;
        }

        private TriangulationVertex getVertex() {
            return this.b;
        }
    }

    public static enum TriangulationAlgorithm {
        Greedy,
        Delaunay;

    }
}

