/*
 * Decompiled with CFR 0.152.
 */
package ProGAL.geom2d;

import ProGAL.geom2d.Circle;
import ProGAL.geom2d.Line;
import ProGAL.geom2d.LineSegment;
import ProGAL.geom2d.Point;
import ProGAL.geom2d.Shape;
import ProGAL.geom2d.Triangle;
import ProGAL.geom2d.TriangulationVertex;
import ProGAL.geom2d.Vector;
import ProGAL.geom2d.viewer.J2DScene;
import ProGAL.geom3d.Plane;
import java.awt.Color;
import java.util.List;

public class TriangulationFace {
    protected int id;
    protected TriangulationVertex[] corners = new TriangulationVertex[3];
    protected TriangulationFace[] neighbors = new TriangulationFace[3];
    protected boolean shorty = false;
    protected Shape[] edgeShape = new Shape[3];
    protected Shape[] triangleShape = new Shape[3];
    protected Circle circumCircle = null;
    protected Double circumRadius = null;
    public boolean displayed = true;
    protected Line oppLine = null;
    protected boolean alive = true;
    protected Integer count = null;
    protected Integer rotCount = null;
    protected ProGAL.geom3d.Triangle liftedTriangle = null;
    protected ProGAL.geom3d.Triangle groundTriangle = null;
    protected Plane plane = null;
    protected int delCount = 0;
    protected int uIndx;

    public TriangulationFace(TriangulationVertex v0, TriangulationVertex v1, TriangulationVertex v2) {
        this.corners[0] = v0;
        this.corners[1] = v1;
        this.corners[2] = v2;
    }

    public TriangulationFace(TriangulationVertex v0, TriangulationVertex v1, TriangulationVertex v2, J2DScene scene, boolean testing) {
        this.corners[0] = v0;
        this.corners[1] = v1;
        this.corners[2] = v2;
        if (scene != null) {
            this.draw(scene, Color.black);
        }
    }

    public void killShapes(J2DScene scene) {
        for (int i = 0; i < 3; ++i) {
            if (this.edgeShape[i] != null) {
                scene.removeShape(this.edgeShape[i]);
            }
            scene.removeShape(this.circumCircle);
        }
    }

    public TriangulationVertex getCorner(int i) {
        return this.corners[i];
    }

    public TriangulationFace getNeighbor(int i) {
        return this.neighbors[i];
    }

    public boolean isShort() {
        return this.shorty;
    }

    public void setShort(boolean shorty) {
        this.shorty = shorty;
    }

    public Shape getEdgeShape(int i) {
        return this.edgeShape[i];
    }

    public void setEdgeShape(int i, Shape shape) {
        this.edgeShape[i] = shape;
    }

    public void setCircumCircle() {
        this.circumCircle = new Circle(this.corners[0], this.corners[1], this.corners[2]);
        this.circumRadius = this.circumCircle.radius;
    }

    public void setCircumCircle(Circle c) {
        if (c == null) {
            this.setCircumCircle();
        } else {
            this.circumCircle = c;
            this.circumRadius = this.circumCircle.radius;
        }
    }

    public void setCircumCircleCenterX(double x) {
        this.circumCircle.center.setCoord(0, x);
    }

    public void setCircumCircleCenterY(double y) {
        this.circumCircle.center.setCoord(1, y);
    }

    public void setCircumCircleRadius(Double r) {
        this.circumCircle.radius = r;
    }

    public void setCircumCircleRadius() {
        this.setCircumCircle();
    }

    public boolean isAlive() {
        return this.alive;
    }

    public boolean hasShape() {
        return this.circumCircle != null;
    }

    public int getCount() {
        if (this.count != null) {
            return this.count;
        }
        this.count = 0;
        for (int i = 0; i < 3; ++i) {
            if (this.corners[i].getType() != TriangulationVertex.VertexType.R) continue;
            this.count = this.count + (int)Math.pow(2.0, i);
        }
        return this.count;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public void setNeighbor(int indx, TriangulationFace face) {
        this.neighbors[indx] = face;
    }

    public void setAlive(boolean alive) {
        this.alive = alive;
    }

    public boolean isBigFace() {
        return this.corners[0].isBigPoint() || this.corners[1].isBigPoint() || this.corners[2].isBigPoint();
    }

    public boolean isFlat() {
        return Point.collinear(this.corners[0], this.corners[1], this.corners[2]);
    }

    public boolean hasLowestRotIndex(TriangulationVertex v, List<Integer> rotIndx, int size) {
        int vIndx = v.getId();
        int indx = size;
        for (int i = 0; i < 3; ++i) {
            int cIndx = this.corners[i].getId();
            if (cIndx >= indx || this.corners[i].getType() != TriangulationVertex.VertexType.R) continue;
            indx = cIndx;
        }
        return vIndx == indx;
    }

    public int nrRotatingCorners() {
        if (this.rotCount == null) {
            this.rotCount = 0;
            for (int i = 0; i < 3; ++i) {
                if (this.corners[i].getType() != TriangulationVertex.VertexType.R) continue;
                Integer n = this.rotCount;
                Integer n2 = this.rotCount = Integer.valueOf(this.rotCount + 1);
            }
        }
        return this.rotCount;
    }

    public boolean hasRotatingCorners(List<Integer> rotIndx) {
        if (rotIndx.contains(this.getCorner(0).getId())) {
            return true;
        }
        if (rotIndx.contains(this.getCorner(1).getId())) {
            return true;
        }
        return rotIndx.contains(this.getCorner(2).getId());
    }

    public boolean circumCircleContains(List<TriangulationVertex> vertices, double eps) {
        Circle circle = this.getCircumCircle();
        for (Point point : vertices) {
            if (!circle.contains(point, eps)) continue;
            return true;
        }
        return false;
    }

    public Triangle getTriangle() {
        return new Triangle(this.corners[0], this.corners[1], this.corners[2]);
    }

    public Circle getCircumCircle() {
        if (this.circumCircle == null) {
            this.setCircumCircle();
        }
        return this.circumCircle;
    }

    public Double getCircumRadius() {
        if (this.circumRadius == null) {
            this.getCircumCircle();
        }
        return this.circumCircle.radius;
    }

    public Line getOppLine(TriangulationVertex v) {
        if (this.oppLine == null) {
            int indx = this.getIndex(v);
            this.oppLine = new Line((Point)this.corners[(indx + 2) % 2], this.corners[(indx + 1) % 3]);
        }
        return this.oppLine;
    }

    public TriangulationFace getOppFace(TriangulationVertex v) {
        return this.getNeighbor(this.getIndex(v));
    }

    public boolean hasVertex(TriangulationVertex v) {
        return this.corners[0] == v || this.corners[1] == v || this.corners[2] == v;
    }

    public int getIndex(TriangulationVertex v) {
        for (int i = 0; i < 3; ++i) {
            if (this.corners[i] != v) continue;
            return i;
        }
        return -1;
    }

    public int getIndex(TriangulationFace t) {
        for (int i = 0; i < 3; ++i) {
            if (this.neighbors[i] != t) continue;
            return i;
        }
        return -1;
    }

    public TriangulationVertex getThirdVertex(TriangulationVertex u, TriangulationVertex v) {
        if (this.corners[0] != u && this.corners[0] != v) {
            return this.corners[0];
        }
        if (this.corners[1] != u && this.corners[1] != v) {
            return this.corners[1];
        }
        return this.corners[2];
    }

    public TriangulationVertex getThirdVertex(TriangulationFace face) {
        if (!this.hasVertex(face.getCorner(0))) {
            return face.getCorner(0);
        }
        if (!this.hasVertex(face.getCorner(1))) {
            return face.getCorner(1);
        }
        return face.getCorner(2);
    }

    public void draw(J2DScene scene, Color clr, double offset) {
        TriangulationVertex b = this.corners[0];
        TriangulationVertex c = this.corners[1];
        if (!this.isBigFace()) {
            for (int i = 0; i < 3; ++i) {
                scene.removeShape(this.triangleShape[i]);
                scene.removeShape(this.edgeShape[i]);
                TriangulationVertex a = b;
                b = c;
                c = this.corners[(i + 2) % 3];
                TriangulationFace oppT = this.getOppFace(c);
                int oppIndx = oppT.getIndex(b);
                scene.removeShape(oppT.edgeShape[oppIndx]);
                Vector offVector = new Vector(a.y() - b.y(), b.x() - a.x()).scaleToLength(offset);
                this.triangleShape[i] = new LineSegment(this.corners[i].add(offVector), this.corners[(i + 1) % 3].add(offVector));
                scene.addShape(this.triangleShape[i], clr, 0.01);
            }
        }
    }

    public void draw(J2DScene scene, Color clr) {
        if (!this.isBigFace()) {
            for (int i = 0; i < 3; ++i) {
                TriangulationFace oppT;
                scene.removeShape(this.edgeShape[i]);
                this.edgeShape[i] = new LineSegment(this.corners[i], this.corners[(i + 1) % 3]);
                scene.addShape(this.edgeShape[i], clr, 0.002);
                if (!this.isShort()) {
                    oppT = this.getOppFace(this.getCorner((i + 2) % 3));
                    if (oppT == null || !oppT.isShort()) continue;
                    int indxOppT = oppT.getIndex(this.getCorner((i + 1) % 3));
                    scene.removeShape(oppT.edgeShape[indxOppT]);
                    scene.addShape(oppT.edgeShape[indxOppT]);
                    continue;
                }
                oppT = this.getOppFace(this.getCorner((i + 2) % 3));
                if (oppT.isShort()) continue;
            }
        }
    }

    public void draw(J2DScene scene) {
        this.draw(scene, Color.black);
    }

    public void draw(J2DScene scene, boolean testing) {
        if (testing && scene != null && !this.isBigFace()) {
            for (int i = 0; i < 3; ++i) {
                scene.removeShape(this.edgeShape[i]);
                this.edgeShape[i] = new LineSegment(this.corners[i], this.corners[(i + 1) % 3]);
                scene.addShape(this.edgeShape[i], Color.black, 0.001);
            }
        }
    }

    public void draw(J2DScene scene, double alpha, boolean testing) {
        boolean bl = this.shorty = this.getCircumRadius() <= alpha;
        if (!this.isShort()) {
            for (int i = 0; i < 3; ++i) {
                if (!(this.corners[i].distance(this.corners[(i + 1) % 3]) < 2.0 * alpha)) continue;
                scene.removeShape(this.edgeShape[i]);
                this.edgeShape[i] = new LineSegment(this.corners[i], this.corners[(i + 1) % 3]);
                scene.addShape(this.edgeShape[i], Color.red, 0.01);
                TriangulationFace oppT = this.getOppFace(this.getCorner((i + 2) % 3));
                if (!oppT.isShort()) continue;
                int indxOppT = oppT.getIndex(this.getCorner((i + 1) % 3));
                scene.removeShape(oppT.edgeShape[indxOppT]);
                scene.addShape(oppT.edgeShape[indxOppT]);
            }
        } else {
            this.draw(scene, testing);
        }
    }

    public void redraw(J2DScene scene, Color clr) {
        if (!this.isBigFace()) {
            for (int i = 0; i < 3; ++i) {
                scene.removeShape(this.edgeShape[i]);
                scene.addShape(this.edgeShape[i], clr, 0.001);
            }
        }
    }

    public void redraw(J2DScene scene) {
        this.redraw(scene, Color.black);
    }

    public void redraw(J2DScene scene, boolean testing) {
        if (scene != null && !this.isBigFace()) {
            for (int i = 0; i < 3; ++i) {
                Color clr = this.corners[i].getType() == this.corners[(i + 1) % 3].getType() ? Color.black : Color.black;
                scene.addShape(this.edgeShape[i], clr, 0.001);
            }
        }
    }

    public Shape drawCircumCircle(J2DScene scene, Color clr) {
        scene.removeShape(this.circumCircle);
        this.circumCircle = new Circle(this.corners[0], this.corners[1], this.corners[2]);
        scene.addShape(this.circumCircle, clr);
        return this.circumCircle;
    }

    public Shape drawRotatedCircumCircle(J2DScene scene, Color clr, double angle, List<Integer> rotIndx) {
        Point[] p = new Point[3];
        for (int i = 0; i < 3; ++i) {
            p[i] = rotIndx.contains(this.corners[i].getId()) ? this.corners[i].rotationClone(angle) : this.corners[i].clone();
        }
        Circle circle = new Circle(p[0], p[1], p[2]);
        scene.addShape(circle, clr);
        return circle;
    }

    public void hide(J2DScene scene) {
        if (scene != null) {
            for (int i = 0; i < 3; ++i) {
                scene.removeShape(this.edgeShape[i]);
            }
        }
    }

    public void hideCircumCircle(J2DScene scene) {
        scene.removeShape(this.circumCircle);
        scene.repaint();
    }

    public void reshape(J2DScene scene, boolean testing) {
        if (testing && this.hasShape()) {
            Circle c = new Circle(this.getCorner(0), this.getCorner(1), this.getCorner(2));
            this.circumCircle.center = c.center;
            this.circumCircle.radius = c.radius;
        }
    }

    public String toString() {
        return "[" + this.corners[0].id + "," + this.corners[1].id + "," + this.corners[2].id + "]";
    }

    public TriangulationVertex[] getCorners() {
        return this.corners;
    }
}

