/*
 * Decompiled with CFR 0.152.
 */
package ProGAL.geom2d;

import ProGAL.dataStructures.DLCyclicList;
import ProGAL.geom2d.Circle;
import ProGAL.geom2d.Point;
import ProGAL.geom2d.TriangulationFace;
import ProGAL.geom3d.volumes.Sphere;
import java.util.ArrayList;
import java.util.List;

public class TriangulationVertex
extends Point {
    private static final long serialVersionUID = 1L;
    protected int id;
    protected TriangulationFace face;
    protected Circle orbit = null;
    private double polarAngle;
    private double cosAngle;
    private double sinAngle;
    private double polarRadius;
    private double squaredPolarRadius;
    private VertexType type;
    protected boolean burried = false;
    protected ProGAL.geom3d.Point liftedPoint;
    protected ProGAL.geom3d.Point groundPoint;
    protected Sphere liftedSphere;
    protected Sphere groundSphere;
    protected boolean bigPoint = false;

    public TriangulationVertex(double x, double y) {
        super(x, y);
    }

    public TriangulationVertex(Point p) {
        super(p.x(), p.y());
    }

    public TriangulationFace getFace() {
        return this.face;
    }

    public void setFace(TriangulationFace face) {
        this.face = face;
    }

    public boolean isBigPoint() {
        return this.bigPoint;
    }

    public void setBigPoint(boolean bigPoint) {
        this.bigPoint = bigPoint;
    }

    public TriangulationFace getNextFace(TriangulationFace f) {
        int indx = f.getIndex(this);
        return f.getNeighbor((indx + 1) % 3);
    }

    public TriangulationFace getPrevFace(TriangulationFace f) {
        int indx = f.getIndex(this);
        return f.getNeighbor((indx + 2) % 3);
    }

    public TriangulationFace getLastFace() {
        TriangulationFace currFace = this.face;
        TriangulationFace nextFace = this.getNextFace(currFace);
        while (nextFace != null && nextFace != this.face) {
            currFace = nextFace;
            nextFace = this.getNextFace(currFace);
        }
        if (nextFace == null) {
            return currFace;
        }
        return this.face;
    }

    public List<TriangulationFace> getFaces() {
        ArrayList<TriangulationFace> faces = new ArrayList<TriangulationFace>();
        TriangulationFace firstFace = this.getFace();
        faces.add(firstFace);
        TriangulationFace face = this.getNextFace(firstFace);
        while (face != null && face != firstFace) {
            faces.add(face);
            face = this.getNextFace(face);
        }
        return faces;
    }

    public DLCyclicList<TriangulationVertex> getNeighboringVertices() {
        DLCyclicList<TriangulationVertex> vertices = new DLCyclicList<TriangulationVertex>();
        TriangulationFace currentFace = this.getFace();
        TriangulationVertex u = currentFace.getCorner((this.face.getIndex(this) + 1) % 3);
        TriangulationVertex v = currentFace.getCorner((this.face.getIndex(this) + 2) % 3);
        vertices.pushBefore(v);
        while (v != u) {
            currentFace = this.getNextFace(currentFace);
            v = currentFace.getThirdVertex(this, v);
            vertices.pushBefore(v);
        }
        return vertices;
    }

    public Circle getOrbit() {
        if (this.orbit == null) {
            this.orbit = new Circle(Point.origo, this.distance());
        }
        return this.orbit;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public VertexType getType() {
        return this.type;
    }

    public void setType(VertexType type) {
        this.type = type;
    }

    public double getPolarRadius() {
        return this.polarRadius;
    }

    public void setPolarRadius(double polarRadius) {
        this.polarRadius = polarRadius;
    }

    public double getSquaredPolarRadius() {
        return this.squaredPolarRadius;
    }

    public void setSquaredPolarRadius(double sqPR) {
        this.squaredPolarRadius = sqPR;
    }

    public double getPolarAngle() {
        return this.polarAngle;
    }

    public void setPolarAngle(double polarAngle) {
        this.polarAngle = polarAngle;
    }

    public double getCosAngle() {
        return this.cosAngle;
    }

    public void setCosAngle(double cosAngle) {
        this.cosAngle = cosAngle;
    }

    public double getSinAngle() {
        return this.sinAngle;
    }

    public void setSinAngle(double sinAngle) {
        this.sinAngle = sinAngle;
    }

    public static enum VertexType {
        S,
        R;

    }
}

