/*
 * Decompiled with CFR 0.152.
 */
package ProGAL.geom2d.delaunay;

import ProGAL.geom2d.Point;
import ProGAL.geom2d.delaunay.Triangle;
import ProGAL.geom2d.delaunay.Vertex;
import ProGAL.geom3d.predicates.ExactJavaPredicates;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.das2.util.LoggerManager;

public class DTWithBigPoints {
    private static final Logger logger = LoggerManager.getLogger((String)"ProGAL.geom2d.delaunay");
    private final ExactJavaPredicates pred = new ExactJavaPredicates();
    final List<Vertex> vertices;
    final List<Triangle> triangles;
    final Vertex[] bigPoints;
    public static int flipCounter = 0;
    public static int predCounter = 0;
    public static int orientPredCounter = 0;

    public DTWithBigPoints(List<Point> points) {
        this.vertices = new ArrayList<Vertex>(points.size());
        this.triangles = new ArrayList<Triangle>(points.size());
        this.bigPoints = new Vertex[3];
        this.bigPoints[0] = new Vertex(new Point(-3000.0, -3000.0));
        this.bigPoints[1] = new Vertex(new Point(3000.0, 0.0));
        this.bigPoints[2] = new Vertex(new Point(0.0, 3000.0));
        Triangle bigTri = new Triangle(this.bigPoints[0], this.bigPoints[1], this.bigPoints[2]);
        this.triangles.add(bigTri);
        int ipoint = 0;
        for (Point p : points) {
            this.addPoint(p);
            if (++ipoint % 10000 != 0 || ipoint <= 0) continue;
            System.err.println("triangulated " + ipoint + " points.");
        }
    }

    public List<Triangle> getTriangles() {
        return new ArrayList<Triangle>(this.triangles);
    }

    public List<int[]> getEdges() {
        ArrayList<int[]> ret = new ArrayList<int[]>();
        for (Triangle tri : this.triangles) {
            for (int i = 0; i < 3; ++i) {
                int[] e = new int[]{tri.corners[i].id - 3, tri.corners[(i + 1) % 3].id - 3};
                if (e[0] < 0 || e[1] < 0) continue;
                if (e[0] > e[1]) {
                    int tmp = e[0];
                    e[0] = e[1];
                    e[1] = tmp;
                }
                if (ret.contains(e)) continue;
                ret.add(e);
            }
        }
        return ret;
    }

    public Triangle walk(Point p) {
        return this.walk(p, null);
    }

    public Triangle walk(Point p, List<Point> trace) {
        Triangle t = this.triangles.get(this.triangles.size() - 1);
        return this.walk(p, trace, t);
    }

    public Triangle walk(Point p, List<Point> trace, Triangle t) {
        HashSet<Triangle> visited = new HashSet<Triangle>();
        if (t == null) {
            t = this.triangles.get(this.triangles.size() - 1);
        }
        visited.add(t);
        while (true) {
            logger.log(Level.FINEST, "walk triangle: {0}", t);
            double a1 = Point.area(t.corners[0], t.corners[1], p);
            ++orientPredCounter;
            double a2 = Point.area(t.corners[1], t.corners[2], p);
            ++orientPredCounter;
            double a3 = Point.area(t.corners[2], t.corners[0], p);
            ++orientPredCounter;
            if (a1 < 0.0 && a2 < 0.0) {
                t = a2 < a1 ? t.neighbors[0] : t.neighbors[2];
            } else {
                if (!(Math.min(a1, Math.min(a2, a3)) < 0.0)) break;
                t = a3 < a1 && a3 < a2 ? t.neighbors[1] : (a2 < a1 ? t.neighbors[0] : t.neighbors[2]);
            }
            if (t == null) {
                throw new IllegalArgumentException("Point is outside of the big triangulation");
            }
            if (visited.contains(t)) {
                throw new IllegalArgumentException("cycle in DTWithBigPoints needs to be fixed.");
            }
            visited.add(t);
            Point c = t.getCenter();
            if (trace == null) continue;
            trace.add(c);
        }
        return t;
    }

    private static void printTriangle(Triangle t, Point p) {
    }

    public void addPoint(Point point) {
        Vertex p = point instanceof Vertex ? (Vertex)point : new Vertex(point);
        this.vertices.add(p);
        Triangle t = this.walk(p);
        DTWithBigPoints.printTriangle(t, p);
        Triangle[] ts = this.splitTriangle(p, t);
        boolean valid = true;
        valid = valid && this.checkValid(ts[0]);
        valid = valid && this.checkValid(ts[1]);
        boolean bl = valid = valid && this.checkValid(ts[2]);
        if (!valid) {
            DTWithBigPoints.printTriangle(t, p);
        }
        this.legalizeEdge(ts[0], 0);
        this.legalizeEdge(ts[1], 0);
        this.legalizeEdge(ts[2], 0);
    }

    private boolean checkValid(Triangle t) {
        try {
            t.getCircumCircle();
            return true;
        }
        catch (RuntimeException ex) {
            return false;
        }
    }

    private Triangle[] splitTriangle(Vertex p, Triangle t) {
        this.triangles.remove(t);
        Vertex[] ps = new Vertex[]{t.corners[0], t.corners[1], t.corners[2]};
        Triangle[] ns = new Triangle[]{t.neighbors[0], t.neighbors[1], t.neighbors[2]};
        Triangle[] ts = new Triangle[]{new Triangle(p, ps[1], ps[2]), new Triangle(p, ps[2], ps[0]), new Triangle(p, ps[0], ps[1])};
        for (int i = 0; i < 3; ++i) {
            ts[i].neighbors[0] = ns[i];
            if (ns[i] != null) {
                ns[i].neighbors[(ns[i].indexOf((Vertex)ps[(i + 1) % 3]) + 1) % 3] = ts[i];
            }
            ts[i].neighbors[1] = ts[(i + 1) % 3];
            ts[i].neighbors[2] = ts[(i + 2) % 3];
            ps[i].first = ts[(i + 1) % 3];
            this.triangles.add(ts[i]);
        }
        p.first = ts[0];
        return ts;
    }

    void legalizeEdge(Triangle t, int e) {
        if (t.neighbors[e] == null) {
            return;
        }
        Triangle u = t.neighbors[e];
        int f = (u.indexOf(t.corners[(e + 1) % 3]) + 1) % 3;
        double inc = this.pred.incircle(t.corners[0].getCoords(), t.corners[1].getCoords(), t.corners[2].getCoords(), u.corners[f].getCoords());
        boolean illegal = inc > 0.0;
        ++predCounter;
        if (illegal) {
            DTWithBigPoints.flip(t, e, u, f);
            this.legalizeEdge(t, e);
            this.legalizeEdge(u, (f + 2) % 3);
        }
    }

    static void flip(Triangle t, int e, Triangle u, int f) {
        ++flipCounter;
        Vertex p0 = t.corners[e];
        Vertex p1 = t.corners[(e + 1) % 3];
        Vertex p2 = u.corners[f];
        Vertex p3 = t.corners[(e + 2) % 3];
        Triangle n01 = t.neighbors[(e + 2) % 3];
        Triangle n12 = u.neighbors[(f + 1) % 3];
        Triangle n23 = u.neighbors[(f + 2) % 3];
        Triangle n34 = t.neighbors[(e + 1) % 3];
        t.corners[(e + 2) % 3] = p2;
        u.corners[(f + 2) % 3] = p0;
        t.setCorner(p2, (e + 2) % 3);
        u.setCorner(p0, (f + 2) % 3);
        t.neighbors[e] = n12;
        t.neighbors[(e + 1) % 3] = u;
        t.neighbors[(e + 2) % 3] = n01;
        u.neighbors[f] = n34;
        u.neighbors[(f + 1) % 3] = t;
        u.neighbors[(f + 2) % 3] = n23;
        if (n12 != null) {
            n12.neighbors[(n12.indexOf((Vertex)p1) + 1) % 3] = t;
        }
        if (n34 != null) {
            n34.neighbors[(n34.indexOf((Vertex)p3) + 1) % 3] = u;
        }
        if (p1.first == u) {
            p1.first = t;
        }
        if (p3.first == t) {
            p3.first = u;
        }
    }

    public boolean inCH(Triangle t) {
        if (t == null) {
            return false;
        }
        for (Vertex bp : this.bigPoints) {
            for (int c = 0; c < 3; ++c) {
                if (t.corners[c] != bp) continue;
                return false;
            }
        }
        return true;
    }

    public boolean onCH(Triangle t) {
        return this.inCH(t) && (!this.inCH(t.neighbors[0]) || !this.inCH(t.neighbors[1]) || !this.inCH(t.neighbors[2]));
    }
}

