/*
 * Decompiled with CFR 0.152.
 */
package ProGAL.geom2d.delaunay;

import ProGAL.geom2d.Point;
import ProGAL.geom2d.delaunay.Vertex;

public class Triangle
extends ProGAL.geom2d.Triangle {
    Triangle[] neighbors = new Triangle[3];
    Vertex[] corners = new Vertex[3];

    public Triangle(Vertex p0, Vertex p1, Vertex p2) {
        super(p0, p1, p2);
        this.corners[0] = p0;
        if (Point.rightTurn(p0, p1, p2)) {
            this.corners[1] = p2;
            this.corners[2] = p1;
            super.setCorner(p2, 1);
            super.setCorner(p1, 2);
        } else {
            this.corners[1] = p1;
            this.corners[2] = p2;
        }
    }

    int indexOf(Vertex v) {
        for (int i = 0; i < 3; ++i) {
            if (this.corners[i] != v) continue;
            return i;
        }
        return -1;
    }

    @Override
    public String toString() {
        return String.format("Triangle[%d,%d,%d]", this.corners[0].id, this.corners[1].id, this.corners[2].id);
    }
}

